/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.math;

import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.util.IDataObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public final class KVectorChain
extends LinkedList<KVector>
implements IDataObject {
    private static final long serialVersionUID = -7978287459602078559L;

    public KVectorChain() {
    }

    public KVectorChain(Collection<KVector> collection) {
        super(collection);
    }

    public KVectorChain(KVector ... vectors) {
        this.addAll(vectors);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("(");
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            KVector vector = (KVector)iter.next();
            builder.append(String.valueOf(vector.x) + "," + vector.y);
            if (!iter.hasNext()) continue;
            builder.append("; ");
        }
        return builder.append(")").toString();
    }

    @Override
    public void parse(String string) {
        String[] tokens = string.split(",|;|\\(|\\)|\\[|\\]|\\{|\\}| |\t|\n");
        this.clear();
        try {
            int i = 0;
            int xy = 0;
            double x = 0.0;
            double y = 0.0;
            while (i < tokens.length) {
                if (tokens[i] != null && tokens[i].trim().length() > 0) {
                    if (xy % 2 == 0) {
                        x = Double.parseDouble(tokens[i]);
                    } else {
                        y = Double.parseDouble(tokens[i]);
                    }
                    if (xy > 0 && xy % 2 != 0) {
                        this.add(new KVector(x, y));
                    }
                    ++xy;
                }
                ++i;
            }
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("The given string does not match the expected format for vectors." + exception);
        }
    }

    public void add() {
        this.add(new KVector());
    }

    public void add(double x, double y) {
        this.add(new KVector(x, y));
    }

    public void addFirst() {
        this.addFirst(new KVector());
    }

    public void addFirst(double x, double y) {
        this.addFirst(new KVector(x, y));
    }

    public void addLast() {
        this.addLast(new KVector());
    }

    public void addLast(double x, double y) {
        this.addLast(new KVector(x, y));
    }

    public void addAll(KVector ... vectors) {
        KVector[] kVectorArray = vectors;
        int n = vectors.length;
        int n2 = 0;
        while (n2 < n) {
            KVector vector = kVectorArray[n2];
            this.add(vector);
            ++n2;
        }
    }

    public void addAllAsCopies(int index, Iterable<KVector> chain) {
        LinkedList<KVector> copies = new LinkedList<KVector>();
        for (KVector v : chain) {
            copies.add(new KVector(v));
        }
        this.addAll(index, copies);
    }

    public KVectorChain scale(double scale) {
        for (KVector vector : this) {
            vector.scale(scale);
        }
        return this;
    }

    public KVectorChain scale(double scalex, double scaley) {
        for (KVector vector : this) {
            vector.scale(scalex, scaley);
        }
        return this;
    }

    public KVectorChain offset(KVector offset) {
        for (KVector vector : this) {
            vector.add(offset);
        }
        return this;
    }

    public KVectorChain offset(double dx, double dy) {
        for (KVector vector : this) {
            vector.add(dx, dy);
        }
        return this;
    }

    public double totalLength() {
        double length = 0.0;
        if (this.size() >= 2) {
            Iterator iter = this.iterator();
            KVector point1 = (KVector)iter.next();
            do {
                KVector point2 = (KVector)iter.next();
                length += point1.distance(point2);
                point1 = point2;
            } while (iter.hasNext());
        }
        return length;
    }

    public boolean hasNaN() {
        for (KVector v : this) {
            if (!v.isNaN()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInfinite() {
        for (KVector v : this) {
            if (!v.isInfinite()) continue;
            return true;
        }
        return false;
    }

    public KVector pointOnLine(double dist) {
        if (this.size() >= 2) {
            double absDistance = Math.abs(dist);
            double distanceSum = 0.0;
            if (dist >= 0.0) {
                ListIterator iter = this.listIterator();
                KVector currentPoint = (KVector)iter.next();
                do {
                    double oldDistanceSum = distanceSum;
                    KVector nextPoint = (KVector)iter.next();
                    double additionalDistanceToNext = currentPoint.distance(nextPoint);
                    if (additionalDistanceToNext > 0.0 && (distanceSum += additionalDistanceToNext) >= absDistance) {
                        double thisRelative = (absDistance - oldDistanceSum) / additionalDistanceToNext;
                        KVector result = nextPoint.clone().sub(currentPoint);
                        result.scale(thisRelative);
                        result.add(currentPoint);
                        return result;
                    }
                    currentPoint = nextPoint;
                } while (iter.hasNext());
                return (KVector)iter.previous();
            }
            ListIterator iter = this.listIterator(this.size() - 1);
            KVector currentPoint = (KVector)iter.previous();
            do {
                double oldDistanceSum = distanceSum;
                KVector nextPoint = (KVector)iter.previous();
                double additionalDistanceToNext = currentPoint.distance(nextPoint);
                if (additionalDistanceToNext > 0.0 && (distanceSum += additionalDistanceToNext) >= absDistance) {
                    double thisRelative = (absDistance - oldDistanceSum) / additionalDistanceToNext;
                    KVector result = nextPoint.clone().sub(currentPoint);
                    result.scale(thisRelative);
                    result.add(currentPoint);
                    return result;
                }
                currentPoint = nextPoint;
            } while (iter.hasPrevious());
            return (KVector)iter.next();
        }
        if (this.size() == 1) {
            return (KVector)this.get(0);
        }
        throw new IllegalStateException("Cannot determine a point on an empty vector chain.");
    }

    public double angleOnLine(double dist) {
        if (this.size() >= 2) {
            KVector currentPoint;
            double additionalDistanceToNext;
            double absDistance = Math.abs(dist);
            double distanceSum = 0.0;
            if (dist >= 0.0) {
                KVector currentPoint2;
                double additionalDistanceToNext2;
                ListIterator iter = this.listIterator();
                KVector nextPoint = (KVector)iter.next();
                while (!((additionalDistanceToNext2 = (currentPoint2 = nextPoint).distance(nextPoint = (KVector)iter.next())) > 0.0 && (distanceSum += additionalDistanceToNext2) >= absDistance || !iter.hasNext())) {
                }
                return nextPoint.clone().sub(currentPoint2).toRadians();
            }
            ListIterator iter = this.listIterator(this.size() - 1);
            KVector nextPoint = (KVector)iter.previous();
            while (!((additionalDistanceToNext = (currentPoint = nextPoint).distance(nextPoint = (KVector)iter.previous())) > 0.0 && (distanceSum += additionalDistanceToNext) >= absDistance || !iter.hasPrevious())) {
            }
            return nextPoint.clone().sub(currentPoint).toRadians();
        }
        throw new IllegalStateException("Need at least two points to determine an angle.");
    }

    public static KVectorChain reverse(KVectorChain chain) {
        KVectorChain result = new KVectorChain();
        for (KVector vector : chain) {
            result.add(0, new KVector(vector));
        }
        return result;
    }
}

