/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.properties;

import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MapPropertyHolder
implements IPropertyHolder,
Serializable {
    private static final long serialVersionUID = 4507851447415709893L;
    private HashMap<IProperty<?>, Object> propertyMap;

    @Override
    public <T> MapPropertyHolder setProperty(IProperty<? super T> property, T value) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        if (value == null) {
            this.propertyMap.remove(property);
        } else {
            this.propertyMap.put(property, value);
        }
        return this;
    }

    @Override
    public <T> T getProperty(IProperty<T> property) {
        Object value;
        if (this.propertyMap != null && (value = this.propertyMap.get(property)) != null) {
            return (T)value;
        }
        T defaultValue = property.getDefault();
        if (defaultValue instanceof Cloneable) {
            this.setProperty(property, (Object)defaultValue);
        }
        return defaultValue;
    }

    @Override
    public MapPropertyHolder copyProperties(IPropertyHolder other) {
        if (other == null) {
            return this;
        }
        Map<IProperty<?>, Object> otherMap = other.getAllProperties();
        if (!otherMap.isEmpty()) {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap(otherMap);
            } else {
                this.propertyMap.putAll(otherMap);
            }
        }
        return this;
    }

    @Override
    public Map<IProperty<?>, Object> getAllProperties() {
        if (this.propertyMap == null) {
            return Collections.emptyMap();
        }
        return this.propertyMap;
    }

    public void checkProperties(IProperty<?> ... newProperties) {
        if (this.propertyMap == null) {
            return;
        }
        IProperty<?>[] iPropertyArray = newProperties;
        int n = newProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty<?> property = iPropertyArray[n2];
            Object value = this.propertyMap.get(property);
            if (value != null) {
                Comparable<?> lowbo = property.getLowerBound();
                Comparable<?> uppbo = property.getUpperBound();
                if (lowbo.compareTo(value) > 0) {
                    if (value.getClass().isAssignableFrom(lowbo.getClass())) {
                        this.propertyMap.put(property, lowbo);
                    } else {
                        this.propertyMap.remove(property);
                    }
                } else if (uppbo.compareTo(value) < 0) {
                    if (value.getClass().isAssignableFrom(uppbo.getClass())) {
                        this.propertyMap.put(property, uppbo);
                    } else {
                        this.propertyMap.remove(property);
                    }
                }
            }
            ++n2;
        }
    }
}

