/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.core.properties;

import de.cau.cs.kieler.core.properties.IProperty;
import java.lang.reflect.Method;

public class Property<T>
implements IProperty<T>,
Comparable<IProperty<?>> {
    public static final Comparable<Object> NEGATIVE_INFINITY = new Comparable<Object>(){

        @Override
        public int compareTo(Object other) {
            return -1;
        }
    };
    public static final Comparable<Object> POSITIVE_INFINITY = new Comparable<Object>(){

        @Override
        public int compareTo(Object other) {
            return 1;
        }
    };
    private final String id;
    private T defaultValue;
    private Comparable<? super T> lowerBound = NEGATIVE_INFINITY;
    private Comparable<? super T> upperBound = POSITIVE_INFINITY;

    public Property(String theid) {
        this.id = theid;
    }

    public Property(String theid, T thedefaultValue) {
        this(theid);
        this.defaultValue = thedefaultValue;
    }

    public Property(String theid, T thedefaultValue, Comparable<? super T> thelowerBound) {
        this(theid, thedefaultValue);
        if (thelowerBound != null) {
            this.lowerBound = thelowerBound;
        }
    }

    public Property(String theid, T thedefaultValue, Comparable<? super T> thelowerBound, Comparable<? super T> theupperBound) {
        this(theid, (T)thedefaultValue, thelowerBound);
        if (theupperBound != null) {
            this.upperBound = theupperBound;
        }
    }

    public Property(IProperty<T> other, T thedefaultValue) {
        this(other.getId(), thedefaultValue, other.getLowerBound(), other.getUpperBound());
    }

    public Property(IProperty<T> other, T thedefaultValue, Comparable<? super T> thelowerBound) {
        this(other.getId(), (T)thedefaultValue, thelowerBound, (Comparable<? super T>)other.getUpperBound());
    }

    public Property(IProperty<T> other, T thedefaultValue, Comparable<? super T> thelowerBound, Comparable<? super T> theupperBound) {
        this(other.getId(), (T)thedefaultValue, thelowerBound, theupperBound);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IProperty) {
            return this.id.equals(((IProperty)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }

    @Override
    public T getDefault() {
        if (this.defaultValue instanceof Cloneable) {
            try {
                Method cloneMethod = this.defaultValue.getClass().getMethod("clone", new Class[0]);
                Object clonedDefaultValue = cloneMethod.invoke(this.defaultValue, new Object[0]);
                return (T)clonedDefaultValue;
            }
            catch (Exception exception) {
                return this.defaultValue;
            }
        }
        return this.defaultValue;
    }

    @Override
    public Comparable<? super T> getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public Comparable<? super T> getUpperBound() {
        return this.upperBound;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(IProperty<?> other) {
        return this.id.compareTo(other.getId());
    }
}

