/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.builders;

import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.AbstractBuildContributor;
import ro.amiq.dvt.model.BuildState;
import ro.amiq.dvt.model.BuildStateProvider;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.smartcopy.SmartCopyPrincipal;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MD5InputStream;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.msdldt.builders.BuildProgressMonitoring;
import ro.amiq.msdldt.builders.MSDLBuilderUtils;
import ro.amiq.msdldt.builders.MSDLPoolingCancelThread;
import ro.amiq.msdldt.model.IMSDLModule;
import ro.amiq.msdldt.model.IMSDLProject;
import ro.amiq.msdldt.model.MSDLFileInfo;
import ro.amiq.msdldt.model.MSDLModelManager;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.parser.IParsingInfo;
import ro.amiq.msdldt.parser.IParsingListener;
import ro.amiq.msdldt.parser.MSDLCompiler;
import ro.amiq.msdldt.parser.MSDLLoadedInfo;
import ro.amiq.msdldt.parser.MSDLSkipInfo;
import ro.amiq.msdldt.parser.MSDLStartedInfo;
import ro.amiq.msdldt.test.TestHelper;

public class MSDLBuildContributor
extends AbstractBuildContributor
implements IParsingListener,
MSDLBuilderUtils.IBuildStatusProvider {
    public static final String ID = "ro.amiq.msdldt.MSDLBuilder";
    public static final String AUTOLINK_SUBFOLDER_NAME = "M-SDL";
    private static final String MSDLDT_BUILDER_CALLER_NAME = "M-SDL Builder";
    private final Set<FileCompileInfo> fDeltaChanged = new LinkedHashSet<FileCompileInfo>();
    private final Set<IFile> fDeltaRemoved = new LinkedHashSet<IFile>();
    private SubProgressMonitor fIncrMonitor;
    private boolean fIncrMonitorBegin;
    private boolean fIncrMonitorDone;
    private MSDLCompiler fCurrentParser;
    private IProgressMonitor fGlobalFullBuildMonitor;
    private BuildProgressMonitoring fBuildProgressMonitoring;
    private boolean fBuildSuccess;
    private String fFullBuildProjectName;
    private List<IResource> fRefreshTopFilesList = new ArrayList<IResource>();
    private MSDLPoolingCancelThread fCancelPoolingThread;
    private boolean fDisableMD5ChangeDetection;
    private boolean fAutoLinkedResourcesEnable;
    private int fFileIndex;
    private Set<ParserPath> fAlreadyCompiledFiles;
    private Map<String, AutoLinkRoot> fAutoLinkedRoots;
    private final Map<ParserPath, MSDLFileInfo> fResources2CreateMap = new LinkedHashMap<ParserPath, MSDLFileInfo>();
    private boolean fNotifyAfterIncremental;
    private int fTotalNofLines;
    private long fTimestamp = 0L;

    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature("ro.amiq.msdldt.msdlnature");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean hasNature(String natureID) {
        return "ro.amiq.msdldt.msdlnature".equals(natureID);
    }

    public boolean notifyAfterIncremental() {
        return this.fNotifyAfterIncremental;
    }

    public IProject[] build(int kind, Map args, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        this.fNotifyAfterIncremental = true;
        if (args != null && args.containsKey("justClean") && args.get("justClean").equals("true")) {
            return null;
        }
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        if (!project.hasNature("ro.amiq.msdldt.msdlnature")) {
            return null;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F73646C")) {
            return null;
        }
        this.fRefreshTopFilesList.clear();
        this.fResources2CreateMap.clear();
        IMSDLProject msdlProject = MSDLModelManager.getInstance().getMSDLModel().getMSDLProject(project);
        if (msdlProject == null) {
            return null;
        }
        this.setReadOnlyBreadcrumbs();
        this.fDisableMD5ChangeDetection = BuildConfigManager.isDisableMD5ChangeDetection((IProject)project);
        this.fAutoLinkedResourcesEnable = BuildConfigManager.isAutoLinkedResources((IProject)project);
        this.fAutoLinkedRoots = BuildConfigManager.getAutoLinkedRoots((IProject)project);
        if (kind == 6) {
            this.fullBuild(monitor);
            RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
            rfProject.setBuildProgressMonitor(monitor);
            this.createAutoLinkedResources(project, monitor);
            MSDLModelManager.getInstance().cbPostFullBuild(project, this.fBuildSuccess);
            Set<ParserPath> uniqueFilesSet = rfProject.getCompiledFilesSet();
            int uniqueFiles = uniqueFilesSet == null ? 0 : uniqueFilesSet.size();
            this.consolePrintSection("Files summary [" + this.fFileIndex + " total, " + uniqueFiles + " unique]");
        } else if (kind == 10 || kind == 9) {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
                RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
                rfProject.setBuildProgressMonitor(monitor);
                this.createAutoLinkedResources(project, monitor);
                MSDLModelManager.getInstance().cbPostFullBuild(project, this.fBuildSuccess);
            } else {
                this.fAlreadyCompiledFiles = null;
                RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
                if (rfProject != null) {
                    this.fAlreadyCompiledFiles = rfProject.getCompiledFilesSet();
                }
                this.incrementalBuild(monitor);
            }
        }
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])this.fRefreshTopFilesList.toArray());
        DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.DifferentColorsDecorator", (Object[])this.fRefreshTopFilesList.toArray());
        this.fRefreshTopFilesList.clear();
        this.fResources2CreateMap.clear();
        return null;
    }

    private void setReadOnlyBreadcrumbs() {
        Job updateBCJob = new Job("Setting read-only Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (IEditorReference edReference : Utils.getCurrentlyOpenEditorReferences()) {
                    IEditorPart editor = edReference.getEditor(false);
                    if (!(editor instanceof DVTEditor)) continue;
                    ro.amiq.msdldt.utils.Utils.setReadOnlyBreadcrumbs((DVTEditor)editor, true);
                }
                return Status.OK_STATUS;
            }
        };
        updateBCJob.setSystem(true);
        updateBCJob.schedule();
    }

    public static void deleteMarkersAndProperties(IProject project) {
        try {
            DVTProblemsUiUpdaterRegistry.get((String)MSDLProblemCategories.MSDL_SYNTAX.getId()).resetNofMarkers(project);
            project.deleteMarkers(MSDLProblemCategories.MSDL_SYNTAX.getMarkerId(), true, 2);
            DVTProblemManager.getInstance().removeProblemsWithCategory(project, MSDLProblemCategories.MSDL_SYNTAX);
            project.deleteMarkers("ro.amiq.msdldt.PersistentTaskMarker", true, 2);
            project.deleteMarkers("ro.amiq.msdldt.PersistentTaskMarker", true, 2);
            final ArrayList refreshList = new ArrayList();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (PropertiesManager.getSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE) != null) {
                        PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE, null);
                        refreshList.add(resource);
                        return true;
                    }
                    return false;
                }
            });
            DVTAbstractDecorator.refresh((String)"ro.amiq.dvt.CompiledFileDecorator", (Object[])refreshList.toArray());
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
    }

    public void clean(IProgressMonitor monitor) throws CoreException {
        this.fFileIndex = 0;
        IProject project = this.getProject();
        this.fAlreadyCompiledFiles = null;
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            this.fAlreadyCompiledFiles = rfProject.getCompiledFilesSet();
        }
        MSDLBuildContributor.deleteMarkersAndProperties(project);
        MSDLModelManager.getInstance().cleanMSDLProject(project);
        IMSDLProject msdlProject = MSDLModelManager.getInstance().getMSDLModel().getMSDLProject(project);
        msdlProject.createNewMSDLParser();
        SmartCopyPrincipal.INSTANCE.flushOrders(project);
        MSDLModelManager.getInstance().cbClean(project);
    }

    protected MSDLCompiler fullBuild(IProgressMonitor monitor) {
        MSDLCompiler msdlParser;
        block6: {
            this.fFileIndex = 0;
            this.fTimestamp = System.currentTimeMillis();
            msdlParser = null;
            this.fBuildSuccess = false;
            IProject project = this.getProject();
            this.fFullBuildProjectName = project.getName();
            long parseStartTimestamp = System.currentTimeMillis();
            TestHelper.fParseTime = 0.0;
            this.fTotalNofLines = 0;
            try {
                try {
                    if (project.exists() && RfManager.getInstance().getRfProjectWithoutRestore(project) != null) {
                        RfManager.getInstance().getRfProject(project).setLastFullBuildStartMemory();
                        RfManager.getInstance().getRfProject(project).setLastFullBuildStartTime();
                        this.fGlobalFullBuildMonitor = monitor;
                        IMSDLProject msdlProject = MSDLModelManager.getInstance().getMSDLModel().getMSDLProject(project);
                        msdlParser = msdlProject.createNewMSDLParser();
                        msdlParser.addParsingListener(this);
                        this.fCurrentParser = msdlParser;
                        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(msdlProject.getProject());
                        rfProject.clean();
                        DVTCodeCommentsPreferences commentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)this.getProject());
                        List customPragmas = BuildConfigManager.getCustomPragmas((IProject)project);
                        int maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)project);
                        this.fBuildProgressMonitoring = new BuildProgressMonitoring(this.fGlobalFullBuildMonitor, BuildConfigManager.getInvocations((IProject)project));
                        this.fBuildSuccess = MSDLBuilderUtils.internalFullBuild(this, msdlParser, rfProject, customPragmas, commentsPreferences, maxIssuesKindNumber);
                        msdlParser.removeParsingListener(this);
                        this.fGlobalFullBuildMonitor.done();
                        monitor.done();
                        msdlParser.removeParsingListener(this);
                        this.fBuildSuccess = true;
                    }
                    TestHelper.fParseTime = System.currentTimeMillis() - parseStartTimestamp;
                    this.consolePrintSection("Done parsing [" + TestHelper.fParseTime + " ms]");
                    DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                    symbols.setGroupingSeparator(' ');
                    DecimalFormat df = new DecimalFormat("###,###", symbols);
                    this.consolePrintSection("Total number of lines [" + df.format(this.fTotalNofLines) + "]");
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    BuildStateProvider.getInstance().setBuildState(BuildState.SEMANTIC);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                BuildStateProvider.getInstance().setBuildState(BuildState.SEMANTIC);
                throw throwable;
            }
            BuildStateProvider.getInstance().setBuildState(BuildState.SEMANTIC);
        }
        this.fCurrentParser = null;
        return msdlParser;
    }

    @Override
    public boolean checkCancel() {
        if (this.fGlobalFullBuildMonitor != null && this.fCurrentParser != null && (this.fGlobalFullBuildMonitor.isCanceled() || MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState()))) {
            this.fCurrentParser.interrupt();
            this.fGlobalFullBuildMonitor.done();
            return true;
        }
        return false;
    }

    @Override
    public void parsing(IParsingInfo info) {
        int infoKind = info.getKind();
        IProject project = this.getProject();
        switch (infoKind) {
            case 1: {
                if (this.checkCancel()) {
                    return;
                }
                MSDLStartedInfo msInfo = (MSDLStartedInfo)info;
                ParserPath parserPath = msInfo.getParserPath();
                if (this.fBuildProgressMonitoring != null) {
                    this.fBuildProgressMonitoring.fileStarted(parserPath.path);
                }
                if (RfProject.isPredefined(parserPath)) break;
                ++this.fFileIndex;
                String message = DVTStringUtil.appendString((Object[])new Object[]{"Loading (", this.fFileIndex, ") ", parserPath, " ..."});
                this.consolePrint(message);
                break;
            }
            case 2: {
                if (this.checkCancel()) {
                    return;
                }
                MSDLLoadedInfo mlInfo = (MSDLLoadedInfo)info;
                ParserPath parserPath = mlInfo.getParserPath();
                if (this.fBuildProgressMonitoring != null) {
                    this.fBuildProgressMonitoring.fileDone(parserPath.path);
                }
                MSDLFileInfo msdlFileInfo = new MSDLFileInfo(project, parserPath, null, mlInfo.getAST(), this.fFileIndex, true);
                this.createResource(parserPath, msdlFileInfo);
                MSDLModelManager.getInstance().notifyBuildListenersFullBuild(msdlFileInfo);
                IBuildConfigParserConstants.LanguageSyntax languageSyntax = mlInfo.getLanguageSyntax();
                if (!RfProject.isPredefined(parserPath)) {
                    int nofRawLines = mlInfo.getNofRawLines();
                    this.fTotalNofLines += nofRawLines;
                    long time = System.currentTimeMillis() - this.fTimestamp;
                    String message = DVTStringUtil.appendString((Object[])new Object[]{"Done ", parserPath, " [", time, " ms, ", nofRawLines, " lines, ", languageSyntax.getFirstName(), "] ..."});
                    this.consolePrint(message);
                    DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).getReportModel().updateTopStatsForProject(parserPath, nofRawLines, time);
                }
                MSDLModelManager.getInstance().cbBuild(msdlFileInfo);
                this.fTimestamp = System.currentTimeMillis();
                break;
            }
            case 3: {
                if (this.checkCancel()) {
                    return;
                }
                MSDLSkipInfo mkInfo = (MSDLSkipInfo)info;
                ParserPath parserPath = mkInfo.getParserPath();
                MSDLFileInfo msdlFileInfo = new MSDLFileInfo(project, parserPath, null, null, this.fFileIndex, true);
                this.createResource(parserPath, msdlFileInfo);
                String message = DVTStringUtil.appendString((Object[])new Object[]{"Skipping ", parserPath, " ..."});
                this.consolePrint(message);
                break;
            }
        }
    }

    @Override
    public void consolePrint(String message) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(message);
    }

    private void createResource(ParserPath parserPath, MSDLFileInfo msdlFileInfo) {
        this.fResources2CreateMap.put(parserPath, msdlFileInfo);
    }

    private void createAutoLinkedResources(final IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.fResources2CreateMap.isEmpty()) {
            TestHelper.fAutoLinkTime -= (double)System.currentTimeMillis();
        }
        DVTAutoLinkManager.getInstance().startWorkspaceOperation(project, true);
        DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                long time = System.currentTimeMillis();
                HashSet<String> files = new HashSet<String>();
                for (ParserPath parserPath : MSDLBuildContributor.this.fResources2CreateMap.keySet()) {
                    files.add(new File(parserPath.path).getName());
                }
                HashMap<String, List<IFile>> fileCandidates = new HashMap<String, List<IFile>>();
                HashMap<IPath, IPath> directorySymlinks = new HashMap<IPath, IPath>();
                DVTFileUtils.getInstance().cacheDirectories(project, files, fileCandidates, directorySymlinks);
                DVTLogger.INSTANCE.logDebug("AUTO_LINKED: Time to collect " + directorySymlinks.size() + " symlinked directories takes " + (System.currentTimeMillis() - time));
                RfProject rfProject = RfManager.getInstance().getRfProject(MSDLBuildContributor.this.getProject());
                for (Map.Entry<ParserPath, MSDLFileInfo> entry : MSDLBuildContributor.this.fResources2CreateMap.entrySet()) {
                    ParserPath parserPath = entry.getKey();
                    IFile resource = MSDLBuildContributor.this.createAutoLinkedResource(project, Path.fromOSString((String)parserPath.path), fileCandidates, directorySymlinks, cachedLinksMap);
                    MSDLFileInfo msdlFileInfo = entry.getValue();
                    if (resource == null || msdlFileInfo == null) continue;
                    msdlFileInfo.setResource(resource);
                    RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
                    String languageSyntaxText = (fileDef == null ? IBuildConfigParserConstants.LanguageSyntax.MSDL : fileDef.getLanguageSyntax()).id;
                    PropertiesManager.addSessionProperty((IResource)resource, (String)PropertyTypes.QN_IMPORTED_FILE, (String)languageSyntaxText);
                    IFile parent = resource;
                    while ((parent = parent.getParent()) != null && PropertiesManager.getSessionProperty((IResource)parent, (String)PropertyTypes.QN_IMPORTED_FILE) == null) {
                        PropertiesManager.addSessionProperty((IResource)parent, (String)PropertyTypes.QN_IMPORTED_FILE, (String)languageSyntaxText);
                    }
                    MSDLBuildContributor.this.fRefreshTopFilesList.add((IResource)resource);
                }
            }
        };
        DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, MSDLDT_BUILDER_CALLER_NAME, op, false);
        DVTAutoLinkManager.getInstance().endWorkspaceOperation(project, false);
        if (!this.fResources2CreateMap.isEmpty()) {
            TestHelper.fAutoLinkTime += (double)System.currentTimeMillis();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFile createAutoLinkedResource(IProject project, IPath parserPath, Map<String, List<IFile>> fileCandidates, Map<IPath, IPath> directorySymlinks, Map<IPath, LinkDescription> cachedLinksMap) {
        try {
            if (parserPath.lastSegment().startsWith("__msdl__")) {
                return null;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file != null && file.getLocation() != null) {
                if (this.fAutoLinkedResourcesEnable) {
                    DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
                    return file;
                }
                if (!file.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) return file;
                return null;
            }
            if (!this.fAutoLinkedResourcesEnable) {
                return null;
            }
            if (DVTAutoLinkManager.getInstance().hasError(project, 2)) return null;
            if (DVTAutoLinkManager.getInstance().hasError(project, 1)) {
                return null;
            }
            file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file == null || file.getLocation() == null) {
                IFile projectFile = project.getFile(".project");
                boolean autolinkUsingLinks = DVTAutoLinkManager.getInstance().autolinkUsingLinksForProject(project);
                boolean readOnly = projectFile.getResourceAttributes().isReadOnly();
                if (readOnly && autolinkUsingLinks) {
                    DVTAutoLinkManager.getInstance().reportError(project, 1);
                } else {
                    file = DVTAutoLinkManager.getInstance().createAutoLink(project, parserPath, this.fAutoLinkedRoots, cachedLinksMap, false);
                }
            } else {
                DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
            }
            if (file == null) return file;
            String resourcePath = file.getProjectRelativePath().toOSString();
            PropertiesManager.addParser2ResourceMapProperty((IProject)project, (String)parserPath.toOSString(), (String)resourcePath);
            return file;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            DVTAutoLinkManager.getInstance().reportError(project, 2);
            return null;
        }
    }

    public int analyzeDelta(IResourceDelta delta, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        IProject project = this.getProject();
        String projectPrefix = String.valueOf(project.getName()) + ": ";
        monitor.beginTask(String.valueOf(projectPrefix) + "Analyzing Deltas ...", 1000);
        this.fDeltaChanged.clear();
        this.fDeltaRemoved.clear();
        this.fAlreadyCompiledFiles = null;
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            this.fAlreadyCompiledFiles = rfProject.getCompiledFilesSet();
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.msdldt.MSDLSource", false);
        delta.accept((IResourceDeltaVisitor)new ChangedModulesVisitor(fileExtensions));
        changedFiles.put(LanguageKind.MSDL, this.fDeltaChanged);
        return this.fDeltaChanged.size() + this.fDeltaRemoved.size();
    }

    protected void incrementalBuild(IProgressMonitor monitor) throws CoreException {
        String projectPrefix = String.valueOf(this.getProject().getName()) + ": ";
        boolean notifyAfterIncremental = false;
        IProject project = this.getProject();
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        boolean cancelIncremental = PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
        if (cancelIncremental) {
            ChangedFilesManager changedFilesManager = rfProject.getChangedFilesManager();
            this.fDeltaChanged.addAll(changedFilesManager.getBacklogElements());
            changedFilesManager.addBacklogElements(this.fDeltaChanged);
        }
        Map documentsInEditors = DVTFileUtils.getInstance().evalNonFileBufferParserPathDocuments();
        if (this.fDeltaChanged.size() + this.fDeltaRemoved.size() != 0) {
            block9: {
                this.fIncrMonitor = new SubProgressMonitor(monitor, 1000);
                int deltaStep = 1000 / (this.fDeltaChanged.size() + this.fDeltaRemoved.size());
                this.fIncrMonitor.beginTask(String.valueOf(projectPrefix) + "Processing Deltas ...", 1000);
                this.fIncrMonitorBegin = true;
                int i = 0;
                int workSize = this.fDeltaChanged.size();
                for (FileCompileInfo fileCompileInfo : this.fDeltaChanged) {
                    IFile file;
                    if (fileCompileInfo == null || (file = fileCompileInfo.getFile()) == null) continue;
                    ++i;
                    if (!this.fIncrMonitor.isCanceled()) {
                        this.fIncrMonitor.subTask(String.valueOf(projectPrefix) + "Loading (" + i + "/" + workSize + ") " + file.getLocation().toOSString() + "...");
                        IMSDLModule msdlModule = MSDLModelManager.getInstance().getMSDLModel().getOrCreateMSDLFile(file);
                        if (msdlModule != null) {
                            msdlModule.cancelReparse();
                        }
                        rfProject.setBuildProgressMonitor(monitor);
                        if (DVTFileUtils.getInstance().shouldIncrementalBuild(null, fileCompileInfo, this.getProject())) {
                            MSDLModelManager.getInstance().cbIncrementalBuild(monitor, fileCompileInfo, msdlModule == null ? null : (IDocument)documentsInEditors.get(msdlModule.getParserPath()), true);
                            notifyAfterIncremental = true;
                        }
                        this.fIncrMonitor.worked(deltaStep);
                        continue;
                    }
                    break block9;
                }
                i = 0;
                workSize = this.fDeltaRemoved.size();
                for (IFile file : this.fDeltaRemoved) {
                    ++i;
                    if (this.fIncrMonitor.isCanceled()) break;
                    this.fIncrMonitor.subTask(String.valueOf(projectPrefix) + "Removing (" + i + "/" + workSize + ") " + file.getLocation().toOSString() + "...");
                    MSDLModelManager.getInstance().cbRemove(file);
                    this.fIncrMonitor.worked(deltaStep);
                }
            }
            if (this.fIncrMonitorBegin && !this.fIncrMonitorDone) {
                this.fIncrMonitor.done();
                this.fIncrMonitorDone = true;
            }
        }
        if (!notifyAfterIncremental) {
            this.fNotifyAfterIncremental = false;
        }
    }

    public String getProjectName() {
        return this.fFullBuildProjectName;
    }

    public IRfSingleLangProject getIRfProject() {
        return RfManager.getInstance().getRfProjectWithoutRestore(this.getProject());
    }

    @Override
    public void newCancelPoolingThread() {
        this.fCancelPoolingThread = new MSDLPoolingCancelThread();
    }

    @Override
    public void startCancelPoolingThread(MSDLCompiler msdlParser, IProject project, boolean linting) {
        this.fCancelPoolingThread.startPoolingThread(this.fGlobalFullBuildMonitor, msdlParser, project, false);
    }

    @Override
    public void stopCancelPoolingThread() {
        this.fCancelPoolingThread.stopPoolingThread();
    }

    @Override
    public void setCancelPoolingThreadFileName(String fileName) {
        this.fCancelPoolingThread.setFileName(fileName);
    }

    @Override
    public void setTimestamp() {
        this.fTimestamp = System.currentTimeMillis();
    }

    @Override
    public void beginInvocation(int invocNumber) {
        this.fBuildProgressMonitoring.invocBegin(invocNumber);
    }

    @Override
    public void endInvocation(int invocNumber) {
        this.fBuildProgressMonitoring.invocDone(invocNumber);
    }

    @Override
    public void consolePrintSection(String message) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printSection(message);
    }

    @Override
    public int getFileIndex() {
        return this.fFileIndex;
    }

    public String getDisplayName() {
        return AUTOLINK_SUBFOLDER_NAME;
    }

    private class ChangedModulesVisitor
    implements IResourceDeltaVisitor {
        private String[] fFileExtensions;

        public ChangedModulesVisitor(String[] fileExtensions) {
            this.fFileExtensions = fileExtensions;
        }

        public boolean visit(IResourceDelta delta) {
            block27: {
                block32: {
                    RfProject rfProject;
                    ParserPath parserPath;
                    IResource resource;
                    block33: {
                        boolean isAlreadyCompiled;
                        IPath location;
                        IProject project;
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block26: {
                                            if (MSDLBuildContributor.this.fDeltaRemoved.size() + MSDLBuildContributor.this.fDeltaChanged.size() <= 50) break block26;
                                            return false;
                                        }
                                        resource = delta.getResource();
                                        if (resource.getType() == 4) {
                                            IProject project2 = (IProject)resource;
                                            return project2.hasNature("ro.amiq.msdldt.msdlnature");
                                        }
                                        if (resource.getType() != 1) break block27;
                                        if (delta.getFlags() != 0x100000) break block28;
                                        return false;
                                    }
                                    project = resource.getProject();
                                    location = resource.getLocation();
                                    if (location != null) break block29;
                                    return false;
                                }
                                parserPath = DVTFileUtils.getInstance().resource2parser(resource);
                                if (parserPath != null) break block30;
                                return false;
                            }
                            rfProject = RfManager.getInstance().getRfProjectWithoutRestore(resource.getProject());
                            if (rfProject != null) break block31;
                            return false;
                        }
                        boolean bl = isAlreadyCompiled = MSDLBuildContributor.this.fAlreadyCompiledFiles != null && MSDLBuildContributor.this.fAlreadyCompiledFiles.contains(parserPath);
                        if (delta.getKind() == 2) {
                            DVTAutoLinkManager.getInstance().removeFileInfo(location);
                            rfProject.disconnectFileFromDocument(parserPath);
                        }
                        if (!isAlreadyCompiled && !DVTFileUtils.getInstance().validExtension(this.fFileExtensions, resource.getName())) break block32;
                        if (!BuildConfigManager.isSkip((IProject)project, (ParserPath)parserPath)) break block33;
                        return false;
                    }
                    try {
                        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
                        if (fileDef != null) {
                            boolean disableMD5ChangeDetection;
                            if (delta.getKind() != 1 && (delta.getFlags() & 0x100) == 0) break block32;
                            long oldSize = fileDef.getParserPath().getSize();
                            byte[] oldMd5 = fileDef.getParserPath().getMd5();
                            boolean bl = disableMD5ChangeDetection = MSDLBuildContributor.this.fDisableMD5ChangeDetection || resource.getSessionProperty(DISABLE_MD5) != null;
                            if (!disableMD5ChangeDetection && new File(parserPath.path).length() == oldSize) {
                                byte[] newMd5 = new byte[]{};
                                Throwable throwable = null;
                                Object var15_17 = null;
                                try (MD5InputStream currentVerifFileStream = new MD5InputStream(new File(parserPath.path));){
                                    while (currentVerifFileStream.read() != -1) {
                                    }
                                    newMd5 = currentVerifFileStream.getMD5();
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                                if (!Arrays.equals(oldMd5, newMd5)) {
                                    MSDLBuildContributor.this.fDeltaChanged.add(new FileCompileInfo((IFile)resource));
                                } else if (DVTLogger.INSTANCE.isDebugMode()) {
                                    TestHelper.out.println("Skip compiling touched file (md5 unchanged): " + resource.getFullPath());
                                }
                                break block32;
                            }
                            MSDLBuildContributor.this.fDeltaChanged.add(new FileCompileInfo((IFile)resource));
                            break block32;
                        }
                        if (rfProject.getEditor(parserPath) == null) break block32;
                        if (delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0) {
                            MSDLBuildContributor.this.fDeltaChanged.add(new FileCompileInfo((IFile)resource));
                            break block32;
                        }
                        if (delta.getKind() != 2) break block32;
                        MSDLBuildContributor.this.fDeltaRemoved.add((IFile)resource);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                return false;
            }
            return true;
        }
    }
}

