/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.builders;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.msdldt.model.MSDLModelManager;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.parser.MSDLCompiler;
import ro.amiq.msdldt.ui.persistenttask.PersistentTaskManager;

public class MSDLBuilderUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean internalFullBuild(IBuildStatusProvider buildStatusProvider, MSDLCompiler msdlParser, RfProject rfProject, List<CustomPragma> customPragmas, DVTCodeCommentsPreferences commentsPreferences, int maxIssuesKindNumber) {
        try {
            IProject project = rfProject.getProject();
            if (project == null) {
                return false;
            }
            List invocations = BuildConfigManager.getInvocations((IProject)project);
            if (invocations == null) return false;
            if (invocations.isEmpty()) {
                return false;
            }
            Set taskNames = PersistentTaskManager.getInstance().getAllTaskNames();
            boolean hideTaskTags = PersistentTaskManager.getInstance().getHideTaskTags();
            boolean caseSensitiveTaskTags = PersistentTaskManager.getInstance().getCaseSensitiveTaskTags();
            int invocOffset = 0;
            int fileIndex = 0;
            int invocNumber = 0;
            while (true) {
                if (invocNumber >= invocations.size()) {
                    return true;
                }
                Invocation invocation = (Invocation)invocations.get(invocNumber);
                buildStatusProvider.beginInvocation(invocNumber);
                List topFiles = BuildConfigManager.getTopFiles((Invocation)invocation, (LanguageKind)LanguageKind.MSDL);
                SkipCompileFilter skipCompileFilter = BuildConfigManager.getSkipCompileFilter((IProject)project, (Invocation)invocation);
                if (!topFiles.isEmpty()) {
                    buildStatusProvider.consolePrint("*** Loading top files ***");
                    int i = 0;
                    while (i < topFiles.size()) {
                        String pathValue = null;
                        IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.MSDL;
                        BuildConfigProperty topFileProperty = (BuildConfigProperty)topFiles.get(i);
                        languageSyntax = (IBuildConfigParserConstants.LanguageSyntax)topFileProperty.getAttribute("ATTRIBUTE_LANGUAGE_SYNTAX");
                        if (languageSyntax == null) {
                            languageSyntax = IBuildConfigParserConstants.LanguageSyntax.MSDL;
                        }
                        if (topFileProperty.getKind() == 0) {
                            if (buildStatusProvider.checkCancel()) {
                                return false;
                            }
                            pathValue = topFileProperty.getValue();
                            pathValue = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(pathValue);
                            if ((pathValue = DVTUtilsCommon.INSTANCE.getFileSubstitute(project, pathValue)) != null) {
                                MSDLModelManager.getInstance().addTopFile(pathValue);
                                MSDLCompiler mSDLCompiler = msdlParser;
                                synchronized (mSDLCompiler) {
                                    block20: {
                                        if (!msdlParser.isInterrupted()) break block20;
                                        buildStatusProvider.stopCancelPoolingThread();
                                        return true;
                                    }
                                    try {
                                        try {
                                            buildStatusProvider.setTimestamp();
                                            buildStatusProvider.newCancelPoolingThread();
                                            buildStatusProvider.startCancelPoolingThread(msdlParser, project, false);
                                            msdlParser.parseFile(pathValue, invocation.getLibName(), languageSyntax, rfProject, null, false, fileIndex, invocNumber + invocOffset, maxIssuesKindNumber, customPragmas, commentsPreferences, taskNames, caseSensitiveTaskTags, hideTaskTags, skipCompileFilter);
                                            ++fileIndex;
                                        }
                                        catch (Exception e) {
                                            DVTLogger.INSTANCE.logError((Throwable)e);
                                            buildStatusProvider.stopCancelPoolingThread();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        buildStatusProvider.stopCancelPoolingThread();
                                        throw throwable;
                                    }
                                    buildStatusProvider.stopCancelPoolingThread();
                                }
                            }
                        }
                        ++i;
                    }
                }
                buildStatusProvider.endInvocation(invocNumber);
                ++invocNumber;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public static interface IBuildStatusProvider {
        public void consolePrint(String var1);

        public void consolePrintSection(String var1);

        public void newCancelPoolingThread();

        public void startCancelPoolingThread(MSDLCompiler var1, IProject var2, boolean var3);

        public void setCancelPoolingThreadFileName(String var1);

        public void stopCancelPoolingThread();

        public void setTimestamp();

        public boolean checkCancel();

        public void beginInvocation(int var1);

        public void endInvocation(int var1);

        public int getFileIndex();
    }
}

