/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.builders;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.BuildInterruptedDialog;
import ro.amiq.msdldt.parser.MSDLCompiler;

public class MSDLPoolingCancelThread {
    private static final long POOLING_STEP_DURATION = 250L;
    public static final int RUNNING = 0;
    public static final int CANCELED = 1;
    public static final int STOPPED = 2;
    public static final int FORCED = 3;
    private IProgressMonitor fMonitor;
    private MSDLCompiler fParser;
    private IProject fProject;
    private int fPoolingSteps;
    private int fPoolingStatus;
    private Timer fTimer;
    private PoolingTask fPoolingTask;
    private boolean fNotify;
    private boolean fIncremental;
    private String fFileName;
    private int fPoolingMaxDuration = 0;

    public void stopPoolingThread() {
        this.fMonitor = null;
        this.fPoolingSteps = 0;
        this.fParser = null;
        this.fPoolingStatus = 2;
        this.fNotify = true;
        if (this.fTimer != null) {
            this.fTimer.cancel();
        }
    }

    public void resetPoolingThread() {
        this.fPoolingSteps = 0;
    }

    public int getPoolingStatus() {
        return this.fPoolingStatus;
    }

    public void startPoolingThread(IProgressMonitor monitor, MSDLCompiler parser, IProject project, boolean incremental) {
        this.fMonitor = monitor;
        this.fParser = parser;
        this.fProject = project;
        this.fPoolingSteps = 0;
        this.fPoolingStatus = 0;
        this.fNotify = true;
        this.fIncremental = incremental;
        Integer backwardPoolingMaxDuration = null;
        IPreferenceStore preferenceStore = DVTPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.contains("ro.amiq.dvt.STOP_TIME_DISABLE") && preferenceStore.getDefaultBoolean("ro.amiq.dvt.STOP_TIME_DISABLE")) {
            backwardPoolingMaxDuration = 0;
        } else if (preferenceStore.contains("ro.amiq.dvt.STOP_TIME_AUTOBUILD") && preferenceStore.getDefaultInt("ro.amiq.dvt.STOP_TIME_AUTOBUILD") != 40) {
            backwardPoolingMaxDuration = preferenceStore.getDefaultInt("ro.amiq.dvt.STOP_TIME_AUTOBUILD");
        }
        if (this.fIncremental) {
            if (!BuildConfigManager.hasDirective((IProject)this.fProject.getProject(), (IBuildConfigParserConstants.Directive)IBuildConfigParserConstants.Directive.INCREMENTAL_COMPILE_TIMEOUT) && backwardPoolingMaxDuration != null) {
                this.fPoolingMaxDuration = backwardPoolingMaxDuration;
                DVTLogger.INSTANCE.logInfo("Incremental build timeout set to " + this.fPoolingMaxDuration + " because it is specified via -pluginCustomization and no +dvt_incremental_compile_timeout directives are present");
            } else {
                this.fPoolingMaxDuration = BuildConfigManager.getIncrementalCompileTimeout((IProject)this.fProject.getProject());
            }
        } else if (!BuildConfigManager.hasDirective((IProject)this.fProject.getProject(), (IBuildConfigParserConstants.Directive)IBuildConfigParserConstants.Directive.FILE_COMPILE_TIMEOUT) && backwardPoolingMaxDuration != null) {
            this.fPoolingMaxDuration = backwardPoolingMaxDuration;
            DVTLogger.INSTANCE.logInfo("Full build timeout set to " + this.fPoolingMaxDuration + " because it is specified via -pluginCustomization and no +dvt_file_compile_timeout directives are present");
        } else {
            this.fPoolingMaxDuration = BuildConfigManager.getFileCompileTimeout((IProject)this.fProject.getProject());
        }
        this.fTimer = new Timer();
        this.fPoolingTask = new PoolingTask();
        this.fTimer.schedule((TimerTask)this.fPoolingTask, 250L, 250L);
    }

    public void interrupt(MSDLCompiler parser, IProject project, boolean notify) {
        if (this.fNotify) {
            this.fNotify = false;
            if (notify) {
                BuildInterruptedDialog.openWarning((IProject)this.fProject.getProject(), (String)this.fFileName, (boolean)this.fIncremental);
            }
        }
        parser.interrupt();
    }

    public void setFileName(String fileName) {
        this.fFileName = fileName;
    }

    class PoolingTask
    extends TimerTask {
        PoolingTask() {
        }

        @Override
        public void run() {
            try {
                if (MSDLPoolingCancelThread.this.fMonitor != null && MSDLPoolingCancelThread.this.fMonitor.isCanceled()) {
                    MSDLPoolingCancelThread.this.interrupt(MSDLPoolingCancelThread.this.fParser, MSDLPoolingCancelThread.this.fProject, false);
                    if (MSDLPoolingCancelThread.this.fPoolingStatus != 2) {
                        MSDLPoolingCancelThread.this.fPoolingStatus = 1;
                    }
                    return;
                }
                if (MSDLPoolingCancelThread.this.fPoolingMaxDuration != 0 && (long)MSDLPoolingCancelThread.this.fPoolingSteps >= (long)(MSDLPoolingCancelThread.this.fPoolingMaxDuration * 1000) / 250L) {
                    MSDLPoolingCancelThread.this.interrupt(MSDLPoolingCancelThread.this.fParser, MSDLPoolingCancelThread.this.fProject, true);
                    if (MSDLPoolingCancelThread.this.fPoolingStatus != 2) {
                        MSDLPoolingCancelThread.this.fPoolingStatus = 3;
                    }
                    return;
                }
                ++MSDLPoolingCancelThread.this.fPoolingSteps;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

