/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.externaltools;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.msdldt.model.MSDLModelManager;
import ro.amiq.msdldt.model.MSDLProject;
import ro.amiq.msdldt.utils.MSDLFileUtils;

public class MSDLExternalToolsDelegate
implements IExternalToolsDelegate {
    private static volatile MSDLExternalToolsDelegate fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private MSDLExternalToolsDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MSDLExternalToolsDelegate getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new MSDLExternalToolsDelegate();
            }
        }
        return fInstance;
    }

    public IFile getResource(IProject project, String knownPath) {
        String customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        Path path = new Path(customPath);
        if (path.isAbsolute()) {
            File classicFile = new File(customPath);
            IFile candidate = MSDLFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
            if (candidate == null) {
                return null;
            }
            return candidate;
        }
        MSDLProject pssProject = (MSDLProject)MSDLModelManager.getInstance().getMSDLModel().getMSDLProject(project);
        if (pssProject != null) {
            File classicFile = new File(customPath);
            IFile candidate = MSDLFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
            if (candidate == null) {
                return null;
            }
            return candidate;
        }
        customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        IFile candidate = MSDLFileUtils.getInstance().findProjectFile(project, customPath);
        if (candidate == null) {
            return null;
        }
        return candidate;
    }

    public String getBuilderKind() {
        return "ro.amiq.dvt.msdldtKind";
    }

    public void openEditor(IProject project, String workingDirectory, String filePath, int line) {
        if (!Path.fromOSString((String)filePath).isAbsolute()) {
            filePath = Path.fromOSString((String)workingDirectory).append(filePath).toOSString();
        }
        filePath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(filePath);
        MSDLFileUtils.getInstance().openFile(project, filePath, line, null);
    }

    public boolean hasRelevantContentType(String fileName) {
        if (fileName == null) {
            return false;
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.msdldt.MSDLSource", false);
        return DVTFileUtils.getInstance().validExtension(fileExtensions, fileName);
    }
}

