/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model;

import antlr.collections.AST;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.msdldt.model.ASTUtils;
import ro.amiq.msdldt.parser.EAST;

public class MSDLFileInfo
extends DVTFileInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient IProject project;
    private ParserPath parserPath;
    private transient IFile resource;
    private transient AST ast;
    private int index;
    private boolean saveRFDM;

    public MSDLFileInfo(IProject project, ParserPath parserPath, IFile resource, AST pssAST, int index, boolean saveRFDM) {
        this.project = project;
        this.parserPath = parserPath;
        this.resource = resource;
        this.ast = pssAST;
        this.saveRFDM = saveRFDM;
        this.index = index;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setResource(IFile resource) {
        this.resource = resource;
    }

    public IFile getResource() {
        return this.resource;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public AST getAST() {
        return this.ast;
    }

    public void setAST(AST pssAST) {
        this.ast = pssAST;
    }

    public int getFileIndex() {
        return this.index;
    }

    public boolean isSaveRFDM() {
        return this.saveRFDM;
    }

    private void readAST(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        try {
            boolean hasAST = ois.readBoolean();
            if (!hasAST) {
                return;
            }
            this.ast = null;
            do {
                this.ast = (EAST)((Object)ois.readObject());
                if (this.ast.getNextSibling() != null) {
                    ((EAST)this.ast.getNextSibling()).setPrevSibling((EAST)this.ast);
                }
                if (this.ast.getFirstChild() == null) continue;
                ((EAST)this.ast.getFirstChild()).setParent((EAST)this.ast);
            } while (!((EAST)this.ast).isRootElement());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void writeAST(final ObjectOutputStream oos) throws IOException {
        try {
            EAST node = (EAST)this.ast;
            if (node == null) {
                oos.writeBoolean(false);
                return;
            }
            oos.writeBoolean(true);
            ASTUtils.scanAST(new ASTUtils.ASTRunnable(){

                @Override
                public void run(AST node) throws Exception {
                    oos.writeObject(node);
                }
            }, this.ast);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        this.writeAST(oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.readAST(ois);
    }
}

