/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.DVTMixedLangBuilder;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.msdldt.model.IMSDLModel;
import ro.amiq.msdldt.model.IMSDLModule;
import ro.amiq.msdldt.model.IMSDLProject;
import ro.amiq.msdldt.model.MSDLFileInfo;
import ro.amiq.msdldt.model.MSDLModel;
import ro.amiq.msdldt.model.MSDLModule;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.util.NullProtectedList;
import ro.amiq.msdldt.parser.MSDLCompiler;
import ro.amiq.msdldt.parser.MSDLProblem;
import ro.amiq.msdldt.ui.syntaxerrors.SyntaxErrorsManager;

public class MSDLModelManager
extends DVTModelManager {
    private static volatile MSDLModelManager fInstance;
    private final MSDLModel fModel;
    private HashMap<IPath, ArrayList> fTopFilesErrors = new HashMap();
    private HashMap<IPath, ArrayList> fTopFilesWarnings = new HashMap();
    private List<MSDLProblem> fUnreportedErrors = new NullProtectedList<MSDLProblem>();
    private List<MSDLProblem> fUnreportedWarnings = new NullProtectedList<MSDLProblem>();
    private RfManager fRfManager;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private MSDLModelManager() {
        this.fModel = new MSDLModel();
        this.fRfManager = RfManager.getInstance();
        this.addBuildListener(this.fRfManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MSDLModelManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new MSDLModelManager();
            }
        }
        return fInstance;
    }

    public int getPriority() {
        return DVTMixedLangBuilder.getBuilderPriorityForNature((String)"ro.amiq.msdldt.msdlnature");
    }

    public IMSDLModel getMSDLModel() {
        return this.fModel;
    }

    public IMSDLProject getIMSDLProject(IDVTProject iDVTProject) {
        return (IMSDLProject)iDVTProject;
    }

    public IMSDLModule getIMSDLFile(IDVTFile iDVTFile) {
        return (IMSDLModule)iDVTFile;
    }

    public MSDLFileInfo getMSDLFileInfo(DVTFileInfo dvtFileInfo) {
        return (MSDLFileInfo)dvtFileInfo;
    }

    public void saveUnfinishedJobs(IProject project) {
    }

    public void cbClean(IProject project) {
        this.fTopFilesErrors.clear();
        this.fTopFilesWarnings.clear();
        this.fUnreportedErrors.clear();
        this.fUnreportedWarnings.clear();
        IMSDLProject pssProject = this.getMSDLModel().getMSDLProject(project);
        if (pssProject == null) {
            return;
        }
        pssProject.clean();
        this.notifyReparseListeners(2, project);
        this.notifyBuildListenersClean(pssProject, true);
    }

    public void cbBuild(DVTFileInfo dvtFileInfo) {
        try {
            MSDLFileInfo info = this.getMSDLFileInfo(dvtFileInfo);
            IMSDLProject pssProject = this.getMSDLModel().getMSDLProject(info.getProject());
            if (pssProject != null) {
                pssProject.addTopFile(info.getParserPath());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cbPostFullBuild(IProject project, boolean success) {
        DVTLogger.INSTANCE.logDebug("DEBUG: cbPostFullBuild start");
        IMSDLProject pssProject = this.getMSDLModel().getMSDLProject(project);
        if (pssProject == null) {
            return;
        }
        MSDLCompiler pssParser = pssProject.getMSDLParser();
        if (pssParser == null) {
            return;
        }
        NullProtectedList<MSDLProblem> unreportedErrors = new NullProtectedList<MSDLProblem>();
        NullProtectedList<MSDLProblem> unreportedWarnings = new NullProtectedList<MSDLProblem>();
        ArrayList<IMSDLModule> pssFiles = new ArrayList<IMSDLModule>();
        for (ParserPath parserPath : pssProject.getTopFiles()) {
            IFile file = DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
            if (file != null && file.getLocation() != null) {
                MSDLCompiler mSDLCompiler;
                IPath location = file.getLocation();
                String resourcePath = location.toOSString();
                IMSDLModule pssFile = this.getMSDLModel().getOrCreateMSDLFile(file);
                if (this.fTopFilesErrors.containsKey(location)) {
                }
                if (pssFile != null) {
                    pssFiles.add(pssFile);
                    mSDLCompiler = pssParser;
                    synchronized (mSDLCompiler) {
                        pssFile.setEncrypted(pssParser.isEncrypted(parserPath));
                        boolean updatePath = !resourcePath.equals(parserPath.path);
                        pssFile.setErrors(pssParser.getErrors(parserPath), updatePath, resourcePath);
                        pssFile.setWarnings(pssParser.getWarnings(parserPath), updatePath, resourcePath);
                        pssFile.setTasks(pssParser.getTasks(parserPath));
                        continue;
                    }
                }
                mSDLCompiler = pssParser;
                synchronized (mSDLCompiler) {
                    unreportedErrors.addAll(pssParser.getErrors(parserPath));
                    unreportedWarnings.addAll(pssParser.getWarnings(parserPath));
                    continue;
                }
            }
            MSDLCompiler mSDLCompiler = pssParser;
            synchronized (mSDLCompiler) {
                unreportedErrors.addAll(pssParser.getErrors(parserPath));
                unreportedWarnings.addAll(pssParser.getWarnings(parserPath));
            }
        }
        int type = 6;
        this.notifyReparseListeners(1, type, pssFiles);
        this.notifyReparseListeners(3, project);
        if (!unreportedErrors.isEmpty()) {
            SyntaxErrorsManager.getInstance().updateProblemsUI(project, unreportedErrors);
        }
        this.notifyBuildListenersPostFullBuild(pssProject, success);
    }

    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo fileInfo, IDocument document, boolean saveRFDM) {
        if (fileInfo == null) {
            return;
        }
        IFile file = fileInfo.getFile();
        if (file == null || !file.exists()) {
            return;
        }
        this.cbClean(file);
        IMSDLModule pssFile = this.getMSDLModel().getOrCreateMSDLFile(file);
        if (pssFile == null) {
            return;
        }
        try {
            if (document != null) {
                pssFile.reparse(monitor, document.get(), saveRFDM);
            } else {
                pssFile.reparse(monitor, saveRFDM);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (pssFile.isAutoBuildStop()) {
            return;
        }
        int type = 1;
        type |= 2;
        this.notifyReparseListeners(0, type |= 4, pssFile);
        IMSDLProject pssProject = this.getMSDLModel().getMSDLProject(file.getProject());
        MSDLCompiler pssParser = pssProject.getMSDLParser();
        ParserPath parserPath = pssFile.getParserPath();
        RfProject rfProject = RfManager.getInstance().getRfProject(file.getProject());
        if (rfProject != null && pssParser != null && parserPath != null) {
            RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
            AST pssAST = pssParser.getFileAST();
            this.notifyBuildListenersPostIncrementalBuild(new MSDLFileInfo(file.getProject(), parserPath, file, pssAST, fileDef == null ? -1 : fileDef.getIndex(), saveRFDM));
        }
    }

    public void cbInstanceIncrementalBuild(MSDLModule pssFile, IDVTFileInstance instance, MSDLCompiler pssParser) {
        if (pssFile == null) {
            return;
        }
        if (pssFile.isAutoBuildStop()) {
            return;
        }
        IFile file = pssFile.getFile();
        ParserPath parserPath = pssFile.getParserPath();
        RfProject rfProject = RfManager.getInstance().getRfProject(file.getProject());
        if (rfProject != null && pssParser != null && parserPath != null) {
            RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
            AST pssAST = pssParser.getFileAST();
            this.notifyBuildListenersIncrementalBuild(new MSDLFileInfo(file.getProject(), parserPath, file, pssAST, fileDef == null ? -1 : fileDef.getIndex(), true));
        }
    }

    public void cbRemove(IFile file) {
        IMSDLModule vModule = this.getMSDLModel().getOrCreateMSDLFile(file);
        if (vModule != null) {
            this.notifyBuildListenersRemove(vModule);
        }
    }

    public void cbClean(IFile file) {
        IMSDLModule pssFile = this.getMSDLModel().getOrCreateMSDLFile(file);
        if (pssFile == null) {
            return;
        }
        this.notifyBuildListenersClean(pssFile);
    }

    public MSDLFileInfo getModuleInfo(DVTFileInfo dvtFileInfo) {
        return (MSDLFileInfo)dvtFileInfo;
    }

    public IMSDLModule getIMSDLModule(IDVTFile iDVTFile) {
        return (IMSDLModule)iDVTFile;
    }

    public void addTopFile(String parserPath) {
        IPath path = Path.fromOSString((String)parserPath);
        this.fTopFilesErrors.put(path, null);
        this.fTopFilesWarnings.put(path, null);
    }

    public void cleanMSDLProject(IProject project) {
        this.fModel.cleanIDVTProject(project);
    }
}

