/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.indexer;

import java.io.File;
import ro.amiq.dvt.model.indexer.AbstractIdentifierIndexer;

public class IdentifierIndexer
extends AbstractIdentifierIndexer {
    private static final String INDEX_FILE = String.valueOf(File.separatorChar) + "msdl_index";

    public String getIndexerFileName() {
        return INDEX_FILE;
    }

    public void index(String text, int line, int column, int ttype, boolean token) {
        try {
            if (token && (ttype == 144 || ttype == 153)) {
                this.indexToken(text, line, column);
            } else if (!token) {
                StringBuilder buff = new StringBuilder();
                int i = 0;
                while (i < text.length()) {
                    char ch = text.charAt(i);
                    if (ch == '\r' || ch == '\n') {
                        length = buff.length();
                        if (length > 0) {
                            this.indexToken(buff.toString(), line, column);
                            buff.delete(0, length);
                        }
                        ++line;
                        column = 1;
                    } else if (i == 0 && Character.isJavaIdentifierStart(ch)) {
                        buff.append(ch);
                    } else if (i != 0 && Character.isJavaIdentifierPart(ch)) {
                        buff.append(ch);
                    } else {
                        length = buff.length();
                        if (length > 0) {
                            this.indexToken(buff.toString(), line, column);
                            column += length;
                            buff.delete(0, length);
                        }
                        ++column;
                    }
                    ++i;
                }
                int length = buff.length();
                if (length > 0) {
                    this.indexToken(buff.toString(), line, column);
                }
            }
        }
        catch (Exception exception) {}
    }

    public synchronized void indexToken(String word, int line, int column) {
        super.indexToken(word, line, column);
    }

    public void index2(String text, int line, int column, int ttype, boolean token, boolean isSkip, boolean doIndex) {
    }
}

