/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.startup.core.DVTLogger;

public class Determinant {
    private static final Pattern SEPARATOR = Pattern.compile(",\\s++");
    private Set<String> determinantSet;

    public Determinant(String fullName) {
        List<String> rawChunks = Arrays.asList(SEPARATOR.split(fullName, 0));
        this.determinantSet = new LinkedHashSet<String>();
        this.determinantSet.addAll(rawChunks);
    }

    public Determinant() {
        this.determinantSet = new LinkedHashSet<String>();
    }

    public void deepClean() {
        try {
            this.determinantSet = null;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public String[] toArray() {
        return this.determinantSet.toArray(new String[this.determinantSet.size()]);
    }

    public boolean equals(Object obj) {
        if (this.determinantSet == null) {
            return false;
        }
        if (obj instanceof Determinant) {
            Determinant determinant = (Determinant)obj;
            if (determinant.determinantSet == null) {
                return false;
            }
            if (this.determinantSet.size() != determinant.determinantSet.size()) {
                return false;
            }
            return this.determinantSet.containsAll(determinant.determinantSet);
        }
        return false;
    }

    public boolean contains(Determinant subDeterminant) {
        if (subDeterminant == null) {
            return true;
        }
        if (this.determinantSet == null) {
            return false;
        }
        if (subDeterminant.determinantSet == null) {
            return false;
        }
        if (this.determinantSet.size() < subDeterminant.determinantSet.size()) {
            return false;
        }
        return this.determinantSet.containsAll(subDeterminant.determinantSet);
    }

    public int hashCode() {
        return this.internalCannonicRepresentation().hashCode();
    }

    private String internalCannonicRepresentation() {
        StringBuilder result = new StringBuilder();
        if (this.determinantSet == null) {
            return result.toString();
        }
        Object[] determinant = this.toArray();
        Arrays.sort(determinant);
        Object[] objectArray = determinant;
        int n = determinant.length;
        int n2 = 0;
        while (n2 < n) {
            Object chunk = objectArray[n2];
            if (result.length() == 0) {
                result.append((String)chunk);
            } else {
                result.append(", ").append((String)chunk);
            }
            ++n2;
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.determinantSet != null) {
            for (String chunk : this.determinantSet) {
                if (result.length() == 0) {
                    result.append(chunk);
                    continue;
                }
                result.append(", ").append(chunk);
            }
        }
        return result.toString();
    }

    public static Determinant concat(Determinant determinant, String qualifier) {
        if (determinant == null) {
            return new Determinant(qualifier);
        }
        Determinant determinant2 = new Determinant();
        determinant2.determinantSet.addAll(determinant.determinantSet);
        determinant2.determinantSet.add(qualifier);
        return determinant2;
    }

    public static Determinant concat(Determinant determinant1, Determinant determinant2) {
        if (determinant1 == null) {
            return determinant2;
        }
        Determinant result = new Determinant();
        result.determinantSet.addAll(determinant1.determinantSet);
        result.determinantSet.addAll(determinant2.determinantSet);
        return result;
    }

    public boolean isEmpty() {
        return this.determinantSet == null || this.determinantSet.isEmpty();
    }
}

