/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.Collection;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.msdldt.model.reflection.DataType;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.IRfAssociatedType;
import ro.amiq.msdldt.model.reflection.RfArrayType;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfDummyElement;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfWhenSubtype;

public abstract class RfAssociatedType
extends RfNamedElement
implements IRfAssociatedType {
    protected DataType associatedDataType;
    protected RfNamedElement resolvedType;

    public RfAssociatedType(String name, DataType dataType) {
        super(name);
        this.associatedDataType = dataType;
    }

    public void setDataType(DataType dataType) {
        this.associatedDataType = dataType;
    }

    @Override
    public DataType getDataType() {
        return this.associatedDataType;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RfAssociatedType rfAssociatedType = (RfAssociatedType)super.clone();
        return rfAssociatedType;
    }

    @Override
    public boolean getAssociatedTypeArray() {
        if (this.associatedDataType == null) {
            return false;
        }
        return this.associatedDataType.isList();
    }

    @Override
    public String getAssociatedTypeArrayDim() {
        return "";
    }

    public String getAssociatedTypeName() {
        if (this.resolvedType != null) {
            return this.resolvedType.getName();
        }
        if (this.associatedDataType != null) {
            return this.associatedDataType.getTypeName();
        }
        return "";
    }

    public RfNamedElement getAssociatedBaseType() {
        if (this.resolvedType instanceof RfUnresolvedInfo) {
            return null;
        }
        if (this.resolvedType instanceof RfArrayType) {
            return ((RfArrayType)this.resolvedType).getAssociatedBaseType();
        }
        return this.resolvedType;
    }

    public Determinant getAssociatedTypeDeterminant() {
        if (this.resolvedType instanceof RfWhenSubtype) {
            return ((RfWhenSubtype)this.resolvedType).getDeterminant();
        }
        if (this.resolvedType != null) {
            return this.resolvedType.getDeterminant();
        }
        return this.getDeterminant();
    }

    public RfNamedElement getAssociatedType() {
        return this.resolvedType instanceof RfUnresolvedInfo ? null : this.resolvedType;
    }

    public void setAssociatedType(RfNamedElement namedElement) {
        this.resolvedType = namedElement;
    }

    @Override
    public void deepClean() {
        super.deepClean();
        if (this.associatedDataType != null) {
            this.associatedDataType.clear();
        }
        this.associatedDataType = null;
        this.resolvedType = null;
    }

    @Override
    public void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
        this.resolvedType = null;
        this.associatedDataType = null;
    }

    public String getRange() {
        return null;
    }

    public static class RfUnresolvedInfo
    extends RfDummyElement {
        private int offset = -1;
        private int index;
        private IRfNamedElement parentScope;
        private Collection<IRfNamedElement> candidates;

        public RfUnresolvedInfo(String name, int index, int offset, IRfNamedElement parentScope) {
            this(name, index, offset, parentScope, null);
        }

        public RfUnresolvedInfo(String name, int index, int offset, IRfNamedElement parentScope, Collection<IRfNamedElement> candidates) {
            super(name);
            this.index = index;
            this.offset = offset;
            this.parentScope = parentScope;
            this.candidates = candidates;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getIndex() {
            return this.index;
        }

        public IRfNamedElement getParentScope() {
            return this.parentScope;
        }

        public Collection<IRfNamedElement> getCandidates() {
            return this.candidates;
        }
    }
}

