/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.Collection;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.model.reflection.BlockKind;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.RfAssociatedType;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfMembersContainer;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfPredefinedField;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.semantic.SemanticUtils;

public class RfBlock
extends RfMembersContainer {
    private BlockKind blockKind = BlockKind.ACTIVITY;
    private RfNamedElement matchScope;
    private RfPredefinedField itVariable;
    private RfPredefinedField meVariable;
    private RfPredefinedField outerVariable;
    private RfAssociatedType itMember;

    public RfBlock(String name) {
        super(name);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RfBlock rfBlock = (RfBlock)super.clone();
        return rfBlock;
    }

    public void setItMember(RfAssociatedType secondaryScope) {
        this.itMember = secondaryScope;
    }

    @Override
    public String getKindName() {
        if (this.blockKind == null) {
            return null;
        }
        return this.blockKind.toString();
    }

    public void setMatchScope(RfNamedElement matchScope) {
        this.matchScope = matchScope;
    }

    public RfNamedElement getMatchScope() {
        return this.matchScope;
    }

    @Override
    public void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
        this.itVariable = null;
        this.meVariable = null;
        this.outerVariable = null;
        this.itMember = null;
        this.matchScope = null;
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, IRfElementFilter elementFilter) {
        if ("it".equals(name)) {
            return this.getItVariable();
        }
        if ("me".equals(name)) {
            return this.getMeVariable();
        }
        if ("outer".equals(name) && this.blockKind == BlockKind.IN_WITH) {
            return this.getOuterVariable();
        }
        RfNamedElement result = super.getLocalMember(null, classes, name, elementFilter);
        if (result != null) {
            return result;
        }
        Collection<RfNamedElement> localMembers = this.getLocalMembers();
        if (localMembers == null || localMembers.isEmpty()) {
            return null;
        }
        for (RfNamedElement member : localMembers) {
            if (!(member instanceof RfBlock) || !member.isAnonymous() || (result = member.getLocalMember(null, classes, name, elementFilter)) == null) continue;
            return result;
        }
        return null;
    }

    private RfNamedElement getItVariable() {
        if (this.itVariable == null) {
            this.itVariable = new RfPredefinedField("it", null, "Implicit variable that refers to the current item");
        }
        this.itVariable.setAssociatedType(this.itMember != null ? this.itMember.getAssociatedType() : null);
        return this.itVariable;
    }

    private RfNamedElement getMeVariable() {
        if (this.meVariable == null) {
            this.meVariable = new RfPredefinedField("me", null, "Implicit variable that refers to the current scenario scope");
        }
        this.meVariable.setAssociatedType(this.itMember != null ? this.itMember.getEnclosingScope() : null);
        return this.meVariable;
    }

    private RfNamedElement getOuterVariable() {
        if (this.outerVariable == null) {
            this.outerVariable = new RfPredefinedField("outer", null, "Implicit variable that refers to the current item");
        }
        this.outerVariable.setAssociatedType(this.getEnclosingScope(RfStruct.class));
        return this.outerVariable;
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        super.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
    }

    @Override
    protected void internalGetMember(Set<RfNamedElement> result, Determinant determinant, Set<IRfNamedElement> visited, String name, boolean isAmbiguousCheck, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter filter) {
        RfNamedElement scope;
        if ("it".equals(name)) {
            result.add(this.getItVariable());
            return;
        }
        if ("me".equals(name)) {
            result.add(this.getMeVariable());
            return;
        }
        if ("outer".equals(name) && this.blockKind == BlockKind.IN_WITH) {
            result.add(this.getOuterVariable());
            return;
        }
        if (this.itMember != null && SemanticUtils.valid(this.itMember) && (scope = this.itMember.getAssociatedType()) != null && SemanticUtils.valid(scope)) {
            scope.internalGetMember(result, this.itMember.getAssociatedTypeDeterminant(), visited, name, isAmbiguousCheck, isFirst, classes, filter);
        }
        if (!result.isEmpty()) {
            return;
        }
        super.internalGetMember(result, determinant, visited, name, isAmbiguousCheck, isFirst, classes, filter);
    }

    @Override
    protected <T extends IRfNamedElement> void internalGetMembers(Set<IRfNamedElement> visited, Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        super.internalGetMembers(visited, result, determinant, clazz, prefix, matchType, local, isFirst, accessModifier, elementFilter);
    }

    @Override
    public Collection<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        return super.getLocalMembers(determinant, classes);
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (this.isAnonymous()) {
            return;
        }
        super.performAdditionalSemanticChecks(project, currentLayer);
    }

    public String getSignature() {
        switch (this.blockKind) {
            case ACTIVITY: {
                return "activity " + this.getName();
            }
            case CONSTRAINT: {
                return "activity statement " + this.getName();
            }
            case SELECT: {
                return "activity select " + this.getName();
            }
        }
        return "[unknown]";
    }

    @Override
    public String getContextType() {
        return "ro.amiq.msdldt.templates.contextType.unknown";
    }

    public Image getImage() {
        switch (this.blockKind) {
            case CONSTRAINT: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CONSTRAINT);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.PSS_ACTIVITY);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        switch (this.blockKind) {
            case CONSTRAINT: {
                return "DUPLICATE_CONSTRAINT: Duplicate constraint ''{0}'' already declared\n    at line {1,number,#######} in {2}";
            }
        }
        return "DUPLICATE_ACTIVITY: Duplicate activity ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public void setBlockKind(BlockKind blockKind) {
        this.blockKind = blockKind;
    }

    public BlockKind getBlockKind() {
        return this.blockKind;
    }
}

