/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.IFileDocumentListener;
import ro.amiq.msdldt.model.reflection.IRfScope;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfDefElementVisitorAdapter;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.utils.Utils;

public class RfDefElement
implements IFileDocumentListener,
IRfScope,
IRfDefElement,
Comparable<RfDefElement>,
IRfBreadcrumbElement {
    private LineInfo startLine;
    private LineInfo endLine;
    private RfFileDef fileDef;
    private CommentBlock comment;
    private RfNamedElement namedElement;
    private List<RfDefElement> childrenDefs;
    private Position position;
    private boolean isIsLayer;
    private RfDefElement enclosingStructDef;
    private String packageName;
    private AST nodeAST;
    private Determinant determinant;

    public RfDefElement(RfFileDef fileDef, Determinant determinant, RfDefElement enclosingStructDef, String packageName, LineInfo startInfo, LineInfo endInfo, boolean isIsLayer, CommentBlock comment) {
        this.fileDef = fileDef;
        this.startLine = startInfo;
        this.endLine = endInfo;
        this.comment = comment;
        this.isIsLayer = isIsLayer;
        this.determinant = determinant;
        this.enclosingStructDef = enclosingStructDef;
        this.packageName = DVTStringUtil.intern((String)packageName);
    }

    public void addNamedElement(RfNamedElement namedElem) {
        this.namedElement = namedElem;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public RfDefElement getEnclosingStructDef() {
        return this.enclosingStructDef;
    }

    public boolean isIs() {
        return this.isIsLayer;
    }

    @Override
    public RfNamedElement getNamedElement() {
        return this.namedElement;
    }

    public RfNamedElement getLastNamedElement() {
        return this.getNamedElement();
    }

    public RfNamedElement getEnclosingScope() {
        return this.getNamedElement();
    }

    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getEnclosingScope(clazz);
    }

    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getEnclosingScope(classes);
    }

    public RfFileDef getDefFile() {
        return this.fileDef;
    }

    public ParserPath getParserPath() {
        if (this.fileDef == null) {
            return null;
        }
        return this.fileDef.getParserPath();
    }

    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        if (this.fileDef == null) {
            return null;
        }
        return this.fileDef.getLanguageSyntax();
    }

    public LanguageKind getLanguageKind() {
        if (this.fileDef == null) {
            return null;
        }
        return this.fileDef.getLanguageKind();
    }

    public IResource getFileAdapter() {
        if (this.fileDef == null) {
            return null;
        }
        return this.fileDef.getFileAdapter();
    }

    public void setDefComment(CommentBlock comment) {
        this.comment = comment;
    }

    public String getDefComment() {
        return this.comment == null ? "" : this.comment.toString();
    }

    public String getRawDefComment() {
        return this.comment == null ? "" : this.comment.toRawString();
    }

    public CommentBlock getCommentBlock() {
        return this.comment;
    }

    @Override
    public boolean connectPositionToDocument(IDocument document, Map<Position, Position> cachedPositions, List<Position> reflectionPositions) {
        block7: {
            if (document != null) break block7;
            return false;
        }
        try {
            if (this.startLine.realOffset > 0 && this.endLine.realOffset >= this.startLine.realOffset && Utils.documentLength(document) >= this.endLine.realOffset) {
                DVTPosition position = new DVTPosition(this.startLine.realOffset, this.endLine.realOffset - this.startLine.realOffset + 1);
                Position existingPosition = cachedPositions.get(position);
                if (existingPosition == null) {
                    this.position = position;
                    if (position.offset + position.length > document.getLength() && position.offset < document.getLength()) {
                        position.length = document.getLength() - position.offset;
                    }
                    reflectionPositions.add((Position)position);
                    cachedPositions.put((Position)position, (Position)position);
                } else {
                    this.position = existingPosition;
                }
                return true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    @Override
    public void removePosition() {
        this.position = null;
    }

    public boolean containsOffset(int offset) {
        return offset == -1 || this.startLine.realOffset <= offset && (this.endLine.realOffset == -1 || offset <= this.endLine.realOffset);
    }

    public int getStartLine() {
        int result;
        if (this.position != null && !Utils.positionDeleted(this.position) && Utils.positionLength(this.position) > 0 && this.fileDef != null && (result = Utils.positionOffset(this.position)) >= 0) {
            this.startLine.realOffset = result;
            this.startLine.line = Utils.convertPositionToLine(this.fileDef.getDocument(), this.startLine.realOffset);
        }
        return this.startLine.line;
    }

    public int getEndLine() {
        int result;
        if (this.position != null && !Utils.positionDeleted(this.position) && Utils.positionLength(this.position) > 0 && this.fileDef != null && (result = Utils.positionOffset(this.position) + Utils.positionLength(this.position) - 1) >= 0) {
            this.endLine.realOffset = result;
            this.endLine.line = Utils.convertPositionToLine(this.fileDef.getDocument(), this.endLine.realOffset);
        }
        return this.endLine.line;
    }

    public int getStartOffset() {
        int result;
        if (this.position != null && !Utils.positionDeleted(this.position) && Utils.positionLength(this.position) > 0 && this.fileDef != null && (result = Utils.positionOffset(this.position)) >= 0) {
            this.startLine.realOffset = result;
            this.startLine.line = Utils.convertPositionToLine(this.fileDef.getDocument(), this.startLine.realOffset);
        }
        return this.startLine.realOffset;
    }

    public LineInfo getStartInfo() {
        return this.startLine;
    }

    public LineInfo getEndInfo() {
        return this.endLine;
    }

    public int getEndOffset() {
        int result;
        if (this.position != null && !Utils.positionDeleted(this.position) && Utils.positionLength(this.position) > 0 && this.fileDef != null && (result = Utils.positionOffset(this.position) + Utils.positionLength(this.position) - 1) >= 0) {
            this.endLine.realOffset = result;
            this.endLine.line = Utils.convertPositionToLine(this.fileDef.getDocument(), this.endLine.realOffset);
        }
        return this.endLine.realOffset;
    }

    public RfProject getRfProject() {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getRfProject();
    }

    public void addChild(RfDefElement child) {
        if (this.childrenDefs == null) {
            this.childrenDefs = new ArrayList<RfDefElement>();
        }
        this.childrenDefs.add(child);
    }

    public void removeChild(RfDefElement child) {
        if (this.childrenDefs == null) {
            return;
        }
        this.childrenDefs.remove(child);
    }

    public Collection<RfDefElement> getChildren() {
        return this.childrenDefs;
    }

    public String getName() {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getName();
    }

    protected void cleanChildren() {
        if (this.namedElement != null) {
            this.namedElement.removeLayer(this);
        }
        if (this.childrenDefs == null) {
            return;
        }
        for (RfDefElement elem : this.childrenDefs) {
            if (elem.childrenDefs == this.childrenDefs) continue;
            elem.cleanChildren();
        }
        this.childrenDefs.clear();
    }

    @Override
    public String getContextType() {
        return "ro.amiq.msdldt.templates.contextType.unknown";
    }

    public boolean isPredefined() {
        if (this.fileDef != null) {
            return this.fileDef.isPredefined();
        }
        return false;
    }

    public boolean isInsideOtherDef(RfDefElement otherDef) {
        if (this.fileDef == null || !this.fileDef.equals(otherDef.getDefFile())) {
            return false;
        }
        return this.startLine.realOffset >= otherDef.startLine.realOffset && this.endLine.realOffset <= otherDef.endLine.realOffset;
    }

    public RfDefElement getKey() {
        return this;
    }

    public void deepClean() {
        this.comment = null;
        if (this.childrenDefs != null && !this.childrenDefs.isEmpty()) {
            for (RfDefElement layer : this.childrenDefs) {
                RfNamedElement namedElement;
                if (layer.getChildren() == this.childrenDefs || (namedElement = layer.getNamedElement()) == null || namedElement == this.namedElement) continue;
                namedElement.deepClean();
            }
            this.childrenDefs.clear();
        }
        this.childrenDefs = null;
        this.namedElement = null;
        this.position = null;
    }

    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getSignalWithPrefix(prefix, matchType);
    }

    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getSignalsWithPrefix(prefix, matchType);
    }

    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getInstanceWithPrefix(prefix, matchType);
    }

    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getDesignsWithPrefix(prefix, matchType);
    }

    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getDesignWithPrefix(prefix, matchType);
    }

    public IRfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getConfigurationWithPrefix(prefix, matchType);
    }

    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getTypesWithPrefix(prefix, matchType);
    }

    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getTypeWithPrefix(prefix, matchType);
    }

    public boolean visit(RfDefElementVisitorAdapter visitor) throws Exception {
        if (!visitor.visitEntering(this)) {
            return false;
        }
        if (this.childrenDefs != null) {
            for (RfDefElement def : this.childrenDefs) {
                if (def.visit(visitor)) continue;
                return false;
            }
        }
        return visitor.visitLeaving(this);
    }

    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        DVTLogger.INSTANCE.logError("Unused API");
    }

    public void getElementsWithPrefix(Collection<IRfNamedElement> result, Determinant determinant, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        if (this.namedElement == null) {
            return;
        }
        this.namedElement.getElementsWithPrefix(result, determinant, prefix, matchType, local, isFirst, accessModifier, elementFilter);
    }

    public IRfLibraryElement getEnclosingLibrary() {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getEnclosingLibrary();
    }

    public boolean isPredefinedDef() {
        return false;
    }

    public List<? extends IRfPackageElement> getPackagesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfPackageElement getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public int compareTo(RfDefElement candidate) {
        int index2;
        RfFileDef module1 = this.getDefFile();
        RfFileDef module2 = candidate.getDefFile();
        if (module1 != null && module1 == module2) {
            return this.getStartOffset() - candidate.getStartOffset();
        }
        int index1 = module1 == null ? 0 : module1.getIndex();
        int n = index2 = module2 == null ? 0 : module2.getIndex();
        if (index1 >= 0 && index2 >= 0) {
            return index1 - index2;
        }
        if (index2 < 0) {
            return -1;
        }
        return 1;
    }

    public boolean contains(RfDefElement declaration) {
        if (declaration == null) {
            return false;
        }
        if (declaration.getDefFile() != this.getDefFile()) {
            return false;
        }
        if (this.getStartOffset() > declaration.getStartOffset()) {
            return false;
        }
        return this.getEndOffset() >= declaration.getEndOffset();
    }

    public RfNamedElement getMember(Determinant determinant, String name, boolean isAmbiguousCheck, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter filter) {
        if (this.namedElement == null) {
            return null;
        }
        return this.namedElement.getMember(determinant, name, isAmbiguousCheck, isFirst, classes, filter);
    }

    public void setMatchScope(RfNamedElement assocType) {
        if (this.namedElement instanceof RfBlock && assocType instanceof RfEnumType) {
            ((RfBlock)this.namedElement).setMatchScope(assocType);
        }
    }

    public void setNodeAST(AST nodeAST) {
        this.nodeAST = nodeAST;
    }

    public AST getNodeAST() {
        return this.nodeAST;
    }

    public boolean isNonScopeLayer() {
        return false;
    }

    public Determinant getDeterminant() {
        return this.determinant;
    }
}

