/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.model.reflection.DataType;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfNamedElement;

public class RfEnumItem
extends RfField {
    public RfEnumItem(String name, DataType dataType) {
        super(name, dataType);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RfEnumItem rfEnumItem = (RfEnumItem)super.clone();
        return rfEnumItem;
    }

    @Override
    public String getSignature() {
        return "enum item " + this.getName() + " : " + this.getEnclosingScope().getName() + " = " + this.getInitialValue(false);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_ENUM: Duplicate enum item ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ENUM_ITEM);
    }

    @Override
    public RfNamedElement getAssociatedType() {
        return this.getEnclosingScope();
    }

    @Override
    public DataType getDataType() {
        DataType result = super.getDataType();
        if (result == null) {
            result = new DataType("int");
        }
        return result;
    }
}

