/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfMembersContainer;
import ro.amiq.msdldt.model.reflection.RfNamedElement;

public class RfEvent
extends RfMembersContainer {
    public RfEvent(String name) {
        super(name);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RfEvent rfEvent = (RfEvent)super.clone();
        return rfEvent;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_EVENT: Duplicate event ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_EVENT);
    }

    public String getSignature() {
        return "event " + this.getName() + "(" + this.getArgs(true, true, false) + ")";
    }

    @Override
    public String getContextType() {
        return null;
    }

    public List<RfNamedElement> getArguments() {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (this.members != null && !this.members.isEmpty()) {
            for (RfNamedElement member : this.members) {
                FieldModifier fieldModifier;
                if (!(member instanceof RfField) || (fieldModifier = ((RfField)member).getFieldModifier()) != FieldModifier.PARAMETER) continue;
                result.add(member);
            }
        }
        return result;
    }

    public String getArgs(boolean addName, boolean hasType, boolean asTemplateVariables) {
        StringBuilder result = new StringBuilder();
        List<RfNamedElement> arguments = this.getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return result.toString();
        }
        Iterator argIt = arguments.iterator();
        while (argIt.hasNext()) {
            RfNamedElement arg = (RfNamedElement)argIt.next();
            if (addName && asTemplateVariables) {
                result.append("${").append(arg.getName()).append("}");
            } else if (addName) {
                result.append(arg.getName());
            }
            if (addName && hasType) {
                result.append(" : ");
            }
            if (hasType) {
                result.append(((RfField)arg).getAssociatedTypeName());
            }
            if (!argIt.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

