/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.model.reflection.ExecBlockKind;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfMembersContainer;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.StructKind;

public class RfExecBlock
extends RfMembersContainer {
    public static final String ACTIVITY_BLOCK_NAME = "activity";
    public static final String BODY_BLOCK_NAME = "body";
    private ExecBlockKind execBlockKind = ExecBlockKind.BODY;

    public RfExecBlock(String name) {
        super(name);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RfExecBlock rfExecBlock = (RfExecBlock)super.clone();
        return rfExecBlock;
    }

    @Override
    public String getKindName() {
        return null;
    }

    public boolean isActivity() {
        return ACTIVITY_BLOCK_NAME.equals(this.getName());
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        List<RfDefElement> layers;
        List<RfDefElement> otherLayers;
        RfNamedElement other;
        RfDefElement enclosingStructDef = currentLayer.getEnclosingStructDef();
        if (enclosingStructDef == null) {
            return;
        }
        RfNamedElement enclosingStruct = enclosingStructDef.getNamedElement();
        if (enclosingStruct == null || !(enclosingStruct instanceof RfStruct)) {
            return;
        }
        StructKind structKind = ((RfStruct)enclosingStruct).getStructKind();
        if (structKind == null) {
            return;
        }
        RfNamedElement element = currentLayer.getNamedElement();
        if (element == null || !(element instanceof RfExecBlock)) {
            return;
        }
        ExecBlockKind execKind = ((RfExecBlock)element).getExecBlockKind();
        if (execKind == null) {
            return;
        }
        if (execKind == ExecBlockKind.BODY && (other = enclosingStruct.getLocalMember(null, Collections.singleton(RfExecBlock.class), BODY_BLOCK_NAME.equals(element.getName()) ? ACTIVITY_BLOCK_NAME : BODY_BLOCK_NAME, null)) != null && (otherLayers = other.getLayers()) != null) {
            for (RfDefElement otherLayer : otherLayers) {
                if (otherLayer.getEnclosingStructDef() != currentLayer.getEnclosingStructDef()) continue;
                int startOffset = currentLayer.getStartOffset();
                int endOffset = startOffset + this.getName().length();
                int startLine = currentLayer.getStartLine();
                ParserPath parserPath = currentLayer.getParserPath();
                int prevStartLine = otherLayer.getStartLine();
                if (prevStartLine > startLine) break;
                ParserPath prevParserPath = otherLayer.getParserPath();
                project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName(), prevStartLine, prevParserPath);
                return;
            }
        }
        if (execKind == ExecBlockKind.BODY && ACTIVITY_BLOCK_NAME.equals(element.getName()) && (layers = this.getLayers()).size() > 1) {
            for (RfDefElement layer : layers) {
                if (layer == currentLayer) break;
                if (layer.getEnclosingStructDef() != currentLayer.getEnclosingStructDef()) continue;
                int startOffset = currentLayer.getStartOffset();
                int endOffset = startOffset + this.getName().length();
                int startLine = currentLayer.getStartLine();
                ParserPath parserPath = currentLayer.getParserPath();
                int prevStartLine = layer.getStartLine();
                ParserPath prevParserPath = layer.getParserPath();
                project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName(), prevStartLine, prevParserPath);
            }
        }
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        if (this.isActivity()) {
            return "DUPLICATE_ACTIVITY_BLOCK: Duplicate activity block already declared\n    at line {1,number,#######} in {2}";
        }
        return "DUPLICATE_EXEC_BLOCK: Duplicate exec block ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public void setExecBlockKind(ExecBlockKind execBlockKind) {
        this.execBlockKind = execBlockKind;
    }

    public ExecBlockKind getExecBlockKind() {
        return this.execBlockKind;
    }

    public Image getImage() {
        switch (this.execBlockKind) {
            case BODY: {
                if (!this.isActivity()) break;
                return DVTImages.imageCache.getImage(DVTImages.PSS_ACTIVITY);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.PSS_EXEC_BLOCK);
    }

    public String getSignature() {
        switch (this.execBlockKind) {
            default: 
        }
        return "exec block " + this.getName();
    }

    @Override
    public String getContextType() {
        return null;
    }
}

