/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.model.reflection.AccessKind;
import ro.amiq.msdldt.model.reflection.DataType;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.RfAssociatedType;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.StructKind;

public class RfField
extends RfAssociatedType
implements IRfFieldElement {
    public static final RfField ANY_FIELD = new RfField("[*]", null);
    private FieldModifier fieldModifier = FieldModifier.NONE;
    private AccessKind accessKind = AccessKind.PUBLIC;

    public RfField(String name, DataType dataType) {
        super(name, dataType);
    }

    @Override
    public boolean isPublic() {
        return this.accessKind == AccessKind.PUBLIC;
    }

    @Override
    public boolean isProtected() {
        return this.accessKind == AccessKind.PROTECTED;
    }

    @Override
    public boolean isPrivate() {
        return this.accessKind == AccessKind.PRIVATE;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RfField rfField = (RfField)super.clone();
        return rfField;
    }

    public String getSignature() {
        String initialValue = this.getInitialValue(false);
        initialValue = initialValue == null ? "" : " = " + initialValue;
        switch (this.fieldModifier) {
            case CONST: {
                return "field const " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName() + initialValue;
            }
            case STATIC_CONST: {
                return "field static const " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName() + initialValue;
            }
            case RAND: {
                return "field rand " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName() + initialValue;
            }
            case COVERGROUP_PORT: {
                return "covergroup argument " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName() + initialValue;
            }
            case COVERGROUP_INLINE: {
                return "covergroup inline instance " + this.getName() + initialValue;
            }
            case COVERPOINT: {
                return "coverpoint " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName() + initialValue;
            }
            case COVERCROSS: {
                return "covercross " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName() + initialValue;
            }
            case SCENARIO_INVOCATION: {
                return "scenario invocation " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName();
            }
            case PARAMETER: {
                return "parameter " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName() + initialValue;
            }
        }
        if (this.isFunctionVariable()) {
            return "variable " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName() + initialValue;
        }
        return "field " + this.getName() + this.getAssociatedTypeArrayDim() + " : " + this.getAssociatedTypeName() + initialValue;
    }

    private boolean isFunctionVariable() {
        RfMethod enclosingMethod = this.getEnclosingScope(RfMethod.class);
        return enclosingMethod != null;
    }

    public boolean isScenarioInvocation() {
        return this.fieldModifier == FieldModifier.SCENARIO_INVOCATION;
    }

    public boolean isCovercross() {
        return this.fieldModifier == FieldModifier.COVERCROSS;
    }

    public boolean isCoverpoint() {
        return this.fieldModifier == FieldModifier.COVERPOINT;
    }

    public String getInitialValue(boolean forceCompute) {
        return null;
    }

    public boolean isLinkage() {
        return false;
    }

    public boolean isBuffer() {
        return false;
    }

    public boolean isInput() {
        return false;
    }

    public boolean isInout() {
        return false;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isRef() {
        return false;
    }

    public boolean isTypeParameter() {
        return false;
    }

    public boolean isParameterNoDataType() {
        return false;
    }

    public FieldModifier getFieldModifier() {
        return this.fieldModifier;
    }

    public int getFieldKind() {
        return -1;
    }

    public int getInterfaceKind() {
        return -1;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.msdldt.templates.contextType.unknown";
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (this.fieldModifier != FieldModifier.PARAMETER || !(this.getEnclosingScope() instanceof RfMethod)) {
            super.performAdditionalSemanticChecks(project, currentLayer);
            return;
        }
        if (currentLayer == null || !currentLayer.isIs()) {
            return;
        }
        List<RfDefElement> parameterLayers = this.getLayers();
        if (parameterLayers.size() <= 1) {
            return;
        }
        List<RfDefElement> methodLayers = this.getEnclosingScope().getLayers();
        for (RfDefElement methodLayer : methodLayers) {
            ArrayList<RfDefElement> perMethodParameterLayers = new ArrayList<RfDefElement>();
            HashSet<RfDefElement> methodLayerChildren = methodLayer.getChildren() == null ? Collections.emptySet() : new HashSet<RfDefElement>(methodLayer.getChildren());
            for (RfDefElement parameterLayer : parameterLayers) {
                if (parameterLayer == currentLayer) break;
                if (!methodLayerChildren.contains(currentLayer) || !methodLayerChildren.contains(parameterLayer)) continue;
                perMethodParameterLayers.add(parameterLayer);
            }
            if (perMethodParameterLayers.isEmpty()) continue;
            for (RfDefElement parameterLayer : parameterLayers) {
                int startOffset = currentLayer.getStartOffset();
                int endOffset = startOffset + this.getName().length();
                int startLine = currentLayer.getStartLine();
                ParserPath parserPath = currentLayer.getParserPath();
                int prevStartLine = parameterLayer.getStartLine();
                ParserPath prevParserPath = parameterLayer.getParserPath();
                project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName(), prevStartLine, prevParserPath);
            }
        }
    }

    public Image getImage() {
        switch (this.fieldModifier) {
            case RAND: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
            }
            case COVERGROUP_PORT: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
            }
            case COVERGROUP_INLINE: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_COVER_IMMEDIATE);
            }
            case COVERPOINT: {
                return DVTImages.imageCache.getImage(DVTImages.COVER_ITEM);
            }
            case COVERCROSS: {
                return DVTImages.imageCache.getImage(DVTImages.COVER_CROSS);
            }
            case PARAMETER: {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_ARGUMENT);
            }
            case SCENARIO_INVOCATION: {
                return DVTImages.imageCache.getImage(DVTImages.MSDL_SCENARIO_INVOCATION);
            }
        }
        RfNamedElement associatedBaseType = this.getAssociatedBaseType();
        while (associatedBaseType instanceof RfTypeAlias) {
            associatedBaseType = ((RfTypeAlias)associatedBaseType).getAssociatedBaseType();
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
    }

    @Override
    public void deepClean() {
        super.deepClean();
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_FIELD: Duplicate field ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    public boolean isEnumElement() {
        return false;
    }

    public boolean isPhysicalUnit() {
        return false;
    }

    public boolean isParameter() {
        return false;
    }

    public void setFieldModifier(FieldModifier fieldModifier) {
        this.fieldModifier = fieldModifier == null ? FieldModifier.NONE : fieldModifier;
    }

    public void setAccessKind(AccessKind accessKind) {
        this.accessKind = accessKind == null ? AccessKind.PUBLIC : accessKind;
    }

    public boolean isInstance() {
        RfNamedElement assocBaseType = this.getAssociatedBaseType();
        return assocBaseType instanceof RfStruct && ((RfStruct)assocBaseType).getStructKind() == StructKind.ACTOR;
    }

    public boolean isRand() {
        return this.fieldModifier == FieldModifier.RAND;
    }

    public boolean isArgument() {
        return false;
    }
}

