/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import ro.amiq.dvt.DVTSynchronizableDocument;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;

public class RfInactiveCodeFileInfo {
    private List<RfInactiveCodeLineInfo> fLineInfos;

    public void addLineInfo(RfInactiveCodeLineInfo info) {
        if (this.fLineInfos == null) {
            this.fLineInfos = new ArrayList<RfInactiveCodeLineInfo>();
        }
        this.fLineInfos.add(info);
    }

    public List<RfInactiveCodeLineInfo> getLineInfos() {
        return this.fLineInfos;
    }

    public void connectToDocument(IDocument document) {
        if (this.fLineInfos == null) {
            return;
        }
        int documentLines = document.getNumberOfLines();
        for (RfInactiveCodeLineInfo lineInfo : this.fLineInfos) {
            try {
                int startLine = lineInfo.getStartLine() - 1;
                int endLine = lineInfo.getEndLine() - 1;
                if (!(document instanceof DVTSynchronizableDocument || startLine <= documentLines && endLine <= documentLines)) {
                    return;
                }
                int startOffset = document.getLineOffset(startLine);
                int endOffset = document.getLineOffset(endLine) + 1;
                document.addPosition("__dvt_inactive_code_position", (Position)new DVTPosition(startOffset, endOffset - startOffset));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public static class RfInactiveCodeLineInfo {
        private int fStartLine;
        private int fEndLine;

        public RfInactiveCodeLineInfo(int startLine, int endLine) {
            this.fStartLine = startLine;
            this.fEndLine = endLine;
        }

        public int getStartLine() {
            return this.fStartLine;
        }

        public int getEndLine() {
            return this.fEndLine;
        }

        public String toString() {
            return "[" + this.fStartLine + "," + this.fEndLine + "]";
        }
    }
}

