/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfEnumItem;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.StructKind;

public enum RfKind implements IRfKind
{
    ACTOR("actor"),
    SCENARIO("scenario"),
    COMPONENT("component"),
    ACTION("action"),
    IMPORT_CLASS("import class"),
    BUFFER("buffer"),
    RESOURCE("resource"),
    STATE("state"),
    STREAM("stream"),
    STRUCT("struct"),
    BLOCK("block"),
    PACKAGE("package"),
    TYPE_ALIAS("type alias"),
    ENUM_TYPE("enum type"),
    ENUM_ITEM("enum item"),
    FIELD("field"),
    POOL("pool"),
    METHOD("method"),
    COVERSPEC("coverspec"),
    UNKNOWN("");

    private String fName;

    private RfKind(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public static RfKind of(IRfNamedElement element) {
        if (element instanceof RfStruct) {
            if (((RfStruct)element).getStructKind() == StructKind.ACTOR) {
                return ACTOR;
            }
            if (((RfStruct)element).getStructKind() == StructKind.SCENARIO) {
                return SCENARIO;
            }
        }
        if (element instanceof RfStruct) {
            return STRUCT;
        }
        if (element instanceof RfTypeAlias) {
            return TYPE_ALIAS;
        }
        if (element instanceof RfEnumType) {
            return ENUM_TYPE;
        }
        if (element instanceof RfEnumItem) {
            return ENUM_ITEM;
        }
        if (element instanceof RfPackage) {
            return PACKAGE;
        }
        if (element instanceof RfBlock) {
            return BLOCK;
        }
        if (element instanceof RfMethod) {
            return METHOD;
        }
        if (element instanceof RfField) {
            return FIELD;
        }
        if (element instanceof RfCovergroup) {
            return COVERSPEC;
        }
        return UNKNOWN;
    }
}

