/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.IRfScope;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfExtendDuplicate;
import ro.amiq.msdldt.model.reflection.RfNamedElement;

public abstract class RfMembersContainer
extends RfNamedElement
implements IRfScope {
    public DVTLinkedHashMap<String, RfNamedElement> members;

    public RfMembersContainer(String name) {
        super(name);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RfMembersContainer rfContainer = (RfMembersContainer)super.clone();
        return rfContainer;
    }

    @Override
    public void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
    }

    @Override
    public void deepClean() {
        if (this.members != null && !this.members.isEmpty()) {
            for (RfNamedElement member : this.members) {
                if (member == this) continue;
                member.deepClean();
            }
        }
        super.deepClean();
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, IRfElementFilter elementFilter) {
        if (this.members == null) {
            return null;
        }
        RfNamedElement member = (RfNamedElement)this.members.get((Object)name);
        if (member == null) {
            return null;
        }
        if (member instanceof RfExtendDuplicate) {
            return member.getLocalMember(determinant, classes, name, elementFilter);
        }
        if (!classes.contains(member.getClass())) {
            return null;
        }
        if ((determinant == null || determinant.contains(member.getDeterminant())) && (elementFilter == null || elementFilter.validElement((IRfNamedElement)member))) {
            return member;
        }
        return null;
    }

    @Override
    protected void addMember(Determinant determinant, RfNamedElement element) {
        if (this.members == null) {
            this.members = new DVTLinkedHashMap();
        } else {
            RfNamedElement existingMember = (RfNamedElement)this.members.get((Object)element.getKey());
            if (existingMember instanceof RfExtendDuplicate) {
                existingMember.addMember(determinant, element);
                return;
            }
            if (existingMember != null) {
                RfExtendDuplicate newMember = new RfExtendDuplicate(element.getKey());
                ((RfNamedElement)newMember).addMember(existingMember.getDeterminant(), existingMember);
                ((RfNamedElement)newMember).addMember(determinant, element);
                this.members.remove((Object)element.getKey());
                element = newMember;
            }
        }
        this.members.put((Object)element.getKey(), (IDVTMapElement)element);
        element.setDeterminant(determinant);
        element.setEnclosingScope(this);
    }

    @Override
    public Collection<RfNamedElement> internalGetRawLocalMembers() {
        return this.members == null ? Collections.emptyList() : this.members.values();
    }

    @Override
    public Collection<RfNamedElement> getLocalMembers() {
        if (this.members == null) {
            return null;
        }
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        for (RfNamedElement member : this.members.values()) {
            if (member instanceof RfExtendDuplicate) {
                Collection<RfNamedElement> localMembers = member.getLocalMembers();
                if (localMembers == null) continue;
                result.addAll(localMembers);
                continue;
            }
            result.add(member);
        }
        return result;
    }

    @Override
    public boolean hasLocalMembers() {
        return this.members != null && !this.members.isEmpty();
    }

    @Override
    public Collection<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        if (this.members == null) {
            return Collections.emptyList();
        }
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        for (RfNamedElement member : this.members.values()) {
            if (member == null) continue;
            if (member instanceof RfExtendDuplicate) {
                result.addAll(member.getLocalMembers(determinant, classes));
            }
            if (classes != null && !classes.contains(member.getClass())) continue;
            result.add(member);
        }
        return result;
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        if (this.members == null) {
            return;
        }
        for (RfNamedElement member : this.members.values()) {
            if (member == null) continue;
            if (member instanceof RfExtendDuplicate) {
                member.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
                continue;
            }
            if (clazz != null && !clazz.isInstance(member) || !elementFilter.validElement((IRfNamedElement)member) || prefix != null && !prefix.isEmpty() && !DVTStringUtil.regionMatches((String)member.getName(), (String)prefix, (int)matchType)) continue;
            result.add(member);
            if (result.size() != elementFilter.resultMaxSize()) continue;
            throw new MaxSizeReachedException();
        }
    }

    protected void swapElement(RfNamedElement element) {
        if (this.members != null) {
            this.members.swap((Object)element.getKey());
        }
    }

    @Override
    public RfNamedElement getNamedElement() {
        return this;
    }

    @Override
    public Determinant getDeterminant() {
        return null;
    }
}

