/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.model.reflection.DataType;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.IRfAssociatedType;
import ro.amiq.msdldt.model.reflection.MethodKind;
import ro.amiq.msdldt.model.reflection.RfArrayType;
import ro.amiq.msdldt.model.reflection.RfAssociatedType;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfDefMethod;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfMembersContainer;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;

public class RfMethod
extends RfMembersContainer
implements IRfAssociatedType {
    private DataType associatedDataType;
    protected RfNamedElement resolvedType;

    public RfMethod(String name, DataType dataType) {
        super(name);
        this.associatedDataType = dataType;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RfMethod rfMethod = (RfMethod)super.clone();
        return rfMethod;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        List<RfDefElement> layers;
        if (currentLayer != null && currentLayer.isIs() && (layers = this.getLayers()).size() > 1) {
            RfDefMethod firstLayer = (RfDefMethod)layers.get(0);
            int i = 1;
            while (i < layers.size()) {
                RfDefMethod layer = (RfDefMethod)layers.get(i);
                if (firstLayer.getMethodKind() == MethodKind.METHOD_EMPTY && layer.getMethodKind() == MethodKind.METHOD_EMPTY && firstLayer.getMethodKind() == MethodKind.METHOD_UNDEFINED && layer.getMethodKind() == MethodKind.METHOD_UNDEFINED) {
                    int startOffset = currentLayer.getStartOffset();
                    int endOffset = startOffset + this.getName().length();
                    int startLine = currentLayer.getStartLine();
                    ParserPath parserPath = currentLayer.getParserPath();
                    int prevStartLine = layer.getStartLine();
                    ParserPath prevParserPath = layer.getParserPath();
                    project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName(), prevStartLine, prevParserPath);
                }
                ++i;
            }
        }
    }

    public void setDataType(DataType dataType) {
        this.associatedDataType = dataType;
    }

    @Override
    public DataType getDataType() {
        return this.associatedDataType;
    }

    public String getInitialValue() {
        return null;
    }

    public boolean isArgumentsCheck() {
        return true;
    }

    @Override
    public boolean getAssociatedTypeArray() {
        if (this.associatedDataType == null) {
            return false;
        }
        return this.associatedDataType.isList();
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_FUNCTION: Duplicate function ''{0}'' already declared\n    at line {1,number,#######} in {2}";
    }

    @Override
    public String getAssociatedTypeArrayDim() {
        return null;
    }

    public String getAssociatedTypeName() {
        if (this.associatedDataType == null) {
            return "";
        }
        return this.associatedDataType.getTypeName();
    }

    public RfNamedElement getAssociatedBaseType() {
        if (this.resolvedType instanceof RfAssociatedType.RfUnresolvedInfo) {
            return null;
        }
        if (this.resolvedType instanceof RfArrayType) {
            return ((RfArrayType)this.resolvedType).getAssociatedBaseType();
        }
        return this.resolvedType;
    }

    public RfNamedElement getAssociatedType() {
        return this.resolvedType instanceof RfAssociatedType.RfUnresolvedInfo ? null : this.resolvedType;
    }

    public void setAssociatedType(RfNamedElement namedElement) {
        this.resolvedType = namedElement;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_METHOD);
    }

    public String getSignature() {
        String assocTypeName = this.associatedDataType == null ? "" : " : " + this.getAssociatedTypeName();
        return "method " + this.getName() + "(" + this.getArgs(true, true, false) + ")" + assocTypeName;
    }

    @Override
    public String getContextType() {
        return null;
    }

    public List<RfNamedElement> getArguments() {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        if (this.members != null && !this.members.isEmpty()) {
            for (RfNamedElement member : this.members) {
                FieldModifier fieldModifier;
                if (!(member instanceof RfField) || (fieldModifier = ((RfField)member).getFieldModifier()) != FieldModifier.PARAMETER) continue;
                result.add(member);
            }
        }
        return result;
    }

    public String getArgs(boolean addName, boolean hasType, boolean asTemplateVariables) {
        StringBuilder result = new StringBuilder();
        List<RfNamedElement> arguments = this.getArguments();
        if (arguments == null || arguments.isEmpty()) {
            return result.toString();
        }
        Iterator argIt = arguments.iterator();
        while (argIt.hasNext()) {
            RfNamedElement arg = (RfNamedElement)argIt.next();
            if (addName && asTemplateVariables) {
                result.append("${").append(arg.getName()).append("}");
            } else if (addName) {
                result.append(arg.getName());
            }
            if (addName && hasType) {
                result.append(" : ");
            }
            if (hasType) {
                result.append(((RfField)arg).getAssociatedTypeName());
            }
            if (!argIt.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

