/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.msdldt.model.reflection.AmbiguousAccessError;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.IRfClassType;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfClassType;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfEnumItem;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfEvent;
import ro.amiq.msdldt.model.reflection.RfExtendDuplicate;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfKind;
import ro.amiq.msdldt.model.reflection.RfLibrary;
import ro.amiq.msdldt.model.reflection.RfMembersContainer;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfPredefinedField;
import ro.amiq.msdldt.model.reflection.RfPredefinedType;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.util.NoDuplicatesCollectionWrapper;

public abstract class RfNamedElement
implements IDVTMapElement<String>,
IRfNamedElement,
Cloneable {
    public static final String ANONYMOUS_PREFIX = "[anonymous:";
    public static final String ANONYMOUS_SUFIX = "]";
    private String name;
    private boolean isEscaped;
    private Determinant determinant;
    private List<RfDefElement> layers;
    private boolean unsortedLayers;
    private RfNamedElement enclosingScope;

    static {
        DVTRfUtils.MEMBERS_TYPES.add(RfPackage.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfStruct.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfEnumType.class);
        DVTRfUtils.MEMBERS_TYPES.add(RfTypeAlias.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfField.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfPredefinedField.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfLibrary.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfPackage.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfBlock.class);
        DVTRfUtils.MEMBERS_OTHERS.add(RfEnumItem.class);
    }

    public RfNamedElement(String name) {
        String unescapedName;
        this.name = unescapedName = DVTStringUtil.unescapeIdentifier((String)name, (boolean)true);
        this.isEscaped = unescapedName != null && name.length() > unescapedName.length();
    }

    public boolean isPublic() {
        return true;
    }

    public boolean isProtected() {
        return false;
    }

    public boolean isPrivate() {
        return false;
    }

    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        List<RfDefElement> layers;
        if (currentLayer != null && currentLayer.isIs() && (layers = this.getLayers()).size() > 1) {
            for (RfDefElement layer : layers) {
                if (layer == currentLayer) break;
                if (currentLayer.getDeterminant() != null && !currentLayer.getDeterminant().contains(layer.getDeterminant())) continue;
                int startOffset = currentLayer.getStartOffset();
                int endOffset = startOffset + this.getName().length();
                int startLine = currentLayer.getStartLine();
                ParserPath parserPath = currentLayer.getParserPath();
                int prevStartLine = layer.getStartLine();
                ParserPath prevParserPath = layer.getParserPath();
                project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName(), prevStartLine, prevParserPath);
            }
        }
    }

    public final IRfNamedElement semanticGetMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement initialScope, IRfNamedElement prevScope, boolean isFirst, boolean isLast, boolean recursiveCall) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    public final IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    public void deepClean() {
        this.enclosingScope = null;
        if (this.layers != null && !this.layers.isEmpty()) {
            for (RfDefElement layer : this.layers) {
                layer.deepClean();
            }
            this.layers.clear();
        }
        this.layers = null;
    }

    public RfNamedElement getMember(Determinant determinant, String name, boolean isAmbiguousCheck, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter filter) {
        Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
        if (this instanceof RfLibrary) {
            determinant = RfPackage.MAIN_DETERMINANT;
        } else if (this instanceof RfPackage) {
            determinant = ((RfPackage)this).getDeterminant();
        }
        LinkedHashSet<RfNamedElement> result = new LinkedHashSet<RfNamedElement>();
        this.internalGetMember(result, determinant, visited, name, isAmbiguousCheck, isFirst, classes, filter);
        if (result.isEmpty()) {
            return null;
        }
        Iterator iterator = result.iterator();
        if (result.size() == 2) {
            return isAmbiguousCheck ? new AmbiguousAccessError((RfNamedElement)iterator.next(), (RfNamedElement)iterator.next()) : (RfNamedElement)iterator.next();
        }
        return (RfNamedElement)iterator.next();
    }

    protected void internalGetMember(Set<RfNamedElement> result, Determinant determinant, Set<IRfNamedElement> visited, String name, boolean isAmbiguousCheck, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter filter) {
        boolean hasLocalElements;
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        boolean isResultEmpty = result.isEmpty();
        RfNamedElement temp = this.getLocalMember(determinant, classes, name, filter);
        if (temp == null && this instanceof IRfClassType) {
            IRfClassType parent = (IRfClassType)((Object)this);
            while (temp == null && (parent = parent.getParentClass()) != null) {
                if (visited.contains(parent)) break;
                visited.add(parent);
                temp = parent.getLocalMember(determinant, classes, name, filter);
            }
        }
        if (temp != null) {
            result.add(temp);
            if (!isAmbiguousCheck && !result.isEmpty() || result.size() > 1) {
                return;
            }
        }
        boolean bl = hasLocalElements = !result.isEmpty() && isResultEmpty;
        if (hasLocalElements) {
            return;
        }
        RfNamedElement enclosing = this.getEnclosingScope();
        if (enclosing == null || enclosing instanceof RfProject || this instanceof RfPredefinedType) {
            return;
        }
        if (enclosing instanceof RfPackage) {
            determinant = RfPackage.MAIN_DETERMINANT;
        }
        if (this instanceof RfClassType && enclosing instanceof RfClassType) {
            filter = new EnclosingScopeElementFileter(filter);
        }
        enclosing.internalGetMember(result, determinant, visited, name, isAmbiguousCheck, isFirst, classes, filter);
    }

    public RfNamedElement getEnclosingScope() {
        if (this.enclosingScope instanceof RfExtendDuplicate) {
            return this.enclosingScope.getEnclosingScope();
        }
        return this.enclosingScope;
    }

    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        RfNamedElement scope = this;
        do {
            if (!clazz.isInstance(scope)) continue;
            return (T)scope;
        } while ((scope = scope.getEnclosingScope()) != null);
        return null;
    }

    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        return null;
    }

    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfPackageElement> getPackagesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfPackageElement getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        return null;
    }

    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    public RfProject getRfProject() {
        if (this.enclosingScope == null) {
            return null;
        }
        return this.enclosingScope.getRfProject();
    }

    public String getName() {
        return this.name;
    }

    public String getLowerCaseName() {
        return this.name == null ? null : this.name.toLowerCase();
    }

    public String getNameForNoDuplicateList() {
        return this.getName();
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public RfDefElement getDeclaration() {
        if (this.layers == null || this.layers.isEmpty()) {
            return null;
        }
        return this.layers.get(0);
    }

    public String getTooltipSignature(IRfScopeElement scope, ElementPath hierarchyPath, Hid hid, boolean useCharLimit) {
        return null;
    }

    public String getComment() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return "";
        }
        String comment = declaration.getDefComment();
        if (comment == null) {
            return "";
        }
        return comment;
    }

    public String getRawUntrimmedComment(String inlineAboveDelimiter) {
        RfDefElement declaration = this.getDeclaration();
        if (declaration == null) {
            return "";
        }
        CommentBlock declarationCommentBlock = declaration.getCommentBlock();
        if (declarationCommentBlock == null) {
            return "";
        }
        return declarationCommentBlock.toRawUntrimmedString(inlineAboveDelimiter);
    }

    public boolean checkEquals(Object obj) {
        return obj == this;
    }

    public boolean isPredefined() {
        return false;
    }

    public Image testGetImage(String imageName) {
        return null;
    }

    public Collection<RfDefElement> getDeclarations() {
        return this.layers;
    }

    public IResource getFileAdapter() {
        return null;
    }

    public boolean hasNoDefs(boolean rawDefs) {
        return this.layers == null || this.layers.isEmpty();
    }

    public int getLine() {
        return 0;
    }

    public IRfLibraryElement getEnclosingLibrary() {
        return null;
    }

    public List<? extends IRfInstanceElement> getBindInstances(long useCacheTimestamp) {
        return null;
    }

    public List<Hid> getHids(HidQualifier[] qualifiers, boolean local) {
        return null;
    }

    public List<IHidOperator> getHidOperators(HidOperatorQualifier[] qualifiers, boolean local) {
        return null;
    }

    public boolean visitHidObject(IRfSingleLangProject project, IHidVisitor<?> visitor) {
        return false;
    }

    public IHidHolder getHidHolder() {
        return null;
    }

    public String getNameForDiagram() {
        return this.getName();
    }

    public LibraryPackageScope getLibPkgScope() {
        return null;
    }

    public boolean isDirtyElement() {
        return false;
    }

    public Collection<RfNamedElement> internalGetRawLocalMembers() {
        return null;
    }

    public Collection<RfNamedElement> getLocalMembers() {
        return null;
    }

    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, IRfElementFilter filter) {
        return null;
    }

    public final void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        DVTLogger.INSTANCE.logError("Unused API");
    }

    public final void getElementsWithPrefix(Collection<IRfNamedElement> result, Determinant determinant, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
        try {
            Set<IRfNamedElement> visited = Collections.newSetFromMap(new IdentityHashMap());
            Collection<IRfNamedElement> noDuplicatesResultWrapper = NoDuplicatesCollectionWrapper.wrap(result);
            this.internalGetMembers(visited, noDuplicatesResultWrapper, determinant, null, prefix, matchType, local, isFirst, accessModifier, elementFilter);
        }
        catch (MaxSizeReachedException maxSizeReachedException) {}
    }

    protected <T extends IRfNamedElement> void internalGetMembers(Set<IRfNamedElement> visited, Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        Assert.isNotNull((Object)elementFilter);
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        this.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
        visited.add(this);
        if (local == 1) {
            return;
        }
        if (this instanceof RfClassType) {
            IRfClassType parentClass = ((RfClassType)this).getParentClass();
            IRfNamedElement.AccessModifier accessModifier2 = accessModifier = accessModifier == IRfNamedElement.AccessModifier.SHOW_PRIVATE ? IRfNamedElement.AccessModifier.SHOW_PROTECTED : accessModifier;
            if (parentClass != null) {
                ((RfNamedElement)((Object)parentClass)).internalGetMembers(visited, result, determinant, null, prefix, matchType, 2, isFirst, accessModifier, elementFilter);
            }
        }
        if (local == 2) {
            return;
        }
        if (local > 3) {
            RfNamedElement enclosing = this.getEnclosingScope();
            if (enclosing == null || enclosing instanceof RfProject || this instanceof RfPredefinedType) {
                return;
            }
            if (this instanceof RfClassType && enclosing instanceof RfClassType) {
                elementFilter = new EnclosingScopeElementFileter(elementFilter);
            }
            enclosing.internalGetMembers(visited, result, determinant, clazz, prefix, matchType, local, isFirst, accessModifier, elementFilter);
        }
    }

    public boolean hasLocalMembers() {
        return false;
    }

    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        return null;
    }

    public Class<? extends IRfNamedElement> getCustomClass() {
        return this.getClass();
    }

    public final <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        DVTLogger.INSTANCE.logError("Unused API");
    }

    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
    }

    public Object clone() throws CloneNotSupportedException {
        RfNamedElement rfElement = (RfNamedElement)super.clone();
        return rfElement;
    }

    public boolean hasReferenceToIdentifierName(String name) {
        return false;
    }

    public String getKindName() {
        return RfKind.of(this).getName();
    }

    public boolean isNonStandard() {
        return false;
    }

    public String elementPathName() {
        return this.getName();
    }

    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        return this.getLocalMember(RfPackage.MAIN_DETERMINANT, classes, name, null);
    }

    public String getKey() {
        return this.getName();
    }

    protected void addMember(Determinant determinant, RfNamedElement element) {
    }

    protected void removeDirtyElements(Iterator<? extends RfNamedElement> iterator, ParserPath parserPath, RfProject project) {
        while (iterator.hasNext()) {
            Collection<RfNamedElement> children;
            RfNamedElement member = iterator.next();
            if (member instanceof RfMembersContainer && (children = member.internalGetRawLocalMembers()) != null && !children.isEmpty()) {
                this.removeDirtyElements(children.iterator(), parserPath, project);
            }
            if (member instanceof RfExtendDuplicate) {
                Collection<RfNamedElement> children2 = member.internalGetRawLocalMembers();
                if (children2 != null && !children2.isEmpty()) {
                    this.removeDirtyElements(children2.iterator(), parserPath, project);
                }
                if (children2 == null || !children2.isEmpty()) continue;
                iterator.remove();
                continue;
            }
            if (member.isPredefined() || !member.hasNoDefs(false)) continue;
            iterator.remove();
        }
    }

    protected void removeDirtyElements(ParserPath parserPath, RfProject project) {
        Collection<RfNamedElement> members = this.internalGetRawLocalMembers();
        if (members == null || members.isEmpty()) {
            return;
        }
        this.removeDirtyElements(members.iterator(), parserPath, project);
    }

    protected boolean internalCheckExisting(RfNamedElement existing, RfNamedElement element) {
        return false;
    }

    public abstract String getContextType();

    public abstract String getSemanticErrorCodeForDuplicate();

    public void setEnclosingScope(RfNamedElement enclosingScope) {
        this.enclosingScope = enclosingScope;
    }

    public void addLayer(RfDefElement layer) {
        layer.addNamedElement(this);
        if (this.layers == null) {
            this.layers = new ArrayList<RfDefElement>();
        }
        this.layers.add(layer);
        this.unsortedLayers = true;
    }

    private void sortLayers() {
        if (this.layers == null) {
            return;
        }
        Collections.sort(this.layers);
    }

    protected void reorderLayers() {
        this.sortLayers();
    }

    protected void removeLayer(RfDefElement layer) {
        if (this.layers == null || this.layers.isEmpty() || layer == null) {
            return;
        }
        this.unsortedLayers = true;
        this.layers.remove(layer);
    }

    public List<RfDefElement> getLayers() {
        if (this.unsortedLayers) {
            this.sortLayers();
        }
        this.unsortedLayers = false;
        return this.internalGetLayers();
    }

    protected List<RfDefElement> internalGetLayers() {
        if (this.layers == null) {
            this.layers = new ArrayList<RfDefElement>();
        }
        return this.layers;
    }

    public Collection<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        return null;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.MSDL;
    }

    public boolean isAnonymous() {
        return this.name.startsWith(ANONYMOUS_PREFIX) && this.name.endsWith(ANONYMOUS_SUFIX);
    }

    public RfDefElement getLayerInLikeParent() {
        String name = this.getName();
        IRfClassType parent = this.getEnclosingScope(RfStruct.class);
        while (parent != null && (parent = parent.getParentClass()) != null) {
            RfNamedElement parentConstraint = parent.getLocalMember(this.determinant, Collections.singleton(this.getClass()), name, null);
            if (parentConstraint == null) continue;
            return parentConstraint.getDeclaration();
        }
        return null;
    }

    public String getPackageName() {
        RfDefElement declaration = this.getDeclaration();
        if (declaration != null && declaration.isIs()) {
            return declaration.getPackageName();
        }
        return "main";
    }

    public String toString() {
        return String.valueOf(this.getName()) + " : " + super.toString();
    }

    public final Collection<? extends IRfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    @Deprecated
    public final IRfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    public final IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        DVTLogger.INSTANCE.logError("Unused API");
        return null;
    }

    public String printScope() {
        StringBuilder result = new StringBuilder();
        this.printScope(result, false);
        return result.toString();
    }

    public void printScope(StringBuilder result, boolean appendThis) {
        RfNamedElement scope = this.getEnclosingScope();
        if (scope instanceof RfProject) {
            return;
        }
        if (scope != null) {
            scope.printScope(result, true);
        }
        if (appendThis && this.name != null && !this.name.isEmpty()) {
            result.append(this.name).append('.');
        }
    }

    public String getFullNameLabel() {
        return String.valueOf(this.printScope()) + this.getName();
    }

    public void setDeterminant(Determinant determinant) {
        this.determinant = determinant;
    }

    public Determinant getDeterminant() {
        if (this.determinant == null) {
            return RfPackage.MAIN_DETERMINANT;
        }
        return this.determinant;
    }

    public static class EnclosingScopeElementFileter
    implements IRfElementFilter {
        private IRfElementFilter prevFilter;

        public EnclosingScopeElementFileter(IRfElementFilter prevFilter) {
            if (prevFilter != null && !(prevFilter instanceof EnclosingScopeElementFileter)) {
                this.prevFilter = prevFilter;
            }
        }

        public boolean validElement(IRfNamedElement candidate) {
            if (candidate instanceof RfPackage || candidate instanceof RfStruct || candidate instanceof RfEnumType || candidate instanceof RfTypeAlias || candidate instanceof RfPredefinedType || candidate instanceof RfCovergroup) {
                return this.prevFilter == null || this.prevFilter.validElement(candidate);
            }
            if (candidate instanceof RfField) {
                return this.prevFilter == null || this.prevFilter.validElement(candidate);
            }
            if (candidate instanceof RfMethod) {
                return this.prevFilter == null || this.prevFilter.validElement(candidate);
            }
            if (candidate instanceof RfEvent) {
                return this.prevFilter == null || this.prevFilter.validElement(candidate);
            }
            return false;
        }

        public int resultMaxSize() {
            return this.prevFilter == null ? 0 : this.prevFilter.resultMaxSize();
        }

        public boolean allowEnumElement() {
            return this.prevFilter == null ? true : this.prevFilter.allowEnumElement();
        }
    }
}

