/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.msdldt.model.reflection.DataType;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfProject;

public class RfPredefinedField
extends RfField {
    private String comment;

    public RfPredefinedField(String name, DataType dataType, String comment) {
        super(name, dataType);
        this.comment = comment;
    }

    @Override
    public boolean isPredefined() {
        return true;
    }

    @Override
    public String getComment() {
        return "PREDEFINED: " + this.comment;
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        if (currentLayer != null && currentLayer.isIs()) {
            int startOffset = currentLayer.getStartOffset();
            int endOffset = startOffset + this.getName().length();
            int startLine = currentLayer.getStartLine();
            ParserPath parserPath = currentLayer.getParserPath();
            project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName());
        }
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return "DUPLICATE_FIELD: Duplicate predefined field ''{0}''";
    }
}

