/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import antlr.collections.AST;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigUtils;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IDVTRfManager;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfProjectContent;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfCompiledFiles;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfGUIUtils;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.IIdleListener;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUtils;
import ro.amiq.dvt.ui.custompragma.TranslatePragma;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSemanticFoldingPosition;
import ro.amiq.dvt.ui.guifilters.ElementType;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMapElement;
import ro.amiq.dvt.utils.MemUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.msdldt.model.IMSDLModule;
import ro.amiq.msdldt.model.MSDLFileInfo;
import ro.amiq.msdldt.model.MSDLModelManager;
import ro.amiq.msdldt.model.reflection.BlockKind;
import ro.amiq.msdldt.model.reflection.DataType;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.IRfClassType;
import ro.amiq.msdldt.model.reflection.IRfFileListener;
import ro.amiq.msdldt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfClassType;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfDefElementVisitorAdapter;
import ro.amiq.msdldt.model.reflection.RfDefMethod;
import ro.amiq.msdldt.model.reflection.RfEnumItem;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfEvent;
import ro.amiq.msdldt.model.reflection.RfExecBlock;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfInactiveCodeFileInfo;
import ro.amiq.msdldt.model.reflection.RfLibrary;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfMembersContainer;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfPredefinedField;
import ro.amiq.msdldt.model.reflection.RfPredefinedMethod;
import ro.amiq.msdldt.model.reflection.RfPredefinedStruct;
import ro.amiq.msdldt.model.reflection.RfPredefinedType;
import ro.amiq.msdldt.model.reflection.RfPredefinedTypeAlias;
import ro.amiq.msdldt.model.reflection.RfProjectContent;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.StructKind;
import ro.amiq.msdldt.model.reflection.semantic.RfSemanticError;
import ro.amiq.msdldt.model.reflection.semantic.SemanticErrorsManager;
import ro.amiq.msdldt.model.reflection.util.NullProtectedList;
import ro.amiq.msdldt.model.reflection.views.MSDLQuickViewersUtil;
import ro.amiq.msdldt.parser.EAST;
import ro.amiq.msdldt.parser.MSDLFileInstance;
import ro.amiq.msdldt.parser.MSDLFileInstancesMap;
import ro.amiq.msdldt.parser.MSDLParser;
import ro.amiq.msdldt.parser.RfWalker;
import ro.amiq.msdldt.parser.SemanticWalker;
import ro.amiq.msdldt.parser.TypesWalker;
import ro.amiq.msdldt.r2lparser.R2LUtils;
import ro.amiq.msdldt.ui.namechecker.NameCheckerWarningsManager;
import ro.amiq.msdldt.ui.syntaxerrors.SyntaxErrorsManager;

public class RfProject
extends RfNamedElement
implements IRfSingleLangProject {
    public static final String LABEL_PREFIX = "label(";
    public static final String LABEL_SUFFIX = ")";
    private static final String TEMP_LIBRARY_NAME = "non-top-files";
    public static final String EXTENSIONS_PREFIX = "__extensions__";
    public static final String DEBUG_PREFIX = "DEBUG MSDL: ";
    public static final Set<Class<? extends IRfNamedElement>> FIELD_CLASSES = new HashSet<Class>(Arrays.asList(RfField.class, RfPredefinedField.class));
    public static final Set<Class<? extends IRfNamedElement>> METHOD_CLASSES = new HashSet<Class>(Arrays.asList(RfMethod.class, RfPredefinedMethod.class));
    public static final Set<Class<? extends IRfNamedElement>> STRUCT_CLASSES = new HashSet<Class>(Arrays.asList(RfStruct.class, RfPredefinedStruct.class));
    public static final Set<Class<? extends IRfNamedElement>> PACKAGE_STRUCT_CLASSES = new HashSet<Class>(Arrays.asList(RfPackage.class, RfStruct.class, RfPredefinedStruct.class));
    public static final String BUILTIN_SCENARIONS_SUFFIX_1 = "__operator";
    public static final String BUILTIN_SCENARIONS_SUFFIX_2 = "__builtin_scenario";
    public static final String BUILTIN_SCENARIONS_SCOPE_NAME = "builtin";
    public static final Set<String> BUILTIN_SCENARIONS = new HashSet<String>(Arrays.asList("serial", "parallel", "first_of", "one_of", "mix", "if", "repeat", "match", "multi_match", "try", "end", "fail", "until", "wait", "wait_time", "call", "plan", "emit"));
    private RfProjectContent fRfProjectContent = new RfProjectContent();
    private transient RfCompiledFiles fRfCompiledFiles = new RfCompiledFiles();
    private transient RfFileDef fCurrentFileDef;
    private transient Map<ParserPath, RfInactiveCodeFileInfo> fInactiveCodeInfos;
    private transient RfMethod fCastMethod;
    private transient long fLastFullBuildStartTime;
    private transient long fLastFullBuildDuration;
    private transient long fLastFullBuildStartMemory;
    private transient long fLastFullBuildMemoryAllocation;
    private transient RfPackage fPackageMain = new RfPackage("main");
    private transient Deque<RfDefElement> fEnclosingStructLayer;
    private transient String fEnclosingPackageName;
    private transient Deque<Determinant> fCurrentDeterminant;
    private transient boolean fIsExtendLayer;
    private transient RfStruct fRootAction;
    private transient IProject fProject;
    private transient Set<ParserPath> fIncrementalParserPaths;
    private transient boolean fIncrementalBuild;
    private transient Map<ParserPath, DVTEditor> fParserPathToEditorMap;
    private transient Deque<RfNamedElement> fScopeStack;
    private transient String fBuildConfig;
    private transient RfMixedLangProject fMixedLangProjectParent;
    private transient RfLibrary fCurrentLibrary;
    private transient boolean fBuildPending;
    private transient RfGUIUtils fGUIUtils;
    private transient IProgressMonitor fBuildProgressMonitor;
    private transient int fNofBuildCanceledQueries;
    private transient boolean fCachedBuildCanceled;
    private transient RfProjectState fProjectState = RfProjectState.NEW;
    private transient Object fSemanticErrorsLock = new Object();
    private transient Map<String, Collection<RfSemanticError>> fSemanticErrors;
    private transient List<FileReference> fFullBuildFileReferences;
    private transient List<FileReference> fRestoreFileReferences;
    private transient Object fRestoreModulesLock = new Object();
    private transient Map<FileReference, MSDLFileInfo> fFileReferenceToMSDLFileInfoMap;
    private transient EAST fStaticConstOverrideAST;
    private transient ChangedFilesManager fChangedFilesManager;
    private transient int fMaxNofSemanticProblemsPerFile;
    private transient HashMap<ParserPath, List<IRfFileListener>> fParserPathToListenerMap;
    private static String[] fPredefinedLibrariesFiles = null;
    private static transient AtomicInteger fCount1 = new AtomicInteger(0);
    private static transient AtomicInteger fCount2 = new AtomicInteger(0);
    private static transient AtomicInteger fCount3 = new AtomicInteger(0);
    private static transient AtomicInteger fCount4 = new AtomicInteger(0);
    private Map<String, Set<FileReference>> fUndeclaredVarNameReferences;
    private Map<String, Set<FileReference>> fUndeclaredTypeNameReferences;
    private List<RfNamedElement> fAddedVarsInCurrentFile;
    private List<RfNamedElement> fAddedTypesInCurrentFile;
    private Map<FileReference, Set<FileReference>> fDependentFileReferences;

    private int getMaxSemanticIssuesPerFile() {
        return TestHelper.isTestMode() && TestHelper.isUsingMaxIntSemanticIssuesPerFile() ? Integer.MAX_VALUE : this.fMaxNofSemanticProblemsPerFile;
    }

    public ChangedFilesManager getChangedFilesManager() {
        if (this.fChangedFilesManager == null) {
            this.fChangedFilesManager = new ChangedFilesManager();
        }
        return this.fChangedFilesManager;
    }

    public static boolean isPredefined(ParserPath path) {
        if (path == null) {
            return false;
        }
        return RfProject.isPredefined(path.path);
    }

    public static boolean isPredefined(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf("__msdl__") != -1;
    }

    public IRfProjectContent getRfProjectContent() {
        return this.fRfProjectContent;
    }

    public void setRfProjectContent(IRfProjectContent rfProjectContent) {
        this.fRfProjectContent = (RfProjectContent)rfProjectContent;
    }

    public void restoreInvocationsInfo(IRfProjectContent rfProjectContent, RfCompiledFiles compiledFiles, Map<String, BCFileInstance> buildConfigFiles) {
        if (compiledFiles == null) {
            return;
        }
        MSDLFileInstancesMap fileInstancesMap = this.fRfProjectContent.fFileInstancesMap;
        if (fileInstancesMap == null) {
            return;
        }
        for (ParserPath parserPath : compiledFiles.fCompiledFiles) {
            List<MSDLFileInstance> fileInstances = fileInstancesMap.getFileInstances(parserPath);
            if (fileInstances == null) continue;
            for (MSDLFileInstance fileInstance : fileInstances) {
                BuildConfigUtils.sendIndexToBCFiles((int)fileInstance.getIndex(), (LanguageKind)LanguageKind.MSDL, (int)fileInstance.getInvocNumber(), buildConfigFiles);
            }
        }
    }

    public RfCompiledFiles getRfCompiledFiles() {
        this.fRfCompiledFiles.fCompiledFiles = new LinkedHashSet<ParserPath>(this.fRfProjectContent.fParserPath2FileDefMap.keySet());
        return this.fRfCompiledFiles;
    }

    public void setRfCompiledFiles(RfCompiledFiles rfCompiledFiles) {
        this.fRfCompiledFiles = rfCompiledFiles;
    }

    public void setBuildProgressMonitor(IProgressMonitor buildProgressMonitor) {
        this.fBuildProgressMonitor = buildProgressMonitor;
        this.fNofBuildCanceledQueries = 0;
        this.fCachedBuildCanceled = false;
    }

    public boolean isCompiled(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null || this.fRfProjectContent.fParserPath2FileDefMap.isEmpty()) {
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                return this.fRfCompiledFiles.fCompiledFiles.contains(parserPath);
            }
            return false;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.containsKey(parserPath);
    }

    private boolean isBuildCanceled() {
        if (this.fGUIUtils.isCancelChecking()) {
            return true;
        }
        if (this.fBuildProgressMonitor == null) {
            return false;
        }
        return this.fBuildProgressMonitor.isCanceled();
    }

    public void checkBuildCanceled() throws BuildCancelException {
        if (this.fNofBuildCanceledQueries % 5000 == 0) {
            this.fCachedBuildCanceled = this.isBuildCanceled();
        }
        ++this.fNofBuildCanceledQueries;
        if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.fCachedBuildCanceled = true;
            throw new BuildCancelException();
        }
        if (this.fCachedBuildCanceled) {
            DVTLogger.INSTANCE.logDebug("### MSDL SEMANTIC CANCELED BY USER ###");
            throw new BuildCancelException();
        }
    }

    public void setLastFullBuildStartTime() {
        this.fLastFullBuildStartTime = System.currentTimeMillis();
    }

    public long getLastFullBuildDuration() {
        return this.fLastFullBuildDuration;
    }

    private void updateDuration() {
        long tmp = System.currentTimeMillis();
        this.fLastFullBuildDuration = (tmp - this.fLastFullBuildStartTime) / 1000L;
    }

    public void setLastFullBuildStartMemory() {
        this.fLastFullBuildStartMemory = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
    }

    public long getLastFullBuildMemoryAllocation() {
        return Math.round((double)this.fLastFullBuildMemoryAllocation / 1048576.0);
    }

    private void updateMemoryAllocation() {
        long tmp = MemUtils.computeUsedMemory((boolean)MemUtils.COLLECT_STATS);
        this.fLastFullBuildMemoryAllocation = tmp - this.fLastFullBuildStartMemory;
    }

    public RfProject(IProject project, RfMixedLangProject rfMixedLangProject) {
        super("");
        this.init(project, null, true);
        this.compilePredefinedLibraries();
        this.setMixedLangProjectParent(rfMixedLangProject);
    }

    public Set<ParserPath> getCompiledFilesSet() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<ParserPath> result = new LinkedHashSet<ParserPath>(this.fRfProjectContent.fParserPath2FileDefMap.keySet());
        return result;
    }

    public Set<IResource> getCompiledFileResourcesSet() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return Collections.emptySet();
        }
        Collection<RfFileDef> fileDefs = this.fRfProjectContent.fParserPath2FileDefMap.values();
        if (fileDefs == null || fileDefs.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        for (RfFileDef fileDef : fileDefs) {
            IResource adapter = fileDef.getFileAdapter();
            if (adapter == null) continue;
            result.add(adapter);
        }
        return result;
    }

    public boolean hasSomethingToCompile() {
        return this.fRfProjectContent.fParserPath2FileDefMap != null && !this.fRfProjectContent.fParserPath2FileDefMap.keySet().isEmpty();
    }

    public void setMixedLangProjectParent(RfMixedLangProject rfMixedLangProject) {
        this.fMixedLangProjectParent = rfMixedLangProject;
    }

    public void init(IProject project, IDVTRfManager rfManager, boolean shouldRunSemanticChecks) {
        EAST.setStringConversion(0, MSDLParser._tokenNames);
        this.fProject = project;
        this.fGUIUtils = new RfGUIUtils();
        this.fIncrementalBuild = false;
        this.fEnclosingStructLayer = new ArrayDeque<RfDefElement>();
        this.fEnclosingPackageName = null;
        this.fCurrentDeterminant = new ArrayDeque<Determinant>();
        this.fIsExtendLayer = false;
        this.fRootAction = null;
        this.fSemanticErrorsLock = new Object();
        this.fSemanticErrors = new HashMap<String, Collection<RfSemanticError>>();
        this.fFullBuildFileReferences = new ArrayList<FileReference>();
        this.fFileReferenceToMSDLFileInfoMap = new LinkedHashMap<FileReference, MSDLFileInfo>();
        if (this.fRfProjectContent == null) {
            this.fRfProjectContent = new RfProjectContent();
        }
        if (this.fRfCompiledFiles == null) {
            this.fRfCompiledFiles = new RfCompiledFiles();
        }
        this.fRfProjectContent.init(this);
        if (this.fScopeStack == null) {
            this.fScopeStack = new ArrayDeque<RfNamedElement>();
            this.fScopeStack.push(this);
        }
        this.fStaticConstOverrideAST = null;
        this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
        this.fMaxNofSemanticProblemsPerFile = BuildConfigManager.getMaxNofSemanticProblemsPerFile((IProject)this.fProject);
        this.fInactiveCodeInfos = new HashMap<ParserPath, RfInactiveCodeFileInfo>();
        ro.amiq.msdldt.utils.Utils.cleanSemanticMarkers(this.fProject);
    }

    public MSDLFileInstancesMap getFileInstancesMap() {
        if (this.fRfProjectContent.fFileInstancesMap == null) {
            this.fRfProjectContent.fFileInstancesMap = new MSDLFileInstancesMap(this);
        }
        return this.fRfProjectContent.fFileInstancesMap;
    }

    public void restoreMixedLangProjectPreElab(IProgressMonitor monitor) {
        this.setBuildProgressMonitor(monitor);
        try {
            ro.amiq.msdldt.utils.Utils.refreshMarkers(this);
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                for (ParserPath parserPath : this.fRfCompiledFiles.fCompiledFiles) {
                    this.checkCustomPragmas(parserPath);
                }
            }
            ro.amiq.msdldt.utils.Utils.triggerSemanticMarkers(this, this.fSemanticErrors, false);
            this.startNameChecking(this.fRfCompiledFiles.fCompiledFiles, 1);
            if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
                for (Map.Entry entry : this.fParserPathToEditorMap.entrySet()) {
                    ro.amiq.msdldt.utils.Utils.startHighlight(this.getFileDefUsingParserPath((ParserPath)entry.getKey()), (DVTEditor)entry.getValue());
                }
            }
            this.updateBreadcrumbs();
        }
        catch (BuildCancelException buildCancelException) {
        }
        catch (Exception exception) {
            DVTLogger.INSTANCE.logError((Throwable)exception);
        }
        this.setBuildProgressMonitor(null);
    }

    private void updateBreadcrumbs() {
        Job updateBCJob = new Job("Updating Breadcrumbs..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (IEditorReference edReference : Utils.getCurrentlyOpenEditorReferences()) {
                    IEditorPart editor = edReference.getEditor(false);
                    if (!(editor instanceof DVTEditor)) continue;
                    ro.amiq.msdldt.utils.Utils.startUpdateScopeBreadcrumb((DVTEditor)editor);
                }
                return Status.OK_STATUS;
            }
        };
        updateBCJob.setSystem(true);
        updateBCJob.schedule();
    }

    public void removeMixedLangProject() {
        IProject project = this.fProject;
        MSDLModelManager.getInstance().saveUnfinishedJobs(project);
        this.clean();
        this.fProjectState = RfProjectState.NEW;
        MSDLModelManager.getInstance().cbClean(project);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public String getSignature() {
        return "";
    }

    @Override
    protected void removeDirtyElements(ParserPath parserPath, RfProject project) {
        if (this.fRfProjectContent.fLibraries == null) {
            return;
        }
        this.removeDirtyElements(this.fRfProjectContent.fLibraries.values().iterator(), parserPath, project);
    }

    public void addIdentifier(AST id) {
        if (this.fCurrentFileDef == null || this.fCurrentFileDef.isInternalModule()) {
            return;
        }
        this.fCurrentFileDef.addIdentifier(id);
    }

    public void addListenerUsingResourcePath(IResource resource, IRfFileListener listener) {
        try {
            ParserPath parserPath;
            if (this.fParserPathToListenerMap == null) {
                this.fParserPathToListenerMap = new HashMap();
            }
            if ((parserPath = this.resource2parser(resource)) == null) {
                return;
            }
            List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(parserPath);
            if (listeners == null) {
                listeners = new ArrayList<IRfFileListener>();
                this.fParserPathToListenerMap.put(parserPath, listeners);
            }
            listeners.add(listener);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void removeListenerUsingResourcePath(IResource resource, IRfFileListener listener) {
        try {
            if (this.fParserPathToListenerMap == null) {
                return;
            }
            ParserPath parserPath = this.resource2parser(resource);
            if (parserPath == null) {
                return;
            }
            List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(parserPath);
            if (listeners == null) {
                return;
            }
            listeners.remove(listener);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void notifyParsingEndUsingParserPath(Set<ParserPath> incrementalParserPaths) {
        try {
            if (this.fParserPathToListenerMap == null) {
                return;
            }
            for (ParserPath incrementalParserPath : incrementalParserPaths) {
                List<IRfFileListener> listeners = this.fParserPathToListenerMap.get(incrementalParserPath);
                if (listeners == null) {
                    return;
                }
                for (IRfFileListener listener : listeners) {
                    listener.notifyFileReparse(this.getFileDefUsingParserPath(incrementalParserPath));
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void connectFileToDocument(ParserPath parserPath, DVTEditor editor, boolean connectPositionsAfterEditorFocus) {
        try {
            if (parserPath == null || editor == null) {
                return;
            }
            if (this.fParserPathToEditorMap == null) {
                this.fParserPathToEditorMap = new HashMap<ParserPath, DVTEditor>();
            }
            this.fParserPathToEditorMap.put(parserPath, editor);
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                return;
            }
            HashMap<Annotation, Position> aditions = new HashMap<Annotation, Position>();
            HashSet<DVTSemanticFoldingPosition> foldingPositions = new HashSet<DVTSemanticFoldingPosition>();
            ArrayList<Position> reflectionPositions = new ArrayList<Position>();
            fileDef.connectPositionToDocument(aditions, connectPositionsAfterEditorFocus, foldingPositions, reflectionPositions);
            IDocument document = editor.getDocument();
            this.connectInactiveCodeInfos(parserPath, document);
            if (DVTFileUtils.getInstance().shouldIncrementalBuild(document, null, this.getProject())) {
                DVTEditor.addOverrideIndications(aditions, (DVTEditor)editor);
            } else {
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            }
            if (document != null && document.getNumberOfLines() < ro.amiq.msdldt.utils.Utils.getCodeFoldingNofLines()) {
                DVTEditor.addSemanticFolding(foldingPositions, (DVTEditor)editor);
            }
            if (!connectPositionsAfterEditorFocus && document != null) {
                DVTDocumentUtils.addDocumentPositions((IDocument)document, (String)"REFLECTION", reflectionPositions);
            }
            CustomPragmaUtils.notifyListeners((IProject)this.fProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void connectInactiveCodeInfos(ParserPath parserPath, IDocument document) {
        this.addInactiveCodeInfos(parserPath, document);
        ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
    }

    public void addInactiveCodeInfos(ParserPath parserPath, IDocument document) {
        if (document == null) {
            return;
        }
        if (document.containsPositionCategory("__dvt_inactive_code_position")) {
            try {
                document.removePositionCategory("__dvt_inactive_code_position");
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (this.fInactiveCodeInfos == null) {
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
            return;
        }
        RfInactiveCodeFileInfo infoForFile = this.fInactiveCodeInfos.get(parserPath);
        if (infoForFile == null) {
            ro.amiq.dvt.utils.Utils.notifyHighlightPositionsChange((IDocument)document, (String)"__dvt_inactive_code_position");
            return;
        }
        document.addPositionCategory("__dvt_inactive_code_position");
        infoForFile.connectToDocument(document);
    }

    public void disconnectFileFromDocument(ParserPath parserPath) {
        try {
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) {
                if (this.fParserPathToEditorMap != null) {
                    this.fParserPathToEditorMap.remove(parserPath);
                }
                return;
            }
            fileDef.disconnectPositionFromDocument();
            if (this.fParserPathToEditorMap != null) {
                this.fParserPathToEditorMap.remove(parserPath);
            }
            this.internalRemoveNonTopFile(parserPath, fileDef);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void internalRemoveNonTopFile(ParserPath parserPath, RfFileDef fileDef) {
        try {
            String libraryName = fileDef.getLibraryName();
            if (!TEMP_LIBRARY_NAME.equals(libraryName)) {
                return;
            }
            MSDLQuickViewersUtil.getInstance().removeWaitEditorJob((IFile)fileDef.getFileAdapter());
            RfLibrary library = this.getLocalLibrary(TEMP_LIBRARY_NAME);
            if (library == null) {
                return;
            }
            this.cleanFile(parserPath);
            library.removeDirtyElements(parserPath, this);
            RfPackage mainPackage = this.getMainPackage();
            if (mainPackage != null) {
                mainPackage.removeDirtyElements(parserPath, this);
            }
            this.cleanSemanticProblems(Collections.singletonList(fileDef.getFileReference()), null);
            ro.amiq.msdldt.utils.Utils.refreshMarkers(this);
            ro.amiq.msdldt.utils.Utils.cleanSemanticMarkers(this.fProject);
            ro.amiq.msdldt.utils.Utils.triggerSemanticMarkers(this, this.fSemanticErrors, false);
            List emptyList = Collections.emptyList();
            SyntaxErrorsManager.getInstance().reparsed(0, 2, fileDef.getFileAdapter(), emptyList, emptyList, emptyList);
            if (this.fRfProjectContent.fParserPath2FileDefMap != null) {
                this.fRfProjectContent.fParserPath2FileDefMap.remove(parserPath);
            }
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                this.fRfCompiledFiles.fCompiledFiles.remove(parserPath);
            }
            this.fScopeStack.clear();
            DVTViewManager.getInstanceByCurrentWorkbenchWindow().notifyViewsWithBuildEvents(BuildEvents.INCREMENTAL_BUILD, this.fProject, ViewsUtils.ALL_BUT_DH_VIEWS);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfFileDef getFile(IResource file) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        ParserPath parserPath = this.resource2parser(file);
        if (parserPath == null) {
            return null;
        }
        return this.getFile(parserPath);
    }

    public RfFileDef getFile(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        if (parserPath == null) {
            return null;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath);
    }

    public Collection<RfFileDef> getFiles() {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        RfFileDef[] result = new RfFileDef[this.fRfProjectContent.fParserPath2FileDefMap.size()];
        this.fRfProjectContent.fParserPath2FileDefMap.values().toArray(result);
        Arrays.sort(result, new Comparator<RfFileDef>(){

            @Override
            public int compare(RfFileDef o1, RfFileDef o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        return Arrays.asList(result);
    }

    public final void postBuildConfigChecks() {
    }

    public RfStruct testGetRootAction() {
        return this.fRootAction;
    }

    public void postMixedLangFullBuild(FullChecksAndLibs fullChecksAndLibs, boolean reportToConsole) {
        try {
            try {
                boolean shouldReportCustomPragmas = false;
                long timeToCheckCustomPragmas = System.currentTimeMillis();
                if (this.getRfCompiledFiles().fCompiledFiles != null) {
                    for (ParserPath parserPath : this.fRfCompiledFiles.fCompiledFiles) {
                        if (!this.checkCustomPragmas(parserPath)) continue;
                        shouldReportCustomPragmas = true;
                    }
                }
                timeToCheckCustomPragmas += System.currentTimeMillis();
                if (reportToConsole && shouldReportCustomPragmas) {
                    this.consolePrint("Full build step 1 (CP) [" + timeToCheckCustomPragmas + " ms] ...");
                }
                ro.amiq.msdldt.utils.Utils.triggerSemanticMarkers(this, this.fSemanticErrors, reportToConsole);
                this.startNameChecking(this.fRfCompiledFiles.fCompiledFiles, 1);
                if (this.fParserPathToEditorMap != null && !this.fParserPathToEditorMap.isEmpty()) {
                    for (Map.Entry entry : this.fParserPathToEditorMap.entrySet()) {
                        ro.amiq.msdldt.utils.Utils.startHighlight(this.getFileDefUsingParserPath((ParserPath)entry.getKey()), (DVTEditor)entry.getValue());
                    }
                }
                this.updateBreadcrumbs();
                DVTProblemsUiUpdater dVTProblemsUiUpdater = DVTProblemsUiUpdaterRegistry.get((String)MSDLProblemCategories.MSDL_NAME_CHECKING.getId());
                dVTProblemsUiUpdater.update(this.fProject);
                dVTProblemsUiUpdater.scheduleObjectionsClear(this.fProject);
            }
            catch (BuildCancelException buildCancelException) {
                this.fBuildPending = false;
                ro.amiq.msdldt.utils.Utils.connectActiveOpenEditor(this);
                this.setBuildProgressMonitor(null);
                this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.fBuildPending = false;
                ro.amiq.msdldt.utils.Utils.connectActiveOpenEditor(this);
                this.setBuildProgressMonitor(null);
                this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
            }
        }
        finally {
            this.fBuildPending = false;
            ro.amiq.msdldt.utils.Utils.connectActiveOpenEditor(this);
            this.setBuildProgressMonitor(null);
            this.fBuildConfig = BuildConfigManager.getActiveBuildConfigName((IProject)this.fProject);
        }
    }

    public void postMixedLangIncrementalBuild(Set<FileCompileInfo> changedFiles, Set<String> updateViewsIds) {
        try {
            try {
                if (updateViewsIds != null) {
                    if (TestHelper.isTestMode()) {
                        updateViewsIds.addAll(ViewsUtils.ALL_VIEWS);
                    } else {
                        updateViewsIds.addAll(ViewsUtils.ALL_BUT_DH_VIEWS);
                    }
                }
                Set<ParserPath> changedParserPaths = this.resource2parser(changedFiles);
                this.startNameChecking(changedParserPaths, 0);
                if (changedParserPaths != null && !changedParserPaths.isEmpty() && this.fParserPathToEditorMap != null) {
                    for (ParserPath parserPath : changedParserPaths) {
                        this.checkCustomPragmas(parserPath);
                        DVTEditor editor = this.fParserPathToEditorMap.get(parserPath);
                        this.connectFileToDocument(parserPath, editor, false);
                        ro.amiq.msdldt.utils.Utils.startHighlight(this.getFileDefUsingParserPath(parserPath), this.fParserPathToEditorMap.get(parserPath));
                    }
                }
                this.updateBreadcrumbs();
                ro.amiq.msdldt.utils.Utils.triggerSemanticMarkers(this, this.fSemanticErrors, false);
            }
            catch (BuildCancelException buildCancelException) {
                if (this.fBuildPending && this.fIncrementalParserPaths != null) {
                    this.notifyParsingEndUsingParserPath(this.fIncrementalParserPaths);
                    this.fIncrementalParserPaths.clear();
                }
                this.fBuildPending = false;
                this.setBuildProgressMonitor(null);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (this.fBuildPending && this.fIncrementalParserPaths != null) {
                    this.notifyParsingEndUsingParserPath(this.fIncrementalParserPaths);
                    this.fIncrementalParserPaths.clear();
                }
                this.fBuildPending = false;
                this.setBuildProgressMonitor(null);
            }
        }
        finally {
            if (this.fBuildPending && this.fIncrementalParserPaths != null) {
                this.notifyParsingEndUsingParserPath(this.fIncrementalParserPaths);
                this.fIncrementalParserPaths.clear();
            }
            this.fBuildPending = false;
            this.setBuildProgressMonitor(null);
        }
    }

    public MSDLFileInfo getFileInfo(FileReference fileReference) {
        if (this.fFileReferenceToMSDLFileInfoMap == null || !this.fFileReferenceToMSDLFileInfoMap.containsKey(fileReference)) {
            return null;
        }
        return this.fFileReferenceToMSDLFileInfoMap.get(fileReference);
    }

    public Collection<MSDLFileInfo> getFileInfos() {
        if (this.fFileReferenceToMSDLFileInfoMap == null) {
            return null;
        }
        return this.fFileReferenceToMSDLFileInfoMap.values();
    }

    private void consolePrint(String message) {
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).print(message);
    }

    @Deprecated
    protected boolean isSemanticErrorCheck() {
        return true;
    }

    @Deprecated
    protected boolean isSemanticWarningCheck() {
        return true;
    }

    public void cleanIncremental(ParserPath parserPath) {
        try {
            this.fBuildPending = true;
            if (this.fIncrementalParserPaths == null) {
                this.fIncrementalParserPaths = new HashSet<ParserPath>();
            }
            this.fIncrementalParserPaths.add(parserPath);
            this.cleanFile(parserPath);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public List<FileReference> getFullBuildFileInfos() {
        return this.fFullBuildFileReferences;
    }

    public void setFullBuildFileInfos(List<FileReference> fullBuildFileInfos) {
        this.fFullBuildFileReferences = fullBuildFileInfos;
    }

    private void cleanSemanticProblems() {
        try {
            if (this.fSemanticErrors == null) {
                this.fSemanticErrors = new HashMap<String, Collection<RfSemanticError>>();
            } else {
                this.fSemanticErrors.clear();
            }
            SemanticErrorsManager.getInstance().clean(this.fProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void cleanSemanticProblems(Collection<FileReference> fileReferences, ParserPath skipParserPath) {
        try {
            if (this.fSemanticErrors == null) {
                return;
            }
            HashSet<ParserPath> alreadyDeleted = new HashSet<ParserPath>();
            if (fileReferences != null) {
                for (FileReference fileReference : fileReferences) {
                    if (skipParserPath != null && skipParserPath.equals((Object)fileReference.parserPath) || alreadyDeleted.contains(fileReference.parserPath)) continue;
                    alreadyDeleted.add(fileReference.parserPath);
                    String resourcePath = this.parser2resource(fileReference.parserPath);
                    this.fSemanticErrors.remove(resourcePath);
                }
            }
            SemanticErrorsManager.getInstance().clean(this.fProject);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void build(MSDLFileInfo info, boolean incrementalBuild) {
        try {
            List<MSDLFileInstance> fileInstances;
            long time = 0L;
            ParserPath parserPath = info.getParserPath();
            FileReference fileReference = new FileReference(parserPath, info.getFileIndex());
            boolean isTopFile = !incrementalBuild || this.isCompiled(parserPath);
            AST ast = info.getAST();
            this.fFileReferenceToMSDLFileInfoMap.put(new FileReference(parserPath, info.getFileIndex()), info);
            if (incrementalBuild) {
                this.initNewDefinedElementsInCurrentFile(true);
                this.cleanSemanticProblems(Collections.singletonList(fileReference), null);
            }
            if ((fileInstances = this.getFileInstancesMap().getFileInstances(parserPath)) != null && !fileInstances.isEmpty()) {
                time = System.currentTimeMillis();
                for (MSDLFileInstance fileInstance : fileInstances) {
                    this.startModule(parserPath, IBuildConfigParserConstants.LanguageSyntax.MSDL, !isTopFile);
                    this.fCurrentFileDef = this.getFileDefUsingParserPath(parserPath);
                    RfWalker rfWalker = new RfWalker(this, fileInstance, this.fCurrentFileDef);
                    rfWalker.statements(ast);
                }
                DVTLogger.INSTANCE.logDebug("DEBUG MSDL: Register Elements [" + (System.currentTimeMillis() - time) + " ms]");
            }
            time = System.currentTimeMillis();
            this.removeDirtyElements(parserPath, this);
            DVTLogger.INSTANCE.logDebug("DEBUG MSDL: Remove Dirty Elements [" + (System.currentTimeMillis() - time) + " ms]");
            if (incrementalBuild) {
                this.fIncrementalBuild = true;
                if (this.fIncrementalParserPaths == null) {
                    this.fIncrementalParserPaths = new HashSet<ParserPath>();
                }
                this.fIncrementalParserPaths.add(parserPath);
            } else {
                if (this.fFullBuildFileReferences == null) {
                    this.fFullBuildFileReferences = new ArrayList<FileReference>();
                }
                this.fFullBuildFileReferences.add(new FileReference(info.getParserPath(), info.getFileIndex()));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.build()", (Throwable)e);
        }
    }

    public void postIncrementalBuild(MSDLFileInfo info) {
        try {
            this.fIncrementalBuild = false;
            this.fGUIUtils.resetTimer();
            ParserPath parserPath = info.getParserPath();
            List<MSDLFileInstance> fileInstances = this.getFileInstancesMap().getFileInstances(parserPath);
            boolean isTopFile = this.isCompiled(parserPath);
            if (fileInstances != null && !fileInstances.isEmpty()) {
                AST ast = info.getAST();
                long time = System.currentTimeMillis();
                for (MSDLFileInstance fileInstance : fileInstances) {
                    this.startModule(parserPath, IBuildConfigParserConstants.LanguageSyntax.MSDL, !isTopFile);
                    this.fCurrentFileDef = this.getFileDefUsingParserPath(parserPath);
                    TypesWalker typesWalker = new TypesWalker(this, info, fileInstance, this.fCurrentFileDef);
                    typesWalker.statements(ast);
                    SemanticWalker semanticWalker = new SemanticWalker(this, info, fileInstance, this.fCurrentFileDef);
                    semanticWalker.statements(ast);
                }
                DVTLogger.INSTANCE.logDebug("DEBUG MSDL: Types and Semantic Incremental [" + (System.currentTimeMillis() - time) + " ms]");
            }
            List<FileReference> dependentFileReferences = null;
            FileReference fileReference = new FileReference(parserPath, info.getFileIndex());
            long time = System.currentTimeMillis();
            dependentFileReferences = this.getSemanticDependentFileReferences(fileReference);
            this.cleanSemanticProblems(dependentFileReferences, parserPath);
            Collections.sort(dependentFileReferences);
            DVTLogger.INSTANCE.logDebug("DEBUG MSDL: Collect Dependencies [" + (System.currentTimeMillis() - time) + " ms]");
            if (dependentFileReferences != null && !dependentFileReferences.isEmpty()) {
                for (FileReference dependentFileReference : dependentFileReferences) {
                    ParserPath dependentParserPath = dependentFileReference.parserPath;
                    List<MSDLFileInstance> dependentFileInstances = this.getFileInstancesMap().getFileInstances(dependentParserPath);
                    if (dependentFileInstances == null || dependentFileInstances.isEmpty()) continue;
                    MSDLFileInfo info2 = this.getFileInfo(dependentFileReference);
                    AST ast = info2.getAST();
                    long time2 = System.currentTimeMillis();
                    for (MSDLFileInstance fileInstance : dependentFileInstances) {
                        this.startModule(dependentParserPath, IBuildConfigParserConstants.LanguageSyntax.MSDL, !isTopFile);
                        this.fCurrentFileDef = this.getFileDefUsingParserPath(dependentParserPath);
                        TypesWalker typesWalker = new TypesWalker(this, info2, fileInstance, this.fCurrentFileDef);
                        typesWalker.statements(ast);
                        SemanticWalker semanticWalker = new SemanticWalker(this, info2, fileInstance, this.fCurrentFileDef);
                        semanticWalker.statements(ast);
                    }
                    DVTLogger.INSTANCE.logDebug("DEBUG MSDL: Types and Semantic for Dependencies [" + (System.currentTimeMillis() - time2) + " ms]");
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void postFullBuild(boolean reportToConsole, boolean saveRFDM) {
        try {
            this.fCurrentFileDef = null;
            this.fGUIUtils.resetTimer();
            if (this.fFileReferenceToMSDLFileInfoMap == null) {
                return;
            }
            try {
                for (MSDLFileInfo info : this.fFileReferenceToMSDLFileInfoMap.values()) {
                    ParserPath parserPath = info.getParserPath();
                    List<MSDLFileInstance> fileInstances = this.getFileInstancesMap().getFileInstances(parserPath);
                    if (fileInstances == null || fileInstances.isEmpty()) continue;
                    boolean isTopFile = this.isCompiled(parserPath);
                    AST ast = info.getAST();
                    long time = System.currentTimeMillis();
                    for (MSDLFileInstance fileInstance : fileInstances) {
                        this.startModule(parserPath, IBuildConfigParserConstants.LanguageSyntax.MSDL, !isTopFile);
                        this.fCurrentFileDef = this.getFileDefUsingParserPath(parserPath);
                        TypesWalker typesWalker = new TypesWalker(this, info, fileInstance, this.fCurrentFileDef);
                        typesWalker.statements(ast);
                        SemanticWalker semanticWalker = new SemanticWalker(this, info, fileInstance, this.fCurrentFileDef);
                        semanticWalker.statements(ast);
                    }
                    DVTLogger.INSTANCE.logDebug("DEBUG MSDL: Types and Semantic Full Build [" + (System.currentTimeMillis() - time) + " ms]");
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            if (saveRFDM) {
                RfManager.getInstance().writeRFDM(this);
            }
        }
    }

    public void clean() {
        this.fBuildPending = true;
        this.fIncrementalBuild = false;
        this.fEnclosingStructLayer = new ArrayDeque<RfDefElement>();
        this.fEnclosingPackageName = null;
        this.fCurrentDeterminant = new ArrayDeque<Determinant>();
        this.fIsExtendLayer = false;
        this.fRootAction = null;
        this.fCurrentLibrary = null;
        this.fPackageMain = new RfPackage("main");
        if (this.fRfProjectContent.fParserPath2FileDefMap != null) {
            for (RfFileDef fileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
                fileDef.deepClean();
            }
            this.fRfProjectContent.fParserPath2FileDefMap.clear();
        }
        this.fScopeStack.clear();
        this.fScopeStack.push(this);
        this.deepClean();
        this.fFileReferenceToMSDLFileInfoMap = new LinkedHashMap<FileReference, MSDLFileInfo>();
        if (this.fRfProjectContent.fLibraries == null) {
            this.fRfProjectContent.fLibraries = new DVTLinkedHashMap();
        } else {
            this.fRfProjectContent.fLibraries.clear();
        }
        if (this.fRfProjectContent.fFileInstancesMap == null) {
            this.fRfProjectContent.fFileInstancesMap = new MSDLFileInstancesMap(this);
        } else {
            this.fRfProjectContent.fFileInstancesMap.clear();
        }
        this.cleanSemanticProblems();
        this.fFullBuildFileReferences = new ArrayList<FileReference>();
        if (this.fInactiveCodeInfos != null) {
            this.fInactiveCodeInfos.clear();
        }
        this.compilePredefinedLibraries();
        this.fMaxNofSemanticProblemsPerFile = BuildConfigManager.getMaxNofSemanticProblemsPerFile((IProject)this.fProject);
    }

    private void compilePredefinedLibraries() {
    }

    public boolean isPredefinedLibraryFile(ParserPath filePath) {
        if (filePath == null) {
            return true;
        }
        if (fPredefinedLibrariesFiles == null) {
            return false;
        }
        String path = filePath.path;
        String[] stringArray = fPredefinedLibrariesFiles;
        int n = fPredefinedLibrariesFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String libraryPath = stringArray[n2];
            if (libraryPath != null && libraryPath.equals(path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void remove(IMSDLModule pssFile) {
        ParserPath parserPath = pssFile.getParserPath();
        if (parserPath != null) {
            this.removeFile(parserPath);
        }
    }

    public void removeFile(ParserPath parserPath) {
        if (parserPath != null) {
            RfFileDef file = this.fRfProjectContent.fParserPath2FileDefMap.remove(parserPath);
            if (this.fRfCompiledFiles.fCompiledFiles != null) {
                this.fRfCompiledFiles.fCompiledFiles.remove(parserPath);
            }
            if (file == null) {
                return;
            }
            file.cleanUpFile();
        }
    }

    public void cleanFile(ParserPath parserPath) {
        if (parserPath != null) {
            RfFileDef file = this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath);
            if (file == null) {
                return;
            }
            if (this.fInactiveCodeInfos != null) {
                this.fInactiveCodeInfos.remove(parserPath);
            }
            file.cleanUpFile();
        }
    }

    @Override
    protected void addMember(Determinant determinant, RfNamedElement element) {
        if (this.fCurrentLibrary == null) {
            return;
        }
        this.fCurrentLibrary.addMember(determinant, element);
    }

    public void setStaticConstOverride(EAST staticConstOverrideAST) {
        this.fStaticConstOverrideAST = staticConstOverrideAST;
    }

    public EAST getStaticConstOverrideAST() {
        return this.fStaticConstOverrideAST;
    }

    public void startModule(ParserPath parserPath, IBuildConfigParserConstants.LanguageSyntax languageSyntax, boolean isNonTopFile) {
        try {
            boolean isNotCompiled;
            this.fCurrentFileDef = this.getFileDefUsingParserPath(parserPath);
            this.fScopeStack.clear();
            this.fEnclosingStructLayer = new ArrayDeque<RfDefElement>();
            this.fEnclosingPackageName = "main";
            this.fCurrentDeterminant = new ArrayDeque<Determinant>();
            this.fIsExtendLayer = false;
            boolean bl = isNotCompiled = this.fIncrementalBuild && !this.isCompiled(parserPath);
            if (this.fRfProjectContent.fLibraries.containsKey((Object)"work")) {
                this.fCurrentLibrary = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)"work");
            } else {
                this.fCurrentLibrary = new RfLibrary("work", this);
                this.fRfProjectContent.fLibraries.put((Object)"work", (IDVTMapElement)this.fCurrentLibrary);
                Determinant currentDeterminant = this.getCurrentDeterminant();
                this.fCurrentLibrary.addMember(currentDeterminant, this.fPackageMain);
                RfPredefinedStruct topActor = new RfPredefinedStruct("top", StructKind.ACTOR, "The top-level actor");
                this.fPackageMain.addMember(currentDeterminant, topActor);
                RfPredefinedField topActorInstance = new RfPredefinedField("top", new DataType("top"), "");
                topActorInstance.setAssociatedType(topActor);
                this.fPackageMain.addMember(currentDeterminant, topActorInstance);
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("null"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("number"));
                RfPredefinedType intType = new RfPredefinedType("int");
                this.fPackageMain.addMember(currentDeterminant, intType);
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("int64"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("uint"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("uint64"));
                RfPredefinedType boolType = new RfPredefinedType("bool");
                this.fPackageMain.addMember(currentDeterminant, boolType);
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("real"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("string"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("external_data"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("acceleration"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("angle"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("angular_speed"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("distance"));
                RfPredefinedType speedType = new RfPredefinedType("speed");
                this.fPackageMain.addMember(currentDeterminant, speedType);
                RfPredefinedTypeAlias speedRangeAlias = new RfPredefinedTypeAlias("speed_range", new DataType("speed_range"), speedType);
                this.fPackageMain.addMember(currentDeterminant, speedRangeAlias);
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("temperature"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("jerk"));
                RfPredefinedType timeType = new RfPredefinedType("time");
                this.fPackageMain.addMember(currentDeterminant, timeType);
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("weight"));
                this.fPackageMain.addMember(currentDeterminant, new RfPredefinedType("index"));
            }
            if (isNonTopFile) {
                if (this.fRfProjectContent.fLibraries.containsKey((Object)TEMP_LIBRARY_NAME)) {
                    this.fCurrentLibrary = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)TEMP_LIBRARY_NAME);
                } else {
                    this.fCurrentLibrary = new RfLibrary(TEMP_LIBRARY_NAME, this);
                    this.fRfProjectContent.fLibraries.put((Object)TEMP_LIBRARY_NAME, (IDVTMapElement)this.fCurrentLibrary);
                }
                RfNamedElement enclosingScope = this.fPackageMain.getEnclosingScope();
                this.fCurrentLibrary.addMember(this.getCurrentDeterminant(), this.fPackageMain);
                this.fPackageMain.setEnclosingScope(enclosingScope);
            }
            if (this.fCurrentFileDef == null) {
                int index = isNotCompiled ? -1 : this.fRfProjectContent.fParserPath2FileDefMap.size();
                this.fCurrentFileDef = new RfFileDef(Path.fromOSString((String)parserPath.path).lastSegment(), index, parserPath, this.fCurrentLibrary, languageSyntax);
                this.fRfProjectContent.fParserPath2FileDefMap.put(parserPath, this.fCurrentFileDef);
            } else {
                String libraryName = this.fCurrentFileDef.getLibraryName();
                this.fCurrentLibrary = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)libraryName);
            }
            this.fScopeStack.push(this.fCurrentLibrary);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfMethod castMethod() {
        if (this.fCastMethod != null) {
            return this.fCastMethod;
        }
        this.fCastMethod = new RfPredefinedMethod("as", new DataType("type"), true, "");
        RfPredefinedField arg = new RfPredefinedField("type", new DataType("type"), "");
        arg.setFieldModifier(FieldModifier.PARAMETER);
        this.fCastMethod.addMember(this.fCastMethod.getDeterminant(), arg);
        return this.fCastMethod;
    }

    public RfPredefinedType getPredefinedType(String name) {
        return (RfPredefinedType)this.fPackageMain.getLocalMember(null, Collections.singleton(RfPredefinedType.class), name, null);
    }

    public RfStruct getPredefinedModifier(String name) {
        RfStruct topActor = this.getTopActor();
        return (RfStruct)topActor.getTopActorMember(null, STRUCT_CLASSES, name, null);
    }

    public RfStruct getPredefinedScenario(String name) {
        RfStruct topActor = this.getTopActor();
        return (RfStruct)topActor.getTopActorMember(null, STRUCT_CLASSES, name, null);
    }

    private RfNamedElement enclosingScope() {
        RfNamedElement enclosing = this.fScopeStack.peek();
        if (enclosing instanceof RfLibrary) {
            enclosing = this.fPackageMain;
        }
        return enclosing;
    }

    private void pushScope(RfDefElement layer, RfNamedElement element) {
        RfDefElement addedElem = layer;
        this.fScopeStack.push(element);
        if (!this.fCurrentFileDef.stackContains(layer)) {
            addedElem = this.fCurrentFileDef.addChildDef(layer);
        }
        this.fCurrentFileDef.pushPhysicalScope(addedElem);
    }

    private void popScope(RfDefElement defElement) {
        if (defElement == null) {
            return;
        }
        RfNamedElement namedElement = defElement.getLastNamedElement();
        if (!this.fScopeStack.isEmpty() && this.fScopeStack.peek() == namedElement) {
            this.fScopeStack.pop();
            this.fCurrentFileDef.popPhysicalScope();
        }
    }

    public DVTEditor getEditor(ParserPath parserPath) {
        if (this.fParserPathToEditorMap == null) {
            return null;
        }
        return this.fParserPathToEditorMap.get(parserPath);
    }

    public Collection<? extends RfNamedElement> getLocalTypes(RfNamedElement element, boolean includePredefined, boolean hideDuplicates) {
        if (element instanceof RfProject) {
            if (this.fRfProjectContent.fLibraries == null) {
                return Collections.emptyList();
            }
            return this.fRfProjectContent.fLibraries.values();
        }
        NullProtectedList<RfNamedElement> elements = new NullProtectedList<RfNamedElement>();
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfPackage.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfStruct.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfTypeAlias.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfCovergroup.class)));
        elements.addAll(element.getLocalMembers(null, Collections.singleton(RfEnumType.class)));
        return elements;
    }

    public Collection<RfLibrary> getLibraries() {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        return this.fRfProjectContent.fLibraries.values();
    }

    public Collection<RfLibrary> getLibrariesByNames(Set<String> libraryNames) {
        if (libraryNames == null) {
            return this.fRfProjectContent.fLibraries.values();
        }
        ArrayList<RfLibrary> result = new ArrayList<RfLibrary>();
        for (String libraryName : libraryNames) {
            RfLibrary library = this.getLocalLibrary(libraryName);
            if (library == null) continue;
            result.add(library);
        }
        return result;
    }

    public RfStruct getTopActor() {
        return (RfStruct)this.getMainPackage().getLocalMember(RfPackage.MAIN_DETERMINANT, STRUCT_CLASSES, "top", null);
    }

    public RfPackage getMainPackage() {
        if (this.fPackageMain != null) {
            return this.fPackageMain;
        }
        RfLibrary library = this.getLocalLibrary("work");
        if (library == null) {
            return null;
        }
        this.fPackageMain = (RfPackage)library.getLocalMember(RfPackage.MAIN_DETERMINANT, Collections.singleton(RfPackage.class), "main", null);
        return this.fPackageMain;
    }

    public RfLibrary getLocalLibrary(String name) {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        return (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)name);
    }

    public List<RfLibrary> getLibrariesWithPrefix(String prefix, int matchType) {
        LinkedHashMap resultMap = new LinkedHashMap();
        return new NullProtectedList<RfLibrary>((Collection<RfLibrary>)resultMap.values());
    }

    public RfLibrary getLibraryWithPrefix(String prefix, int matchType) {
        HashMap resultMap = new HashMap();
        return resultMap.isEmpty() ? null : (RfLibrary)resultMap.values().iterator().next();
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, IRfElementFilter filter) {
        if (this.fRfProjectContent.fLibraries == null) {
            return null;
        }
        RfLibrary member = (RfLibrary)this.fRfProjectContent.fLibraries.get((Object)name);
        if (classes.contains(RfLibrary.class)) {
            return member;
        }
        return null;
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumParentTypeName, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        if (this.fRfProjectContent.fLibraries == null || classes != null && !classes.contains(RfLibrary.class)) {
            return null;
        }
        RfNamedElement candidate = (RfNamedElement)this.fRfProjectContent.fLibraries.get((Object)name);
        return candidate;
    }

    @Override
    public String getContextType() {
        return "ro.amiq.msdldt.templates.contextType.component";
    }

    public Map<ParserPath, DVTEditor> getFileEditors() {
        return this.fParserPathToEditorMap;
    }

    public static IPath getExtensionsPath(IProject project, String ext) {
        IPath stateLocation = ro.amiq.msdldt.utils.Utils.getStateLocation();
        IPath topLocation = stateLocation.addTrailingSeparator().append(String.valueOf(project.getName()) + EXTENSIONS_PREFIX + ext);
        return topLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSemanticError(int messageType, String pattern, LibraryPackageScope libraryPackageScope, int offsetStart, int offsetEnd, Map<String, Object> attributes, int line, ParserPath parserPath, Object ... arguments) {
        if (this.fProject == null) {
            return true;
        }
        String resourcePath = this.parser2resource(parserPath);
        Object object = this.fSemanticErrorsLock;
        synchronized (object) {
            int maxSemanticIssuesPerFile;
            int nofProblems;
            boolean maxSizeReached;
            Collection<RfSemanticError> errors = this.fSemanticErrors.get(resourcePath);
            if (errors == null) {
                errors = new LinkedHashSet<RfSemanticError>();
                this.fSemanticErrors.put(resourcePath, errors);
            }
            boolean bl = maxSizeReached = (nofProblems = errors.size()) >= (maxSemanticIssuesPerFile = this.getMaxSemanticIssuesPerFile());
            if (maxSizeReached && nofProblems <= 2 * maxSemanticIssuesPerFile) {
                nofProblems = 0;
                for (RfSemanticError problem : errors) {
                    if (messageType != problem.getSeverity()) continue;
                    ++nofProblems;
                }
                boolean bl2 = maxSizeReached = nofProblems >= maxSemanticIssuesPerFile;
            }
            if (!maxSizeReached) {
                String message = MessageFormat.format(pattern, arguments);
                RfSemanticError error = new RfSemanticError(messageType, message, this.getFileIndex(parserPath), line, resourcePath);
                if (offsetStart != -1 && offsetEnd != -1) {
                    error.setOffsetStart(offsetStart);
                    error.setOffsetEnd(offsetEnd);
                }
                error.setAttributes(attributes);
                errors.add(error);
            }
        }
        return true;
    }

    public final int getFileIndex(ParserPath parserPath) {
        RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return -1;
        }
        return fileDef.getIndex();
    }

    public RfFileDef getFileDefUsingParserPath(ParserPath parserPath) {
        if (this.fRfProjectContent.fParserPath2FileDefMap == null) {
            return null;
        }
        return this.fRfProjectContent.fParserPath2FileDefMap.get(parserPath);
    }

    public RfMixedLangProject getMixedLangProjectParent() {
        return this.fMixedLangProjectParent;
    }

    public String getNature() {
        return "ro.amiq.msdldt.msdlnature";
    }

    public String getBuildConfig() {
        return this.fBuildConfig;
    }

    public RfProjectState getProjectState() {
        return this.fProjectState;
    }

    public void setProjectState(RfProjectState state) {
        this.fProjectState = state;
    }

    public String parser2resource(ParserPath parserPath) {
        return DVTFileUtils.getInstance().parser2resource(this.fProject, parserPath);
    }

    public ParserPath resource2parser(IResource file) {
        return DVTFileUtils.getInstance().resource2parser(file);
    }

    private Set<ParserPath> resource2parser(Set<FileCompileInfo> changedFiles) {
        return DVTFileUtils.getInstance().resource2parser(changedFiles);
    }

    public RfNamedElement getSemanticScope() {
        return this.fScopeStack != null ? this.fScopeStack.peek() : null;
    }

    public boolean isUndeclaredIdentifierChecks() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        try {
            RfLibrary library;
            Collection<RfLibrary> libraries = this.getLibraries();
            if (libraries == null) return true;
            Iterator<RfLibrary> iterator = libraries.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((library = iterator.next()).visitHidObject(rfProject, visitor));
            return false;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public static void debugDelay() {
    }

    public void computeFilesIncludedByMatchingTop(Map<StringMatcher, Set<String>> expanded) {
        for (ParserPath parserPath : this.getCompiledFilesSet()) {
            for (Map.Entry<StringMatcher, Set<String>> entry : expanded.entrySet()) {
                StringMatcher matcher = entry.getKey();
                if (!matcher.match(parserPath.path)) continue;
                entry.getValue().add(parserPath.path);
            }
        }
    }

    public Set<String> computeFilesInMacroReparseStack(IRfDefElement declaration) {
        return null;
    }

    public ElementType computeElementType(IRfNamedElement namedElement, ElementPath instancePath) {
        if (namedElement instanceof RfPackage) {
            return new ElementType(ElementType.ElementTypeName.PACKAGE, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfStruct && ((RfStruct)namedElement).getStructKind() == StructKind.ACTOR) {
            return new ElementType(ElementType.ElementTypeName.MSDL_ACTOR, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfStruct && ((RfStruct)namedElement).getStructKind() == StructKind.SCENARIO) {
            return new ElementType(ElementType.ElementTypeName.MSDL_SCENARIO, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfStruct && ((RfStruct)namedElement).getStructKind() == StructKind.MODIFIER) {
            return new ElementType(ElementType.ElementTypeName.MSDL_MODIFIER, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfStruct) {
            return new ElementType(ElementType.ElementTypeName.STRUCT, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfEnumType || namedElement instanceof RfTypeAlias) {
            return new ElementType(ElementType.ElementTypeName.TYPE, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfField) {
            if (((RfField)namedElement).isCovercross()) {
                return new ElementType(ElementType.ElementTypeName.COVER_CROSS, ElementType.ElementTypeLanguage.MSDL);
            }
            if (((RfField)namedElement).isCoverpoint()) {
                return new ElementType(ElementType.ElementTypeName.COVER_POINT, ElementType.ElementTypeLanguage.MSDL);
            }
            return new ElementType(ElementType.ElementTypeName.FIELD, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfEvent) {
            return new ElementType(ElementType.ElementTypeName.EVENT, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfMethod) {
            return new ElementType(ElementType.ElementTypeName.FUNCTION, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfCovergroup) {
            return new ElementType(ElementType.ElementTypeName.COVER_GROUP, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfExecBlock && ((RfExecBlock)namedElement).isActivity()) {
            return new ElementType(ElementType.ElementTypeName.ACTIVITY, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfExecBlock) {
            return new ElementType(ElementType.ElementTypeName.EXEC_BLOCK, ElementType.ElementTypeLanguage.MSDL);
        }
        if (namedElement instanceof RfBlock) {
            if (((RfBlock)namedElement).getBlockKind() == BlockKind.CONSTRAINT) {
                return new ElementType(ElementType.ElementTypeName.CONSTRAINT, ElementType.ElementTypeLanguage.MSDL);
            }
            return new ElementType(ElementType.ElementTypeName.BLOCK, ElementType.ElementTypeLanguage.MSDL);
        }
        return null;
    }

    public ElementType computeElementType(IRfDefElement defElement, IRfNamedElement namedElement, ElementPath instancePath) {
        IRfNamedElement rfNamedElement = defElement.getNamedElement();
        if (rfNamedElement == null) {
            return this.computeElementType(namedElement, instancePath);
        }
        return this.computeElementType(rfNamedElement, instancePath);
    }

    public IIdleListener getIdleListener() {
        return null;
    }

    @Override
    public void deepClean() {
        if (this.fFileReferenceToMSDLFileInfoMap != null && !this.fFileReferenceToMSDLFileInfoMap.isEmpty()) {
            for (MSDLFileInfo info : this.fFileReferenceToMSDLFileInfoMap.values()) {
                info.setAST(null);
            }
        }
        if (this.fRfProjectContent != null) {
            this.fRfProjectContent.deepClean();
        }
        this.getFileInstancesMap();
        super.deepClean();
    }

    public boolean preRestore() {
        this.clean();
        boolean result = RfManager.getInstance().preRestoreRfProject(this);
        if (this.fRfProjectContent == null) {
            this.fRfProjectContent = new RfProjectContent();
        }
        this.fRfProjectContent.init(this);
        if (this.fRfCompiledFiles == null) {
            this.fRfCompiledFiles = new RfCompiledFiles();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restore(IProgressMonitor monitor) {
        try {
            var2_2 = this.fRestoreModulesLock;
            synchronized (var2_2) {
                if (this.fFullBuildFileReferences == null) {
                    return;
                }
                {
                    this.fRestoreFileReferences = new ArrayList<FileReference>(this.fFullBuildFileReferences);
                    this.fFullBuildFileReferences.clear();
                }
            }
            monitor.beginTask("", this.fRestoreFileReferences.size());
            index = 0;
            {
                for (FileReference fileReference : this.fRestoreFileReferences) {
                    ++index;
                    if (monitor.isCanceled()) {
                        this.clean();
                        break;
                    }
                    monitor.subTask("Load from dictionary (" + index + "/" + this.fRestoreFileReferences.size() + ") module: " + fileReference);
                    info = this.loadFileInfo(this.fProject, fileReference.parserPath, fileReference.fileIndex);
                    if (info == null) {
                        return;
                    }
                    ** try [egrp 5[TRYBLOCK] [7 : 208->309)] { 
lbl24:
                    // 1 sources

                    info.setProject(this.fProject);
                    this.build(info, false);
                    monitor.worked(1);
                }
                monitor.beginTask("", 1);
                monitor.subTask("Resolve types");
                this.postFullBuild(false, false);
                this.postMixedLangFullBuild(null, false);
                monitor.worked(1);
                BuildEventManager.getInstance().notifyFullBuild(this.getProject());
                var3_6 = this.fRestoreModulesLock;
                synchronized (var3_6) {
                    this.fRestoreFileReferences = null;
                    return;
                }
            }
        }
lbl41:
        // 2 sources

        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        finally {
            ro.amiq.msdldt.utils.Utils.connectActiveOpenEditor(this);
            monitor.done();
        }
    }

    /*
     * Loose catch block
     */
    private final MSDLFileInfo loadFileInfo(IProject project, ParserPath parserPath, int fileIndex) {
        String fileName;
        block20: {
            block19: {
                try {
                    fileName = BuildConfigManager.getModelPersistenceLocation((IProject)project, (String)(String.valueOf(Integer.toHexString(parserPath.hashCode())) + "_" + fileIndex), (boolean)true, (BuildConfigManagerCommon.PersistenceModeWrapper)BuildConfigManagerCommon.PersistenceModeWrapper.regular());
                    if (fileName != null) break block19;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logDebug("Error loading module '" + parserPath + "' info (" + e.getMessage() + ").");
                    return null;
                }
            }
            File file = new File(fileName);
            if (file.exists()) break block20;
            return null;
        }
        Throwable throwable = null;
        Object var7_9 = null;
        try {
            MSDLFileInfo mSDLFileInfo;
            ObjectInputStream ois;
            BufferedInputStream bif;
            block22: {
                block21: {
                    bif = new BufferedInputStream(new FileInputStream(fileName), 32768);
                    ois = new ObjectInputStream(bif);
                    MSDLFileInfo readObject = (MSDLFileInfo)ois.readObject();
                    ois.close();
                    mSDLFileInfo = readObject;
                    if (ois == null) break block21;
                    ois.close();
                }
                if (bif == null) break block22;
                bif.close();
            }
            return mSDLFileInfo;
            {
                catch (Throwable throwable2) {
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (bif != null) {
                            bif.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static void debugIncrement1() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount1.incrementAndGet();
        }
    }

    public static void debugIncrement2() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount2.incrementAndGet();
        }
    }

    public static void debugIncrement3() {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount3.incrementAndGet();
        }
    }

    public static void incrementTime1(int time) {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            fCount4.addAndGet(time);
        }
    }

    public void accept(IRfNamedElementVisitor visitor) {
    }

    public boolean accept(RfDefElementVisitorAdapter visitor) throws Exception {
        if (this.fRfCompiledFiles == null) {
            return false;
        }
        for (RfFileDef fileDef : this.fRfProjectContent.fParserPath2FileDefMap.values()) {
            if (fileDef.visit(visitor)) continue;
            return false;
        }
        return true;
    }

    public void syncCancelSave() {
    }

    public void getSortCandidatesForContentAssist(IRfNamedElement[] sortedCandidates, String prefix) {
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
    }

    public boolean isLintingEnabled() {
        return false;
    }

    public DVTPFModel getPFModel() {
        return null;
    }

    public void addUndeclaredVarNameReference(FileReference reference, String name) {
        if (this.fUndeclaredVarNameReferences == null) {
            this.fUndeclaredVarNameReferences = new HashMap<String, Set<FileReference>>();
        }
        this.addUndeclaredNameReference(this.fUndeclaredVarNameReferences, reference, name);
    }

    public void addUndeclaredTypeNameReference(FileReference reference, String name) {
        if (this.fUndeclaredTypeNameReferences == null) {
            this.fUndeclaredTypeNameReferences = new HashMap<String, Set<FileReference>>();
        }
        this.addUndeclaredNameReference(this.fUndeclaredTypeNameReferences, reference, name);
    }

    private final void addUndeclaredNameReference(Map<String, Set<FileReference>> undeclaredNameReferences, FileReference reference, String name) {
        Set<FileReference> references = undeclaredNameReferences.get(name);
        if (references == null) {
            references = new HashSet<FileReference>();
            undeclaredNameReferences.put(name, references);
        }
        references.add(reference);
    }

    private void cleanUndeclaredReferences(FileReference reference) {
        this.cleanUndeclaredNameReference(this.fUndeclaredVarNameReferences, reference);
        this.cleanUndeclaredNameReference(this.fUndeclaredTypeNameReferences, reference);
    }

    private final void cleanUndeclaredNameReference(Map<String, Set<FileReference>> undeclaredNameReferences, FileReference reference) {
        if (undeclaredNameReferences == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(undeclaredNameReferences.keySet());
        for (String name : names) {
            Set<FileReference> references = undeclaredNameReferences.get(name);
            if (references == null) continue;
            references.remove(reference);
            if (!references.isEmpty()) continue;
            undeclaredNameReferences.remove(name);
        }
    }

    public void addNewDefinedVarName(RfNamedElement element) {
        if (this.fAddedVarsInCurrentFile == null) {
            return;
        }
        this.fAddedVarsInCurrentFile.add(element);
    }

    public void addNewDefinedTypeName(RfNamedElement type) {
        if (this.fAddedTypesInCurrentFile == null) {
            return;
        }
        this.fAddedTypesInCurrentFile.add(type);
    }

    private void initNewDefinedElementsInCurrentFile(boolean incremental) {
        if (incremental) {
            this.fAddedVarsInCurrentFile = new ArrayList<RfNamedElement>();
            this.fAddedTypesInCurrentFile = new ArrayList<RfNamedElement>();
        } else {
            this.fAddedVarsInCurrentFile = null;
            this.fAddedTypesInCurrentFile = null;
        }
    }

    public Set<FileReference> getPotentialyDependentModuleReferences(int fileIndex) {
        HashSet<FileReference> result = new HashSet<FileReference>();
        this.getNewDefinedNamesReferences(result, this.fAddedVarsInCurrentFile, this.fUndeclaredVarNameReferences, fileIndex);
        this.getNewDefinedNamesReferences(result, this.fAddedTypesInCurrentFile, this.fUndeclaredTypeNameReferences, fileIndex);
        return result;
    }

    private final void getNewDefinedNamesReferences(Set<FileReference> result, Collection<? extends RfNamedElement> addedElementsInCurrentFile, Map<String, Set<FileReference>> undeclaredNameReferences, int fileIndex) {
        if (addedElementsInCurrentFile == null || undeclaredNameReferences == null) {
            return;
        }
        for (RfNamedElement rfNamedElement : addedElementsInCurrentFile) {
            Set<FileReference> references;
            if (rfNamedElement instanceof RfEnumType) {
                this.getNewDefinedNamesReferences(result, ((RfEnumType)rfNamedElement).getLocalMembers(), this.fUndeclaredVarNameReferences, fileIndex);
            }
            if (rfNamedElement instanceof RfField && !(rfNamedElement instanceof RfEnumItem) && ((RfField)rfNamedElement).getAssociatedType() instanceof RfEnumType) {
                this.getNewDefinedNamesReferences(result, ((RfEnumType)((RfField)rfNamedElement).getAssociatedType()).getLocalMembers(), this.fUndeclaredVarNameReferences, fileIndex);
            }
            if ((references = undeclaredNameReferences.get(rfNamedElement.getName())) == null) continue;
            for (FileReference reference : references) {
                if (reference.fileIndex < fileIndex) continue;
                result.add(reference);
            }
        }
    }

    public void addDependentFileReference(FileReference current, FileReference reference) {
        Set<FileReference> references;
        if (this.fDependentFileReferences == null) {
            this.fDependentFileReferences = new HashMap<FileReference, Set<FileReference>>();
        }
        if ((references = this.fDependentFileReferences.get(current)) == null) {
            references = new HashSet<FileReference>();
            this.fDependentFileReferences.put(current, references);
        }
        references.add(reference);
    }

    public List<FileReference> getSemanticDependentFileReferences(FileReference current) {
        Set<FileReference> result = this.getPotentialyDependentModuleReferences(current.fileIndex);
        if (this.fDependentFileReferences != null) {
            Set<FileReference> dependencies = this.fDependentFileReferences.get(current);
            Set<ParserPath> compiledFilesSet = this.getCompiledFilesSet();
            if (dependencies != null && !dependencies.isEmpty() && compiledFilesSet != null) {
                for (FileReference dependency : dependencies) {
                    if (!compiledFilesSet.contains(dependency.parserPath)) continue;
                    result.add(dependency);
                }
            }
        }
        ArrayList<FileReference> sorted = new ArrayList<FileReference>(result);
        Collections.sort(sorted);
        return sorted;
    }

    public boolean testIsPredefinedLibraryFile(ParserPath parserPath) {
        return this.isPredefinedLibraryFile(parserPath);
    }

    public void setPFModel(DVTPFModel powerFormatModel) {
    }

    public Image getImage() {
        return null;
    }

    @Override
    public LanguageKind getLanguageKind() {
        return LanguageKind.MSDL;
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        return null;
    }

    public void addInactiveCode(boolean limitation, boolean ifBranch, LineInfo ifLine, LineInfo elseLine, LineInfo endLine) {
        ParserPath parserPath;
        RfInactiveCodeFileInfo infosForFile;
        if (limitation || endLine == null || ifLine == null) {
            return;
        }
        if (ifBranch && (elseLine == null || elseLine.line == -1)) {
            return;
        }
        if (this.fCurrentFileDef == null) {
            return;
        }
        if (this.fInactiveCodeInfos == null) {
            this.fInactiveCodeInfos = new HashMap<ParserPath, RfInactiveCodeFileInfo>();
        }
        if ((infosForFile = this.fInactiveCodeInfos.get(parserPath = this.fCurrentFileDef.getParserPath())) == null) {
            infosForFile = new RfInactiveCodeFileInfo();
            this.fInactiveCodeInfos.put(parserPath, infosForFile);
        }
        if (ifBranch) {
            infosForFile.addLineInfo(new RfInactiveCodeFileInfo.RfInactiveCodeLineInfo(elseLine.line, endLine.line));
        } else if (elseLine != null && elseLine.line != -1) {
            infosForFile.addLineInfo(new RfInactiveCodeFileInfo.RfInactiveCodeLineInfo(ifLine.line, elseLine.line));
        } else {
            infosForFile.addLineInfo(new RfInactiveCodeFileInfo.RfInactiveCodeLineInfo(ifLine.line, endLine.line));
        }
    }

    private boolean checkCustomPragmas(ParserPath parserPath) {
        if (parserPath == null) {
            return false;
        }
        LibraryPackageScope libPkgScope = new LibraryPackageScope("[dummy]", null, RfElementPath.UNKNOWN_ELEMENT_PATH);
        List<CustomPragmaUsage> customPragmas = ro.amiq.msdldt.utils.Utils.getCustomPragmas(this, parserPath);
        if (customPragmas == null || customPragmas.isEmpty()) {
            return false;
        }
        ArrayDeque<CustomPragmaUsage> workingPragmas = new ArrayDeque<CustomPragmaUsage>();
        ArrayList<CustomPragmaUsage> sortedPragmas = new ArrayList<CustomPragmaUsage>();
        for (CustomPragmaUsage pragma : customPragmas) {
            int errorType;
            int n = errorType = pragma.getPragma() instanceof TranslatePragma ? 1 : 2;
            if (pragma.getKind() == CustomPragmaUsage.Kind.START) {
                if (workingPragmas.size() < 3) {
                    workingPragmas.push(pragma);
                    continue;
                }
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_NESTING_EXCEEDED: More than 3 nested custom pragmas found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, new Object[0]);
                continue;
            }
            if (workingPragmas.isEmpty()) {
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_UNEXPECTED_END: No ''{0}'' start found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, pragma.getPragma().getStartPragma());
                sortedPragmas.add(pragma);
                continue;
            }
            CustomPragmaUsage stackPragma = (CustomPragmaUsage)workingPragmas.pop();
            if (!stackPragma.getPragmaName().equals(pragma.getPragmaName())) {
                this.addSemanticError(errorType, "CUSTOM_PRAGMA_MISMATCH: Expecting ''{0}'' found ''{1}''", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, stackPragma.getPragma().getEndPragma(), pragma.getPragma().getEndPragma());
                workingPragmas.push(stackPragma);
                sortedPragmas.add(pragma);
                continue;
            }
            stackPragma.setValid();
            pragma.setValid();
            sortedPragmas.add(stackPragma);
            sortedPragmas.add(pragma);
        }
        while (!workingPragmas.isEmpty()) {
            CustomPragmaUsage pragma;
            pragma = (CustomPragmaUsage)workingPragmas.pop();
            sortedPragmas.add(pragma);
            int errorType = pragma.getPragma() instanceof TranslatePragma ? 1 : 2;
            this.addSemanticError(errorType, "CUSTOM_PRAGMA_NO_END: No matching ''{0}'' end pragma found", libPkgScope, -1, -1, null, pragma.getLine(), parserPath, pragma.getPragma().getEndPragma());
        }
        ro.amiq.msdldt.utils.Utils.setCustomPragmas(this, parserPath, sortedPragmas);
        return true;
    }

    private void startNameChecking(Set<ParserPath> parserPaths, int buildKind) {
        NameCheckerWarningsManager.getInstance().clean();
        if (parserPaths == null || parserPaths.isEmpty()) {
            return;
        }
        for (ParserPath parserPath : parserPaths) {
            RfFileDef fileDef = this.getFileDefUsingParserPath(parserPath);
            if (fileDef == null) continue;
            NameCheckerWarningsManager.getInstance().build(buildKind, fileDef, this.fProject);
        }
    }

    public void addImportPath(AST filePath) {
        this.addIdentifier(filePath);
    }

    public void stopLintTracking() {
    }

    private RfDefElement getEnclosingStructLayer() {
        if (this.fEnclosingStructLayer.isEmpty()) {
            return null;
        }
        return this.fEnclosingStructLayer.peek();
    }

    private Determinant getCurrentDeterminant() {
        if (this.fCurrentDeterminant.isEmpty()) {
            return RfPackage.MAIN_DETERMINANT;
        }
        return this.fCurrentDeterminant.peek();
    }

    public ElementContainer startPackage(String name, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.fScopeStack.peek();
            this.fEnclosingPackageName = name;
            Determinant currentDeterminant = new Determinant(this.fEnclosingPackageName);
            this.fCurrentDeterminant.push(currentDeterminant);
            RfPackage member = (RfPackage)enclosing.getLocalMember(currentDeterminant, Collections.singleton(RfPackage.class), name, null);
            if (member == null) {
                member = new RfPackage(name);
                enclosing.addMember(currentDeterminant, member);
                this.addNewDefinedTypeName(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, endLine, true, comment);
            member.addLayer(layer);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endPackage(ElementContainer container) {
        try {
            this.fEnclosingPackageName = "main";
            this.fCurrentDeterminant.pop();
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startEnumType(String name, boolean isExtend, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            Determinant currentDeterminant = this.getCurrentDeterminant();
            RfEnumType member = (RfEnumType)enclosing.getLocalMember(currentDeterminant, Collections.singleton(RfEnumType.class), name, null);
            if (member == null) {
                member = new RfEnumType(name);
                enclosing.addMember(currentDeterminant, member);
                this.addNewDefinedTypeName(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, endLine, !isExtend, comment);
            member.addLayer(layer);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endEnumType(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startScenario(RfNamedElement enclosing, String name, StructKind structKind, boolean isExtend, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        String builtinOpteratorName;
        if (enclosing != null && BUILTIN_SCENARIONS_SCOPE_NAME.equals(enclosing.getName()) && name.endsWith(BUILTIN_SCENARIONS_SUFFIX_1)) {
            String builtinOpteratorName2 = name.substring(0, name.length() - BUILTIN_SCENARIONS_SUFFIX_1.length());
            if (BUILTIN_SCENARIONS.contains(builtinOpteratorName2)) {
                name = builtinOpteratorName2;
            }
        } else if (enclosing != null && BUILTIN_SCENARIONS_SCOPE_NAME.equals(enclosing.getName()) && name.endsWith(BUILTIN_SCENARIONS_SUFFIX_2) && BUILTIN_SCENARIONS.contains(builtinOpteratorName = name.substring(0, name.length() - BUILTIN_SCENARIONS_SUFFIX_2.length()))) {
            name = builtinOpteratorName;
        }
        return this.startStruct(enclosing, name, structKind, isExtend, startLine, endLine, comment);
    }

    public ElementContainer startStruct(String name, StructKind structKind, boolean isExtend, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        RfNamedElement enclosing = this.enclosingScope();
        return this.startStruct(enclosing, name, structKind, isExtend, startLine, endLine, comment);
    }

    private ElementContainer startStruct(RfNamedElement enclosing, String name, StructKind structKind, boolean isExtend, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        block13: {
            if (enclosing != null) break block13;
            return null;
        }
        try {
            Determinant currentDeterminant = this.getCurrentDeterminant();
            RfStruct member = null;
            if (enclosing instanceof RfStruct) {
                IRfClassType parent = (RfStruct)enclosing;
                while (member == null && parent != null) {
                    member = (RfStruct)parent.getLocalMember(currentDeterminant, STRUCT_CLASSES, name, null);
                    currentDeterminant = Determinant.concat(((RfNamedElement)((Object)parent)).getDeterminant(), currentDeterminant);
                    parent = parent.getParentClass();
                }
            } else {
                member = (RfStruct)enclosing.getLocalMember(currentDeterminant, STRUCT_CLASSES, name, null);
            }
            this.fCurrentDeterminant.push(currentDeterminant);
            if (member == null) {
                member = new RfStruct(name);
                enclosing.addMember(currentDeterminant, member);
                this.addNewDefinedTypeName(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, endLine, !isExtend, comment);
            this.fEnclosingStructLayer.push(layer);
            member.addLayer(layer);
            if (!isExtend) {
                member.setStructKind(structKind);
                if (structKind == StructKind.SCENARIO || structKind == StructKind.MODIFIER) {
                    RfNamedElement parent = this.fPackageMain.getLocalMember(null, Collections.singleton(RfStruct.class), "any_normal_scenario", null);
                    member.setParent((RfClassType)parent);
                } else if (structKind == StructKind.ACTOR) {
                    RfNamedElement parent = this.fPackageMain.getLocalMember(null, Collections.singleton(RfStruct.class), "any_agent", null);
                    member.setParent((RfClassType)parent);
                } else if (!"sdl_struct".equals(name)) {
                    RfNamedElement parent = this.fPackageMain.getLocalMember(null, Collections.singleton(RfStruct.class), "sdl_struct", null);
                    member.setParent((RfClassType)parent);
                }
            }
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endStruct(ElementContainer container) {
        try {
            this.fCurrentDeterminant.pop();
            this.fEnclosingStructLayer.pop();
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void endScenario(ElementContainer container) {
        this.endStruct(container);
    }

    public ElementContainer startWhenStruct(String qualifiedName, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        RfDefElement enclosingStructLayer;
        block3: {
            try {
                this.fIsExtendLayer = true;
                enclosingStructLayer = this.getEnclosingStructLayer();
                if (enclosingStructLayer != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        RfNamedElement member = enclosingStructLayer.getNamedElement();
        Determinant currentDeterminant = new Determinant(qualifiedName);
        this.fCurrentDeterminant.push(currentDeterminant);
        RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, enclosingStructLayer, this.fEnclosingPackageName, startLine, endLine, false, comment);
        this.fEnclosingStructLayer.push(layer);
        member.addLayer(layer);
        this.pushScope(layer, member);
        return new ElementContainer(layer);
    }

    public void endWhenStruct(ElementContainer container) {
        try {
            this.fIsExtendLayer = false;
            this.fEnclosingStructLayer.pop();
            this.fCurrentDeterminant.pop();
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startEnumItem(String name, LineInfo startLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            Determinant currentDeterminant = this.getCurrentDeterminant();
            RfEnumItem member = (RfEnumItem)enclosing.getLocalMember(currentDeterminant, Collections.singleton(RfEnumItem.class), name, null);
            if (member == null) {
                member = new RfEnumItem(name, null);
                enclosing.addMember(currentDeterminant, member);
                this.addNewDefinedVarName(member);
            } else {
                ((RfMembersContainer)enclosing).swapElement(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, startLine, false, comment);
            member.addLayer(layer);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ElementContainer startField(String name, FieldModifier modifier, DataType dataType, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            Determinant currentDeterminant = this.getCurrentDeterminant();
            RfField member = (RfField)enclosing.getLocalMember(currentDeterminant, FIELD_CLASSES, name, null);
            if (member == null || modifier == FieldModifier.ITERATOR) {
                member = new RfField(name, null);
                enclosing.addMember(currentDeterminant, member);
                member.setFieldModifier(modifier);
                this.addNewDefinedVarName(member);
            } else if (modifier == FieldModifier.PARAMETER) {
                ((RfMembersContainer)enclosing).swapElement(member);
            } else if (modifier != FieldModifier.COVERPOINT) {
                member.setFieldModifier(modifier);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, startLine, true, comment);
            member.addLayer(layer);
            member.setDataType(dataType);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ElementContainer startEvent(String name, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            Determinant currentDeterminant = this.getCurrentDeterminant();
            RfEvent member = (RfEvent)enclosing.getLocalMember(currentDeterminant, Collections.singleton(RfEvent.class), name, null);
            if (member == null) {
                member = new RfEvent(name);
                enclosing.addMember(currentDeterminant, member);
                this.addNewDefinedVarName(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, endLine, true, comment);
            member.addLayer(layer);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endEvent(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startMethod(String name, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            Determinant currentDeterminant = this.getCurrentDeterminant();
            RfMethod member = (RfMethod)enclosing.getLocalMember(currentDeterminant, Collections.singleton(RfMethod.class), name, null);
            if (member == null) {
                member = new RfMethod(name, null);
                enclosing.addMember(currentDeterminant, member);
                this.addNewDefinedVarName(member);
            }
            RfDefMethod layer = new RfDefMethod(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, endLine, comment);
            member.addLayer(layer);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endMethod(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startBlock(BlockKind blockKind, AST id, boolean isBlockArray, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            Determinant currentDeterminant = this.getCurrentDeterminant();
            RfNamedElement scope = enclosing;
            String name = id == null ? blockKind.toString() : id.getText();
            RfBlock member = (RfBlock)scope.getLocalMember(currentDeterminant, Collections.singleton(RfBlock.class), name, null);
            if (member == null) {
                member = new RfBlock(name);
                scope.addMember(currentDeterminant, member);
                member.setEnclosingScope(enclosing);
                if (id != null) {
                    this.addNewDefinedVarName(member);
                }
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, endLine, true, comment);
            member.addLayer(layer);
            member.setBlockKind(blockKind);
            this.pushScope(layer, member);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endBlock(ElementContainer container) {
        try {
            if (container == null) {
                return;
            }
            this.popScope(container.def);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public ElementContainer startScenarioInvocation(String name, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            Determinant currentDeterminant = this.getCurrentDeterminant();
            name = this.getAnonymousScenarioName(enclosing, name);
            RfField member = (RfField)enclosing.getLocalMember(currentDeterminant, Collections.singleton(RfField.class), name, null);
            if (member == null) {
                member = new RfField(name, null);
                enclosing.addMember(currentDeterminant, member);
                member.setEnclosingScope(enclosing);
                this.addNewDefinedVarName(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, endLine, true, comment);
            member.addLayer(layer);
            member.setFieldModifier(FieldModifier.SCENARIO_INVOCATION);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private String getAnonymousScenarioName(RfNamedElement enclosing, String scenarioName) {
        Determinant currentDeterminant = this.getCurrentDeterminant();
        int indexOf = scenarioName.indexOf(46);
        if (indexOf >= 0) {
            if (indexOf == 0) {
                scenarioName = scenarioName.substring(1);
            }
            String labelName = DVTStringUtil.appendString((Object[])new Object[]{LABEL_PREFIX, scenarioName, LABEL_SUFFIX});
            RfField member = (RfField)enclosing.getLocalMember(currentDeterminant, Collections.singleton(RfField.class), labelName, null);
            if (member == null || member.hasNoDefs(false)) {
                return labelName;
            }
            int index = 2;
            while (true) {
                labelName = DVTStringUtil.appendString((Object[])new Object[]{LABEL_PREFIX, scenarioName, "(", index, LABEL_SUFFIX, LABEL_SUFFIX});
                member = (RfField)enclosing.getLocalMember(currentDeterminant, Collections.singleton(RfField.class), labelName, null);
                if (member == null || member.hasNoDefs(false)) {
                    return labelName;
                }
                ++index;
            }
        }
        return scenarioName;
    }

    public void endScenarioInvocation(ElementContainer container) {
    }

    public ElementContainer startModifierInvocation(String name, LineInfo startLine, LineInfo endLine, CommentBlock comment) {
        try {
            RfNamedElement enclosing = this.enclosingScope();
            Determinant currentDeterminant = this.getCurrentDeterminant();
            name = this.getAnonymousScenarioName(enclosing, name);
            RfField member = (RfField)enclosing.getLocalMember(currentDeterminant, Collections.singleton(RfField.class), name, null);
            if (member == null) {
                member = new RfField(name, null);
                enclosing.addMember(currentDeterminant, member);
                member.setEnclosingScope(enclosing);
                this.addNewDefinedVarName(member);
            }
            RfDefElement layer = new RfDefElement(this.fCurrentFileDef, currentDeterminant, this.getEnclosingStructLayer(), this.fEnclosingPackageName, startLine, endLine, true, comment);
            member.addLayer(layer);
            member.setFieldModifier(FieldModifier.MODIFIER_INVOCATION);
            this.fCurrentFileDef.addChildDef(layer);
            return new ElementContainer(layer);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void endModifierInvocation(ElementContainer container) {
    }

    public Set<ParserPath> getRawCompiledFilesSet() {
        if (this.fRfCompiledFiles == null) {
            return null;
        }
        return this.fRfCompiledFiles.fCompiledFiles;
    }

    public IProgressMonitor getBuildProgressMonitor() {
        return this.fBuildProgressMonitor;
    }

    public IHidBuilders getHidBuilders() {
        return HidUtils.DEFAULT_BUILDERS;
    }

    public static class ElementContainer {
        public RfNamedElement element;
        public RfDefElement def;

        public ElementContainer(RfNamedElement element) {
            this.element = element;
        }

        public ElementContainer(RfDefElement def) {
            this.element = def == null ? null : def.getNamedElement();
            this.def = def;
        }

        public ElementContainer(RfDefElement def, RfNamedElement element) {
            this.element = def == null ? element : def.getNamedElement();
            this.def = def;
        }
    }

    public static class FileReference
    implements Comparable<FileReference>,
    Serializable {
        private static final long serialVersionUID = 1914L;
        public ParserPath parserPath;
        public int fileIndex;

        public FileReference(ParserPath parserPath, int fileIndex) {
            this.parserPath = parserPath;
            this.fileIndex = fileIndex;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.parserPath == null ? 0 : this.parserPath.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileReference other = (FileReference)obj;
            return !(this.parserPath == null ? other.parserPath != null : !this.parserPath.equals((Object)other.parserPath));
        }

        @Override
        public int compareTo(FileReference o) {
            return this.fileIndex - o.fileIndex;
        }

        public String toString() {
            return this.parserPath.toString();
        }
    }
}

