/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.msdldt.model.reflection.BlockKind;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.IRfClassType;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfClassType;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfPredefinedField;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.StructKind;
import ro.amiq.msdldt.model.reflection.semantic.SemanticUtils;

public class RfStruct
extends RfClassType {
    public static final RfStruct CIRCULAR_INHERITANCE = new RfStruct("[CIRCULAR INHERITANCE]"){

        @Override
        public void addChild(IRfClassType child) {
        }
    };
    private StructKind structKind = StructKind.STRUCT;
    private RfPredefinedField meVariable;
    private RfPredefinedField actorVariable;
    private RfStruct ofScenario;

    public RfStruct(String name) {
        super(name);
    }

    @Override
    public void performAdditionalSemanticChecks(RfProject project, RfDefElement currentLayer) {
        List<RfDefElement> layers;
        if (currentLayer.isIs() && (layers = this.getLayers()).size() > 1) {
            for (RfDefElement layer : layers) {
                if (layer == currentLayer) break;
                if (!layer.isIs()) continue;
                int startOffset = currentLayer.getStartOffset();
                int endOffset = startOffset + this.getName().length();
                int startLine = currentLayer.getStartLine();
                ParserPath parserPath = currentLayer.getParserPath();
                int prevStartLine = layer.getStartLine();
                ParserPath prevParserPath = layer.getParserPath();
                project.addSemanticError(1, this.getSemanticErrorCodeForDuplicate(), null, startOffset, endOffset, null, startLine, parserPath, this.getName(), prevStartLine, prevParserPath);
            }
        }
    }

    @Override
    public void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
        this.meVariable = null;
        this.actorVariable = null;
    }

    @Override
    public String getKindName() {
        if (this.structKind == null) {
            return null;
        }
        return this.structKind.toString();
    }

    public boolean isTopActor() {
        return this.structKind == StructKind.ACTOR && "top".equals(this.getName());
    }

    @Override
    public void setParent(IRfClassType parent) {
        if (parent == null) {
            return;
        }
        this.parent = parent;
        IRfClassType grandParent = parent;
        do {
            if (grandParent != this) continue;
            this.parent = CIRCULAR_INHERITANCE;
            return;
        } while ((grandParent = grandParent.getParentClass()) != null);
        this.parent.addChild(this);
    }

    @Override
    public RfNamedElement getLocalMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, IRfElementFilter elementFilter) {
        if ("me".equals(name)) {
            return this.getMeVariable();
        }
        if ((this.structKind == StructKind.SCENARIO || this.structKind == StructKind.MODIFIER) && "actor".equals(name)) {
            return this.getActorVariable();
        }
        return super.getLocalMember(determinant, classes, name, elementFilter);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RfStruct rfStruct = (RfStruct)super.clone();
        return rfStruct;
    }

    private RfNamedElement getMeVariable() {
        if (this.meVariable == null) {
            this.meVariable = new RfPredefinedField("me", null, "Implicit variable that refers to the current scenario scope");
        }
        this.meVariable.setAssociatedType(this);
        return this.meVariable;
    }

    private RfNamedElement getActorVariable() {
        if (this.actorVariable == null) {
            this.actorVariable = new RfPredefinedField("actor", null, "Implicit variable that refers to the current actor enclosing scope");
        }
        RfStruct enclosingScope = null;
        Collection<RfDefElement> declarations = this.getDeclarations();
        if (declarations != null && !declarations.isEmpty()) {
            for (RfDefElement declaration : declarations) {
                RfNamedElement actorScope;
                RfDefElement enclosingStructDef = declaration.getEnclosingStructDef();
                if (enclosingStructDef == null || !((actorScope = enclosingStructDef.getNamedElement()) instanceof RfStruct) || ((RfStruct)actorScope).getStructKind() != StructKind.ACTOR || enclosingScope != null && !((RfStruct)actorScope).isLike(enclosingScope)) continue;
                enclosingScope = (RfStruct)actorScope;
            }
        }
        if (enclosingScope == null) {
            enclosingScope = this.getEnclosingScope(RfStruct.class);
            if (enclosingScope != null && enclosingScope.getStructKind() != StructKind.ACTOR) {
                enclosingScope = enclosingScope.getEnclosingScope().getEnclosingScope(RfStruct.class);
            }
            this.actorVariable.setAssociatedType(enclosingScope);
            return this.actorVariable;
        }
        this.actorVariable.setAssociatedType(enclosingScope);
        return this.actorVariable;
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Determinant determinant, Class<T> clazz, String prefix, int matchType, boolean isFirst, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        if (clazz == null || clazz != RfField.class) {
            // empty if block
        }
        super.getLocalMembers(result, determinant, clazz, prefix, matchType, isFirst, elementFilter);
    }

    @Override
    public Collection<RfNamedElement> getLocalMembers(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes) {
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        classes.contains(RfPredefinedField.class);
        Collection<RfNamedElement> result2 = super.getLocalMembers(determinant, classes);
        if (result2 != null && !result2.isEmpty()) {
            result.addAll(result2);
        }
        return result;
    }

    @Override
    protected void internalGetMember(Set<RfNamedElement> result, Determinant determinant, Set<IRfNamedElement> visited, String name, boolean isAmbiguousCheck, boolean isFirst, Set<Class<? extends IRfNamedElement>> classes, IRfElementFilter filter) {
        super.internalGetMember(result, determinant, visited, name, isAmbiguousCheck, isFirst, classes, filter);
        if (!result.isEmpty() || this.getStructKind() != StructKind.SCENARIO || !name.startsWith("label(")) {
            return;
        }
        Collection<RfNamedElement> localMembers = this.getLocalMembers();
        if (localMembers == null || localMembers.isEmpty()) {
            return;
        }
        for (RfNamedElement member : localMembers) {
            if (!(member instanceof RfBlock) || ((RfBlock)member).getBlockKind() != BlockKind.WITH) continue;
            member.internalGetMember(result, determinant, visited, name, isAmbiguousCheck, isFirst, classes, filter);
            if (result.isEmpty()) continue;
            return;
        }
    }

    public String getSignature() {
        RfNamedElement enclosing = this.getEnclosingScope();
        String enclosingName = enclosing == null ? "" : String.valueOf(enclosing.getName()) + "::";
        switch (this.structKind) {
            case ACTOR: {
                return "actor " + this.getName();
            }
            case SCENARIO: {
                return "scenario " + enclosingName + this.getName();
            }
            case MODIFIER: {
                return "modifier " + enclosingName + this.getName();
            }
        }
        return "struct " + enclosingName + this.getName();
    }

    public Image getImage() {
        switch (this.structKind) {
            case ACTOR: {
                return DVTImages.imageCache.getImage(DVTImages.MSDL_ACTOR);
            }
            case SCENARIO: {
                return DVTImages.imageCache.getImage(DVTImages.MSDL_SCENARIO);
            }
            case MODIFIER: {
                return DVTImages.imageCache.getImage(DVTImages.MSDL_MODIFIER);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT);
    }

    public Image getExtendImage() {
        switch (this.structKind) {
            case ACTOR: {
                return DVTImages.imageCache.getImage(DVTImages.MSDL_ACTOR_EXTEND);
            }
            case SCENARIO: {
                return DVTImages.imageCache.getImage(DVTImages.MSDL_SCENARIO_EXTEND);
            }
            case MODIFIER: {
                return DVTImages.imageCache.getImage(DVTImages.MSDL_MODIFIER_EXTEND);
            }
        }
        return DVTImages.imageCache.getImage(DVTImages.OUTLINE_STRUCT_EXTEND);
    }

    @Override
    public String getSemanticErrorCodeForDuplicate() {
        switch (this.structKind) {
            case ACTOR: {
                return "DUPLICATE_ACTOR: Duplicate actor ''{0}'' already declared\n    at line {1,number,#######} in {2}";
            }
            case SCENARIO: {
                return "DUPLICATE_SCENARIO: Duplicate scenario ''{0}'' already declared\n    at line {1,number,#######} in {2}";
            }
            case MODIFIER: {
                return "DUPLICATE_MODIFIER: Duplicate modifier ''{0}'' already declared\n    at line {1,number,#######} in {2}";
            }
        }
        return "DUPLICATE_STRUCT: Duplicate struct ''{0}'', already declared\n    at line {1,number,#######} in {2}";
    }

    public void setStructKind(StructKind kind) {
        this.structKind = kind;
    }

    @Override
    public StructKind getStructKind() {
        return this.structKind;
    }

    public RfNamedElement getTopActorMember(Determinant determinant, Set<Class<? extends IRfNamedElement>> classes, String name, IRfElementFilter elementFilter) {
        if (this.members == null) {
            return null;
        }
        RfNamedElement result = this.getLocalMember(determinant, classes, name, elementFilter);
        if (result != null) {
            return result;
        }
        for (RfNamedElement member : this.members) {
            RfNamedElement assocType;
            if (!(member instanceof RfField) || !((RfField)member).isInstance() || (assocType = ((RfField)member).getAssociatedType()) == null || (result = ((RfStruct)assocType).getLocalMember(determinant, classes, name, elementFilter)) == null) continue;
            return result;
        }
        return null;
    }

    public List<RfNamedElement> getArguments(Determinant determinant) {
        Collection<RfNamedElement> fields = this.getLocalMembers(determinant, SemanticUtils.MEMBER_FIELDS);
        if (fields == null) {
            return Collections.emptyList();
        }
        ArrayList<RfNamedElement> result = new ArrayList<RfNamedElement>();
        for (RfNamedElement field : fields) {
            if (!(field instanceof RfField) || ((RfField)field).getFieldModifier() != FieldModifier.RAND) continue;
            result.add(field);
        }
        return result;
    }

    public void ofScenario(RfStruct ofScenario) {
        this.ofScenario = ofScenario;
    }

    public RfStruct getOfScenario() {
        return this.ofScenario;
    }
}

