/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.semantic;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.msdldt.model.problems.Bridge;
import ro.amiq.msdldt.model.reflection.semantic.RfSemanticError;

public class SemanticErrorsManager {
    private static volatile SemanticErrorsManager fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SemanticErrorsManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new SemanticErrorsManager();
            }
        }
        return fInstance;
    }

    private SemanticErrorsManager() {
        DVTProblemsUiUpdaterRegistry.register((DVTProblemsUiUpdater)new DVTProblemsUiUpdater(MSDLProblemCategories.MSDL_SEMANTIC));
    }

    public void reparsed(IProject project, Map<String, Collection<RfSemanticError>> semanticErrors, boolean toConsole) {
        if (!DVTPlugin.getDefault().collect().c(project.getProject(), "F73646C")) {
            return;
        }
        if (semanticErrors != null) {
            for (Collection<RfSemanticError> errors : semanticErrors.values()) {
                if (errors == null || errors.isEmpty()) continue;
                for (RfSemanticError error : errors) {
                    DVTProblemManager.getInstance().reportProblem(Bridge.from(project.getProject(), error, toConsole));
                }
            }
        }
        DVTProblemsUiUpdaterRegistry.get((String)MSDLProblemCategories.MSDL_SEMANTIC.getId()).update(project);
        DVTProblemManager.getInstance().save(project);
        DVTProblemsUiUpdaterRegistry.get((String)MSDLProblemCategories.MSDL_SEMANTIC.getId()).scheduleObjectionsClear(project);
        DVTProblemsUiUpdaterRegistry.get((String)MSDLProblemCategories.MSDL_SYNTAX.getId()).scheduleObjectionsClear(project);
    }

    public void clean(IProject project) {
        DVTProblemManager.getInstance().removeProblemsWithCategory(project, MSDLProblemCategories.MSDL_SEMANTIC);
        DVTProblemsUiUpdaterRegistry.get((String)MSDLProblemCategories.MSDL_SEMANTIC.getId()).clean(project);
    }
}

