/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.semantic;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.LineInfo;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.msdldt.model.ASTUtils;
import ro.amiq.msdldt.model.reflection.AmbiguousAccessError;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.IRfClassType;
import ro.amiq.msdldt.model.reflection.IRfScope;
import ro.amiq.msdldt.model.reflection.RfArrayType;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfEnumItem;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfEvent;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfLibrary;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfPredefinedField;
import ro.amiq.msdldt.model.reflection.RfPredefinedMethod;
import ro.amiq.msdldt.model.reflection.RfPredefinedStruct;
import ro.amiq.msdldt.model.reflection.RfPredefinedType;
import ro.amiq.msdldt.model.reflection.RfPredefinedTypeAlias;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.RfWhenSubtype;
import ro.amiq.msdldt.model.reflection.StructKind;
import ro.amiq.msdldt.parser.EAST;
import ro.amiq.msdldt.parser.HierarchicalScope;
import ro.amiq.msdldt.parser.RfDummyField;
import ro.amiq.msdldt.parser.SemanticWalker;

public class SemanticUtils {
    public static final Map<String, Set<String>> ALL_UNITS = new HashMap<String, Set<String>>();
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_TYPES;
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_VARIABLES;
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_FIELDS;
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_FIELDS_2;
    public static final Set<Class<? extends IRfNamedElement>> MEMBER_METHODS;
    public static final Set<String> ASSIGNMENT_COMPATIBLE_1;
    public static final Set<String> ASSIGNMENT_COMPATIBLE_2;
    public static final Set<StructKind> NO_MODIFIER_STRUCT_KINDS;

    static {
        HashSet<String> jerk = new HashSet<String>();
        ALL_UNITS.put("jerk", jerk);
        jerk.addAll(Arrays.asList("nm_per_ms_cubed", "mpspsps", "meter_per_sec_cubed", "mile_per_sec_cubed"));
        HashSet<String> acceleration = new HashSet<String>();
        ALL_UNITS.put("acceleration", acceleration);
        acceleration.addAll(Arrays.asList("kphps", "mpsps", "meter_per_sec_sqr", "mile_per_hour_per_sec"));
        HashSet<String> angle = new HashSet<String>();
        ALL_UNITS.put("angle", angle);
        angle.addAll(Arrays.asList("deg", "degree", "rad", "radian"));
        HashSet<String> angular_speed = new HashSet<String>();
        ALL_UNITS.put("angular_speed", angular_speed);
        angular_speed.addAll(Arrays.asList("degree_per_second", "radian_per_second"));
        HashSet<String> distance = new HashSet<String>();
        ALL_UNITS.put("distance", distance);
        distance.addAll(Arrays.asList("mm", "millimeter", "cm", "centimeter", "in", "inch", "feet", "m", "meter", "km", "kilometer", "mile"));
        HashSet<String> speed = new HashSet<String>();
        ALL_UNITS.put("speed", speed);
        speed.addAll(Arrays.asList("kph", "kilometer_per_hour", "mph", "mile_per_hour", "meter_per_second", "mps"));
        HashSet<String> temperature = new HashSet<String>();
        ALL_UNITS.put("temperature", temperature);
        temperature.addAll(Arrays.asList("c", "celsius", "f", "fahrenheit"));
        HashSet<String> time = new HashSet<String>();
        ALL_UNITS.put("time", time);
        time.addAll(Arrays.asList("ms", "millisecond", "s", "sec", "second", "min", "minute", "hr", "hour"));
        HashSet<String> weight = new HashSet<String>();
        ALL_UNITS.put("weight", weight);
        weight.addAll(Arrays.asList("kg", "kilogram", "ton"));
        MEMBER_TYPES = new HashSet<Class>(Arrays.asList(RfPackage.class, RfStruct.class, RfTypeAlias.class, RfPredefinedTypeAlias.class, RfEnumType.class, RfCovergroup.class, RfPredefinedType.class, RfPredefinedStruct.class));
        MEMBER_VARIABLES = new HashSet<Class>(Arrays.asList(RfField.class, RfPredefinedField.class, RfMethod.class, RfPredefinedMethod.class, RfEvent.class, RfBlock.class, RfEnumItem.class));
        MEMBER_FIELDS = new HashSet<Class>(Arrays.asList(RfField.class, RfPredefinedField.class, RfEvent.class));
        MEMBER_FIELDS_2 = new HashSet<Class>(Arrays.asList(RfField.class, RfPredefinedField.class, RfBlock.class, RfEvent.class));
        MEMBER_METHODS = new HashSet<Class>(Arrays.asList(RfMethod.class, RfPredefinedMethod.class));
        ASSIGNMENT_COMPATIBLE_1 = new HashSet<String>(Arrays.asList("int", "int64", "uint", "uint64", "number", "index", "real"));
        ASSIGNMENT_COMPATIBLE_2 = new HashSet<String>(Arrays.asList("bool"));
        NO_MODIFIER_STRUCT_KINDS = EnumSet.of(StructKind.ACTOR, StructKind.SCENARIO, StructKind.STRUCT);
    }

    public static void setTransientResult(AST node, RfNamedElement result) {
        if (node == null) {
            return;
        }
        if (node.getType() == 75 || node.getType() == 74 || node.getType() == 152 || node.getType() == 77 || node.getType() == 60 || node.getType() == 21) {
            return;
        }
        ((EAST)node).transientResult = result;
    }

    public static <T extends IRfNamedElement> T getTransientResult(Class<T> clazz, AST node) {
        if (node == null || ((EAST)node).transientResult == null) {
            return null;
        }
        Object candidate = ((EAST)node).transientResult;
        if (!clazz.isInstance(candidate)) {
            return null;
        }
        return (T)((IRfNamedElement)candidate);
    }

    public static void setTransientScope(AST node, IRfScope result) {
        if (node == null) {
            return;
        }
        ((EAST)node).transientScope = result;
    }

    public static <T> T getTransientScope(Class<T> clazz, AST node) {
        if (node == null || ((EAST)node).transientScope == null) {
            return null;
        }
        Object candidate = ((EAST)node).transientScope;
        if (!clazz.isInstance(candidate)) {
            return null;
        }
        return (T)candidate;
    }

    public static LineInfo getLineInfo(AST node) {
        if (node == null) {
            return SemanticUtils.getUnknownLineInfo();
        }
        EAST t = (EAST)node;
        LineInfo result = new LineInfo(t.getLine(), t.getOffset(), -1);
        return result;
    }

    private static LineInfo getUnknownLineInfo() {
        return new LineInfo(-1, -1, -1);
    }

    public static LineInfo getTreeLineInfo(AST rootAST) {
        if (rootAST == null) {
            return null;
        }
        final LineInfo first = new LineInfo(Integer.MAX_VALUE, Integer.MAX_VALUE, -1);
        final LineInfo last = new LineInfo(0, 0, -1);
        ASTUtils.scanBelowAST(new ASTUtils.ASTRunnable(){

            @Override
            public void run(AST node) throws Exception {
                boolean enable2;
                int t = node.getType();
                boolean enable1 = node.getLine() > 0 && node.getOffset() > 0;
                boolean bl = enable2 = t == 144 || t == 152 || t == 149 || t == 150 || t == 151 || t == 60 || t == 21 || t == 38;
                if ((enable1 || enable2) && node.getLine() <= first.line && node.getOffset() > 0 && node.getOffset() < first.realOffset) {
                    first.line = node.getLine();
                    first.realOffset = node.getOffset();
                }
                int endOffset = node.getOffset() + (enable2 ? node.getText().length() : 0);
                if ((enable1 || enable2) && node.getLine() >= last.line && node.getOffset() > 0 && endOffset > last.realOffset) {
                    last.line = node.getLine();
                    last.realOffset = endOffset;
                }
            }
        }, rootAST);
        if (first.line != Integer.MAX_VALUE && first.realOffset != Integer.MAX_VALUE && last.realOffset > 0) {
            return new LineInfo(first.line, first.realOffset, last.realOffset);
        }
        return null;
    }

    public static RfNamedElement resolveQualifiedType(RfProject project, Determinant determinant, RfDefElement currentScopeLayer, List<AST> qid, boolean isMethod, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (currentScopeLayer == null) {
            return null;
        }
        RfNamedElement currentScope = currentScopeLayer instanceof RfFileDef ? project.getMainPackage() : currentScopeLayer.getNamedElement();
        return SemanticUtils.resolveQualifiedType(project, determinant, currentScope, qid, isMethod, fileIndex, parserPath, fileDef);
    }

    public static RfNamedElement resolveQualifiedType(RfProject project, Determinant determinant, RfNamedElement currentScope, List<AST> qid, boolean isMethod, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (currentScope == null) {
            return null;
        }
        AST ast = null;
        int i = 0;
        while (i < qid.size() - 1) {
            ast = qid.get(i);
            currentScope = project.getLocalLibrary("work");
            if ((currentScope = ((RfLibrary)currentScope).getLocalType(project, MEMBER_TYPES, ast.getText(), null)) == null) {
                project.addSemanticError(1, "UNDECLARED_TYPE: Type ''{0}'' is not declared", null, ast.getOffset(), ast.getOffset() + ast.getText().length(), null, ast.getLine(), parserPath, ast.getText());
                currentScope = SemanticWalker.UNRESOLVED_ELEMENT;
            }
            SemanticUtils.setTransientResult(ast, currentScope);
            fileDef.createTypeDependency(project, currentScope, ast.getText());
            if (currentScope == SemanticWalker.UNRESOLVED_ELEMENT) {
                return currentScope;
            }
            ++i;
        }
        ast = qid.get(qid.size() - 1);
        RfNamedElement result = currentScope.getMember(determinant, ast.getText(), qid.size() == 1, true, isMethod ? MEMBER_METHODS : MEMBER_TYPES, null);
        if (result == null) {
            if (isMethod) {
                project.addSemanticError(1, "UNDECLARED_FUNCTION: Function ''{0}'' is not declared", null, ast.getOffset(), ast.getOffset() + ast.getText().length(), null, ast.getLine(), parserPath, ast.getText());
            } else {
                project.addSemanticError(1, "UNDECLARED_TYPE: Type ''{0}'' is not declared", null, ast.getOffset(), ast.getOffset() + ast.getText().length(), null, ast.getLine(), parserPath, ast.getText());
            }
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        if (result instanceof AmbiguousAccessError) {
            result = currentScope.getMember(determinant, ast.getText(), qid.size() == 1, true, isMethod ? MEMBER_METHODS : MEMBER_TYPES, null);
            RfNamedElement package1 = ((AmbiguousAccessError)result).getCandidate1().getEnclosingScope();
            RfNamedElement package2 = ((AmbiguousAccessError)result).getCandidate2().getEnclosingScope();
            if (isMethod) {
                project.addSemanticError(1, "AMBIGUOUS_FUNCTION: Function name ''{0}'' exists in multiple imported scopes (''{1}'', ''{2}'', and possibly others)", null, ast.getOffset(), ast.getOffset() + ast.getText().length(), null, ast.getLine(), parserPath, ast.getText(), package1.getName(), package2.getName());
            } else {
                project.addSemanticError(1, "AMBIGUOUS_TYPE: Type name ''{0}'' exists in multiple imported scopes (''{1}'', ''{2}'', and possibly others)", null, ast.getOffset(), ast.getOffset() + ast.getText().length(), null, ast.getLine(), parserPath, ast.getText(), package1.getName(), package2.getName());
            }
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        SemanticUtils.setTransientResult(ast, result);
        if (isMethod) {
            fileDef.createVariableDependency(project, result, ast.getText());
        } else {
            fileDef.createTypeDependency(project, result, ast.getText());
        }
        return result;
    }

    public static RfNamedElement resolveHierarchicalId(RfProject project, Determinant determinant, RfDefElement currentScopeLayer, RfDefElement enclosingScopeLayer, AST id, boolean isFirst, StructKind structKind, RfField exclude, boolean isCoverageDecl, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        RfNamedElement currentScope = currentScopeLayer == null ? null : currentScopeLayer.getNamedElement();
        return SemanticUtils.resolveHierarchicalId(project, determinant, currentScope, enclosingScopeLayer, id, isFirst, structKind, exclude, isCoverageDecl, fileIndex, parserPath, fileDef);
    }

    public static RfNamedElement resolveHierarchicalId(RfProject project, Determinant determinant, final RfNamedElement currentScope, RfDefElement enclosingScopeLayer, AST id, boolean isFirst, final StructKind structKind, final RfField exclude, boolean isCoverageDecl, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        Collection<RfNamedElement> blocks;
        if (currentScope == null || id == null) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        final RfStruct[] modifierOfScenario = new RfStruct[1];
        final RfNamedElement[] modifierScenarioScope = new RfNamedElement[1];
        final RfNamedElement[] coverpoint = new RfNamedElement[1];
        IRfElementFilter filter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                if (candidate == exclude) {
                    return false;
                }
                if (candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.MODIFIER) {
                    RfStruct ofScenario = ((RfStruct)candidate).getOfScenario();
                    if (ofScenario == null) {
                        return true;
                    }
                    RfField itField = (RfField)currentScope.getLocalMember(null, MEMBER_VARIABLES, "it", null);
                    if (itField == null) {
                        return true;
                    }
                    RfNamedElement scenarioScope = itField.getAssociatedType();
                    if (scenarioScope == ofScenario) {
                        return true;
                    }
                    if (scenarioScope instanceof IRfClassType && ((IRfClassType)((Object)scenarioScope)).isLike(ofScenario)) {
                        return true;
                    }
                    modifierOfScenario[0] = ofScenario;
                    modifierScenarioScope[0] = scenarioScope;
                    return true;
                }
                if (candidate instanceof RfField && ((RfField)candidate).getFieldModifier() == FieldModifier.COVERPOINT) {
                    coverpoint[0] = (RfNamedElement)candidate;
                    return false;
                }
                if (structKind == null) {
                    return true;
                }
                return candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == structKind;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 0;
            }
        };
        RfNamedElement result = null;
        if (structKind == StructKind.SCENARIO || structKind == StructKind.MODIFIER) {
            result = currentScope.getMember(determinant, id.getText(), false, isFirst, RfProject.STRUCT_CLASSES, filter);
        } else {
            result = currentScope.getMember(determinant, id.getText(), false, isFirst, MEMBER_VARIABLES, filter);
            if (result == null && isCoverageDecl) {
                result = coverpoint[0];
            }
            if (result instanceof RfPredefinedField && ("it".equals(id.getText()) || "me".equals(id.getText()) || "outer".equals(id.getText())) && determinant != null && determinant != RfPackage.MAIN_DETERMINANT && determinant.toArray().length > 0) {
                RfPredefinedField rfPredefinedField = (RfPredefinedField)result;
                RfPredefinedField itField = new RfPredefinedField(rfPredefinedField.getName(), null, result.getComment().substring("PREDEFINED: ".length()));
                itField.setDeterminant(determinant);
                itField.setAssociatedType(rfPredefinedField.getAssociatedType());
                result = itField;
            }
        }
        if (modifierOfScenario[0] != null && modifierScenarioScope[0] != null) {
            project.addSemanticError(1, "MODIFIER_OF_SCENARIO: Modifier ''{0}'' of scenario ''{1}'' is not applicable to scenario ''{2}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), modifierOfScenario[0].getName(), modifierScenarioScope[0].getName());
            fileDef.createVariableDependency(project, result, id.getText());
            SemanticUtils.setTransientResult(id, result);
            return result;
        }
        RfDefElement enclosingStructDef = enclosingScopeLayer;
        if (result == null && enclosingStructDef != null) {
            while ((enclosingStructDef = enclosingStructDef.getEnclosingStructDef()) != null) {
                result = enclosingStructDef.getNamedElement().getMember(enclosingStructDef.getDeterminant(), id.getText(), false, isFirst, RfProject.STRUCT_CLASSES, filter);
                if (result != null) break;
            }
        }
        if (result == null && isFirst && currentScope instanceof RfStruct && (blocks = currentScope.getLocalMembers(determinant, Collections.singleton(RfBlock.class))) != null && !blocks.isEmpty()) {
            for (RfNamedElement block : blocks) {
                result = block.getMember(determinant, id.getText(), false, isFirst, MEMBER_VARIABLES, filter);
                if (result != null) break;
            }
        }
        if (result == null && isFirst && (structKind == StructKind.SCENARIO || structKind == StructKind.MODIFIER)) {
            RfStruct topActor = project.getTopActor();
            result = topActor.getTopActorMember(determinant, RfProject.STRUCT_CLASSES, id.getText(), filter);
        }
        if (result == null || !SemanticUtils.valid(result)) {
            if (parserPath != null) {
                if (isFirst) {
                    project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
                } else {
                    project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), currentScope.getName());
                }
            }
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        fileDef.createVariableDependency(project, result, id.getText());
        SemanticUtils.setTransientResult(id, result);
        return result;
    }

    public static void checkExtendStructKind(RfProject project, RfDefElement currentScopeLayer, StructKind structKind, LineInfo lineInfo) {
        if (currentScopeLayer == null) {
            return;
        }
        RfNamedElement element = currentScopeLayer.getNamedElement();
        List<RfDefElement> layers = element.getLayers();
        RfDefElement declaration = null;
        if (layers == null || layers.size() <= 1 || (declaration = layers.iterator().next()) != null && !declaration.isIs()) {
            int startOffset = lineInfo.realOffset;
            String name = element.getName();
            int endOffset = startOffset + name.length();
            ParserPath parserPath = currentScopeLayer.getParserPath();
            int startLine = lineInfo.line;
            project.addSemanticError(1, "EXTEND_UNDEFINED_TYPE: Cannot extend ''{0}'' {1} type, because it was not previously defined", null, startOffset, endOffset, null, startLine, parserPath, name, structKind.toString());
            return;
        }
        if (element instanceof RfEnumType) {
            int startOffset = lineInfo.realOffset;
            String name = element.getName();
            int endOffset = startOffset + name.length();
            ParserPath parserPath = currentScopeLayer.getParserPath();
            int startLine = lineInfo.line;
            project.addSemanticError(1, "EXTEND_ENUM_TYPE: Wrong kind ''{0}'' specified to extend ''{1}'' enum type", null, startOffset, endOffset, null, startLine, parserPath, structKind.toString(), name);
            return;
        }
        if (element instanceof RfStruct) {
            StructKind expectedStructKind = ((RfStruct)element).getStructKind();
            int startOffset = lineInfo.realOffset;
            String name = element.getName();
            int endOffset = startOffset + name.length();
            ParserPath parserPath = currentScopeLayer.getParserPath();
            int startLine = lineInfo.line;
            project.addSemanticError(1, "EXTEND_CLASS_TYPE: Wrong kind ''{0}'' specified to extend ''{1}'' {2} type", null, startOffset, endOffset, null, startLine, parserPath, structKind.toString(), name, expectedStructKind.toString());
        }
    }

    public static void checkNofArgsMismatch(RfProject project, RfNamedElement element, AST id, int nofParamsExpected, int nofParamsFound, ParserPath parserPath) {
        if (element == null) {
            return;
        }
        if (nofParamsExpected == nofParamsFound) {
            return;
        }
        String message = "FUNCTION_CALL_ARGUMENTS: Expecting ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''";
        if (element instanceof RfEvent) {
            message = "EVENT_CALL_ARGUMENTS: Expecting ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''";
        } else if (element instanceof RfMethod) {
            message = "FUNCTION_CALL_ARGUMENTS: Expecting ''{1}'' argument{1,choice,0#s|1#|1<s} when calling ''{0}'', found ''{2}''";
        } else {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(id);
        if (lineInfo == null) {
            return;
        }
        project.addSemanticError(1, message, null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, element.getName(), nofParamsExpected, nofParamsFound);
    }

    public static boolean isLike(IRfNamedElement classChild, IRfNamedElement classParent) {
        if (!(classChild instanceof IRfClassType) || !(classParent instanceof IRfClassType)) {
            return false;
        }
        return ((IRfClassType)classChild).isLike((IRfClassType)classParent);
    }

    public static String getElementName(AST expFrom, RfNamedElement assignFromElement) {
        String fromElementName;
        String string = fromElementName = assignFromElement instanceof RfDummyField ? ((RfDummyField)assignFromElement).getNameForErrorReporting() : assignFromElement.getName();
        if (fromElementName == null) {
            fromElementName = expFrom == null ? "null" : ((EAST)expFrom).getMeta("text");
        }
        fromElementName = SemanticUtils.customizeElementName(fromElementName);
        return fromElementName;
    }

    public static String customizeElementName(String elementName) {
        if (elementName != null) {
            elementName = elementName.replace('\n', ' ');
            elementName = elementName.replace('\r', ' ');
            if ((elementName = DVTStringUtil.replaceAll((Pattern)DVTStringUtil.MULTIPLE_WS, (CharSequence)elementName, (String)" ")).length() > 100) {
                elementName = elementName.startsWith("\"") && elementName.endsWith("\"") ? String.valueOf(elementName.substring(0, 97)) + "...\"" : String.valueOf(elementName.substring(0, 97)) + " ...";
            }
        }
        return elementName;
    }

    public static boolean valid(RfNamedElement result) {
        if (result == null) {
            return false;
        }
        if (result == SemanticWalker.UNRESOLVED_ELEMENT) {
            return false;
        }
        if (result.isPredefined()) {
            return true;
        }
        if (result instanceof RfWhenSubtype) {
            return true;
        }
        if (result instanceof RfArrayType) {
            return true;
        }
        return !result.hasNoDefs(false);
    }

    public static boolean valid(SemanticWalker.RfExpressionResult result) {
        if (result == null) {
            return false;
        }
        if (result.mul.isEmpty() && result.div.isEmpty()) {
            return false;
        }
        for (RfNamedElement element : result.mul) {
            if (SemanticUtils.valid(element)) continue;
            return false;
        }
        return true;
    }

    public static RfNamedElement resolveOptionId(RfProject project, RfDefElement currentScopeLayer, AST id, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (currentScopeLayer == null) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        RfNamedElement currentScope = currentScopeLayer.getNamedElement();
        if (currentScope == null) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        RfNamedElement result = RfCovergroup.getOption(project, id.getText());
        if (result == null || !SemanticUtils.valid(result)) {
            project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        SemanticUtils.setTransientResult(id, result);
        return result;
    }

    public static void setClassParent(RfProject project, IRfClassType classType, RfNamedElement parentClassType, String parentDeterminant, AST id, ParserPath parserPath) {
        if (id == null || !SemanticUtils.valid((RfNamedElement)((Object)classType)) || !SemanticUtils.valid(parentClassType)) {
            return;
        }
        String name = id.getText();
        int startOffset = id.getOffset();
        int endOffset = startOffset + name.length();
        int line = id.getLine();
        StructKind childStructKind = classType.getStructKind();
        StructKind parentStructKind = ((IRfClassType)((Object)parentClassType)).getStructKind();
        String childStructKindName = childStructKind.toString();
        parentStructKind.toString();
        if (parentDeterminant == null || parentDeterminant.isEmpty()) {
            classType.setParent((IRfClassType)((Object)parentClassType));
        } else {
            classType.setParent(new RfWhenSubtype((IRfClassType)((Object)parentClassType), new Determinant(parentDeterminant)));
        }
        if (classType.getParentClass() != RfStruct.CIRCULAR_INHERITANCE) {
            return;
        }
        String kindName = String.valueOf(childStructKindName.substring(0, 1).toUpperCase()) + childStructKindName.substring(1);
        project.addSemanticError(1, "CIRCULAR_INHERITANCE: {0} ''{1}'' extends itself", null, startOffset, endOffset, null, line, parserPath, kindName, name);
    }

    public static RfNamedElement resolveType(RfProject project, Determinant determinant, RfNamedElement currentScope, AST id, final Set<StructKind> structKinds, boolean isFirstID, boolean isLastID, boolean isMethod, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (currentScope == null || !SemanticUtils.valid(currentScope)) {
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                if (structKinds != null && candidate instanceof RfStruct && !structKinds.contains((Object)((RfStruct)candidate).getStructKind())) {
                    return false;
                }
                if (candidate.isPredefined()) {
                    return true;
                }
                return !candidate.hasNoDefs(false);
            }

            public int resultMaxSize() {
                return 1;
            }

            public boolean allowEnumElement() {
                return true;
            }
        };
        RfNamedElement result = currentScope.getMember(determinant, id.getText(), isLastID, isFirstID, isLastID && isMethod ? MEMBER_METHODS : MEMBER_TYPES, elementFilter);
        if (result == null) {
            if (isMethod) {
                project.addSemanticError(1, "UNDECLARED_FUNCTION: Function ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            } else {
                project.addSemanticError(1, "UNDECLARED_TYPE: Type ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            }
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        if (result instanceof AmbiguousAccessError) {
            result = currentScope.getMember(determinant, id.getText(), isLastID, isFirstID, isMethod ? MEMBER_METHODS : MEMBER_TYPES, null);
            RfNamedElement package1 = ((AmbiguousAccessError)result).getCandidate1().getEnclosingScope();
            RfNamedElement package2 = ((AmbiguousAccessError)result).getCandidate2().getEnclosingScope();
            if (isMethod) {
                project.addSemanticError(1, "AMBIGUOUS_FUNCTION: Function name ''{0}'' exists in multiple imported scopes (''{1}'', ''{2}'', and possibly others)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), package1.getName(), package2.getName());
            } else {
                project.addSemanticError(1, "AMBIGUOUS_TYPE: Type name ''{0}'' exists in multiple imported scopes (''{1}'', ''{2}'', and possibly others)", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), package1.getName(), package2.getName());
            }
            result = ((AmbiguousAccessError)result).getCandidate1();
        }
        SemanticUtils.setTransientResult(id, result);
        if (isMethod) {
            fileDef.createVariableDependency(project, result, id.getText());
        } else {
            fileDef.createTypeDependency(project, result, id.getText());
        }
        return result;
    }

    public static RfNamedElement getActor(RfProject project, AST id, ParserPath parserPath) {
        RfPackage mainPackage = project.getMainPackage();
        RfNamedElement result = mainPackage.getLocalMember(RfPackage.MAIN_DETERMINANT, RfProject.STRUCT_CLASSES, id.getText(), null);
        if (result == null) {
            project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        SemanticUtils.setTransientResult(id, result);
        return result;
    }

    public static void setItAssociatedType(RfProject project, RfDefElement currentScopeLayer, AST id) {
        if (id == null || currentScopeLayer == null) {
            return;
        }
        RfField rfField = SemanticUtils.getTransientResult(RfField.class, id);
        if (rfField == null) {
            return;
        }
        RfNamedElement currentScope = currentScopeLayer.getNamedElement();
        if (currentScope instanceof RfBlock) {
            RfField itVariable = (RfField)currentScope.getLocalMember(RfPackage.MAIN_DETERMINANT, Collections.singleton(RfPredefinedField.class), "it", null);
            if (itVariable == null) {
                return;
            }
            itVariable.setDataType(rfField.getDataType());
            itVariable.setAssociatedType(rfField.getAssociatedType());
        }
    }

    public static void checkWhenQualifier(RfProject project, HierarchicalScope scope, RfDefElement enclosingScopeLayer, AST id1, AST id2, ParserPath parserPath) {
        if (id1 == null || scope == null || scope.scope == null) {
            return;
        }
        RfNamedElement result = scope.scope.getMember(scope.determinant, id1.getText(), false, true, Collections.singleton(RfField.class), null);
        if (result == null) {
            project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id1.getOffset(), id1.getOffset() + id1.getText().length(), null, id1.getLine(), parserPath, id1.getText());
            result = SemanticWalker.UNRESOLVED_ELEMENT;
            SemanticUtils.setTransientResult(id1, result);
            return;
        }
        SemanticUtils.setTransientResult(id1, result);
        RfNamedElement assocType = ((RfField)result).getAssociatedType();
        if (id2 != null) {
            if (assocType instanceof RfEnumType) {
                result = assocType.getLocalMember(RfPackage.MAIN_DETERMINANT, Collections.singleton(RfEnumItem.class), id2.getText(), null);
                if (result == null) {
                    project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id2.getOffset(), id2.getOffset() + id2.getText().length(), null, id2.getLine(), parserPath, id2.getText());
                    result = SemanticWalker.UNRESOLVED_ELEMENT;
                    SemanticUtils.setTransientResult(id2, result);
                    return;
                }
                SemanticUtils.setTransientResult(id2, result);
            } else if (SemanticUtils.valid(assocType)) {
                project.addSemanticError(1, "UNEXPECTED_TYPE: Unexpected type of variable ''{0}'' (expecting {1} type)", null, id1.getOffset(), id1.getOffset() + id1.getText().length(), null, id1.getLine(), parserPath, id1.getText(), "enumerated");
                result = SemanticWalker.UNRESOLVED_ELEMENT;
                SemanticUtils.setTransientResult(id2, result);
            }
        } else if (assocType != null && !assocType.getName().equals("bool")) {
            project.addSemanticError(1, "UNEXPECTED_TYPE: Unexpected type of variable ''{0}'' (expecting {1} type)", null, id1.getOffset(), id1.getOffset() + id1.getText().length(), null, id1.getLine(), parserPath, id1.getText(), "boolean");
        }
    }

    public static void checkIllegalAssignment(RfProject project, AST operator, AST leftAST, SemanticWalker.RfExpressionResult left, AST rightAST, SemanticWalker.RfExpressionResult right, ParserPath parserPath) {
        boolean isConstraint;
        boolean rightHasUnits;
        if (!SemanticUtils.valid(left) || !SemanticUtils.valid(right)) {
            return;
        }
        int operatorType = operator.getType();
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(operator);
        String leftExprText = ((EAST)leftAST).getMeta("text");
        String rightExprText = ((EAST)rightAST).getMeta("text");
        ArrayList<String> leftUnitMul = new ArrayList<String>();
        ArrayList<String> leftUnitDiv = new ArrayList<String>();
        SemanticUtils.getBaseUnits(left.mul, leftUnitMul, leftUnitDiv);
        SemanticUtils.getBaseUnits(left.div, leftUnitDiv, leftUnitMul);
        Iterator iterator = leftUnitDiv.iterator();
        while (iterator.hasNext()) {
            String unit = (String)iterator.next();
            if (!leftUnitMul.remove(unit)) continue;
            iterator.remove();
        }
        ArrayList<String> rightUnitMul = new ArrayList<String>();
        ArrayList<String> rightUnitDiv = new ArrayList<String>();
        SemanticUtils.getBaseUnits(right.mul, rightUnitMul, rightUnitDiv);
        SemanticUtils.getBaseUnits(right.div, rightUnitDiv, rightUnitMul);
        Iterator iterator2 = rightUnitDiv.iterator();
        while (iterator2.hasNext()) {
            String unit = (String)iterator2.next();
            if (!rightUnitMul.remove(unit)) continue;
            iterator2.remove();
        }
        boolean leftHasUnits = !leftUnitMul.isEmpty() && !"null".equals(leftUnitMul.get(0)) || !leftUnitDiv.isEmpty();
        boolean bl = rightHasUnits = !rightUnitMul.isEmpty() && !"null".equals(rightUnitMul.get(0)) || !rightUnitDiv.isEmpty();
        if ((leftHasUnits || rightHasUnits) && operatorType != 135 && operatorType != 136 && (operatorType != 137 || rightHasUnits)) {
            if (!rightUnitMul.isEmpty() && "null".equals(rightUnitMul.get(0))) {
                leftUnitMul.clear();
                leftUnitDiv.clear();
                rightUnitMul.clear();
                rightUnitDiv.clear();
            } else if (!leftUnitMul.isEmpty() && "null".equals(leftUnitMul.get(0))) {
                leftUnitMul.clear();
                leftUnitDiv.clear();
                rightUnitMul.clear();
                rightUnitDiv.clear();
            } else {
                String unit;
                Iterator iterator3 = rightUnitMul.iterator();
                while (iterator3.hasNext()) {
                    unit = (String)iterator3.next();
                    if (!leftUnitMul.remove(unit)) continue;
                    iterator3.remove();
                }
                iterator3 = rightUnitDiv.iterator();
                while (iterator3.hasNext()) {
                    unit = (String)iterator3.next();
                    if (!leftUnitDiv.remove(unit)) continue;
                    iterator3.remove();
                }
            }
            if (!(leftUnitMul.isEmpty() && leftUnitDiv.isEmpty() && rightUnitMul.isEmpty() && rightUnitDiv.isEmpty())) {
                if (operatorType == 30) {
                    project.addSemanticError(1, "UNEXPECTED_TYPE: ''{0}'' is not a boolean expression", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightExprText);
                } else {
                    project.addSemanticError(1, "UNEXPECTED_TYPE: Expression ''{0}'' is not type compatible with expression ''{1}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, rightExprText, leftExprText);
                }
                return;
            }
            return;
        }
        if (left.mul.isEmpty() || right.mul.isEmpty()) {
            return;
        }
        RfNamedElement leftOperandType = left.mul.get(0);
        RfNamedElement rightOperandType = right.mul.get(0);
        if (!SemanticUtils.valid(leftOperandType) || !SemanticUtils.valid(rightOperandType)) {
            return;
        }
        if (leftOperandType == rightOperandType) {
            return;
        }
        String leftOperandTypeName = leftOperandType.getName();
        String rightOperandTypeName = rightOperandType.getName();
        if (leftOperandType instanceof RfArrayType && rightOperandType instanceof RfArrayType) {
            RfNamedElement listLeft = leftOperandType;
            RfNamedElement listRight = rightOperandType;
            while (listLeft instanceof RfArrayType && listRight instanceof RfArrayType) {
                if ((listLeft = ((RfArrayType)listLeft).getAssociatedType()) == (listRight = ((RfArrayType)listRight).getAssociatedType())) {
                    return;
                }
                if (listLeft == null || !ASSIGNMENT_COMPATIBLE_1.contains(listLeft.getName()) || listRight == null || !ASSIGNMENT_COMPATIBLE_1.contains(listRight.getName())) continue;
                return;
            }
        }
        if (!(operatorType != 135 && operatorType != 136 && operatorType != 137 || leftOperandType instanceof RfStruct || rightOperandType instanceof RfStruct || leftOperandType instanceof RfEnumType || rightOperandType instanceof RfEnumType || "bool".equals(leftOperandTypeName) || "bool".equals(rightOperandTypeName))) {
            return;
        }
        if (leftOperandType instanceof RfStruct && rightOperandType instanceof RfPredefinedType && "null".equals(rightOperandTypeName)) {
            return;
        }
        if (leftOperandType instanceof IRfClassType && rightOperandType instanceof IRfClassType && SemanticUtils.isLike(rightOperandType, leftOperandType)) {
            return;
        }
        boolean bl2 = isConstraint = operatorType == 138 || operatorType == 139;
        if (leftOperandType instanceof IRfClassType && rightOperandType instanceof IRfClassType && isConstraint && SemanticUtils.isLike(leftOperandType, rightOperandType)) {
            return;
        }
        if (!(leftOperandType instanceof RfStruct)) {
            boolean cfr_ignored_0 = leftOperandType instanceof RfEnumType;
        }
        if (!(rightOperandType instanceof RfStruct)) {
            boolean cfr_ignored_1 = rightOperandType instanceof RfEnumType;
        }
        if (ASSIGNMENT_COMPATIBLE_1.contains(leftOperandTypeName) && ASSIGNMENT_COMPATIBLE_1.contains(rightOperandTypeName)) {
            return;
        }
        if ("string".equals(leftOperandTypeName) && ("string".equals(rightOperandTypeName) || "null".equals(rightOperandTypeName))) {
            return;
        }
        project.addSemanticError(1, "UNEXPECTED_TYPE: Expression is of type ''{0}'', while expecting type ''{1}''", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, leftOperandTypeName, rightOperandTypeName);
    }

    private static void getBaseUnits(List<RfNamedElement> mul, List<String> leftUnitMul, List<String> leftUnitDiv) {
        for (RfNamedElement element : mul) {
            if (!SemanticUtils.valid(element) || !(element instanceof RfPredefinedType)) continue;
            String name = element.getName();
            if ("jerk".equals(name)) {
                leftUnitMul.add("distance");
                leftUnitDiv.add("time");
                leftUnitDiv.add("time");
                leftUnitDiv.add("time");
                continue;
            }
            if ("acceleration".equals(name)) {
                leftUnitMul.add("distance");
                leftUnitDiv.add("time");
                leftUnitDiv.add("time");
                continue;
            }
            if ("speed".equals(name)) {
                leftUnitMul.add("distance");
                leftUnitDiv.add("time");
                continue;
            }
            if ("angular_speed".equals(name)) {
                leftUnitMul.add("angle");
                leftUnitDiv.add("time");
                continue;
            }
            if ("angle".equals(name) || "distance".equals(name) || "temperature".equals(name) || "time".equals(name) || "weight".equals(name)) {
                leftUnitMul.add(name);
                continue;
            }
            if (!"null".equals(name)) continue;
            leftUnitMul.clear();
            leftUnitDiv.clear();
            leftUnitMul.add("null");
            return;
        }
    }

    public static RfNamedElement getUnitType(RfProject project, AST unitAST, ParserPath parserPath) {
        if (unitAST == null) {
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        String unitText = unitAST.getText();
        for (Map.Entry<String, Set<String>> entry : ALL_UNITS.entrySet()) {
            if (!entry.getValue().contains(unitText)) continue;
            return project.getPredefinedType(entry.getKey());
        }
        project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, unitAST.getOffset(), unitAST.getOffset() + unitText.length(), null, unitAST.getLine(), parserPath, unitText);
        return SemanticWalker.UNRESOLVED_ELEMENT;
    }

    public static RfNamedElement resolveLabelId(RfProject project, Determinant determinant, RfNamedElement currentScope, AST id, AST number, String implicitName, boolean isFirst, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (currentScope == null) {
            SemanticUtils.setTransientResult(id, SemanticWalker.UNRESOLVED_ELEMENT);
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        if (id == null) {
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        RfNamedElement result = null;
        if (result == null) {
            result = currentScope.getMember(determinant, implicitName, false, isFirst, MEMBER_VARIABLES, null);
        }
        if (result == null && isFirst && number == null) {
            result = currentScope.getMember(determinant, id.getText(), false, isFirst, MEMBER_VARIABLES, null);
        }
        if (result == null || !SemanticUtils.valid(result)) {
            if (parserPath != null) {
                if (isFirst) {
                    project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not declared", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
                } else {
                    project.addSemanticError(1, "UNDECLARED_IDENTIFIER: Identifier ''{0}'' is not a member of ''{1}''", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText(), currentScope.getName());
                }
            }
            result = SemanticWalker.UNRESOLVED_ELEMENT;
        }
        fileDef.createVariableDependency(project, result, id.getText());
        SemanticUtils.setTransientResult(id, result);
        return result;
    }

    public static RfNamedElement getPredefinedScenario(RfProject project, AST id, int fileIndex, ParserPath parserPath, RfFileDef fileDef) {
        if (id == null) {
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        RfStruct result = project.getPredefinedScenario(id.getText());
        if (result == null) {
            RfStruct topActor = project.getTopActor();
            RfNamedElement builtin = topActor.getTopActorMember(null, RfProject.FIELD_CLASSES, "builtin", null);
            if (builtin == null) {
                project.addSemanticError(1, "MISSING_BUILTIN_SCENARIO: Missing 'builtin' actor instance under top actor", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
                return SemanticWalker.UNRESOLVED_ELEMENT;
            }
            project.addSemanticError(1, "MISSING_BUILTIN_SCENARIO: Missing builtin scenario ''{0}'' declaration", null, id.getOffset(), id.getOffset() + id.getText().length(), null, id.getLine(), parserPath, id.getText());
            return SemanticWalker.UNRESOLVED_ELEMENT;
        }
        return result;
    }

    public static void checkIsArrayType(RfProject project, AST expAST, RfNamedElement namedElement, ParserPath parserPath) {
        if (expAST == null) {
            return;
        }
        if (namedElement instanceof RfArrayType) {
            return;
        }
        LineInfo lineInfo = SemanticUtils.getTreeLineInfo(expAST);
        if (lineInfo == null) {
            return;
        }
        project.addSemanticError(1, "NOT_AN_ARRAY: Expression must be of array type", null, lineInfo.realOffset, lineInfo.virtOffset, null, lineInfo.line, parserPath, new Object[0]);
    }
}

