/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.model.reflection.IRfNamedElement;

public class NoDuplicatesCollectionWrapper<T extends IRfNamedElement>
implements Collection<T> {
    private Collection<T> original;
    private Set<String> nameSet;

    public static <K extends IRfNamedElement> Collection<K> wrap(Collection<K> original) {
        if (original instanceof NoDuplicatesCollectionWrapper) {
            return original;
        }
        return new NoDuplicatesCollectionWrapper<K>(original);
    }

    private NoDuplicatesCollectionWrapper(Collection<T> original) {
        Assert.isNotNull(original);
        this.original = original;
        this.nameSet = new HashSet<String>();
    }

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof IRfNamedElement)) {
            return false;
        }
        if (this.nameSet.contains(((IRfNamedElement)o).getName())) {
            return this.original.contains(o);
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return this.original.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.original.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.original.toArray(a);
    }

    @Override
    public boolean add(T e) {
        if (this.nameSet.contains(e.getName())) {
            return false;
        }
        this.nameSet.add(e.getName());
        return this.original.add(e);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof IRfNamedElement)) {
            return false;
        }
        boolean result = this.original.remove(o);
        if (result) {
            this.nameSet.remove(((IRfNamedElement)o).getName());
        }
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.original.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        for (IRfNamedElement e : c) {
            this.add((T)e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        for (Object e : c) {
            this.remove(e);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.nameSet.clear();
        this.original.clear();
    }
}

