/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.model.reflection.util.MaxNofItemsReached;

public class NullProtectedList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private Set<String> fNamesSet;
    private int fMaxNofItems = -1;
    private MaxNofItemsReached fMaxNofItemsReached = null;

    public NullProtectedList(int i) {
        this(false, i);
    }

    public NullProtectedList() {
        this(false);
    }

    public void setMaxNofItems(int nofItems) {
        this.fMaxNofItems = nofItems;
        this.fMaxNofItemsReached = new MaxNofItemsReached();
    }

    public NullProtectedList(boolean checkDuplicateNamedElement) {
        if (checkDuplicateNamedElement) {
            this.fNamesSet = new HashSet<String>();
        }
    }

    public NullProtectedList(boolean checkDuplicateNamedElement, int i) {
        super(i);
        if (checkDuplicateNamedElement) {
            this.fNamesSet = new HashSet<String>();
        }
    }

    public NullProtectedList(Collection<E> values) {
        super(values);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            return false;
        }
        if (this.fMaxNofItemsReached != null && this.fMaxNofItems > 0 && this.size() >= this.fMaxNofItems) {
            throw this.fMaxNofItemsReached;
        }
        if (this.fNamesSet != null) {
            for (E e : c) {
                if (e == null) continue;
                this.fNamesSet.add(e.toString());
            }
        }
        if (this.fMaxNofItems > 0 && c.size() + this.size() > this.fMaxNofItems) {
            return super.addAll(new ArrayList<E>(c).subList(0, this.fMaxNofItems - this.size()));
        }
        return super.addAll(c);
    }

    public Set<String> getNamesTable() {
        return this.fNamesSet;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            return false;
        }
        if (this.fMaxNofItemsReached != null && this.fMaxNofItems > 0 && this.size() >= this.fMaxNofItems) {
            throw this.fMaxNofItemsReached;
        }
        if (this.fNamesSet != null) {
            this.fNamesSet.add(e.toString());
        }
        return super.add(e);
    }

    @Override
    public E remove(int index) {
        Object e = super.remove(index);
        if (this.fNamesSet != null && e != null) {
            this.fNamesSet.remove(e.toString());
        }
        return e;
    }

    @Override
    public boolean remove(Object o) {
        if (this.fNamesSet != null && o != null) {
            this.fNamesSet.remove(o.toString());
        }
        return super.remove(o);
    }

    public void addCheckAll(Collection<? extends E> elements) {
        if (elements == null) {
            return;
        }
        for (E e : elements) {
            if (e == null || this.contains(e)) continue;
            this.add(e);
        }
    }

    public void setNoDuplicateCheck() {
        this.fNamesSet = null;
    }

    public void addAllNoDuplicateNamedElement(Collection<? extends E> c) {
        if (c == null) {
            return;
        }
        if (this.fNamesSet == null) {
            Assert.isTrue((boolean)false, (String)"List does not support: addAllNoDuplicateNamedElement()");
        }
        for (E e : c) {
            if (e != null && this.fNamesSet.contains(e.toString())) continue;
            if (this.fMaxNofItemsReached != null && this.fMaxNofItems > 0 && this.size() >= this.fMaxNofItems) {
                throw this.fMaxNofItemsReached;
            }
            if (e != null) {
                this.fNamesSet.add(e.toString());
            }
            super.add(e);
        }
    }

    public E lastElement() {
        return this.get(this.size() - 1);
    }
}

