/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.util;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfMembersContainer;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;

public class RfEnclosingScopeUtils {
    public static String getScopeInfo(IProject project, ParserPath parserPath, int offset) {
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
        if (fileDef == null) {
            return null;
        }
        RfDefElement scope = fileDef.getScope(offset);
        RfNamedElement namedElement = scope.getNamedElement();
        while (namedElement != null && (!(namedElement instanceof RfMembersContainer) || namedElement.isAnonymous())) {
            namedElement = namedElement.getEnclosingScope();
        }
        if (namedElement != null) {
            String text = namedElement.getName();
            if (text == null) {
                return null;
            }
            String kindName = namedElement.getKindName();
            if (kindName != null && !kindName.isEmpty()) {
                text = String.valueOf(kindName) + ": " + text;
            }
            return " [" + text + "]";
        }
        return null;
    }
}

