/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.util;

import java.io.Serializable;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.msdldt.model.reflection.BlockKind;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfLibrary;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;

public class RfNameTypeScopeHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fElementName;
    private int fElementKind = 0;

    public RfNameTypeScopeHelper(IRfNamedElement element) {
        if (element instanceof RfPackage) {
            this.fElementKind = 512;
        } else if (element instanceof RfLibrary) {
            this.fElementKind = 1024;
        } else if (element instanceof RfStruct) {
            this.fElementKind = 64;
        } else if (element instanceof RfMethod) {
            this.fElementKind = 4;
        } else if (element instanceof RfBlock && ((RfBlock)element).getBlockKind() == BlockKind.CONSTRAINT) {
            this.fElementKind = 4096;
        } else if (element instanceof RfBlock) {
            this.fElementKind = 32;
        } else if (element instanceof RfEnumType) {
            this.fElementKind = 2048;
        } else if (element instanceof RfTypeAlias) {
            this.fElementKind = 8;
        } else if (!(element instanceof RfNamedElement)) {
            this.fElementKind = 16384;
        } else {
            return;
        }
        this.fElementName = element.getName();
    }

    public RfNameTypeScopeHelper(int kind, String name) {
        this.fElementKind = kind;
        this.fElementName = name;
    }

    public String getElementName() {
        return this.fElementName;
    }

    public int getElementKind() {
        return this.fElementKind;
    }

    public boolean equals(Object obj) {
        boolean nameAndTypeCompare;
        if (obj == null || !(obj instanceof RfNameTypeScopeHelper)) {
            return false;
        }
        RfNameTypeScopeHelper elem = (RfNameTypeScopeHelper)obj;
        if (this.fElementName == null && elem.fElementName == null) {
            return this.fElementKind == elem.fElementKind;
        }
        if (this.fElementName == null) {
            return false;
        }
        boolean bl = nameAndTypeCompare = this.fElementName.equals(elem.fElementName) && this.fElementKind == elem.fElementKind;
        return nameAndTypeCompare;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setElementName(String elementName) {
        this.fElementName = elementName;
    }
}

