/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.msdldt.model.reflection.IRfScope;
import ro.amiq.msdldt.model.reflection.RfAssociatedType;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfKind;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.StructKind;
import ro.amiq.msdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.msdldt.ui.editor.MSDLWordFinder;
import ro.amiq.msdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.msdldt.utils.MSDLFileUtils;

public class RfUtils {
    private static RfElementCache fRfElementCache = new RfElementCache();

    public static List<RfNamedElementActionHyperlink> getEntityAndArchitectureHyperlinks(IProject project, RfWNamedElementAndScope elementAndScope, IRegion hyperlinkRegion) {
        return Collections.emptyList();
    }

    public static RfNamedElementActionHyperlink getAssociatedTypeHyperlink(IProject project, IRfNamedElement namedElement, IRegion hyperlinkRegion) {
        RfNamedElement associatedType;
        block4: {
            if (!(namedElement instanceof RfAssociatedType)) {
                return null;
            }
            try {
                associatedType = ((RfAssociatedType)namedElement).getAssociatedType();
                if (associatedType != null && !associatedType.isPredefined()) break block4;
                return null;
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
                return null;
            }
        }
        return RfUtils.createOpenAction(associatedType, project, hyperlinkRegion);
    }

    public static String getAssociatedTypeHyperlinkLabelPart(IRfNamedElement element) {
        RfKind kind = RfKind.of(element);
        return DVTStringUtil.toTitleCase((String)kind.getName());
    }

    public static String getCrossLanguageHyperlinkLabelPart(IRfNamedElement element) {
        if (!(element instanceof IRfDesignElement)) {
            return "";
        }
        return "";
    }

    public static List<RfNamedElementActionHyperlink> getPossibleEntitiesAndArchitecturesHyperlinks(ITextEditor editor, IProject project, IDocument document, int offset) {
        return Collections.emptyList();
    }

    public static RfNamedElementActionHyperlink getCustomRfNamedElementActionHyperlink(ITextEditor editor, IProject project, IDocument document, int offset) {
        block3: {
            RfNamedElementActionHyperlink hyperlinkAction;
            block4: {
                IRegion hyperlinkRegion;
                IRfScope scope;
                RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(editor, document, offset);
                if (elementAndScope == null || elementAndScope.getIRfNamedElement() == null || elementAndScope.getIRfNamedElement().isPredefined()) break block3;
                IRfNamedElement element = elementAndScope.getIRfNamedElement();
                hyperlinkAction = RfUtils.getRfNamedElementActionHyperlink(project, element, scope = elementAndScope.getScope(), hyperlinkRegion = MSDLWordFinder.getDefault().getWordAtOffset(document, offset));
                if (hyperlinkAction != null) break block4;
                return null;
            }
            try {
                return hyperlinkAction;
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
            }
        }
        return null;
    }

    public static RfNamedElementActionHyperlink getRfNamedElementActionHyperlink(IProject project, IRfNamedElement namedElement, IRfScope elementScope, IRegion hyperlinkRegion) {
        RfNamedElementActionHyperlink hyperlink;
        block3: {
            try {
                hyperlink = RfUtils.createOpenAction(namedElement, project, hyperlinkRegion);
                if (hyperlink != null) break block3;
                return null;
            }
            catch (Exception x) {
                DVTLogger.INSTANCE.logError((Throwable)x);
                return null;
            }
        }
        hyperlink.setScope(elementScope);
        return hyperlink;
    }

    public static RfWNamedElementAndScope getRfElement(ITextEditor textEditor, IDocument document, int offset) {
        IFile file;
        block9: {
            IEditorInput editorInput;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (textEditor != null) break block6;
                            return null;
                        }
                        catch (Exception x) {
                            DVTLogger.INSTANCE.logError((Throwable)x);
                            return null;
                        }
                    }
                    if (document != null) break block7;
                    return null;
                }
                editorInput = textEditor.getEditorInput();
                if (editorInput != null) break block8;
                return null;
            }
            file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) break block9;
            return null;
        }
        return RfUtils.getRfElement(file, document, offset);
    }

    public static List<RfWNamedElementAndScope> getRfElements(ITextEditor textEditor, IDocument document, int offset) {
        IFile file;
        block9: {
            IEditorInput editorInput;
            block8: {
                block7: {
                    block6: {
                        try {
                            if (textEditor != null) break block6;
                            return null;
                        }
                        catch (Exception x) {
                            DVTLogger.INSTANCE.logError((Throwable)x);
                            return null;
                        }
                    }
                    if (document != null) break block7;
                    return null;
                }
                editorInput = textEditor.getEditorInput();
                if (editorInput != null) break block8;
                return null;
            }
            file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) break block9;
            return null;
        }
        return RfUtils.getRfElements(file, document, offset);
    }

    public static void clearCaches() {
        fRfElementCache = new RfElementCache();
    }

    public static RfWNamedElementAndScope getRfElement(IFile file, IDocument document, int offset) {
        IRegion region;
        List<RfWNamedElementAndScope> elements;
        block6: {
            block5: {
                try {
                    elements = RfUtils.internalComputeElements(file, document, offset);
                    if (elements != null && !elements.isEmpty()) break block5;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            region = MSDLWordFinder.getDefault().getWordAtOffset(document, offset);
            if (region != null && region.getLength() != 0) break block6;
            return null;
        }
        RfWNamedElementAndScope element = elements.get(0);
        if (elements.size() == 1) {
            fRfElementCache.putCacheElement(region, element);
        }
        return element;
    }

    private static List<RfWNamedElementAndScope> internalComputeElements(IFile file, IDocument document, int offset) {
        RfNamedElement assocType;
        RfFileDef.IdentifierPosition candidate;
        RfDefElement rfScope;
        block12: {
            RfFileDef rfFileDef;
            block11: {
                RfProject rfProject;
                block10: {
                    block9: {
                        try {
                            if (file != null && document != null && offset >= 0 && offset <= document.getLength()) break block9;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    rfProject = RfManager.getInstance().getRfProject(file.getProject());
                    if (rfProject != null) break block10;
                    return null;
                }
                rfFileDef = rfProject.getFile((IResource)file);
                if (rfFileDef != null) break block11;
                return null;
            }
            rfScope = rfFileDef.getScope(offset);
            IRegion region = MSDLWordFinder.getDefault().getWordAtOffset(document, offset);
            fRfElementCache.setDocument(document);
            RfWNamedElementAndScope cachedElement = fRfElementCache.getCacheElement(region);
            if (cachedElement != null) {
                return Arrays.asList(cachedElement);
            }
            String text = document.get(region.getOffset(), region.getLength());
            if (text.endsWith("$")) {
                text = text.substring(0, text.length() - 1);
                --offset;
            }
            if ((candidate = rfFileDef.getIdentifier(text, offset)) != null) break block12;
            return null;
        }
        RfNamedElement namedElement = candidate.getNamedElement();
        if (candidate.getIdAst() != null && candidate.getIdAst().getType() != 144 && namedElement instanceof RfField && (assocType = ((RfField)namedElement).getAssociatedType()) instanceof RfStruct && (((RfStruct)assocType).getStructKind() == StructKind.SCENARIO || ((RfStruct)assocType).getStructKind() == StructKind.MODIFIER)) {
            namedElement = assocType;
        }
        return Collections.singletonList(new RfWNamedElementAndScope(namedElement, rfScope));
    }

    public static List<RfWNamedElementAndScope> getRfElements(IFile file, IDocument document, int offset) {
        List<RfWNamedElementAndScope> elements = RfUtils.internalComputeElements(file, document, offset);
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return elements;
    }

    public static IRfScope getRfScope(ITextEditor textEditor, IDocument document, int offset) {
        RfProject rfProject;
        IFile file;
        block12: {
            block11: {
                IEditorInput editorInput;
                block10: {
                    block9: {
                        block8: {
                            if (textEditor != null) break block8;
                            return null;
                        }
                        if (document != null) break block9;
                        return null;
                    }
                    editorInput = textEditor.getEditorInput();
                    if (editorInput != null) break block10;
                    return null;
                }
                file = (IFile)editorInput.getAdapter(IFile.class);
                if (file != null) break block11;
                return null;
            }
            rfProject = RfManager.getInstance().getRfProject(file.getProject());
            if (rfProject != null) break block12;
            return null;
        }
        try {
            RfFileDef rfFileDef = rfProject.getFile((IResource)file);
            if (rfFileDef != null) {
                return rfFileDef.getScope(offset);
            }
        }
        catch (Exception x) {
            DVTLogger.INSTANCE.logError((Throwable)x);
        }
        return null;
    }

    public static RfNamedElementActionHyperlink createOpenAction(final IRfNamedElement namedElement, final IProject project, IRegion region) {
        if (!DVTPlugin.getDefault().collect().c(project, "F73646C")) {
            return null;
        }
        if (namedElement == null || namedElement.isPredefined()) {
            return null;
        }
        IRfDefElement declaration = namedElement.getDeclaration();
        if (declaration == null) {
            return null;
        }
        IRfFileDef rfFileDef = declaration.getDefFile();
        if (rfFileDef == null) {
            return null;
        }
        final ParserPath parserPath = rfFileDef.getParserPath();
        final int line = declaration.getStartLine();
        Action action = new Action(){

            public void run() {
                MSDLFileUtils.getInstance().openFile(project, parserPath.path, line, namedElement.getName());
            }
        };
        return new RfNamedElementActionHyperlink(project, namedElement, region, (IAction)action);
    }

    public static RfNamedElementActionHyperlink createOpenAction(final RfDefElement defElement, final IProject project, IRegion region) {
        if (!DVTPlugin.getDefault().collect().c(project, "F73646C")) {
            return null;
        }
        if (defElement == null) {
            return null;
        }
        RfFileDef rfFileDef = defElement.getDefFile();
        if (rfFileDef == null) {
            return null;
        }
        final ParserPath parserPath = rfFileDef.getParserPath();
        final int line = defElement.getStartLine();
        Action action = new Action(){

            public void run() {
                MSDLFileUtils.getInstance().openFile(project, parserPath.path, line, defElement.getName());
            }
        };
        return new RfNamedElementActionHyperlink(project, defElement.getNamedElement(), region, (IAction)action);
    }

    public static ITypedRegion getTypedRegion(IDocument document, int offset) {
        block3: {
            try {
                if (offset >= 0) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        IDocumentExtension3 extension3 = (IDocumentExtension3)document;
        return extension3.getPartition("__msdl_partitioning", offset, false);
    }

    public static void getTooltipFormattedText(IRfNamedElement candidate, DVTTooltipContent tooltipContent) {
        if (candidate == null) {
            return;
        }
        String signature = candidate.getSignature();
        if (signature != null) {
            tooltipContent.set(DVTTooltipContent.TooltipContent.SIGNATURE, "<b>" + DVTStringUtil.partiallyEscapeHTML((String)signature) + "</b>");
            tooltipContent.set(DVTTooltipContent.TooltipContent.COMMENT, "<br>" + DVTStringUtil.partiallyEscapeHTML((String)candidate.getComment()));
        }
    }

    private static class RfElementCache {
        private IDocument fDocument;
        private RfWNamedElementAndScope fCachedElement;
        private IRegion fCachedRegion;
        private long fTimestamp;

        private RfElementCache() {
        }

        public void setDocument(IDocument document) {
            if (document == this.fDocument) {
                return;
            }
            this.fDocument = document;
            this.fCachedRegion = null;
            this.fCachedElement = null;
            this.fTimestamp = 0L;
        }

        public RfWNamedElementAndScope getCacheElement(IRegion region) {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                try {
                                    if (region != null && this.fCachedRegion != null) break block7;
                                    return null;
                                }
                                catch (Exception exception) {
                                    return null;
                                }
                            }
                            if (this.fCachedElement != null) break block8;
                            return null;
                        }
                        if (region.getLength() != 0) break block9;
                        return null;
                    }
                    if (region.equals(this.fCachedRegion)) break block10;
                    return null;
                }
                long oldTimestamp = this.fTimestamp;
                this.fTimestamp = System.currentTimeMillis();
                if (this.fTimestamp - oldTimestamp <= 200L) break block11;
                return null;
            }
            return new RfWNamedElementAndScope(this.fCachedElement);
        }

        public void putCacheElement(IRegion region, RfWNamedElementAndScope element) {
            this.fCachedElement = new RfWNamedElementAndScope(element);
            this.fCachedRegion = region;
            this.fTimestamp = System.currentTimeMillis();
        }
    }
}

