/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.views;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.views.MSDLLabelProvider;
import ro.amiq.msdldt.model.reflection.views.MSDLLanguageElement;
import ro.amiq.msdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.msdldt.model.reflection.views.TypesViewLabelProvider;

public class CoverageViewLabelProvider
extends MSDLLabelProvider {
    private TypesViewLabelProvider fTypesViewLabelProvider = new TypesViewLabelProvider();

    public Image getColumnImage(Object element, int columnIndex) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)element);
        Object rfElement = rfWrapper.getRfElement();
        if (rfElement instanceof MSDLLanguageElement && columnIndex == 0) {
            return DVTImages.imageCache.getImage(DVTImages.SDL_LANGUAGE);
        }
        Image result = null;
        if (rfElement instanceof String || columnIndex == 1) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (rfElement instanceof RfNamedElement) {
            result = ((RfNamedElement)rfElement).getImage();
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!rfWrapper.getOverlayStatus()) {
            return result;
        }
        if (this.fDecorator != null) {
            result = this.fDecorator.decorateImage(result, element);
        }
        if (result == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        return result;
    }

    public String getColumnText(Object wrapper, int columnIndex) {
        Object element;
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)wrapper);
        if (rfWrapper.getAdditionalInfo(IDVTElementWrapper.Attribute.MATCH) != null && columnIndex == 0) {
            this.setBoldFont(rfWrapper);
        }
        if ((element = rfWrapper.getRfElement()) instanceof MSDLLanguageElement && columnIndex == 0) {
            return (String)((MSDLLanguageElement)((Object)element)).getInfo();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof RfCovergroup) {
            RfCovergroup rfCovergroup = (RfCovergroup)element;
            if (columnIndex == 0) {
                return rfCovergroup.getName();
            }
            return ViewsUtils.trimText((String)rfCovergroup.getComment(), (int)100, (boolean)true);
        }
        if (element instanceof RfField && ((RfField)element).getFieldModifier() == FieldModifier.COVERPOINT) {
            RfField rfCoverpoint = (RfField)element;
            if (columnIndex == 0) {
                return rfCoverpoint.getName();
            }
            return ViewsUtils.trimText((String)rfCoverpoint.getComment(), (int)100, (boolean)true);
        }
        if (element instanceof RfField) {
            RfField rfField = (RfField)element;
            if (columnIndex == 0) {
                return rfField.getName();
            }
            return ViewsUtils.trimText((String)rfField.getComment(), (int)100, (boolean)true);
        }
        if (element instanceof RfNamedElement && columnIndex == 0) {
            return this.fTypesViewLabelProvider.getText(wrapper);
        }
        return null;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object object) {
        String result = this.getColumnText(object, 0);
        if (result == null) {
            return "";
        }
        return result;
    }

    public String getTextForSearch(Object element) {
        StringBuilder result = new StringBuilder();
        result.append(this.getColumnText(element, 0)).append(" ").append(this.getColumnText(element, 1));
        return result.toString();
    }
}

