/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.BaseInspectViewContributor;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.FileCompileInfo;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.util.RfUtils;
import ro.amiq.msdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.msdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.msdldt.parser.MSDLFileInstance;
import ro.amiq.msdldt.parser.MSDLFileInstancesMap;
import ro.amiq.msdldt.ui.editor.MSDLDocumentSetupParticipant;
import ro.amiq.msdldt.ui.editor.MSDLEditor;
import ro.amiq.msdldt.ui.editor.MSDLSourceViewerConfiguration;

public class MSDLInspectViewContributor
extends BaseInspectViewContributor {
    private static final MSDLDocumentSetupParticipant MSDL_DOCUMENT_SETUP_PARTICIPANT = new MSDLDocumentSetupParticipant();
    private static final HashSet<Character> possibleCharacters = new HashSet<Character>(Arrays.asList(Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('\''), Character.valueOf('.'), Character.valueOf('B'), Character.valueOf('S'), Character.valueOf('X'), Character.valueOf('O'), Character.valueOf('D'), Character.valueOf('U'), Character.valueOf('\"'), Character.valueOf('_'), Character.valueOf('\''), Character.valueOf('#')));

    public void updatePreviewer(DVTPreviewSourceViewer previewViewer, final IHyperlinkDetector hyperlinkDetector, boolean disableHighlight) {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(() -> {
            MSDLSourceViewerConfiguration configuration = new MSDLSourceViewerConfiguration(null){

                @Override
                public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
                    return new IHyperlinkDetector[]{hyperlinkDetector};
                }

                protected boolean isInspectView() {
                    return true;
                }

                public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
                    return 0;
                }
            };
            previewViewer.unconfigure();
            previewViewer.setEditable(false);
            previewViewer.setPreferenceStore(MSDLPlugin.getDefault().getCombinedPreferenceStore());
            previewViewer.configure((SourceViewerConfiguration)configuration);
            previewViewer.setDocument((IDocument)new Document());
            if (!disableHighlight) {
                MSDL_DOCUMENT_SETUP_PARTICIPANT.setup(previewViewer.getDocument());
            }
        });
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.MSDL;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursorOffset) {
        IDocument document;
        RfProject rfProject;
        IProject project;
        IFile file;
        block15: {
            IDocumentProvider documentProvider;
            IEditorInput editorInput;
            block14: {
                MSDLEditor pssEditor;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    try {
                                        if (editor instanceof MSDLEditor) break block9;
                                        return null;
                                    }
                                    catch (Exception e) {
                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                        return null;
                                    }
                                }
                                pssEditor = (MSDLEditor)editor;
                                editorInput = pssEditor.getEditorInput();
                                if (editorInput != null) break block10;
                                return null;
                            }
                            file = (IFile)editorInput.getAdapter(IFile.class);
                            if (file != null) break block11;
                            return null;
                        }
                        project = file.getProject();
                        if (project != null) break block12;
                        return null;
                    }
                    rfProject = RfManager.getInstance().getRfProject(project);
                    if (rfProject != null) break block13;
                    return null;
                }
                documentProvider = pssEditor.getDocumentProvider();
                if (documentProvider != null) break block14;
                return null;
            }
            document = documentProvider.getDocument((Object)editorInput);
            if (document != null) break block15;
            return null;
        }
        cursorOffset = cursorOffset >= document.getLength() ? document.getLength() - 1 : cursorOffset;
        List<Object> object = Arrays.asList(file, rfProject, document);
        return new InspectViewUpdateEvent(object, LanguageKind.MSDL, cursorOffset, null, project, InspectViewUpdateEventCommon.TYPE.PRELIMINARY_EDITOR);
    }

    public InspectViewUpdateEvent createEventFromPreliminary(InspectViewUpdateEvent preliminaryEvent) {
        IDocument document;
        RfProject rfProject;
        IFile file;
        int cursorOffset;
        block8: {
            Object preliminaryEventElement;
            block7: {
                try {
                    preliminaryEventElement = preliminaryEvent.getElement();
                    if (preliminaryEventElement instanceof List) break block7;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            List preliminaryData = (List)preliminaryEventElement;
            cursorOffset = preliminaryEvent.getCallOffset();
            file = (IFile)preliminaryData.get(0);
            rfProject = (RfProject)preliminaryData.get(1);
            document = (IDocument)preliminaryData.get(2);
            if (file != null && rfProject != null && document != null) break block8;
            return null;
        }
        IRfNamedElement element = null;
        RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement(file, document, cursorOffset);
        if (elementAndScope == null || elementAndScope.getIRfNamedElement() == null) {
            String number = this.findNumberAtOffset(cursorOffset, document);
            if (number != null) {
                number = number.replace("_", "");
                return new InspectViewUpdateEvent((Object)number, LanguageKind.MSDL, cursorOffset, rfProject.getFile((IResource)file).getParserPath().path, file.getProject(), InspectViewUpdateEventCommon.TYPE.NUMBER);
            }
        } else {
            element = elementAndScope.getIRfNamedElement();
        }
        InspectViewUpdateEvent returnEvent = null;
        returnEvent = element == null ? new InspectViewUpdateEvent(file, InspectViewUpdateEventCommon.TYPE.FILE) : new InspectViewUpdateEvent((Object)element, element.getLanguageKind(), cursorOffset, null, rfProject.getProject(), InspectViewUpdateEventCommon.TYPE.EDITOR);
        return returnEvent;
    }

    /*
     * Unable to fully structure code
     */
    private String findNumberAtOffset(int cursorOffset, IDocument document) throws BadLocationException {
        numberAtOffset = new StringBuilder();
        if (cursorOffset >= 0 && cursorOffset < document.getLength()) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            --cursorOffset;
lbl5:
            // 2 sources

            ** while (cursorOffset >= 0 && (document.getChar((int)cursorOffset) == '\n' || document.getChar((int)cursorOffset) == '\t' || document.getChar((int)cursorOffset) == ' '))
        }
lbl6:
        // 1 sources

        if (cursorOffset < 0) {
            return null;
        }
        endPosition = cursorOffset;
        start = '\u0000';
        end = '\u0000';
        for (startingPosition = cursorOffset; startingPosition >= 0; --startingPosition) {
            start = TextUtils.getChar((IDocument)document, (int)startingPosition);
            document.getChar(startingPosition);
            if (MSDLInspectViewContributor.possibleCharacters.contains(Character.valueOf(start))) continue;
        }
        while (endPosition < document.getLength()) {
            end = document.getChar(endPosition);
            ++endPosition;
            if (MSDLInspectViewContributor.possibleCharacters.contains(Character.valueOf(end))) continue;
        }
        index = startingPosition + 2;
        while (index <= endPosition - 2) {
            temp = document.getChar(index);
            numberAtOffset.append(temp);
            ++index;
        }
        return numberAtOffset.length() > 0 ? numberAtOffset.toString() : null;
    }

    public InspectViewInput getInput(InspectViewUpdateEvent event) {
        InspectViewInput result;
        block9: {
            IProject iProject;
            block8: {
                block7: {
                    block6: {
                        result = null;
                        if (event.getLanguage().equals((Object)LanguageKind.MSDL)) break block6;
                        return null;
                    }
                    iProject = event.getProject();
                    if (iProject != null && iProject.isAccessible() && iProject.hasNature("ro.amiq.msdldt.msdlnature")) break block7;
                    return null;
                }
                if (DVTPlugin.getDefault().collect().c(iProject, "F73646C")) break block8;
                return null;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(iProject);
            if (rfProject != null) break block9;
            return null;
        }
        try {
            result = this.getInspectContent(event);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private InspectViewInput getInspectContent(InspectViewUpdateEvent event) {
        if (event.hasInfos()) {
            return this.getInspectFromDiagram(event);
        }
        IProject project = event.getProject();
        Object selectedElement = event.getElement();
        if (event.getType() == InspectViewUpdateEventCommon.TYPE.WRAPPER && selectedElement instanceof IDVTElementWrapper) {
            selectedElement = ((IDVTElementWrapper)selectedElement).getRfElement();
        }
        if (selectedElement instanceof IRfNamedElement) {
            IRfNamedElement element = (IRfNamedElement)selectedElement;
            return MSDLInspectViewContributor.processNamedElement(project, element);
        }
        if (selectedElement instanceof IRfDefElement) {
            IRfDefElement def = (IRfDefElement)selectedElement;
            return MSDLInspectViewContributor.processDefElement(project, def);
        }
        return null;
    }

    public static InspectViewInput processNamedElement(IProject project, IRfNamedElement element) {
        IRfDefElement declaration = element.getDeclaration();
        return MSDLInspectViewContributor.processDefElement(project, declaration);
    }

    private static InspectViewInput processDefElement(IProject project, IRfDefElement declaration) {
        if (!(declaration instanceof RfDefElement)) {
            return null;
        }
        return DVTInspectViewUtils.getInstance().processDefElement(project, declaration, "//", null, 0, null);
    }

    public FileCompileInfo getCompileInfo(IFile iFile) {
        if (iFile == null) {
            return null;
        }
        if (iFile.getProject() == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(iFile.getProject());
        if (rfProject == null) {
            return null;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)iFile);
        if (parserPath == null) {
            return null;
        }
        MSDLFileInstancesMap fileInstancesMap = rfProject.getFileInstancesMap();
        if (fileInstancesMap == null) {
            return null;
        }
        List<MSDLFileInstance> fileInstances = fileInstancesMap.getFileInstances(parserPath);
        if (fileInstances == null || fileInstances.isEmpty()) {
            return null;
        }
        ArrayList<Integer> compileIndices = new ArrayList<Integer>();
        ArrayList<IBuildConfigParserConstants.LanguageSyntax> languageSyntaxes = new ArrayList<IBuildConfigParserConstants.LanguageSyntax>();
        for (MSDLFileInstance fileInstance : fileInstances) {
            if (fileInstance.getIndex() < 0) continue;
            compileIndices.add(fileInstance.getIndex());
            languageSyntaxes.add(fileInstance.getLanguageSyntax());
        }
        return compileIndices.isEmpty() ? null : new FileCompileInfo(compileIndices, languageSyntaxes);
    }
}

