/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.views;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.ui.views.ISearchContributor;
import ro.amiq.msdldt.model.IMSDLModel;
import ro.amiq.msdldt.model.MSDLModelManager;
import ro.amiq.msdldt.model.reflection.RfLibrary;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.util.RfEnclosingScopeUtils;
import ro.amiq.msdldt.ui.editor.MSDLDocumentSetupParticipant;
import ro.amiq.msdldt.utils.Utils;

public class MSDLSearchContributor
implements ISearchContributor {
    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature("ro.amiq.msdldt.msdlnature");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getNature() {
        return "ro.amiq.msdldt.msdlnature";
    }

    public boolean isInstantiable(IRfNamedElement element) {
        return false;
    }

    public String getScopeInfo(IProject project, ParserPath parserPath, int line, int offset) {
        return RfEnclosingScopeUtils.getScopeInfo(project, parserPath, offset);
    }

    public IRfNamedElement getElementFromString(IProject project, String elementString) {
        RfProject rfProject = Utils.getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        String string = elementString.replace(".", " ").replace("::", " ");
        String[] firstAndRest = RfElementPath.SPLIT_PATTERN.split(string, 2);
        RfLibrary library = rfProject.getLibraryWithPrefix(firstAndRest[0], 1);
        if (library != null) {
            if (firstAndRest.length == 1 || firstAndRest[1].isEmpty()) {
                return library;
            }
            return RfElementPath.fromString((String)this.getNature().concat(" ").concat(library.getName()).concat(" ").concat(firstAndRest[1])).toNamedElement(project);
        }
        for (RfLibrary libraryCandidate : rfProject.getLibraries()) {
            String libraryCandidateSegment = String.valueOf(libraryCandidate.getName()) + " ";
            String[] firstSecondAndRest = RfElementPath.SPLIT_PATTERN.split(string, 2);
            IRfNamedElement existingPackage = rfProject.getLocalMember(null, firstSecondAndRest[0], null);
            if (existingPackage != null) {
                if (firstSecondAndRest.length == 2 || firstAndRest[2].isEmpty()) {
                    return existingPackage;
                }
                return RfElementPath.fromString((String)this.getNature().concat(" ").concat(libraryCandidateSegment).concat(firstSecondAndRest[1]).concat(" ").concat(firstSecondAndRest[2])).toNamedElement(project);
            }
            Collection<RfNamedElement> pkgs = rfProject.getLocalMembers();
            if (pkgs == null || pkgs.isEmpty()) continue;
            for (RfNamedElement pkg : pkgs) {
                String pkgCandidateSegment = String.valueOf(pkg.getName()) + " ";
                IRfNamedElement result = RfElementPath.fromString((String)(String.valueOf(this.getNature()) + " " + libraryCandidateSegment + pkgCandidateSegment + string)).toNamedElement(project);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void installPartitionerForFile(IDocument document) {
        MSDLDocumentSetupParticipant setupParticipant = new MSDLDocumentSetupParticipant();
        setupParticipant.setup(document);
    }

    public boolean hasValidPartitioner(IDocument document) {
        try {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            IDocumentPartitioner partitioner = extension3.getDocumentPartitioner("__msdl_partitioning");
            if (partitioner != null) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean validContentType(IDocument document, int index) {
        block12: {
            String[] partitionings;
            block11: {
                block10: {
                    block9: {
                        if (index < document.getLength()) break block9;
                        return false;
                    }
                    if (index != -1) break block10;
                    return false;
                }
                partitionings = ((IDocumentExtension3)document).getPartitionings();
                if (partitionings != null) break block11;
                return false;
            }
            boolean hasPartition = false;
            String[] stringArray = partitionings;
            int n = partitionings.length;
            int n2 = 0;
            while (n2 < n) {
                String partitioning = stringArray[n2];
                if (partitioning.equals("__msdl_partitioning")) {
                    hasPartition = true;
                    break;
                }
                ++n2;
            }
            if (hasPartition) break block12;
            return false;
        }
        try {
            String contentType = ((IDocumentExtension3)document).getContentType("__msdl_partitioning", index, false);
            return contentType.equals("__dftl_partition_content_type");
        }
        catch (BadLocationException badLocationException) {
            throw new IndexOutOfBoundsException();
        }
        catch (BadPartitioningException badPartitioningException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public IDVTFile getIDVTFile(IFile file) {
        IMSDLModel msdlModel = MSDLModelManager.getInstance().getMSDLModel();
        if (msdlModel == null) {
            return null;
        }
        return msdlModel.getMSDLFile(file);
    }
}

