/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.IDVTEditor;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.typehierarchy.GotoDataContainer;
import ro.amiq.dvt.ui.views.typehierarchy.ITHViewContributor;
import ro.amiq.dvt.ui.views.typehierarchy.THViewInput;
import ro.amiq.dvt.ui.views.typehierarchy.THViewInputConfigurator;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.msdldt.model.reflection.BlockKind;
import ro.amiq.msdldt.model.reflection.IRfClassType;
import ro.amiq.msdldt.model.reflection.IRfScope;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfDummyElement;
import ro.amiq.msdldt.model.reflection.RfExtendDuplicate;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfScopeUtil;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.semantic.SemanticUtils;
import ro.amiq.msdldt.model.reflection.util.NullProtectedList;
import ro.amiq.msdldt.model.reflection.util.RfNameTypeScopeHelper;
import ro.amiq.msdldt.model.reflection.util.RfUtils;
import ro.amiq.msdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.msdldt.model.reflection.views.MSDLQuickViewersUtil;
import ro.amiq.msdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.msdldt.model.reflection.views.THViewLabelProvider;
import ro.amiq.msdldt.ui.editor.MSDLEditor;
import ro.amiq.msdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class MSDLTHViewContributor
implements ITHViewContributor {
    private static final Comparator<IRfClassType> CLASS_INTERFACE_COMPARATOR = new Comparator<IRfClassType>(){

        @Override
        public int compare(IRfClassType c1, IRfClassType c2) {
            return c1.getName().compareTo(c2.getName());
        }
    };
    private THViewLabelProvider fLabelProvider = new THViewLabelProvider();
    private boolean fHasGUIFilteredMembers;

    public LanguageKind getLanguageKind() {
        return LanguageKind.MSDL;
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        return this.fLabelProvider;
    }

    public String getComment(Object wrapper) {
        RfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement == null ? "" : DVTStringUtil.replaceAll((Pattern)DVTStringUtil.NEW_LINE, (CharSequence)namedElement.getComment(), (String)" ");
    }

    private RfNamedElement getNamedElement(Object wrapper) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        if (!(((RfTreeElementWrapper)((Object)wrapper)).getRfElement() instanceof RfNamedElement)) {
            return null;
        }
        return (RfNamedElement)((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
    }

    public RfNamedElementActionHyperlink getActionHiperlink(IProject project, Object dataContainer) {
        if (!(dataContainer instanceof GotoDataContainer)) {
            return null;
        }
        GotoDataContainer gtContainer = (GotoDataContainer)dataContainer;
        IDVTElementWrapper wrapper = gtContainer.getWrapper();
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return null;
        }
        Object element = ((RfTreeElementWrapper)wrapper).getRfElement();
        if (element == null) {
            return null;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfDefElement) {
            element = ((RfDefElement)element).getNamedElement();
        }
        if (element instanceof RfNamedElement) {
            actionHyperlink = RfUtils.createOpenAction((RfNamedElement)element, project, null);
        }
        return actionHyperlink;
    }

    public void gotoElement(IProject project, Object dataContainer) {
        RfNamedElementActionHyperlink actionHyperlink = this.getActionHiperlink(project, dataContainer);
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (!(rfElement instanceof RfNamedElement)) {
            return false;
        }
        if (matcher != null) {
            return ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(element));
        }
        if (referenceData instanceof UpdateViewEvent) {
            UpdateViewEvent event = (UpdateViewEvent)referenceData;
            if (!(rfElement instanceof RfStruct)) {
                return false;
            }
            IRfClassType classType = (IRfClassType)rfElement;
            IRfClassType eventClassType = this.getClazz(event);
            if (eventClassType == null) {
                return false;
            }
            return classType.getName().equals(eventClassType.getName());
        }
        if (referenceData instanceof RfTreeElementWrapper) {
            RfTreeElementWrapper rfWrapper = (RfTreeElementWrapper)((Object)referenceData);
            Object refElement = rfWrapper.getRfElement();
            if (!(rfElement instanceof RfStruct)) {
                return false;
            }
            if (!(refElement instanceof RfStruct)) {
                return false;
            }
            IRfClassType clazz = (IRfClassType)rfElement;
            IRfClassType refClazz = (IRfClassType)refElement;
            return clazz.getName().equals(refClazz.getName());
        }
        return true;
    }

    private IRfClassType getClazz(UpdateViewEvent event) {
        IProject project = Utils.getProject((String)event.getProjectName());
        if (!project.isAccessible()) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return this.getClassType(rfProject, event.getElementName(), (List)event.getElementScope());
    }

    private IRfClassType getClassType(RfProject project, String elementName, List<RfNameTypeScopeHelper> elementScope) {
        IRfScopeElement scope;
        block4: {
            try {
                scope = RfScopeUtil.getScopeElementOfDef(project, elementScope);
                if (scope != null && scope instanceof IRfScope) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        IRfClassType candidate = (IRfClassType)((Object)((RfNamedElement)scope).getLocalMember(null, new HashSet<Class<? extends IRfNamedElement>>(Arrays.asList(RfStruct.class)), elementName, null));
        if (scope instanceof IRfClassType && candidate == null) {
            candidate = (IRfClassType)scope;
        }
        return candidate;
    }

    private List<IDVTElementWrapper> getHierarchyData(RfProject project, StringMatcher matcher, boolean triggeredForQuickView, String elementName, int elementType, List<RfNameTypeScopeHelper> elementScope, UpdateJob updateJob) {
        IRfClassType candidate;
        boolean isConstraint;
        String memberName = null;
        boolean isFunction = elementType == 4;
        boolean bl = isConstraint = elementType == 4096;
        if (triggeredForQuickView && (elementType == 4 || elementType == 4096)) {
            memberName = elementName;
        }
        if ((candidate = this.getClassType(project, elementName, elementScope)) == null) {
            return new ArrayList<IDVTElementWrapper>();
        }
        List<IDVTElementWrapper> hData = this.getHierarchy(candidate, memberName, isFunction, isConstraint, updateJob);
        if (hData == null) {
            return new ArrayList<IDVTElementWrapper>();
        }
        if (matcher != null) {
            this.filterInput(hData, matcher, updateJob);
        }
        return hData;
    }

    public List<IDVTElementWrapper> getHierarchy(IRfClassType classType, String elementName, boolean isFunction, boolean isConstraint, UpdateJob updateJob) {
        if (classType == null) {
            return null;
        }
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        try {
            RfTreeElementWrapper root = new RfTreeElementWrapper(classType);
            root.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, true);
            if (PrefConst.getTHViewShowSupertype()) {
                this.getRecursiveClassParentsSupertype(root, updateJob, isFunction, elementName);
                result.add(root);
            } else {
                this.getRecursiveClassChildren(new HashSet<IRfClassType>(), root, classType, updateJob, isFunction, isConstraint, elementName);
                root = this.getRecursiveClassParents(root, classType, updateJob, isFunction, isConstraint, elementName);
                result.add(root);
                if (PrefConst.getTHViewShowSubtype()) {
                    IDVTElementWrapper newRoot;
                    List<Object> tempResult = result;
                    if (tempResult.isEmpty()) {
                        return result;
                    }
                    do {
                        if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                            return result;
                        }
                        newRoot = (IDVTElementWrapper)tempResult.get(0);
                        if (newRoot == null) {
                            return result;
                        }
                        if (!(newRoot.getRfElement() instanceof RfNamedElement)) continue;
                        Object rfElement = newRoot.getRfElement();
                        if (rfElement == null) {
                            return result;
                        }
                        String name = ((RfNamedElement)rfElement).getName();
                        if (name == null) {
                            return result;
                        }
                        if (name.equals(classType.getName())) break;
                    } while ((tempResult = newRoot.getChildren()) != null);
                    result = tempResult;
                }
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return result;
        }
    }

    private void getRecursiveClassParentsSupertype(RfTreeElementWrapper root, UpdateJob updateJob, boolean isFunction, String functionName) {
        if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
            return;
        }
        IRfClassType classType = (IRfClassType)root.getRfElement();
        IRfClassType parentClass = classType.getParentClass();
        if (parentClass != null) {
            RfMethod method;
            RfTreeElementWrapper parentClassWrapper = new RfTreeElementWrapper(parentClass);
            if (isFunction && (method = (RfMethod)parentClass.getLocalMember(RfPackage.MAIN_DETERMINANT, SemanticUtils.MEMBER_METHODS, functionName, null)) == null) {
                parentClassWrapper.setGrayIcon(true);
            }
            this.getRecursiveClassParentsSupertype(parentClassWrapper, updateJob, isFunction, functionName);
            root.addChild(parentClassWrapper);
        }
        if (classType.getParentInterfaces() != null) {
            this.getRecursiveInterfaceClassParentsSupertype(root, updateJob, isFunction, functionName);
        }
    }

    private void getRecursiveInterfaceClassParentsSupertype(RfTreeElementWrapper root, UpdateJob updateJob, boolean isFunction, String functionName) {
        IRfClassType classType = (IRfClassType)root.getRfElement();
        if (classType.getParentInterfaces() == null) {
            return;
        }
        ArrayList<IRfClassType> parent_interfaces = new ArrayList<IRfClassType>(classType.getParentInterfaces());
        Collections.sort(parent_interfaces, CLASS_INTERFACE_COMPARATOR);
        for (IRfClassType interfaze : parent_interfaces) {
            RfMethod method;
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            RfTreeElementWrapper interfaceWrapper = new RfTreeElementWrapper(interfaze);
            if (isFunction && (method = (RfMethod)interfaze.getLocalMember(RfPackage.MAIN_DETERMINANT, SemanticUtils.MEMBER_METHODS, functionName, null)) == null) {
                interfaceWrapper.setGrayIcon(true);
            }
            this.getRecursiveInterfaceClassParentsSupertype(interfaceWrapper, updateJob, isFunction, functionName);
            root.addChild(interfaceWrapper);
        }
    }

    private void getRecursiveClassChildren(Set<IRfClassType> visited, RfTreeElementWrapper root, IRfClassType classType, UpdateJob updateJob, boolean isFunction, boolean isConstraint, String name) {
        Collection<IRfClassType> children = classType.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        ArrayList<IRfClassType> childrenList = new ArrayList<IRfClassType>(children);
        Collections.sort(childrenList, CLASS_INTERFACE_COMPARATOR);
        if (!isFunction && !isConstraint) {
            boolean circularInheritance = visited.contains(classType);
            if (circularInheritance) {
                root.addChild(new RfTreeElementWrapper(new RfDummyElement("[...recurrence detected]")));
                return;
            }
            visited.add(classType);
        }
        for (IRfClassType child : childrenList) {
            RfBlock constraint;
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            RfTreeElementWrapper childWrapper = new RfTreeElementWrapper(child);
            if (isConstraint && ((constraint = (RfBlock)child.getLocalMember(null, Collections.singleton(RfBlock.class), name, null)) == null || constraint.hasNoDefs(false))) {
                childWrapper.setGrayIcon(true);
            }
            this.getRecursiveClassChildren(new HashSet<IRfClassType>(visited), childWrapper, child, updateJob, isFunction, isConstraint, name);
            if ((isFunction || isConstraint) && !childWrapper.hasChildren() && childWrapper.isGrayIcon()) continue;
            root.addChild(childWrapper);
        }
    }

    private RfTreeElementWrapper getRecursiveClassParents(RfTreeElementWrapper root, IRfClassType classType, UpdateJob updateJob, boolean isFunction, boolean isConstraint, String name) {
        IRfClassType parent = classType;
        while ((parent = parent.getParentClass()) != null) {
            RfBlock constraint;
            RfTreeElementWrapper parentClassWrapper = new RfTreeElementWrapper(parent);
            if (isConstraint && ((constraint = (RfBlock)parent.getLocalMember(null, Collections.singleton(RfBlock.class), name, null)) == null || constraint.hasNoDefs(false))) {
                parentClassWrapper.setGrayIcon(true);
            }
            parentClassWrapper.addChild(root);
            root = parentClassWrapper;
        }
        return root;
    }

    private void filterInput(List<IDVTElementWrapper> input, StringMatcher matcher, UpdateJob updateJob) {
        ArrayList<IDVTElementWrapper> toRemove = new ArrayList<IDVTElementWrapper>();
        for (IDVTElementWrapper wrapper : input) {
            if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                return;
            }
            if (wrapper.getChildren() != null && !wrapper.getChildren().isEmpty()) {
                this.filterInput(wrapper.getChildren(), matcher, updateJob);
            }
            if (wrapper.getChildren() != null && !wrapper.getChildren().isEmpty() || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.fLabelProvider.getText(wrapper))) continue;
            toRemove.add(wrapper);
        }
        input.removeAll(toRemove);
    }

    private List<IDVTElementWrapper> getMembersData(RfProject project, StringMatcher matcher, String elementName, int elementType, List<RfNameTypeScopeHelper> elementScope, UpdateJob updateJob) {
        IRfClassType classType = this.getClassType(project, elementName, elementScope);
        List<IDVTElementWrapper> membersData = this.getMembersWrappers(classType, updateJob);
        ArrayList<IDVTElementWrapper> filteredMembers = new ArrayList<IDVTElementWrapper>();
        if (matcher != null) {
            for (IDVTElementWrapper element : membersData) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return new ArrayList<IDVTElementWrapper>();
                }
                String name = "";
                if (element.getRfElement() instanceof RfNamedElement) {
                    name = ((RfNamedElement)element.getRfElement()).getName();
                }
                if (name == null || !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)name)) continue;
                filteredMembers.add(element);
            }
            membersData = filteredMembers;
        }
        return membersData;
    }

    public List<IDVTElementWrapper> getMembersWrappers(IRfClassType clazz, UpdateJob updateJob) {
        ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
        try {
            RfNamedElement[] sorted;
            if (clazz == null) {
                return result;
            }
            NullProtectedList<RfNamedElement> elements = new NullProtectedList<RfNamedElement>();
            LexicalSorter lexicalSorter = new LexicalSorter();
            if (PrefConst.getTHViewSortByCategory()) {
                NullProtectedList<RfNamedElement> fields = new NullProtectedList<RfNamedElement>();
                this.getFields(fields, (RfNamedElement)((Object)clazz));
                sorted = fields.toArray(new RfNamedElement[fields.size()]);
                Arrays.sort(sorted, lexicalSorter);
                elements.addAll(Arrays.asList(sorted));
            } else {
                this.getFields(elements, (RfNamedElement)((Object)clazz));
            }
            if (PrefConst.getTHViewSortByCategory()) {
                NullProtectedList<RfNamedElement> methods = new NullProtectedList<RfNamedElement>();
                this.getFunctions(methods, (RfNamedElement)((Object)clazz));
                sorted = methods.toArray(new RfNamedElement[methods.size()]);
                Arrays.sort(sorted, lexicalSorter);
                elements.addAll(Arrays.asList(sorted));
            } else {
                this.getFunctions(elements, (RfNamedElement)((Object)clazz));
            }
            if (!PrefConst.getTHViewSortByCategory()) {
                Collections.sort(elements, lexicalSorter);
            }
            for (RfNamedElement namedElement : elements) {
                if (ViewsUtils.isCanceled((IDVTJob)updateJob)) {
                    return result;
                }
                DVTGUIFilterMatcher.GUIFilterResult filterResult = DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPE_HIERARCHY_MEMBERS, (IRfNamedElement)namedElement, () -> this.fLabelProvider.getText((Object)new RfTreeElementWrapper(namedElement)));
                if (filterResult != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                    if (filterResult == DVTGUIFilterMatcher.GUIFilterResult.PREFERENCE) continue;
                    this.fHasGUIFilteredMembers = true;
                    continue;
                }
                if (PrefConst.getTHViewShowOnlyPublic() && !namedElement.isPublic()) continue;
                RfTreeElementWrapper wrapper = new RfTreeElementWrapper(namedElement, true);
                result.add(wrapper);
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return result;
        }
    }

    private void getFields(List<RfNamedElement> result, RfNamedElement scope) {
        boolean showInherited;
        Collection<RfNamedElement> members = scope.getLocalMembers();
        if (members != null && !members.isEmpty()) {
            for (RfNamedElement member : members) {
                if (member instanceof RfExtendDuplicate) {
                    this.getFields(result, member);
                    continue;
                }
                if (!(member instanceof RfField)) continue;
                result.add(member);
            }
        }
        if ((showInherited = PrefConst.getTHViewShowAllInherited()) && scope instanceof IRfClassType && ((IRfClassType)((Object)scope)).getParentClass() != null) {
            this.getFields(result, (RfNamedElement)((Object)((IRfClassType)((Object)scope)).getParentClass()));
        }
    }

    private void getFunctions(List<RfNamedElement> result, RfNamedElement scope) {
        boolean showInherited;
        Collection<RfNamedElement> members = scope.getLocalMembers();
        if (members != null && !members.isEmpty()) {
            for (RfNamedElement member : members) {
                if (member instanceof RfExtendDuplicate) {
                    this.getFunctions(result, member);
                    continue;
                }
                if (!(member instanceof RfMethod)) continue;
                result.add(member);
            }
        }
        if ((showInherited = PrefConst.getTHViewShowAllInherited()) && scope instanceof IRfClassType && ((IRfClassType)((Object)scope)).getParentClass() != null) {
            this.getFunctions(result, (RfNamedElement)((Object)((IRfClassType)((Object)scope)).getParentClass()));
        }
    }

    public THViewInput getInput(THViewInputConfigurator inputConfig) {
        Object namedElement = null;
        List<Object> hierarchyElements = new ArrayList();
        List<Object> memberElements = new ArrayList();
        this.fHasGUIFilteredMembers = false;
        try {
            if (!(inputConfig.getHistoryItem() instanceof UpdateViewEvent)) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            if (!inputConfig.getHistoryItem().getLanguage().equals((Object)LanguageKind.MSDL)) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            UpdateViewEvent ev = (UpdateViewEvent)inputConfig.getHistoryItem();
            String projectName = ev.getProjectName();
            IProject project = Utils.getProject((String)projectName);
            if (!project.isAccessible() || !project.hasNature("ro.amiq.msdldt.msdlnature")) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F73646C")) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            if (!inputConfig.isTriggeredForQuickView() && ev.getElementType() != 64) {
                return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
            }
            memberElements = this.getMembersData(rfProject, inputConfig.getMembersStringMatcher(), ev.getElementName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getUpdateJob());
            if (inputConfig.getUpdateOnlyMembers()) {
                memberElements = this.getMembersData(rfProject, inputConfig.getMembersStringMatcher(), ev.getElementName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getUpdateJob());
            } else {
                hierarchyElements = this.getHierarchyData(rfProject, inputConfig.getHierarchyStringMatcher(), inputConfig.isTriggeredForQuickView(), ev.getElementName(), ev.getElementType(), (List)ev.getElementScope(), inputConfig.getUpdateJob());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new THViewInput(namedElement, hierarchyElements, memberElements, this.fHasGUIFilteredMembers);
    }

    public HistoryItem createHistoryItemForElementAtCursor(IDVTEditor editor, int cursorOffset, boolean ignoreMethods) {
        RfNamedElement element;
        IProject project;
        block25: {
            block24: {
                block23: {
                    IDocument document;
                    RfProject rfProject;
                    IFile file;
                    MSDLEditor pssEditor;
                    block22: {
                        IDocumentProvider documentProvider;
                        IEditorInput editorInput;
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block16: {
                                                try {
                                                    if (editor instanceof MSDLEditor) break block16;
                                                    return null;
                                                }
                                                catch (Exception e) {
                                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                                    return null;
                                                }
                                            }
                                            pssEditor = (MSDLEditor)editor;
                                            editorInput = pssEditor.getEditorInput();
                                            if (editorInput != null) break block17;
                                            return null;
                                        }
                                        file = (IFile)editorInput.getAdapter(IFile.class);
                                        if (file != null) break block18;
                                        return null;
                                    }
                                    project = file.getProject();
                                    if (project != null) break block19;
                                    return null;
                                }
                                rfProject = RfManager.getInstance().getRfProject(project);
                                if (rfProject != null) break block20;
                                return null;
                            }
                            documentProvider = pssEditor.getDocumentProvider();
                            if (documentProvider != null) break block21;
                            return null;
                        }
                        document = documentProvider.getDocument((Object)editorInput);
                        if (document != null) break block22;
                        return null;
                    }
                    element = null;
                    RfWNamedElementAndScope elementAndScope = RfUtils.getRfElement((ITextEditor)pssEditor, document, cursorOffset);
                    if (elementAndScope == null || elementAndScope.getNamedElement() == null) {
                        char bchar;
                        RfFileDef fileDef = rfProject.getFile((IResource)file);
                        char achar = document.getChar(cursorOffset);
                        char c = bchar = cursorOffset > 0 ? (char)document.getChar(cursorOffset - 1) : (char)' ';
                        if (fileDef != null && (Character.isWhitespace(bchar) || Character.isWhitespace(achar))) {
                            RfDefElement lineScope = fileDef.getScope(cursorOffset);
                            element = MSDLQuickViewersUtil.getInstance().getEnclosingFunctionOrClass(lineScope, true);
                        }
                    } else {
                        element = elementAndScope.getNamedElement();
                    }
                    if (element != null) break block23;
                    return null;
                }
                if (element instanceof RfField) {
                    element = ((RfField)element).getAssociatedType();
                }
                if (element instanceof IRfClassType || element instanceof RfMethod || element instanceof RfBlock && ((RfBlock)element).getBlockKind() == BlockKind.CONSTRAINT) break block24;
                return null;
            }
            if (!(element instanceof RfMethod) || !ignoreMethods) break block25;
            return null;
        }
        return MSDLQuickViewersUtil.createViewUpdateEvent(element, project, 2);
    }

    public HistoryItem createHistoryItemForWrapper(IDVTElementWrapper wrapper, IProject project, int updateHistory) {
        Object namedElement;
        block5: {
            block4: {
                try {
                    if (wrapper instanceof RfTreeElementWrapper) break block4;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            RfTreeElementWrapper treeElementWrapper = (RfTreeElementWrapper)wrapper;
            namedElement = treeElementWrapper.getRfElement();
            if (namedElement != null && namedElement instanceof IRfClassType) break block5;
            return null;
        }
        IRfClassType rfClass = (IRfClassType)namedElement;
        List<RfNameTypeScopeHelper> scope = RfScopeUtil.getDefOfScopeElement((IRfScopeElement)rfClass);
        String text = "[" + project.getName() + "] " + (rfClass.getEnclosingScope() == null ? "" : String.valueOf(rfClass.getEnclosingScope().getName()) + " :: ") + rfClass.getName();
        return MSDLQuickViewersUtil.createViewUpdateEvent(text, project.getName(), rfClass.getName(), scope, 64, updateHistory);
    }

    public void overrideMethod(IDVTElementWrapper hierarchyWrapper, IDVTElementWrapper memberWrapper) {
    }

    public boolean canShowOverrideMethodMenuEntry(IDVTElementWrapper hierarchyWrapper, IDVTElementWrapper memberWrapper) {
        return false;
    }

    public boolean shouldOverrideShowPredefined(IDVTElementWrapper element) {
        return false;
    }

    private static class LexicalSorter
    implements Comparator<RfNamedElement> {
        private LexicalSorter() {
        }

        @Override
        public int compare(RfNamedElement o1, RfNamedElement o2) {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareTo(name2);
        }
    }
}

