/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.ComplexFilter;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.comparators.ClassComparator;
import ro.amiq.dvt.ui.views.comparators.LabelProviderWrapperComparator;
import ro.amiq.dvt.ui.views.lazy.views.types.BaseTypesViewContributor;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInput;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesViewInputConfigurator;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.msdldt.model.reflection.IRfAssociatedType;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfEnumItem;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfKind;
import ro.amiq.msdldt.model.reflection.RfLibrary;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfMembersContainer;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.StructKind;
import ro.amiq.msdldt.model.reflection.util.RfUtils;
import ro.amiq.msdldt.model.reflection.views.MSDLLanguageElement;
import ro.amiq.msdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.msdldt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.msdldt.model.reflection.views.TypesViewMembersLabelProvider;
import ro.amiq.msdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class MSDLTypesViewContributor
extends BaseTypesViewContributor {
    public MSDLTypesViewContributor() {
        super((DVTBaseLabelProvider)new TypesViewLabelProvider(), (IMembersLabelProvider)new TypesViewMembersLabelProvider());
    }

    private List<IDVTElementWrapper> toWrappers(TypesViewInputConfigurator configurator, TypesViewInput input) {
        ArrayList<IDVTElementWrapper> resultList = new ArrayList<IDVTElementWrapper>();
        try {
            RfProject project = RfManager.getInstance().getRfProject(configurator.getProject());
            if (project == null) {
                return resultList;
            }
            Collection<RfLibrary> libraries = project.getLibraries();
            if (libraries == null) {
                return resultList;
            }
            for (RfLibrary library : libraries) {
                if (configurator.isCanceled()) {
                    return resultList;
                }
                Collection<? extends RfNamedElement> childElements = project.getLocalTypes(library, false, configurator.hideDuplicates());
                if (childElements == null || childElements.isEmpty()) continue;
                this.toWrappersTopElements(project, resultList, childElements, library, configurator, input);
            }
            if (configurator.isCategorySort()) {
                Collections.sort(resultList, new TypeCategoryComparator());
            } else {
                Collections.sort(resultList, new LabelProviderWrapperComparator((ILabelProvider)this.getLabelProvider(resultList), true));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return resultList;
    }

    private void toWrappersTopElements(RfProject project, List<IDVTElementWrapper> resultList, Collection<? extends RfNamedElement> childElements, RfLibrary library, TypesViewInputConfigurator configurator, TypesViewInput input) {
        for (RfNamedElement rfNamedElement : childElements) {
            if (rfNamedElement.isAnonymous() || rfNamedElement.isPredefined() && rfNamedElement.getLocalMembers() == null) continue;
            boolean access = rfNamedElement instanceof RfField;
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper(rfNamedElement, access);
            if (rfNamedElement instanceof RfPackage && ((RfPackage)rfNamedElement).isMainPackage()) {
                Collection<? extends RfNamedElement> childElements2;
                if ("non-top-files".equals(library.getName()) || (childElements2 = project.getLocalTypes(rfNamedElement, false, false)) == null || childElements2.isEmpty()) continue;
                this.toWrappersTopElements(project, resultList, childElements2, library, configurator, input);
                continue;
            }
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES, (IRfNamedElement)rfNamedElement, () -> this.getLabelProvider((Object)wrapper).getText((Object)wrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                if (!input.isSearchedElementFiltered()) {
                    IRfFilterableTreeAccessor view = configurator.getView();
                    if ((view.getTreeSearchPort() == null || view.getTreeSearchPort().isEmpty()) && ViewsUtilsCommon.matchesPath((Object)((Object)wrapper), (IRfFilterableTreeAccessor)view)) {
                        input.setSearchedElementFiltered(true);
                    } else if (view.getTreeSearchPort() != null && !view.getTreeSearchPort().isEmpty()) {
                        input.setSearchedElementFiltered(this.hasFilteredSearchedPorts(project, rfNamedElement, view));
                    } else if (rfNamedElement.hasLocalMembers()) {
                        input.setSearchedElementFiltered(this.hasFilteredSearchedLocalMember(project, rfNamedElement, view));
                    }
                }
                input.setHasGUIFilteredElements(true);
                continue;
            }
            if (!(rfNamedElement instanceof RfPackage)) {
                input.incrementNrTypes();
            }
            this.addAllChildElements(wrapper, project, rfNamedElement, configurator, input);
            resultList.add(wrapper);
        }
    }

    protected void addAllChildElements(RfTreeElementWrapper root, RfProject project, RfNamedElement parent, TypesViewInputConfigurator configurator, TypesViewInput input) {
        Collection<? extends RfNamedElement> childElements = project.getLocalTypes(parent, false, configurator.hideDuplicates());
        for (RfNamedElement rfNamedElement : childElements) {
            if (configurator.isCanceled()) {
                return;
            }
            if (rfNamedElement.isAnonymous() || rfNamedElement.isPredefined() && rfNamedElement.getLocalMembers() == null) continue;
            boolean access = rfNamedElement instanceof RfField;
            RfTreeElementWrapper wrapper = new RfTreeElementWrapper(rfNamedElement, access);
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES, (IRfNamedElement)rfNamedElement, () -> this.getLabelProvider((Object)wrapper).getText((Object)wrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                if (!input.isSearchedElementFiltered()) {
                    IRfFilterableTreeAccessor view = configurator.getView();
                    if ((view.getTreeSearchPort() == null || view.getTreeSearchPort().isEmpty()) && ViewsUtilsCommon.matchesPath((Object)((Object)wrapper), (IRfFilterableTreeAccessor)view)) {
                        input.setSearchedElementFiltered(true);
                    } else if (view.getTreeSearchPort() != null && !view.getTreeSearchPort().isEmpty()) {
                        input.setSearchedElementFiltered(this.hasFilteredSearchedPorts(project, rfNamedElement, view));
                    } else if (rfNamedElement.hasLocalMembers()) {
                        input.setSearchedElementFiltered(this.hasFilteredSearchedLocalMember(project, rfNamedElement, view));
                    }
                }
                input.setHasGUIFilteredElements(true);
                continue;
            }
            if (!(rfNamedElement instanceof RfPackage)) {
                input.incrementNrTypes();
            }
            root.addChild(wrapper);
            this.addAllChildElements(wrapper, project, rfNamedElement, configurator, input);
        }
    }

    public TypesViewInput getInput(TypesViewInputConfigurator inputConfigurator) {
        try {
            TypesViewInput input = TypesViewInput.emptyInput();
            IProject project = inputConfigurator.getProject();
            if (project == null || !project.isAccessible() || !project.hasNature("ro.amiq.msdldt.msdlnature")) {
                return input;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F73646C")) {
                return input;
            }
            List<IDVTElementWrapper> wrappers = this.toWrappers(inputConfigurator, input);
            if (wrappers == null || wrappers.isEmpty()) {
                return input;
            }
            if (inputConfigurator.isCanceled()) {
                return TypesViewInput.emptyInput();
            }
            RfTreeElementWrapper tmpRoot = new RfTreeElementWrapper();
            tmpRoot.addChildren(wrappers);
            int matchCount = this.filterTree(tmpRoot, inputConfigurator);
            if (matchCount >= 0) {
                input.setNrNotFilteredTypes(matchCount);
            }
            Collections.sort(wrappers, new ClassComparator());
            if (inputConfigurator.isShowLanguageNameAsRootElement()) {
                int nrTypes = input.getNrTypes();
                String langInfo = String.valueOf(LanguageKind.MSDL.VIEW_NAME) + " [" + (matchCount != -1 ? String.valueOf(matchCount) + "/" + nrTypes : Integer.valueOf(nrTypes)) + ViewsUtils.getUnitName((String)"type", (int)nrTypes, (String)" ", (String)"") + "]";
                RfTreeElementWrapper languageWrapper = new RfTreeElementWrapper(new MSDLLanguageElement<String>(langInfo));
                languageWrapper.addChildren(tmpRoot.getChildren());
                input.setElements(Arrays.asList(new IDVTElementWrapper[]{languageWrapper}));
                return input;
            }
            input.setElements(new ArrayList<RfTreeElementWrapper>(tmpRoot.getChildren()));
            return input;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return TypesViewInput.emptyInput();
        }
    }

    private int filterTree(RfTreeElementWrapper root, TypesViewInputConfigurator viewConfigurator) {
        if (root == null || viewConfigurator == null) {
            return -1;
        }
        if (!viewConfigurator.getView().isFiltered()) {
            return -1;
        }
        ComplexFilter filter = new ComplexFilter(viewConfigurator.getView(), true){

            public boolean shouldSkipCount(IDVTElementWrapper node) {
                if (node.getRfElement() == null) {
                    return true;
                }
                if (!(node.getRfElement() instanceof RfNamedElement)) {
                    return true;
                }
                RfNamedElement namedElement = (RfNamedElement)node.getRfElement();
                return namedElement instanceof RfLibrary || namedElement instanceof RfPackage;
            }
        };
        ViewsUtils.filterElementComplex((IDVTElementWrapper)root, (ComplexFilter)filter, (IProgressMonitor)viewConfigurator.getMonitor());
        return filter.matchCount;
    }

    private boolean hasFilteredSearchedPorts(RfProject project, RfNamedElement parentElement, IRfFilterableTreeAccessor view) {
        if (ViewsUtilsCommon.matchesUnfilteredPort((IDVTElementWrapper)new RfTreeElementWrapper(parentElement), (IRfFilterableTreeAccessor)view)) {
            return true;
        }
        if (!parentElement.hasLocalMembers()) {
            return false;
        }
        Collection<? extends RfNamedElement> childElements = project.getLocalTypes(parentElement, false, true);
        for (RfNamedElement rfNamedElement : childElements) {
            if (ViewsUtilsCommon.matchesUnfilteredPort((IDVTElementWrapper)new RfTreeElementWrapper(rfNamedElement), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedPorts(project, rfNamedElement, view)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFilteredSearchedLocalMember(RfProject project, RfNamedElement parentElement, IRfFilterableTreeAccessor view) {
        if (!parentElement.hasLocalMembers()) {
            return false;
        }
        Collection<? extends RfNamedElement> childElements = project.getLocalTypes(parentElement, false, true);
        for (RfNamedElement rfNamedElement : childElements) {
            if (ViewsUtilsCommon.matchesPath((Object)((Object)new RfTreeElementWrapper(rfNamedElement)), (IRfFilterableTreeAccessor)view)) {
                return true;
            }
            if (!this.hasFilteredSearchedLocalMember(project, rfNamedElement, view)) continue;
            return true;
        }
        return false;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.MSDL;
    }

    public void gotoElement(IProject project, Object wrapper) {
        try {
            if (!(wrapper instanceof RfTreeElementWrapper)) {
                return;
            }
            Object object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
            if (object == null || !(object instanceof RfNamedElement)) {
                return;
            }
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction((RfNamedElement)object, project, (IRegion)new Region(0, 1));
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean adaptsTo(Object adapted) {
        return adapted instanceof RfTreeElementWrapper;
    }

    public boolean isSelectable(Object element, Object referenceData, StringMatcher matcher) {
        if (!(element instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (rfElement == null) {
            return false;
        }
        if (rfElement instanceof MSDLLanguageElement) {
            return false;
        }
        if (rfElement instanceof RfLibrary) {
            return false;
        }
        return matcher == null || ViewsUtils.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.getLabelProvider(element).getText(element));
    }

    public MembersViewInput getMembersInput(Object wrapper, StringMatcher stringMatcher) {
        MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
        if (wrapper == null) {
            return emptyResult;
        }
        Object rfElement = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : wrapper;
        if (!(rfElement instanceof RfNamedElement)) {
            return emptyResult;
        }
        RfNamedElement namedElemet = (RfNamedElement)rfElement;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        if (namedElemet instanceof IRfAssociatedType && ((IRfAssociatedType)((Object)namedElemet)).getAssociatedType() != null) {
            namedElemet = (RfNamedElement)((IRfAssociatedType)((Object)namedElemet)).getAssociatedType();
        }
        AtomicBoolean hasGUIFilteredMembers = new AtomicBoolean(false);
        if (namedElemet instanceof RfMembersContainer) {
            Collection<RfNamedElement> members = namedElemet.getLocalMembers();
            this.collectMatchingMembers(elements, members, stringMatcher, hasGUIFilteredMembers);
        }
        return new MembersViewInput(elements, hasGUIFilteredMembers.get());
    }

    private void collectMatchingMembers(Collection<IDVTElementWrapper> result, Iterable<? extends RfNamedElement> members, StringMatcher stringMatcher, AtomicBoolean hasGUIFilteredElements) {
        if (members == null) {
            return;
        }
        for (RfNamedElement rfNamedElement : members) {
            if (rfNamedElement.isAnonymous() || rfNamedElement instanceof RfBlock || rfNamedElement.isPredefined() && rfNamedElement.getLocalMembers() == null || rfNamedElement instanceof RfStruct || rfNamedElement instanceof RfPackage || rfNamedElement instanceof RfEnumType) continue;
            boolean access = rfNamedElement instanceof RfField;
            RfTreeElementWrapper elementWrapper = new RfTreeElementWrapper(rfNamedElement, access);
            if (!ViewsUtils.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)this.getMembersViewLabelProvider().getText((Object)elementWrapper))) continue;
            if (DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES_MEMBERS, (IRfNamedElement)rfNamedElement, () -> this.getLabelProvider((Object)elementWrapper).getText((Object)elementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                hasGUIFilteredElements.set(true);
                continue;
            }
            result.add(elementWrapper);
        }
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return;
        }
        Object elem = element.getRfElement();
        if (!(elem instanceof RfNamedElement)) {
            return;
        }
        RfUtils.createOpenAction((IRfNamedElement)elem, project, null).open();
    }

    protected IRfKind getKind(IRfNamedElement e) {
        return RfKind.of(e);
    }

    public IRfKind getKind(String rfKindValue) {
        return null;
    }

    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator configurator) {
        return null;
    }

    private static class TypeCategoryComparator
    implements Comparator<IDVTElementWrapper> {
        private TypeCategoryComparator() {
        }

        public int category(IRfNamedElement elem) {
            if (elem instanceof RfPackage) {
                return 0;
            }
            if (elem instanceof RfStruct && ((RfStruct)elem).getStructKind() == StructKind.ACTOR) {
                return 1;
            }
            if (elem instanceof RfStruct && ((RfStruct)elem).getStructKind() == StructKind.SCENARIO) {
                return 2;
            }
            if (elem instanceof RfStruct) {
                return 3;
            }
            if (elem instanceof RfTypeAlias) {
                return 4;
            }
            if (elem instanceof RfEnumType) {
                return 5;
            }
            if (elem instanceof RfCovergroup) {
                return 6;
            }
            if (elem instanceof RfField) {
                return 7;
            }
            if (elem instanceof RfEnumItem) {
                return 8;
            }
            if (elem instanceof RfEnumItem) {
                return 9;
            }
            if (elem instanceof RfMethod) {
                return 10;
            }
            if (elem instanceof RfBlock) {
                return 11;
            }
            return 100;
        }

        @Override
        public int compare(IDVTElementWrapper o1, IDVTElementWrapper o2) {
            int cat2;
            int cat1 = this.category((IRfNamedElement)o1.getRfElement());
            if (cat1 != (cat2 = this.category((IRfNamedElement)o2.getRfElement()))) {
                return cat1 - cat2;
            }
            return ((IRfNamedElement)o1.getRfElement()).getName().compareTo(((IRfNamedElement)o2.getRfElement()).getName());
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

