/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.LabelProviderInput;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHViewContributor;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.msdldt.model.reflection.RfArrayType;
import ro.amiq.msdldt.model.reflection.RfAssociatedType;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfDummyElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.util.RfUtils;
import ro.amiq.msdldt.model.reflection.views.MSDLInspectViewContributor;
import ro.amiq.msdldt.model.reflection.views.MSDLQuickViewersUtil;
import ro.amiq.msdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.msdldt.model.reflection.views.VHHistoryItem;
import ro.amiq.msdldt.model.reflection.views.VHLabelProvider;
import ro.amiq.msdldt.model.reflection.views.VHPortsLabelProvider;
import ro.amiq.msdldt.model.reflection.views.VHTopDialogLabelProvider;
import ro.amiq.msdldt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class MSDLVHViewContributor
implements IVHViewContributor {
    private static final Comparator<Object> lexicalSorter = (w1, w2) -> {
        boolean firstIsField = w1 instanceof RfField;
        boolean secondIsField = w2 instanceof RfField;
        if (firstIsField && secondIsField) {
            return ((RfField)w1).getName().compareTo(((RfField)w2).getName());
        }
        if (firstIsField) {
            return -1;
        }
        if (secondIsField) {
            return 1;
        }
        return 0;
    };
    private final VHLabelProvider treeLabelProvider = new VHLabelProvider();
    private final VHPortsLabelProvider tableLabelProvier = new VHPortsLabelProvider();
    private final VHTopDialogLabelProvider topDialogLabelProvider = new VHTopDialogLabelProvider();
    private boolean hasGUIFilteredTree;
    private boolean searchedElementFiltered;

    public DVTBaseLabelProvider getLabelProvider(Object wrapper) {
        if (!(wrapper instanceof LabelProviderInput)) {
            return null;
        }
        Object referenceData = ((LabelProviderInput)wrapper).getReferenceData();
        if (!(referenceData instanceof String)) {
            return this.treeLabelProvider;
        }
        String treeID = (String)referenceData;
        if (treeID.equals("default-tree")) {
            return this.treeLabelProvider;
        }
        if (treeID.equals("default-top-dialog")) {
            return this.topDialogLabelProvider;
        }
        return null;
    }

    public List<HistoryItem> getTops(IProject project) {
        if (!DVTPlugin.getDefault().collect().c(project, "F73646C")) {
            return Collections.emptyList();
        }
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<HistoryItem> results = new ArrayList<HistoryItem>();
        Collection<RfNamedElement> components = this.getTopComponents(project);
        for (RfNamedElement component : components) {
            HistoryItem item = VHHistoryItem.parseHistoryItem(project.getName(), component.getName(), this.getLanguageKind());
            if (item == null) continue;
            results.add(item);
        }
        return results;
    }

    private Collection<RfNamedElement> getTopComponents(IProject project) {
        HashMap<String, RfNamedElement> result = new HashMap<String, RfNamedElement>();
        if (project == null) {
            return result.values();
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return result.values();
        }
        RfPackage mainPackage = rfProject.getMainPackage();
        if (mainPackage == null) {
            return result.values();
        }
        Collection<RfNamedElement> allTypesAndComponents = mainPackage.getLocalMembers();
        if (allTypesAndComponents == null) {
            return result.values();
        }
        HashSet<String> nonTopComponentNames = new HashSet<String>();
        for (RfNamedElement candidate : allTypesAndComponents) {
            String name = candidate.getName();
            if (name.equals("pss_top")) {
                result.clear();
                result.put(name, candidate);
                return result.values();
            }
            if (nonTopComponentNames.contains(name) || !(candidate instanceof RfStruct)) continue;
            Collection<RfNamedElement> fields = ((RfStruct)candidate).getLocalMembers(RfPackage.MAIN_DETERMINANT, Collections.singleton(RfField.class));
            for (RfNamedElement field : fields) {
                String associatedTypeName;
                if (!((RfField)field).isInstance() || (associatedTypeName = ((RfField)field).getAssociatedTypeName()) == null) continue;
                nonTopComponentNames.add(associatedTypeName);
            }
            result.put(name, candidate);
        }
        for (String nonTopUnitName : nonTopComponentNames) {
            result.remove(nonTopUnitName);
        }
        ArrayList<RfNamedElement> topComponents = new ArrayList<RfNamedElement>(result.values());
        Collections.sort(topComponents, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        return topComponents;
    }

    public TreePath createRootTreePath(HistoryItem top, TreePath parent, boolean isPrependPackage, IProgressMonitor monitor) {
        if (!(top instanceof VHHistoryItem)) {
            return null;
        }
        VHHistoryItem treeHistoryItem = (VHHistoryItem)top;
        String componentName = treeHistoryItem.getComponentName();
        RfStruct elementStruct = this.computeStructElementFromHistoryItem(treeHistoryItem, componentName);
        if (elementStruct == null) {
            return null;
        }
        String text = this.treeLabelProvider.getText(elementStruct);
        TreePath child = TreePath.child((TreePath)parent, (String)text, (int)0, (Comparator)treePathComparator);
        child.setElement((Object)elementStruct);
        return child;
    }

    public List<Object> getChildrenForElement(Object candidate, IRfFilterableTreeAccessor view, boolean prependPackage, boolean isAlphabeticalSort, boolean showComponentsOnly, IProject project, IProgressMonitor monitor) {
        if (!this.c(project)) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (candidate instanceof RfArrayType) {
            candidate = ((RfArrayType)candidate).getAssociatedType();
        }
        if (!(candidate instanceof RfNamedElement)) {
            return result;
        }
        Collection<RfNamedElement> members = ((RfNamedElement)candidate).getLocalMembers();
        if (candidate instanceof RfField && ((RfField)candidate).isInstance()) {
            RfNamedElement associatedType = ((RfField)candidate).getAssociatedBaseType();
            while (associatedType instanceof RfTypeAlias) {
                associatedType = ((RfTypeAlias)associatedType).getAssociatedBaseType();
            }
            members = associatedType.getLocalMembers();
        }
        if (members != null) {
            for (RfNamedElement member : members) {
                if (!(member instanceof RfField)) continue;
                if (monitor.isCanceled()) {
                    return null;
                }
                if (!((RfField)member).isInstance()) continue;
                result.add(member);
            }
        }
        if (isAlphabeticalSort && !result.isEmpty()) {
            Collections.sort(result, lexicalSorter);
        }
        return result;
    }

    private RfStruct computeStructElementFromHistoryItem(VHHistoryItem treeHistoryItem, String componentName) {
        RfStruct elementStruct = null;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(treeHistoryItem.getProjectName());
        if (project == null) {
            return null;
        }
        if (!this.c(project)) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfPackage mainPackage = rfProject.getMainPackage();
        if (mainPackage == null) {
            return null;
        }
        elementStruct = (RfStruct)mainPackage.getLocalMember(RfPackage.MAIN_DETERMINANT, Collections.singleton(RfStruct.class), componentName, null);
        return elementStruct;
    }

    public String getTreeLabelText(HistoryItem top) {
        if (top == null || !(top instanceof VHHistoryItem)) {
            return "";
        }
        VHHistoryItem treeHistoryItem = (VHHistoryItem)top;
        String componentName = treeHistoryItem.getComponentName();
        if (componentName == null) {
            return "";
        }
        return "[" + treeHistoryItem.getProjectName() + "] " + componentName + " ";
    }

    public IMembersLabelProvider getMembersViewLabelProvider() {
        this.tableLabelProvier.setBoldMatcher(null);
        return this.tableLabelProvier;
    }

    public MembersViewInput getMembersInput(Object element, StringMatcher stringMatcher) {
        MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
        Object obj = element instanceof RfTreeElementWrapper ? ((RfTreeElementWrapper)((Object)element)).getRfElement() : element;
        if (!(obj instanceof RfField) && !(obj instanceof RfStruct)) {
            return emptyResult;
        }
        RfNamedElement associatedType = null;
        if (obj instanceof RfStruct) {
            associatedType = (RfNamedElement)obj;
        } else if (obj instanceof RfField) {
            associatedType = ((RfField)obj).getAssociatedBaseType();
            while (associatedType instanceof RfTypeAlias) {
                associatedType = ((RfTypeAlias)associatedType).getAssociatedBaseType();
            }
        }
        if (associatedType == null || !(associatedType instanceof RfStruct)) {
            return emptyResult;
        }
        Collection<RfNamedElement> members = ((RfStruct)associatedType).getLocalMembers();
        if (members == null || members.isEmpty()) {
            return emptyResult;
        }
        ArrayList<RfTreeElementWrapper> results = new ArrayList<RfTreeElementWrapper>(4);
        for (RfNamedElement member : members) {
            RfTreeElementWrapper bw = new RfTreeElementWrapper(member);
            if (!ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)this.tableLabelProvier.getText((Object)bw))) continue;
            results.add(bw);
        }
        return new MembersViewInput(results, false);
    }

    public IRfNamedElement getMemberNamedElement(Object element) {
        if (!(element instanceof IDVTElementWrapper)) {
            return null;
        }
        Object rfElement = ((IDVTElementWrapper)element).getRfElement();
        if (!(rfElement instanceof IRfNamedElement)) {
            return null;
        }
        return (IRfNamedElement)rfElement;
    }

    public void gotoElement(IProject project, Object wrapper) {
        if (project == null) {
            return;
        }
        Object element = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : (wrapper instanceof TreePath ? ((TreePath)wrapper).getElement() : wrapper);
        if (element == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = null;
        if (element instanceof RfDummyElement) {
            return;
        }
        if (element instanceof RfDefElement && ((RfDefElement)element).getNamedElement() instanceof RfStruct) {
            actionHyperlink = RfUtils.createOpenAction((RfDefElement)element, project, null);
        } else if (element instanceof RfNamedElement) {
            actionHyperlink = RfUtils.createOpenAction((RfNamedElement)element, project, null);
        } else {
            return;
        }
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return;
        }
        this.gotoElement(project, element);
    }

    public boolean acceptsHistoryItem(HistoryItem item) {
        return item instanceof VHHistoryItem;
    }

    public HistoryItem parseHistoryItem(String projectName, String historyItemText) {
        return VHHistoryItem.parseHistoryItem(projectName, historyItemText, this.getLanguageKind());
    }

    public String getComment(Object wrapper) {
        return null;
    }

    public boolean isSelectable(Object wrapper, Object referenceData, StringMatcher matcher) {
        if (!(wrapper instanceof RfTreeElementWrapper)) {
            return false;
        }
        Object rfElement = ((IDVTElementWrapper)wrapper).getRfElement();
        if (rfElement == null) {
            return false;
        }
        return !ViewsUtilsCommon.matchCamelCaseOrRegex((StringMatcher)matcher, (String)this.treeLabelProvider.getText(wrapper));
    }

    private RfStruct getStructFromSelectedWrappedInstance(Object selectedWrapper) {
        Object elem = selectedWrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)selectedWrapper).getRfElement() : selectedWrapper;
        if (!(elem instanceof RfField)) {
            return null;
        }
        RfField field = (RfField)elem;
        RfNamedElement type = field.getAssociatedBaseType();
        while (type instanceof RfTypeAlias) {
            type = ((RfTypeAlias)type).getAssociatedBaseType();
        }
        if (field.isInstance() && type instanceof RfStruct) {
            return (RfStruct)type;
        }
        return null;
    }

    public void openTypeDeclarationAction(Object selectedWrapper, IProject project) {
        RfStruct struct = this.getStructFromSelectedWrappedInstance(selectedWrapper);
        if (struct == null) {
            return;
        }
        RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(struct, project, null);
        if (actionHyperlink == null) {
            return;
        }
        actionHyperlink.open();
    }

    public void openCreateCallAction(Object selectedWrapper, IProject project) {
    }

    public List<String> getAdditionalContextMenuActionIds(Object selectedWrapper) {
        Object elem = selectedWrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)selectedWrapper).getRfElement() : selectedWrapper;
        ArrayList<String> results = new ArrayList<String>(2);
        results.add("ro.amiq.dvt.ui.views.verification.hierarchy.copyHierarchyPath");
        if (!(elem instanceof RfField) || !((RfField)elem).isInstance()) {
            return results;
        }
        RfStruct struct = this.getStructFromSelectedWrappedInstance(selectedWrapper);
        if (struct == null) {
            return results;
        }
        if (struct.isPredefined()) {
            return results;
        }
        results.add("ro.amiq.dvt.ui.views.verification.hierarchy.OpenTypeDeclaration");
        return results;
    }

    public void openViewForElementAtCursor() {
        MSDLQuickViewersUtil.getInstance().openVerificationHierarchyForElementAtCursor();
    }

    public Comparator<IDVTElementWrapper> getMembersCategoryComparator() {
        return null;
    }

    public GoToInfo getInstanceMarker(List<String> names, List<String> types, IProject project) {
        RfProject rfProject;
        if (names == null || types == null || names.isEmpty() || types.size() < 2) {
            return null;
        }
        String name = names.get(0);
        String type = types.get(0);
        if (type.contains("(")) {
            type = type.substring(0, type.indexOf(40)).trim();
        }
        if (type.contains(" ")) {
            type = type.substring(type.lastIndexOf(" ") + 1);
        }
        if ((rfProject = RfManager.getInstance().getRfProject(project)) == null) {
            return null;
        }
        RfPackage mainPackage = rfProject.getMainPackage();
        if (mainPackage == null) {
            return null;
        }
        RfNamedElement struct = mainPackage.getLocalMember(RfPackage.MAIN_DETERMINANT, Collections.singleton(RfStruct.class), type, null);
        if (struct == null || struct.getDeclaration() == null) {
            return null;
        }
        Collection<RfNamedElement> members = struct.getLocalMembers();
        if (members == null || members.isEmpty()) {
            return null;
        }
        RfField field = null;
        for (RfNamedElement member : members) {
            if (!(member instanceof RfField) || !member.getName().equals(name)) continue;
            field = (RfField)member;
            break;
        }
        if (field == null) {
            return null;
        }
        return GoToInfo.sourceOf(field);
    }

    public GoToInfo getTypeMarker(String type, IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        IRfDefElement defElement = null;
        return GoToInfo.sourceOf(defElement, (String)type);
    }

    public InspectViewInput getInspectContent(IDVTElementWrapper wrapper) {
        IProject project = wrapper.getProject();
        if (project == null) {
            return null;
        }
        Object element = wrapper.getRfElement();
        if (element == null) {
            return null;
        }
        if (element instanceof RfDefElement) {
            IRfDefElement structLayer = (IRfDefElement)element;
            return DVTInspectViewUtils.getInstance().processDefElement(project, structLayer, "//", null, 0, null);
        }
        if (element instanceof RfNamedElement) {
            IRfNamedElement namedElement = (IRfNamedElement)element;
            return MSDLInspectViewContributor.processNamedElement(project, namedElement);
        }
        return null;
    }

    public void setHasGUIFilteredTree(boolean hasGUIFilteredTree) {
        this.hasGUIFilteredTree = hasGUIFilteredTree;
    }

    public boolean hasGUIFilteredTree() {
        return this.hasGUIFilteredTree;
    }

    public void setSearchedElementFiltered(boolean searchedElementFiltered) {
        this.searchedElementFiltered = searchedElementFiltered;
    }

    public boolean isSearchedElementFiltered() {
        return this.searchedElementFiltered;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.MSDL;
    }

    public boolean adaptsTo(Object adapted) {
        if (adapted instanceof DVTTreeElementWrapper) {
            adapted = ((DVTTreeElementWrapper)adapted).getRfElement();
        }
        if (adapted instanceof TreePath) {
            adapted = ((TreePath)adapted).getElement();
        }
        if (DummyElement.RECURRENCE_NODE.equals(adapted)) {
            return true;
        }
        if (adapted instanceof RfNamedElement) {
            return ((RfNamedElement)adapted).getLanguageKind() == this.getLanguageKind();
        }
        return adapted instanceof RfTreeElementWrapper || adapted instanceof VHHistoryItem;
    }

    public static String getCopyHierarchyPathSegmentSeparator() {
        return DVTPlugin.getDefault().getPreferenceStore().getString("copyHierarchyPathSegmentSeparator");
    }

    public void copyHierarchyPathAction(Object selectedWrapper, Object port) {
        ViewsUtils.ITreePathAccessor treePathAnccessor = wrapper -> {
            if (wrapper == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            Object obj = wrapper instanceof IDVTElementWrapper ? ((IDVTElementWrapper)wrapper).getRfElement() : (wrapper instanceof TreePath ? ((TreePath)wrapper).getElement() : wrapper);
            if (obj instanceof IRfScopeElement) {
                result.append(((IRfScopeElement)obj).getName());
            }
            if (result.length() != 0 && obj instanceof RfField) {
                RfNamedElement assocType = (RfNamedElement)obj;
                while (assocType instanceof RfAssociatedType && (assocType = ((RfAssociatedType)assocType).getAssociatedType()) != null) {
                    if (!(assocType instanceof RfArrayType)) continue;
                    result.append("[0]");
                }
            }
            return result.length() != 0 ? result.toString() : "";
        };
        String copyHierarchyPathSegmentSeparator = MSDLVHViewContributor.getCopyHierarchyPathSegmentSeparator();
        String elementPath = ViewsUtils.pathToRoot((Object)selectedWrapper, (String)copyHierarchyPathSegmentSeparator, (ViewsUtils.ITreePathAccessor)treePathAnccessor);
        if (port != null) {
            String portPath = ViewsUtils.pathToRoot((Object)port, (String)copyHierarchyPathSegmentSeparator, (ViewsUtils.ITreePathAccessor)treePathAnccessor);
            Utils.copyToClipboard((String)(String.valueOf(elementPath) + copyHierarchyPathSegmentSeparator + portPath), (int)3);
        } else {
            Utils.copyToClipboard((String)elementPath, (int)3);
        }
    }

    public String getText(Object dvtElementWrapper, TreePath ... parent) {
        return this.treeLabelProvider.getText(dvtElementWrapper);
    }

    public void setVHBreadcrumbData(Object selectedWrapper, IProject project) {
    }

    public boolean c(IProject project) {
        return DVTPlugin.getDefault().collect().c(project, "F73646C");
    }
}

