/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.model.reflection.views;

import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IOutlineTreeViewProvider;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.StructKind;
import ro.amiq.msdldt.model.reflection.views.MSDLLabelProvider;
import ro.amiq.msdldt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.msdldt.parser.EAST;

public class OutlineTreeViewProvider
extends MSDLLabelProvider
implements ITreeContentProvider,
IOutlineTreeViewProvider {
    public Object[] getElements(Object wrapper) {
        List elements;
        if (wrapper == null) {
            return new Object[0];
        }
        if (wrapper instanceof IDVTElementWrapper && (elements = ((IDVTElementWrapper)wrapper).getChildren()) != null) {
            return elements.toArray();
        }
        return new Object[0];
    }

    public Object[] getChildren(Object wrapper) {
        List elements;
        if (wrapper == null) {
            return null;
        }
        if (wrapper instanceof IDVTElementWrapper && (elements = ((IDVTElementWrapper)wrapper).getChildren()) != null) {
            return elements.toArray();
        }
        return null;
    }

    public Object getParent(Object wrapper) {
        return null;
    }

    public boolean hasChildren(Object wrapper) {
        if (wrapper == null) {
            return false;
        }
        return ((IDVTElementWrapper)wrapper).getChildren() != null;
    }

    public Image getImage(Object wrapper) {
        Object element = null;
        if (wrapper instanceof IDVTElementWrapper) {
            element = ((IDVTElementWrapper)wrapper).getRfElement();
        } else if (wrapper instanceof TreePath) {
            element = ((TreePath)wrapper).getElement();
        }
        Image result = null;
        if (element instanceof EAST) {
            return this.getASTImage(wrapper);
        }
        if (element instanceof RfNamedElement) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (element instanceof String) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!(element instanceof IRfDefElement)) {
            return null;
        }
        IRfNamedElement namedElement = ((IRfDefElement)element).getNamedElement();
        result = namedElement != null ? (element instanceof RfDefElement && !((RfDefElement)element).isIs() ? (namedElement instanceof RfStruct ? ((RfStruct)namedElement).getExtendImage() : (namedElement instanceof RfEnumType ? ((RfEnumType)namedElement).getExtendImage() : namedElement.getImage())) : namedElement.getImage()) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_FIELD);
        if (wrapper instanceof RfTreeElementWrapper && !((RfTreeElementWrapper)((Object)wrapper)).getOverlayStatus()) {
            return result;
        }
        if (this.fDecorator != null) {
            return this.fDecorator.decorateImage(result, wrapper);
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    public String getText(Object object) {
        String result = this.internalGetText(object);
        if (result == null) {
            return "";
        }
        return result;
    }

    private String internalGetText(Object wrapper) {
        Object element = null;
        if (wrapper instanceof IDVTElementWrapper) {
            element = ((IDVTElementWrapper)wrapper).getRfElement();
        } else if (wrapper instanceof TreePath) {
            element = ((TreePath)wrapper).getElement();
        }
        if (element instanceof EAST) {
            return this.getASTText(wrapper);
        }
        if (element instanceof IRfNamedElement) {
            return ((IRfNamedElement)element).getName();
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (!(element instanceof IRfDefElement)) {
            return null;
        }
        IRfNamedElement namedElement = ((IRfDefElement)element).getNamedElement();
        if (namedElement instanceof RfStruct) {
            Determinant determinant = ((RfDefElement)element).getDeterminant();
            if (determinant != null && !determinant.isEmpty()) {
                return String.valueOf(namedElement.getName()) + "(" + determinant + ")";
            }
            if (((RfStruct)namedElement).getStructKind() == StructKind.SCENARIO) {
                return String.valueOf(namedElement.getEnclosingScope().getName()) + "." + namedElement.getName();
            }
            if (((RfStruct)namedElement).getStructKind() == StructKind.MODIFIER) {
                return String.valueOf(namedElement.getEnclosingScope().getName()) + "." + namedElement.getName();
            }
            return namedElement.getName();
        }
        String result = namedElement.getName();
        return result;
    }

    public Image getImageByFieldName(String fieldName) {
        try {
            ImageDescriptor descriptor = (ImageDescriptor)DVTImages.class.getDeclaredField(fieldName).get(null);
            return DVTImages.imageCache.getImage(descriptor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private String getASTText(Object o) {
        String[] tokenNames;
        String signature;
        IDVTElementWrapper wrapper = (IDVTElementWrapper)o;
        EAST east = (EAST)((Object)wrapper.getRfElement());
        if (east == null) {
            return "null";
        }
        String result = east.getText();
        if (east.transientResult instanceof IRfNamedElement && (signature = ((RfNamedElement)east.transientResult).getSignature()) != null) {
            result = String.valueOf(result) + " : " + signature.replaceAll("\\R", " ");
        }
        if ((tokenNames = EAST.getTokenNames()) == null) {
            return "[not initialized]";
        }
        result = String.valueOf(result) + " <" + tokenNames[east.getType()] + ">";
        return result;
    }

    private Image getASTImage(Object o) {
        IDVTElementWrapper wrapper = (IDVTElementWrapper)o;
        if (wrapper.getChildren() != null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }
}

