/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.parser;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.TokenStreamRecognitionException;
import antlr.collections.AST;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.utils.FileInputStreamUtils;
import ro.amiq.dvt.utils.MD5InputStream;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.msdldt.model.IMSDLModule;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.parser.EAST;
import ro.amiq.msdldt.parser.IParsingListener;
import ro.amiq.msdldt.parser.MSDLFileInstance;
import ro.amiq.msdldt.parser.MSDLLexer;
import ro.amiq.msdldt.parser.MSDLLexerStack;
import ro.amiq.msdldt.parser.MSDLLoadedInfo;
import ro.amiq.msdldt.parser.MSDLParser;
import ro.amiq.msdldt.parser.MSDLProblem;
import ro.amiq.msdldt.parser.MSDLSkipInfo;
import ro.amiq.msdldt.parser.MSDLStartedInfo;
import ro.amiq.msdldt.parser.MSDLUtil;
import ro.amiq.msdldt.ui.persistenttask.TaskInfoWrapper;
import ro.amiq.msdldt.utils.Utils;

public class MSDLCompiler {
    private MSDLUtil util = new MSDLUtil();
    private IMSDLModule parsingInstanceListener;
    private AST fileAST;

    public void parseFile(String filename, String libraryName, IBuildConfigParserConstants.LanguageSyntax languageSyntax, RfProject rfProject, String documentContent, boolean incremental, int fileIndex, int invocNumber, int maxIssuesKindNumber, List<CustomPragma> customPragmas, DVTCodeCommentsPreferences commentsPreferences, Set<String> taskNames, boolean caseSensitive, boolean hideTaskName, SkipCompileFilter skipCompileFilter) {
        try {
            this.util.setMaxIssuesKindPerFile(maxIssuesKindNumber);
            this.util.setInvocationProperties(invocNumber, IBuildConfigParserConstants.ToolCompat.DVT);
            this.util.setTaskTagsProperties(taskNames, caseSensitive, hideTaskName);
            this.util.setCustomPragmas(customPragmas);
            this.util.setSkipCompileFilter(skipCompileFilter);
            this.util.restoreFileInstancesMap(rfProject.getFileInstancesMap());
            this.util.setRfProject(rfProject);
            MSDLUtil.setCommentsPreferences(commentsPreferences);
            File file = new File(filename);
            ParserPath parserPath = new ParserPath(filename);
            this.util.cleanMessages(parserPath);
            this.util.cleanFileInstanceCustomPragmas();
            if (this.util.isIgnored(file)) {
                this.util.notifyParsingListeners(new MSDLSkipInfo(parserPath, 3));
                return;
            }
            this.util.notifyParsingListeners(new MSDLStartedInfo(parserPath));
            if (incremental) {
                List<MSDLFileInstance> fileInstances = this.util.getFileInstances(parserPath);
                if (fileInstances == null || fileInstances.isEmpty()) {
                    MSDLFileInstance fileInstance = new MSDLFileInstance(rfProject, parserPath, fileIndex, invocNumber, null);
                    this.util.setCurrentFile(fileInstance);
                    this.util.addFileInstance(fileInstance);
                    this.parseFileInstance(file, parserPath, rfProject, documentContent, libraryName, incremental, languageSyntax);
                    this.parsingInstanceListener.notifyInstanceParsing(fileInstance, this);
                } else {
                    for (MSDLFileInstance fileInstance : fileInstances) {
                        this.util.setCurrentFile(fileInstance);
                        this.util.removeComments();
                        this.parseFileInstance(file, parserPath, rfProject, documentContent, libraryName, incremental, languageSyntax);
                        this.parsingInstanceListener.notifyInstanceParsing(fileInstance, this);
                    }
                }
            } else {
                MSDLFileInstance fileInstance = new MSDLFileInstance(rfProject, parserPath, fileIndex, invocNumber, null);
                this.util.setCurrentFile(fileInstance);
                this.util.addFileInstance(fileInstance);
                this.parseFileInstance(file, parserPath, rfProject, documentContent, libraryName, incremental, languageSyntax);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void parseImportedFile(RfProject rfProject, String filename) {
        File file = new File(filename);
        ParserPath parserPath = new ParserPath(filename);
        List<MSDLFileInstance> fileInstances = this.util.getFileInstances(parserPath);
        if (fileInstances != null && !fileInstances.isEmpty()) {
            return;
        }
        if (this.util.isIgnored(file)) {
            this.util.notifyParsingListeners(new MSDLSkipInfo(parserPath, 3));
            return;
        }
        this.util.notifyParsingListeners(new MSDLStartedInfo(parserPath));
        MSDLFileInstance currentFileInstance = this.util.getCurrentFileInstance();
        try {
            MSDLFileInstance fileInstance = new MSDLFileInstance(rfProject, parserPath, this.util.getFileInstancesMapSize(), currentFileInstance.getInvocNumber(), null);
            this.util.setCurrentFile(fileInstance);
            this.util.addFileInstance(fileInstance);
            this.parseFileInstance(file, parserPath, rfProject, null, null, false, this.util.getLanguageSyntax());
        }
        finally {
            this.util.setCurrentFile(currentFileInstance);
            IIdentifierIndexerExtension indexer = Utils.getIndexer(rfProject.getProject());
            parserPath = currentFileInstance.getParserPath();
            if (indexer != null) {
                indexer.startFile(parserPath.toString(), false);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseFileInstance(File file, ParserPath parserPath, RfProject rfProject, String documentContent, String libraryName, boolean incremental, IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        MSDLLexer lexer;
        block20: {
            lexer = null;
            int fileIndex = -1;
            try {
                Throwable throwable = null;
                Object var11_17 = null;
                try {
                    InputStream inputStream = this.getInputStream(file, documentContent);
                    try {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                            lexer = new MSDLLexer(reader);
                            lexer.util = this.util;
                            lexer.init(rfProject, parserPath, incremental);
                            MSDLParser parser = new MSDLParser(new MSDLLexerStack(lexer, this.util));
                            parser.setFilename(parserPath.toString());
                            parser.setASTNodeClass(EAST.class);
                            parser.util = this.util;
                            parser.rfp = rfProject;
                            parser.incremental = incremental;
                            parser.compiler = this;
                            RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
                            fileIndex = fileDef == null ? -1 : fileDef.getIndex();
                            parser.statements();
                            if (fileDef != null) {
                                fileDef.getParserPath().setMd5(((MD5InputStream)inputStream).getMD5());
                                fileDef.getParserPath().setSize(file.length());
                            }
                            this.fileAST = parser.getAST();
                        }
                        if (inputStream == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (TokenStreamRecognitionException e) {
                this.fileAST = null;
                this.util.reportError("*** Error: ", e.recog.getFilename(), this.util.getLanguageSyntax(), e.recog.getLine(), e.recog.getOffset(), e.recog.getLength(), e.recog.getMessage(), fileIndex);
            }
            catch (RecognitionException e) {
                this.fileAST = null;
                this.util.reportError("*** Error: ", e.getFilename(), this.util.getLanguageSyntax(), e.getLine(), e.getOffset(), e.getLength(), e.getMessage(), fileIndex);
            }
            catch (TokenStreamException e) {
                this.fileAST = null;
                if (!e.getMessage().equals("INTERRUPT")) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            catch (Exception e) {
                this.fileAST = null;
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        int nofRawLines = lexer == null ? 0 : lexer.getLine();
        this.util.notifyParsingListeners(new MSDLLoadedInfo(parserPath, this.util, languageSyntax, nofRawLines, this.fileAST));
    }

    private InputStream getInputStream(File file, String documentContent) throws NoSuchAlgorithmException, IOException {
        MD5InputStream inputStream;
        if (documentContent != null) {
            byte[] bytevals = documentContent.getBytes();
            ByteArrayInputStream byteis = new ByteArrayInputStream(bytevals);
            inputStream = new MD5InputStream((InputStream)new BufferedInputStream(byteis), file);
        } else {
            inputStream = new MD5InputStream(FileInputStreamUtils.createStream((File)file), file);
        }
        return inputStream;
    }

    public void addParsingInstanceListener(IMSDLModule pssModule) {
        this.parsingInstanceListener = pssModule;
    }

    public void removeParsingInstanceListener(IMSDLModule pssModule) {
        this.parsingInstanceListener = null;
    }

    public List<MSDLProblem> getErrors(ParserPath parserPath) {
        Set<MSDLProblem> problems = this.util.getErrors(parserPath);
        if (problems == null) {
            return null;
        }
        ArrayList<MSDLProblem> result = new ArrayList<MSDLProblem>(problems.size());
        result.addAll(problems);
        return result;
    }

    public List<MSDLProblem> getWarnings(ParserPath parserPath) {
        Set<MSDLProblem> problems = this.util.getWarnings(parserPath);
        if (problems == null) {
            return null;
        }
        ArrayList<MSDLProblem> result = new ArrayList<MSDLProblem>(problems.size());
        result.addAll(problems);
        return result;
    }

    public AST getFileAST() {
        return this.fileAST;
    }

    public final List<TaskInfoWrapper> getTasks(ParserPath parserPath) {
        List<TaskInfoWrapper> taskInfoWrappers = this.util.getTasks(parserPath);
        if (taskInfoWrappers == null) {
            return null;
        }
        ArrayList<TaskInfoWrapper> result = new ArrayList<TaskInfoWrapper>(taskInfoWrappers.size());
        result.addAll(taskInfoWrappers);
        return result;
    }

    public boolean isEncrypted(ParserPath parserPath) {
        return this.util.isEncrypted(parserPath);
    }

    public Map<ParserPath, Set<MSDLProblem>> getErrorsMap() {
        return this.util.getErrorsMap();
    }

    public Map<ParserPath, Set<MSDLProblem>> getWarningsMap() {
        return this.util.getWarningsMap();
    }

    public Map<ParserPath, List<TaskInfoWrapper>> getTasksMap() {
        return this.util.getTasksMap();
    }

    public void interrupt() {
        this.util.setInterrupt(true);
    }

    public boolean isInterrupted() {
        return this.util.getInterrupt();
    }

    protected boolean hasParsingListeners() {
        return !this.util.parsingListeners.isEmpty();
    }

    public void addParsingListener(IParsingListener l) {
        this.util.parsingListeners.add(l);
    }

    public void removeParsingListener(IParsingListener l) {
        this.util.parsingListeners.remove(l);
    }

    public void resetInterrupt() {
        this.util.setInterrupt(false);
    }
}

