/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.parser;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.CommentsTable;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.msdldt.model.reflection.RfProject;

public class MSDLFileInstance
implements IDVTFileInstance,
Serializable {
    private static final long serialVersionUID = 6L;
    private ParserPath parserPath;
    private int index;
    private int invocNumber;
    private int nofRawLines;
    private CommentsTable comments;
    private List<CustomPragmaUsage> fCustomPragmas;
    private transient IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.MSDL;

    protected MSDLFileInstance(RfProject project, ParserPath parserPath, int index, int invocNumber, IBuildConfigParserConstants.ToolCompat toolCompat) {
        this.parserPath = parserPath;
        this.index = index;
        this.invocNumber = invocNumber;
        this.nofRawLines = 0;
        this.fCustomPragmas = new ArrayList<CustomPragmaUsage>();
    }

    public int getInvocNumber() {
        return this.invocNumber;
    }

    public final ParserPath getParserPath() {
        return this.parserPath;
    }

    public final List<MSDLFileInstance> getFileInstances(ParserPath parserPath) {
        ArrayList<MSDLFileInstance> fileList = new ArrayList<MSDLFileInstance>();
        this.internalGetFileInstances(parserPath, fileList);
        return fileList;
    }

    private final void internalGetFileInstances(ParserPath parserPath, List<MSDLFileInstance> fileList) {
        if (this.parserPath != null && this.parserPath.equals((Object)parserPath)) {
            fileList.add(this);
        }
    }

    public void newLine(int line) {
        if (this.comments == null) {
            this.comments = new CommentsTable();
        }
        this.comments.add(Comment.EMPTY_LINE_INFO, line);
    }

    public void nextTokenLine(int line) {
        if (this.comments == null) {
            this.comments = new CommentsTable();
        }
        this.comments.add(Comment.CODE_LINE_INFO, line);
    }

    public void setNofRawLines(int nofRawLines) {
        this.nofRawLines = nofRawLines;
    }

    public int getNofRawLines() {
        return this.nofRawLines;
    }

    protected final void addComment(Comment comment) {
        int line;
        Comment oldComment;
        if (this.comments == null) {
            this.comments = new CommentsTable();
        }
        if (!Comment.isComment((Comment)(oldComment = this.comments.add(comment, line = comment.getEndLine())))) {
            return;
        }
        comment.setProtected(oldComment.isProtected());
    }

    public final CommentsTable getComments() {
        return this.comments;
    }

    public final void cleanAllComments() {
        if (this.comments != null) {
            this.comments.clear();
        }
        this.comments = null;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "[" + this.parserPath + ": " + this.index + "]";
    }

    public void setLanguageSyntax(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        this.languageSyntax = languageSyntax;
    }

    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        if (this.languageSyntax == null) {
            this.languageSyntax = IBuildConfigParserConstants.LanguageSyntax.MSDL;
        }
        return this.languageSyntax;
    }

    public void deepClean() {
        this.parserPath = null;
        this.comments = null;
    }

    public void endDefElement(IRfDefElement defElement) {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void addCustomPragma(CustomPragmaUsage pragma) {
        this.fCustomPragmas.add(pragma);
    }

    public List<CustomPragmaUsage> getCustomPragmas() {
        if (this.fCustomPragmas == null) {
            return new ArrayList<CustomPragmaUsage>();
        }
        return this.fCustomPragmas;
    }

    public void setCustomPragmas(List<CustomPragmaUsage> pragmas) {
        if (this.fCustomPragmas == null) {
            this.fCustomPragmas = new ArrayList<CustomPragmaUsage>();
        }
        this.fCustomPragmas.addAll(pragmas);
    }

    public void cleanCustomPragmas() {
        if (this.fCustomPragmas != null) {
            this.fCustomPragmas.clear();
        }
    }

    public boolean isInstanceInScope(IRfNamedElement instance) {
        return false;
    }

    public boolean isValid() {
        return true;
    }
}

