/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.parser;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.parser.MSDLFileInstance;

public class MSDLFileInstancesMap
implements Serializable {
    private static final long serialVersionUID = 7L;
    private Map<ParserPath, List<MSDLFileInstance>> fFileInstancesMap = new LinkedHashMap<ParserPath, List<MSDLFileInstance>>();

    public MSDLFileInstancesMap(RfProject rfProject) {
    }

    public void addFileInstance(MSDLFileInstance fileInstance) {
        ParserPath parserPath = fileInstance.getParserPath();
        List<MSDLFileInstance> fileInstances = this.fFileInstancesMap.get(parserPath);
        if (fileInstances == null) {
            fileInstances = new ArrayList<MSDLFileInstance>();
            this.fFileInstancesMap.put(parserPath, fileInstances);
        }
        fileInstances.add(fileInstance);
    }

    protected Map<ParserPath, List<MSDLFileInstance>> getFileInstances() {
        return this.fFileInstancesMap;
    }

    public List<MSDLFileInstance> getFileInstances(ParserPath parserPath) {
        if (this.fFileInstancesMap == null) {
            return Collections.emptyList();
        }
        return this.fFileInstancesMap.get(parserPath);
    }

    public final void clear() {
        if (this.fFileInstancesMap != null) {
            this.fFileInstancesMap.clear();
        }
    }

    public final void cleanAllComments(boolean recursive) {
        if (this.fFileInstancesMap == null || this.fFileInstancesMap.isEmpty()) {
            return;
        }
        for (List<MSDLFileInstance> fileInstances : this.fFileInstancesMap.values()) {
            for (MSDLFileInstance fileInstance : fileInstances) {
                fileInstance.cleanAllComments();
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void deepClean() {
        if (this.fFileInstancesMap == null || this.fFileInstancesMap.isEmpty()) {
            return;
        }
        for (List<MSDLFileInstance> fileInstances : this.fFileInstancesMap.values()) {
            for (MSDLFileInstance fileInstance : fileInstances) {
                fileInstance.deepClean();
            }
        }
    }
}

