/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.parser;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUsage;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.parser.Comment;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.utils.parser.CommentsTable;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.dvt.utils.parser.HeaderCommentBlock;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.parser.IParsingInfo;
import ro.amiq.msdldt.parser.IParsingListener;
import ro.amiq.msdldt.parser.MSDLFileInstance;
import ro.amiq.msdldt.parser.MSDLFileInstancesMap;
import ro.amiq.msdldt.parser.MSDLProblem;
import ro.amiq.msdldt.ui.persistenttask.TaskInfoWrapper;

public class MSDLUtil {
    private static boolean fIsOSX = System.getProperty("os.name") == null ? false : System.getProperty("os.name").contains("OS X");
    private static final int TASK_TAG_MAX_DESCRIPTION_LENGTH = 100;
    private static final int TASK_TAG_MAX_LINE_LENGTH = 100 + Math.round(10.0f);
    private static final int TASK_TAG_LIMIT = 100;
    protected static final String FILE_NOT_FOUND = "[file not found]";
    private Map<ParserPath, List<TaskInfoWrapper>> taskTableMap;
    private Map<ParserPath, Set<MSDLProblem>> errorTableMap;
    private Map<ParserPath, Set<MSDLProblem>> warningTableMap;
    private Map<ParserPath, Boolean> encryptedTableMap;
    protected static boolean debugMode;
    protected static final String REVISION_ID = "1.0.0";
    public static final String SEVERITY_ERROR = "*** Error: ";
    public static final String SEVERITY_WARNING = "*** Warning: ";
    protected static final String DEBUG_PREFIX = "*** Debug: ";
    protected static final String LOADING_MESSAGE = "Parsing file: ";
    protected static final String IGNORED_MESSAGE = "Skip file: ";
    private static final String nonStandardSeverity = "*** Warning: ";
    private MSDLFileInstancesMap fileInstancesMap;
    private MSDLFileInstance currentFileInstance;
    protected List<IParsingListener> parsingListeners = new ArrayList<IParsingListener>();
    private volatile boolean interrupt;
    private int MAX_ISSUE_KIND_PER_FILE = 100;
    private int index;
    private int invocNumber;
    private int invocOffset;
    private IBuildConfigParserConstants.ToolCompat toolCompat = IBuildConfigParserConstants.ToolCompat.DVT;
    protected final Deque<IBuildConfigParserConstants.LanguageSyntax> fCurrentLanguageSyntax = new ArrayDeque<IBuildConfigParserConstants.LanguageSyntax>();
    private RfProject rfProject;
    private SkipCompileFilter fSkipCompileFilter;
    private static IBuildConfigParserConstants.LanguageSyntax defaultLanguageSyntax;
    private static DVTCodeCommentsPreferences commentsPreferences;
    private Set<String> taskNames;
    private boolean taskNamesCaseSensitive;
    private boolean hideTaskName;
    private Set<String> fCustomPragmaFirstIdentifiers;
    private Map<String, CustomPragma> fStartPragmas;
    private Map<String, CustomPragma> fEndPragmas;

    static {
        defaultLanguageSyntax = IBuildConfigParserConstants.LanguageSyntax.MSDL;
        commentsPreferences = new DVTCodeCommentsPreferences();
    }

    protected MSDLUtil() {
        this.errorTableMap = new LinkedHashMap<ParserPath, Set<MSDLProblem>>();
        this.warningTableMap = new LinkedHashMap<ParserPath, Set<MSDLProblem>>();
        this.encryptedTableMap = new LinkedHashMap<ParserPath, Boolean>();
        this.taskTableMap = new LinkedHashMap<ParserPath, List<TaskInfoWrapper>>();
    }

    protected void reportClean() {
        this.errorTableMap = new LinkedHashMap<ParserPath, Set<MSDLProblem>>();
        this.warningTableMap = new LinkedHashMap<ParserPath, Set<MSDLProblem>>();
        this.encryptedTableMap = new LinkedHashMap<ParserPath, Boolean>();
        this.taskTableMap = new LinkedHashMap<ParserPath, List<TaskInfoWrapper>>();
    }

    protected boolean isOSX() {
        return fIsOSX;
    }

    protected Map<ParserPath, Set<MSDLProblem>> getErrorsMap() {
        return this.errorTableMap;
    }

    protected Map<ParserPath, Set<MSDLProblem>> getWarningsMap() {
        return this.warningTableMap;
    }

    public Map<ParserPath, List<TaskInfoWrapper>> getTasksMap() {
        return this.taskTableMap;
    }

    protected final void setEncryptedFile(String parserPath, boolean encrypted) {
        this.encryptedTableMap.put(new ParserPath(parserPath), encrypted);
    }

    protected void reportMessage(String severity, String filename) {
    }

    public void removeComments() {
        this.currentFileInstance.cleanAllComments();
    }

    protected void reportError(String severity, String filename, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, int offsetStart, int length, String message, int fileIndex) {
        this.reportError(severity, filename, languageSyntax, line, offsetStart, length, message, fileIndex, null);
    }

    protected String getLanguageSyntaxName(IBuildConfigParserConstants.LanguageSyntax languageSyntax) {
        return "M-SDL";
    }

    protected void reportError(String severity, String filename, IBuildConfigParserConstants.LanguageSyntax languageSyntax, int line, int offsetStart, int length, String message, int fileIndex, Map<String, Object> attributes) {
        Set<MSDLProblem> warningTable;
        ParserPath parserPath = new ParserPath(filename);
        if (message != null && message.length() > 1) {
            message = String.valueOf(message.substring(0, 1).toUpperCase()) + message.substring(1);
        }
        String messagePrefix = String.valueOf(this.getLanguageSyntaxName(languageSyntax)) + ":";
        if (severity != null && severity.equals(SEVERITY_ERROR)) {
            Set<MSDLProblem> errorTable = this.getErrors(parserPath);
            if (errorTable.size() < this.MAX_ISSUE_KIND_PER_FILE || message != null && message.startsWith("NON_STANDARD:")) {
                MSDLProblem problem = new MSDLProblem(1, filename, messagePrefix, line, message, fileIndex, this.invocNumber + this.invocOffset);
                if (attributes != null && !attributes.isEmpty()) {
                    problem.setAttributes(attributes);
                }
                if (offsetStart >= 0 && length > 0) {
                    problem.setOffsetStart(offsetStart);
                    problem.setOffsetEnd(offsetStart + length);
                }
                if (!errorTable.contains(problem)) {
                    errorTable.add(problem);
                }
            }
        } else if (severity != null && severity.equals("*** Warning: ") && ((warningTable = this.getWarnings(parserPath)).size() < this.MAX_ISSUE_KIND_PER_FILE || message != null && message.startsWith("NON_STANDARD:"))) {
            MSDLProblem problem = new MSDLProblem(0, filename, messagePrefix, line, message, fileIndex, this.invocNumber + this.invocOffset);
            if (offsetStart >= 0 && length > 0) {
                problem.setOffsetStart(offsetStart);
                problem.setOffsetEnd(offsetStart + length);
            }
            if (!warningTable.contains(problem)) {
                warningTable.add(problem);
            }
        }
    }

    protected void setMaxIssuesKindPerFile(int maxNumber) {
        this.MAX_ISSUE_KIND_PER_FILE = maxNumber;
    }

    protected void cleanMessages(ParserPath parserPath) {
        if (this.warningTableMap.containsKey(parserPath)) {
            this.warningTableMap.remove(parserPath);
        }
        if (this.errorTableMap.containsKey(parserPath)) {
            this.errorTableMap.remove(parserPath);
        }
        if (this.encryptedTableMap.containsKey(parserPath)) {
            this.encryptedTableMap.remove(parserPath);
        }
        if (this.taskTableMap.containsKey(parserPath)) {
            this.taskTableMap.remove(parserPath);
        }
    }

    public Set<MSDLProblem> getWarnings(ParserPath parserPath) {
        if (this.warningTableMap.containsKey(parserPath)) {
            return this.warningTableMap.get(parserPath);
        }
        LinkedHashSet<MSDLProblem> warningTable = new LinkedHashSet<MSDLProblem>();
        this.warningTableMap.put(parserPath, warningTable);
        return warningTable;
    }

    public Set<MSDLProblem> getErrors(ParserPath parserPath) {
        if (this.errorTableMap.containsKey(parserPath)) {
            return this.errorTableMap.get(parserPath);
        }
        LinkedHashSet<MSDLProblem> errorTable = new LinkedHashSet<MSDLProblem>();
        this.errorTableMap.put(parserPath, errorTable);
        return errorTable;
    }

    public List<TaskInfoWrapper> getTasks(ParserPath parserPath) {
        if (this.taskTableMap.containsKey(parserPath)) {
            return this.taskTableMap.get(parserPath);
        }
        LinkedList<TaskInfoWrapper> taskTable = new LinkedList<TaskInfoWrapper>();
        this.taskTableMap.put(parserPath, taskTable);
        return taskTable;
    }

    public boolean isEncrypted(ParserPath parserPath) {
        if (this.encryptedTableMap.containsKey(parserPath)) {
            return this.encryptedTableMap.get(parserPath);
        }
        return false;
    }

    protected synchronized void notifyParsingListeners(IParsingInfo e) {
        for (IParsingListener listener : this.parsingListeners) {
            listener.parsing(e);
        }
    }

    protected void debug(Object ... s) {
        if (debugMode) {
            Object[] sl = Arrays.asList(s).toArray();
            StringBuilder sb = new StringBuilder(DEBUG_PREFIX);
            int i = 0;
            while (i < sl.length) {
                if (sl[i] != null) {
                    sb.append(sl[i].toString());
                } else {
                    sb.append("null");
                }
                ++i;
            }
            TestHelper.out.println(sb.toString());
        }
    }

    protected static void setDebugMode() {
        debugMode = true;
    }

    protected void setCurrentFile(MSDLFileInstance fileToParse) {
        this.currentFileInstance = fileToParse;
        this.invocNumber = fileToParse.getInvocNumber();
    }

    protected void setInvocationProperties(int invocNumber, IBuildConfigParserConstants.ToolCompat toolCompat) {
        this.toolCompat = toolCompat;
        this.invocNumber = invocNumber;
        this.invocOffset = 0;
    }

    protected int getInvocationNumber() {
        return this.invocNumber;
    }

    public void restoreFileInstancesMap(MSDLFileInstancesMap fileInstancesMap) {
        this.fileInstancesMap = fileInstancesMap;
    }

    protected List<MSDLFileInstance> getFileInstances(ParserPath parserPath) {
        return this.fileInstancesMap.getFileInstances(parserPath);
    }

    public void addFileInstance(MSDLFileInstance fileInstance) {
        this.fileInstancesMap.addFileInstance(fileInstance);
    }

    public int getFileInstancesMapSize() {
        return this.fileInstancesMap.getFileInstances().size();
    }

    public MSDLFileInstance getCurrentFileInstance() {
        return this.currentFileInstance;
    }

    public int getCurrentFileIndex() {
        return this.currentFileInstance.getIndex();
    }

    public synchronized void addParsingListenerLT(IParsingListener l) {
        this.parsingListeners.add(l);
    }

    public synchronized void removeParsingListenerLT(IParsingListener l) {
        this.parsingListeners.remove(l);
    }

    protected static String trimCustom(StringBuilder text) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\ufff0') {
                indexes.add(i);
                text.setCharAt(i, '?');
            }
            ++i;
        }
        String result = text.toString().trim();
        if (indexes.isEmpty()) {
            return result;
        }
        int offset = text.toString().indexOf(result);
        text = new StringBuilder(result);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            text.setCharAt(index - offset, ' ');
        }
        result = text.toString();
        return result;
    }

    public String getCrossPlatformPath(String inputPath) {
        return DVTUtilsCommon.INSTANCE.getCrossPlatformPath(inputPath);
    }

    public void setRfProject(RfProject rfProject) {
        this.rfProject = rfProject;
    }

    public String getFileSubstitute(String filePath) {
        if (this.rfProject == null) {
            return filePath;
        }
        return DVTUtilsCommon.INSTANCE.getFileSubstitute(this.rfProject.getProject(), filePath);
    }

    public void setSkipCompileFilter(SkipCompileFilter skipCompileFilter) {
        this.fSkipCompileFilter = skipCompileFilter;
    }

    public boolean isIgnored(File file) {
        if (this.fSkipCompileFilter == null) {
            return false;
        }
        ParserPath parserPath = new ParserPath(file.getAbsolutePath());
        return this.fSkipCompileFilter.shouldSkip(parserPath, true);
    }

    protected void resetIndex() {
        this.index = 1;
    }

    public static CommentBlock getHeaderCommentBlock(IDVTFileInstance fileInstance, int startLine) {
        if (fileInstance == null) {
            return null;
        }
        CommentsTable comments = fileInstance.getComments();
        if (comments == null) {
            return null;
        }
        HeaderCommentBlock headerCandidateAttachedToFirstElement = comments.getHeaderCandidateOnce();
        int lastCommentLine = 0;
        int glueLine = 0;
        int firstLineOfCode = comments.getFirstLineOfCode();
        boolean skipComment = true;
        String commentString = "";
        int firstLineOfAboveComment = -1;
        while (lastCommentLine < firstLineOfCode && skipComment) {
            StringBuilder commentSB = new StringBuilder();
            lastCommentLine = glueLine;
            glueLine = -1;
            int line = lastCommentLine + 1;
            while (line < firstLineOfCode) {
                Comment commentLine = comments.get(line);
                if (!Comment.isComment((Comment)commentLine)) break;
                int commentStartLine = commentLine.getStartLine();
                int commentEndLine = commentLine.getEndLine();
                if (commentStartLine != glueLine + 1 && glueLine >= 0) break;
                glueLine = commentEndLine;
                comments.remove(line);
                commentSB.append(commentLine.getComment()).append('\n');
                if (firstLineOfAboveComment < 0) {
                    firstLineOfAboveComment = commentStartLine;
                }
                ++line;
            }
            if ((commentString = commentSB.toString()).isEmpty()) break;
            boolean bl = skipComment = commentString.trim().isEmpty() || MSDLUtil.matchesPattern(commentString, commentsPreferences.getExtractHeaderCommentIgnorePatterns()) || MSDLUtil.matchesRegex(commentString, commentsPreferences.getExtractHeaderCommentIgnoreRegexes());
        }
        if (!commentString.isEmpty()) {
            return new CommentBlock(null, commentString, firstLineOfAboveComment, false);
        }
        if (headerCandidateAttachedToFirstElement != null) {
            return headerCandidateAttachedToFirstElement.getOnlyHeaderComment();
        }
        return null;
    }

    private static boolean matchesRegex(String commentString, Collection<Pattern> patternsToIgnore) {
        if (patternsToIgnore == null || patternsToIgnore.isEmpty()) {
            return false;
        }
        for (Pattern pattern : patternsToIgnore) {
            Matcher m = pattern.matcher(commentString);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesPattern(String commentString, Set<StringMatcher> patternsToIgnore) {
        if (patternsToIgnore == null || patternsToIgnore.isEmpty()) {
            return false;
        }
        for (StringMatcher pattern : patternsToIgnore) {
            if (!pattern.match(commentString)) continue;
            return true;
        }
        return false;
    }

    public static CommentBlock getCommentAtLine(IDVTFileInstance fileInstance, int startLine, boolean addAbove, int endLine, boolean addInline, boolean addHeader) {
        CommentBlock result = MSDLUtil.getCommentAtLine(fileInstance, startLine, addAbove, endLine, addInline);
        if (!(addHeader &= commentsPreferences.getUseHeaderComment())) {
            return result;
        }
        CommentBlock headerCommentBlock = MSDLUtil.getHeaderCommentBlock(fileInstance, startLine);
        if (headerCommentBlock == null) {
            return result;
        }
        if (result == null) {
            return headerCommentBlock;
        }
        result.setHeaderComment(headerCommentBlock.getRawAboveComment());
        return result;
    }

    public static CommentBlock getCommentAtLine(IDVTFileInstance fileInstance, int startLine, boolean addAbove, int endLine, boolean addInline) {
        return MSDLUtil.getCommentAtLine(fileInstance, startLine, 0, addAbove, endLine, addInline);
    }

    public static CommentBlock getCommentAtLine(IDVTFileInstance fileInstance, int startLine, int upperLineLimit, boolean addAbove, int endLine, boolean addInline) {
        boolean isHeaderCandidate;
        if (startLine == -1 || endLine == -1) {
            return null;
        }
        if (fileInstance == null) {
            return null;
        }
        int currentLine = startLine;
        CommentsTable comments = fileInstance.getComments();
        if (comments == null) {
            return null;
        }
        if (!(addAbove &= commentsPreferences.getUseAboveComment()) && !(addInline &= commentsPreferences.getUseInlineComment())) {
            return null;
        }
        boolean isProtected = false;
        Comment protectedFlag = comments.get(startLine);
        if (Comment.isComment((Comment)protectedFlag)) {
            isProtected = protectedFlag.isProtected();
        }
        Comment commentInline = null;
        if (addInline) {
            commentInline = comments.get(endLine);
            comments.remove(endLine);
        }
        if (!addAbove) {
            if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
                return null;
            }
            return new CommentBlock(commentInline.getRawComment(), null, -1, isProtected);
        }
        Comment commentAbove = comments.get(--currentLine);
        while (Comment.isEmptyLine((Comment)commentAbove) && currentLine > upperLineLimit && currentLine > startLine - 1 - commentsPreferences.getEmptyLinesAboveToSkip()) {
            commentAbove = comments.get(--currentLine);
        }
        if (!Comment.isComment((Comment)commentAbove) || commentAbove.isInline()) {
            comments.remove(currentLine);
            if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
                return null;
            }
            return new CommentBlock(commentInline.getComment(), null, -1, isProtected);
        }
        int firstLineOfCode = comments.getFirstLineOfCode();
        boolean bl = isHeaderCandidate = firstLineOfCode < 0 || startLine == firstLineOfCode;
        if (commentAbove.getKind() == Comment.CommentStyle.ML_KIND || commentAbove.getKind() == Comment.CommentStyle.ML2_KIND) {
            comments.remove(currentLine);
            if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
                CommentBlock commentResult = new CommentBlock(null, commentAbove.getComment(), commentAbove.getStartLine(), isProtected);
                if (isHeaderCandidate) {
                    commentResult = new HeaderCommentBlock(commentResult);
                    comments.setHeaderCommentBlock(commentResult);
                }
                return commentResult;
            }
            CommentBlock commentResult = new CommentBlock(commentInline.getComment(), commentAbove.getComment(), commentAbove.getStartLine(), isProtected);
            if (isHeaderCandidate) {
                commentResult = new HeaderCommentBlock(commentResult);
                comments.setHeaderCommentBlock(commentResult);
            }
            return commentResult;
        }
        StringBuilder result = new StringBuilder("");
        int endCommentLine = currentLine;
        int startCommentLine = currentLine;
        while (commentAbove.getKind() == Comment.CommentStyle.SL_KIND) {
            commentAbove = comments.get(--startCommentLine);
            if (startCommentLine > upperLineLimit && Comment.isComment((Comment)commentAbove) && !commentAbove.isInline() && commentAbove.getKind() == Comment.CommentStyle.SL_KIND) continue;
            ++startCommentLine;
            break;
        }
        int i = startCommentLine;
        while (i < endCommentLine + 1) {
            commentAbove = comments.get(i);
            comments.remove(i);
            if (commentAbove != null) {
                result.append(commentAbove.getComment()).append('\n');
            }
            ++i;
        }
        if (commentInline == null || !Comment.isComment((Comment)commentInline)) {
            CommentBlock commentResult = new CommentBlock(null, result.toString().trim(), startCommentLine, isProtected);
            if (isHeaderCandidate) {
                commentResult = new HeaderCommentBlock(commentResult);
                comments.setHeaderCommentBlock(commentResult);
            }
            return commentResult;
        }
        CommentBlock commentResult = new CommentBlock(commentInline.getComment(), result.toString().trim(), startCommentLine, isProtected);
        if (isHeaderCandidate) {
            commentResult = new HeaderCommentBlock(commentResult);
            comments.setHeaderCommentBlock(commentResult);
        }
        return commentResult;
    }

    public static String getNonStandardSeverity() {
        return "*** Warning: ";
    }

    public static IBuildConfigParserConstants.LanguageSyntax getDefaultLanguageSyntax() {
        return defaultLanguageSyntax;
    }

    public IBuildConfigParserConstants.LanguageSyntax getLanguageSyntax() {
        return MSDLUtil.getDefaultLanguageSyntax();
    }

    public void newLine(int line) {
        this.currentFileInstance.newLine(line);
    }

    public void nextTokenLine(int line, boolean usePrevFileInstance) {
        this.currentFileInstance.nextTokenLine(line);
    }

    public void addComment(Comment comment) {
        if (!commentsPreferences.getAddSingleLineComment() && comment.getKind() == Comment.CommentStyle.SL_KIND) {
            return;
        }
        if (!commentsPreferences.getAddMultiLineComment() && comment.getKind() == Comment.CommentStyle.ML_KIND) {
            return;
        }
        if (!commentsPreferences.getAddMulti2LineComment() && comment.getKind() == Comment.CommentStyle.ML2_KIND) {
            return;
        }
        this.currentFileInstance.addComment(comment);
        String firstIdentifier = DVTStringUtil.getFirstIdentifier((String)comment.getComment());
        if (!this.isCustomPragmaFirstIdentifier(firstIdentifier)) {
            return;
        }
        String processedComment = this.processComment(comment.getComment());
        CustomPragma customPragma = this.getStartCustomPragma(processedComment);
        if (customPragma != null) {
            this.addCustomPragmaUsage(new CustomPragmaUsage(CustomPragmaUsage.Kind.START, comment.getStartLine(), customPragma));
        } else {
            customPragma = this.getEndCustomPragma(processedComment);
            if (customPragma != null) {
                this.addCustomPragmaUsage(new CustomPragmaUsage(CustomPragmaUsage.Kind.END, comment.getStartLine(), customPragma));
            }
        }
    }

    public static synchronized void setCommentsPreferences(DVTCodeCommentsPreferences preferences) {
        commentsPreferences = preferences == null ? new DVTCodeCommentsPreferences() : preferences;
    }

    public RfProject getRfProject() {
        return this.rfProject;
    }

    protected final void setTaskTagsProperties(Set<String> taskNames, boolean caseSensitive, boolean hideTaskName) {
        if (caseSensitive) {
            this.taskNames = taskNames;
        } else if (taskNames == null) {
            this.taskNames = null;
        } else {
            this.taskNames = new HashSet<String>();
            for (String taskName : taskNames) {
                this.taskNames.add(taskName.toUpperCase());
            }
        }
        this.taskNamesCaseSensitive = caseSensitive;
        this.hideTaskName = hideTaskName;
    }

    public void collectTaskTag(String firstIdentifier, String comment, int line, int offsetStart, int offsetEnd, ParserPath parserPath) {
        try {
            if (this.taskNames == null || firstIdentifier == null) {
                return;
            }
            int commentStartWithNewLine = comment.indexOf(firstIdentifier);
            int index = 0;
            while (index < commentStartWithNewLine) {
                if (comment.charAt(index) == '\n') {
                    ++line;
                    break;
                }
                ++index;
            }
            String commentToScan = comment;
            int commentLength = commentToScan.length();
            int i = 0;
            while (i < commentLength) {
                char ch = commentToScan.charAt(i);
                while (!Character.isJavaIdentifierPart(ch) && ch != '@') {
                    if (ch == '\n') {
                        ++line;
                    }
                    if (i >= commentLength - 1) {
                        return;
                    }
                    ch = commentToScan.charAt(++i);
                }
                StringBuilder possibleTaskTag = new StringBuilder();
                int startIndex = i;
                while (Character.isJavaIdentifierPart(ch) || ch == '@') {
                    possibleTaskTag.append(ch);
                    if (i == commentLength - 1) {
                        this.checkAndExtractPossibleTaskTag(line, parserPath, commentToScan, i, possibleTaskTag, startIndex, offsetStart);
                        return;
                    }
                    ch = commentToScan.charAt(++i);
                }
                i = this.checkAndExtractPossibleTaskTag(line, parserPath, commentToScan, i, possibleTaskTag, startIndex, offsetStart);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private int checkAndExtractPossibleTaskTag(int line, ParserPath parserPath, String commentToScan, int currentIndex, StringBuilder possibleTaskTag, int startIndex, int offsetStart) {
        String taskTagCandidate;
        int possLength = possibleTaskTag.length();
        if (possLength >= 1 && !Character.isJavaIdentifierPart(possibleTaskTag.charAt(possLength - 1))) {
            possibleTaskTag = possibleTaskTag.deleteCharAt(possLength - 1);
        }
        String string = taskTagCandidate = this.taskNamesCaseSensitive ? possibleTaskTag.toString() : possibleTaskTag.toString().toUpperCase();
        if (this.taskNames.contains(taskTagCandidate)) {
            List<TaskInfoWrapper> taskTable;
            String commentToDisplay = commentToScan.substring(startIndex, Math.min(startIndex + TASK_TAG_MAX_LINE_LENGTH, commentToScan.length()));
            commentToDisplay = DVTFileUtils.getInstance().cropFirstLine(commentToDisplay, 100);
            int newLineIndex = commentToScan.indexOf(10, currentIndex += commentToDisplay.length() - taskTagCandidate.length() - 1);
            if (newLineIndex > 0) {
                currentIndex = newLineIndex;
            }
            if ((taskTable = this.getTasks(parserPath)).size() < 100) {
                int length = commentToDisplay.length();
                commentToDisplay = DVTFileUtils.getInstance().displayUpperCaseTaskTag(this.taskNamesCaseSensitive, this.hideTaskName, commentToDisplay, taskTagCandidate);
                int taskTagStartOffset = offsetStart + startIndex;
                TaskInfoWrapper taskInfoWrapper = new TaskInfoWrapper(taskTagCandidate, line, taskTagStartOffset, taskTagStartOffset + length, commentToDisplay);
                taskTable.add(taskInfoWrapper);
            }
        }
        return currentIndex;
    }

    public String replaceAllSystemVariables(String input) {
        final IProject project = this.rfProject.getProject();
        if (project == null) {
            return input;
        }
        return DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((CharSequence)input, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, new DVTUtilsCommon.IEnvironmentProvider(){

            public String getenv(String name) {
                List invocations = BuildConfigManager.getInvocations((IProject)project);
                if (invocations == null || invocations.size() <= MSDLUtil.this.invocNumber || MSDLUtil.this.invocNumber < 0) {
                    return name;
                }
                return BuildConfigManager.getenv((Invocation)((Invocation)invocations.get(MSDLUtil.this.invocNumber)), (String)name);
            }
        });
    }

    public void setInterrupt(boolean interupt) {
        this.interrupt = interupt;
    }

    public boolean getInterrupt() {
        return this.interrupt;
    }

    protected final void setCustomPragmas(List<CustomPragma> customPragmas) {
        if (customPragmas == null) {
            return;
        }
        this.fStartPragmas = new HashMap<String, CustomPragma>();
        this.fEndPragmas = new HashMap<String, CustomPragma>();
        this.fCustomPragmaFirstIdentifiers = new HashSet<String>();
        for (CustomPragma pragma : customPragmas) {
            if (!pragma.isEnabled() || pragma.isOverriden()) continue;
            this.fStartPragmas.put(pragma.getStartPragma(), pragma);
            this.fEndPragmas.put(pragma.getEndPragma(), pragma);
            this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier((String)pragma.getStartPragma()));
            this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier((String)pragma.getEndPragma()));
        }
    }

    protected final String processComment(String comment) {
        if (this.fStartPragmas == null || this.fEndPragmas == null || this.fStartPragmas.isEmpty() || this.fEndPragmas.isEmpty() || comment == null) {
            return null;
        }
        return DVTStringUtil.collapseWhitespaces((String)comment);
    }

    protected final CustomPragma getStartCustomPragma(String comment) {
        if (this.fStartPragmas == null || this.fStartPragmas.isEmpty() || comment == null) {
            return null;
        }
        return this.fStartPragmas.get(comment.trim());
    }

    protected final CustomPragma getEndCustomPragma(String comment) {
        if (this.fEndPragmas == null || this.fEndPragmas.isEmpty() || comment == null) {
            return null;
        }
        return this.fEndPragmas.get(comment.trim());
    }

    protected final boolean isCustomPragmaFirstIdentifier(String firstIdentifier) {
        if (this.fCustomPragmaFirstIdentifiers == null || firstIdentifier == null) {
            return false;
        }
        return this.fCustomPragmaFirstIdentifiers.contains(firstIdentifier);
    }

    public void addCustomPragmaUsage(CustomPragmaUsage pragma) {
        this.currentFileInstance.addCustomPragma(pragma);
    }

    public void cleanFileInstanceCustomPragmas() {
        if (this.currentFileInstance != null) {
            this.currentFileInstance.cleanCustomPragmas();
        }
    }

    public boolean isEnableIncludeEnvVarExpansion() {
        return true;
    }

    public boolean isFile(File file) {
        IPath filePath = Path.fromOSString((String)file.getPath());
        IFileInfo fileInfo = DVTAutoLinkManager.getInstance().getCachedFileInfo(filePath);
        if (fileInfo != null && !fileInfo.exists()) {
            DVTAutoLinkManager.getInstance().removeFileInfo(filePath);
        }
        return (fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(filePath)).exists() && !fileInfo.isDirectory();
    }

    public List<String> getIncdirs() {
        return Collections.emptyList();
    }

    public void includedFileNotFound(String origFileName) {
    }
}

