/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.r2lparser;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.model.reflection.DataType;
import ro.amiq.msdldt.model.reflection.Determinant;
import ro.amiq.msdldt.model.reflection.IRfScope;
import ro.amiq.msdldt.model.reflection.RfArrayType;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfPackage;
import ro.amiq.msdldt.model.reflection.RfPredefinedField;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.semantic.SemanticUtils;
import ro.amiq.msdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.msdldt.r2lparser.R2LResultContainer;
import ro.amiq.msdldt.r2lparser.R2LScopeContainer;

public abstract class R2LManager {
    public static final int UNDEF_ACCESS = -1;
    public static final int DOT_ACCESS = 0;
    public static final int COLON_ACCESS = 1;
    public static final int FUNCTION_NAME = 1;
    public static final int RETURN_NAME = 2;
    public static final int PACKAGE_INSTANTIATION = 0;
    public static final int FUNCTION_INSTANTIATION = 1;
    public static final int PROCEDURE_INSTANTIATION = 2;
    protected IRfScope fInitialScope;
    protected IDocument fDocument;
    protected int fScopeOffset;
    protected int fDocumentOffset;
    protected int fDocumentLine;
    protected RfProject fRfProject;
    protected Determinant fDeterminant;
    protected boolean fIgnoreCase;
    protected RfFileDef fFileDef;

    public R2LManager(RfProject rfProject, IRfScope initialScope, IResource file, IDocument document, int documentOffset, int scopeOffset) {
        try {
            this.fIgnoreCase = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("ca.ignore_case");
            this.fFileDef = rfProject.getFile(file);
            this.fInitialScope = initialScope;
            this.fDocument = document;
            this.fScopeOffset = scopeOffset;
            this.fDocumentOffset = documentOffset;
            this.fRfProject = rfProject;
            this.fDeterminant = this.computeDeterminant();
            this.fDocumentLine = this.fDocument.getLineOfOffset(documentOffset) + 1;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Determinant computeDeterminant() {
        if (this.fInitialScope == null || !(this.fInitialScope instanceof RfDefElement)) {
            return RfPackage.MAIN_DETERMINANT;
        }
        return null;
    }

    public abstract R2LResultContainer getProposals();

    public abstract List<RfWNamedElementAndScope> getElements();

    public R2LScopeContainer getScope(R2LScopeContainer scopeContainer, int accessKind, String name, boolean isMethod, List<String> selects) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return null;
        }
        R2LScopeContainer result = new R2LScopeContainer(scopeContainer);
        if (this.isNumber(name)) {
            result.isNumber = true;
            return result;
        }
        result.scope = null;
        result.accessKind = accessKind;
        IRfScope scope = null;
        Object scopeElement = scopeContainer.scope;
        if (scopeElement instanceof RfDefElement) {
            scopeElement = ((RfDefElement)scopeElement).getNamedElement();
        }
        if (scopeElement instanceof RfNamedElement) {
            RfNamedElement candidate = null;
            if ("this".equals(name)) {
                enclosing = (RfNamedElement)scopeElement;
                if ((enclosing = (RfNamedElement)enclosing.getEnclosingScope(RfStruct.class)) instanceof RfStruct) {
                    candidate = new RfPredefinedField("this", new DataType(enclosing.getName()), "The predefined variable this is used refer the current enclosing class");
                    ((RfField)candidate).setAssociatedType(enclosing);
                    candidate.setEnclosingScope(enclosing);
                }
            } else if ("super".equals(name)) {
                enclosing = (RfNamedElement)scopeElement;
                if ((enclosing = (RfNamedElement)enclosing.getEnclosingScope(RfStruct.class)) instanceof RfStruct) {
                    candidate = new RfPredefinedField("super", new DataType(enclosing.getName()), "The predefined variable this is used refer the current enclosing class");
                    ((RfField)candidate).setAssociatedType((RfNamedElement)((Object)((RfStruct)enclosing).getParentClass()));
                    candidate.setEnclosingScope(enclosing);
                }
            } else {
                Set<Class<? extends IRfNamedElement>> classes = accessKind == 1 ? SemanticUtils.MEMBER_TYPES : (isMethod ? SemanticUtils.MEMBER_METHODS : SemanticUtils.MEMBER_FIELDS_2);
                candidate = ((RfNamedElement)scopeElement).getMember(null, name, false, scopeContainer.path == null || scopeContainer.path.isEmpty(), classes, null);
            }
            if (accessKind == 1) {
                scope = (IRfScope)((Object)candidate);
            } else if (candidate instanceof RfField) {
                scope = (IRfScope)((Object)((RfField)candidate).getAssociatedType());
            } else if (candidate instanceof RfMethod) {
                scope = (IRfScope)((Object)((RfMethod)candidate).getAssociatedType());
            } else if (candidate instanceof RfBlock) {
                scope = (IRfScope)((Object)candidate);
            }
        }
        if (scope == null) {
            return result;
        }
        if (selects != null && !selects.isEmpty()) {
            for (String select : selects) {
                boolean isItem = select.indexOf(58) == -1;
                scope = this.getAssociatedType(scope, isItem);
            }
        }
        if (!scopeContainer.disableTypeOverride) {
            StringBuilder instancePath = new StringBuilder();
            if (scopeContainer.path != null && !scopeContainer.path.isEmpty()) {
                for (String pathSegment : scopeContainer.path) {
                    instancePath.append(pathSegment).append('.');
                }
            }
            instancePath.append(name);
        }
        result.scope = scope;
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private IRfScope getAssociatedType(IRfScope scope, boolean isItem) {
        if (isItem) ** GOTO lbl4
        return scope;
lbl-1000:
        // 1 sources

        {
            scope = (IRfScope)((RfTypeAlias)scope).getAssociatedType();
lbl4:
            // 2 sources

            ** while (scope instanceof RfTypeAlias)
        }
lbl5:
        // 1 sources

        if (scope instanceof RfArrayType) {
            return (IRfScope)((RfArrayType)scope).getAssociatedType();
        }
        return null;
    }

    protected boolean isNumber(String name) {
        if (name.length() > 2 && name.charAt(0) == '\'') {
            name = name.substring(2);
        }
        return DVTStringUtil.isNumber((String)name);
    }

    public final IRfNamedElement[] getTypeCandidates(R2LScopeContainer scopeContainer, String prefix, boolean showCompAndPkg, String typeKind) {
        return this.getTypeCandidates(scopeContainer, prefix, showCompAndPkg, typeKind, null);
    }

    public abstract IRfNamedElement[] getEnumCandidates(R2LScopeContainer var1, List<String> var2, String var3);

    public abstract IRfNamedElement[] getEnumCandidates(R2LScopeContainer var1, String var2);

    public abstract IRfNamedElement[] getTypeCandidates(R2LScopeContainer var1, String var2, boolean var3, String var4, R2LScopeContainer var5);

    public abstract IRfNamedElement[] getExprCandidates(R2LScopeContainer var1, R2LScopeContainer var2, String var3);

    public abstract IRfNamedElement[] getMappingCandidates(R2LScopeContainer var1, String var2, String var3, Set<String> var4);

    public abstract IRfNamedElement[] getOptionCandidates(R2LScopeContainer var1, String var2);

    public abstract IRfNamedElement[] getMatchBlockEnumCandidates(R2LScopeContainer var1, String var2);
}

