/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.r2lparser;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.model.reflection.BlockKind;
import ro.amiq.msdldt.model.reflection.FieldModifier;
import ro.amiq.msdldt.model.reflection.IRfAssociatedType;
import ro.amiq.msdldt.model.reflection.IRfScope;
import ro.amiq.msdldt.model.reflection.RfAssociatedType;
import ro.amiq.msdldt.model.reflection.RfBlock;
import ro.amiq.msdldt.model.reflection.RfCovergroup;
import ro.amiq.msdldt.model.reflection.RfEnumItem;
import ro.amiq.msdldt.model.reflection.RfEnumType;
import ro.amiq.msdldt.model.reflection.RfField;
import ro.amiq.msdldt.model.reflection.RfMembersContainer;
import ro.amiq.msdldt.model.reflection.RfMethod;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;
import ro.amiq.msdldt.model.reflection.RfStruct;
import ro.amiq.msdldt.model.reflection.RfTypeAlias;
import ro.amiq.msdldt.model.reflection.StructKind;
import ro.amiq.msdldt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.msdldt.r2lparser.R2LCoverpointArg;
import ro.amiq.msdldt.r2lparser.R2LManager;
import ro.amiq.msdldt.r2lparser.R2LNoProposalElement;
import ro.amiq.msdldt.r2lparser.R2LParser;
import ro.amiq.msdldt.r2lparser.R2LResultContainer;
import ro.amiq.msdldt.r2lparser.R2LScopeContainer;
import ro.amiq.msdldt.r2lparser.R2LTokenizer;
import ro.amiq.msdldt.r2lparser.R2LUtils;
import ro.amiq.msdldt.r2lparser.R2LWalker;

public class R2LProposalManager
extends R2LManager {
    public static final int MAX_NOF_TOTAL_PROPOSALS = 50;
    private int fMatchType;

    public R2LProposalManager(RfProject rfProject, IRfScope initialScope, IResource file, IDocument document, int documentOffset) {
        super(rfProject, initialScope, file, document, documentOffset, documentOffset);
        boolean ignoreCase = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("ca.ignore_case");
        boolean camelCase = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("ca.camel_case");
        boolean prefixMatch = MSDLPlugin.getDefault().getPreferenceStore().getBoolean("ca.prefix_match");
        this.fMatchType = (ignoreCase ? 8 : 0) | (camelCase ? 4 : 0) | (prefixMatch || !camelCase ? 2 : 0);
    }

    public R2LProposalManager(RfProject rfProject, IRfScope initialScope, IResource file, IDocument document, int offset, boolean wordDistanceSearch) {
        super(rfProject, initialScope, file, document, offset, offset);
        this.fMatchType = 48;
    }

    @Override
    public R2LResultContainer getProposals() {
        List<String> path;
        block6: {
            try {
                if (this.fInitialScope != null) break block6;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        R2LResultContainer result = null;
        R2LScopeContainer scopeContainer = new R2LScopeContainer(this.fInitialScope);
        R2LWalker walker = new R2LWalker(this);
        R2LTokenizer lexer = new R2LTokenizer(this.fDocument, this.fDocumentOffset, false);
        RfNamedElement namedElement = this.fInitialScope.getNamedElement();
        boolean enableFieldDecl = !(namedElement instanceof RfBlock) || ((RfBlock)namedElement).getBlockKind() != BlockKind.CONSTRAINT;
        R2LParser parser = new R2LParser(lexer, enableFieldDecl, false);
        parser.rules();
        AST pAST = parser.getAST();
        if (pAST != null) {
            result = walker.rules(pAST, scopeContainer);
        }
        if (result == null || !result.isNumber && !result.hasProposals() && result.allowProposals()) {
            scopeContainer.accessKind = 0;
            path = result == null ? null : result.path;
            String prefix = result == null || result.prefix == null ? "" : result.prefix;
            result = new R2LResultContainer();
            result.candidates = this.getExprCandidates(scopeContainer, null, prefix);
            result.prefix = prefix;
            result.path = path;
        }
        if (!result.isNumber && !result.hasProposals()) {
            path = result.path;
            result = new R2LResultContainer();
            result.candidates = new RfNamedElement[]{new R2LNoProposalElement()};
            result.prefix = "";
            result.path = path;
        }
        result.initialScope = this.fInitialScope;
        return result;
    }

    @Override
    public List<RfWNamedElementAndScope> getElements() {
        return null;
    }

    public RfNamedElement[] getEnumCandidates(R2LScopeContainer scopeContainer, List<String> enums, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scope = scopeContainer.scope;
        if (!(scope instanceof RfEnumType)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                return candidate instanceof RfEnumItem;
            }

            public boolean allowEnumElement() {
                return true;
            }

            public int resultMaxSize() {
                return 50;
            }
        };
        ((RfEnumType)scope).getElementsWithPrefix(candidates, this.fDeterminant, prefix, this.fMatchType, 1, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        if (candidates.isEmpty()) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        if (enums != null && !enums.isEmpty()) {
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext()) {
                IRfNamedElement candidate = (IRfNamedElement)iterator.next();
                if (!enums.contains(candidate.getName())) continue;
                iterator.remove();
            }
        }
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getLexicalSorter(prefix));
        return sortedCandidates;
    }

    public RfNamedElement[] getEnumCandidates(R2LScopeContainer scopeContainer, String prefix) {
        return this.getEnumCandidates(scopeContainer, null, prefix);
    }

    public RfNamedElement[] getTypeCandidates(R2LScopeContainer scopeContainer, String prefix, boolean showCompAndPkg, String typeKind, R2LScopeContainer likeContainer) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null) {
            scope = this.fRfProject.getMainPackage();
        }
        if (scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        HashSet<IRfNamedElement> candidates = new HashSet<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                return candidate instanceof RfStruct && ((RfStruct)candidate).getStructKind() == StructKind.SCENARIO;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 50;
            }
        };
        scope.getElementsWithPrefix(candidates, this.fDeterminant, prefix, this.fMatchType, 4, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        this.getTopActorMembers(candidates, this.fRfProject.getTopActor(), prefix, elementFilter);
        RfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
        return sortedCandidates;
    }

    private void getTopActorMembers(Collection<IRfNamedElement> candidates, RfStruct topActor, String prefix, IRfElementFilter elementFilter) {
        if (topActor == null) {
            return;
        }
        Collection<RfNamedElement> members = topActor.getLocalMembers();
        if (members == null) {
            return;
        }
        for (RfNamedElement member : members) {
            RfNamedElement assocType;
            if (!(member instanceof RfField) || !((RfField)member).isInstance() || (assocType = ((RfField)member).getAssociatedType()) == null) continue;
            assocType.getElementsWithPrefix(candidates, null, prefix, this.fMatchType, 4, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        }
    }

    private RfNamedElement getLikeStruct(R2LScopeContainer likeContainer) {
        if (likeContainer != null && likeContainer.scope instanceof RfAssociatedType) {
            return ((RfAssociatedType)likeContainer.scope).getAssociatedType();
        }
        if (likeContainer != null && likeContainer.scope instanceof RfStruct) {
            return (RfNamedElement)likeContainer.scope;
        }
        return null;
    }

    @Override
    public IRfNamedElement[] getExprCandidates(R2LScopeContainer rightScopeContainer, R2LScopeContainer leftScopeContainer, String prefix) {
        IRfNamedElement[] result;
        RfNamedElement leftScope;
        if (rightScopeContainer == null || rightScopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = rightScopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope instanceof RfTypeAlias) {
            scope = ((RfTypeAlias)scope).getAssociatedType();
        }
        if (scope == null || !(scope instanceof RfMembersContainer)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement rfNamedElement = leftScope = leftScopeContainer != null && leftScopeContainer.scope != null ? ((IRfScope)leftScopeContainer.scope).getNamedElement() : null;
        if (leftScope instanceof RfEnumType && (rightScopeContainer.path == null || rightScopeContainer.path.isEmpty()) && (result = this.getEnumCandidates(leftScopeContainer, prefix)) != null && result.length > 0 && !(result[0] instanceof R2LNoProposalElement)) {
            return result;
        }
        HashSet<IRfNamedElement> candidates = new HashSet<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                if (candidate instanceof RfMethod || candidate instanceof RfField || candidate instanceof RfBlock && !((RfBlock)candidate).isAnonymous()) {
                    if (leftScope instanceof RfEnumType && candidate instanceof IRfAssociatedType) {
                        IRfNamedElement assocType = ((IRfAssociatedType)candidate).getAssociatedType();
                        while (assocType instanceof RfTypeAlias) {
                            assocType = ((RfTypeAlias)assocType).getAssociatedType();
                        }
                        return assocType instanceof RfStruct || assocType instanceof RfEnumType;
                    }
                    return true;
                }
                return false;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 50;
            }
        };
        scope.getElementsWithPrefix(candidates, this.fDeterminant, prefix, this.fMatchType, 4, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        IRfNamedElement[] sortedCandidates = candidates.toArray(new RfNamedElement[candidates.size()]);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
        return sortedCandidates;
    }

    @Override
    public IRfNamedElement[] getMappingCandidates(R2LScopeContainer scopeContainer, String prefix, String covergroupName, final Set<String> ports) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null || !(scope instanceof RfMembersContainer)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        if (!(scope instanceof RfCovergroup)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        ArrayList<IRfNamedElement> candidates = new ArrayList<IRfNamedElement>();
        IRfElementFilter elementFilter = new IRfElementFilter(){

            public boolean validElement(IRfNamedElement candidate) {
                if (candidate instanceof RfField && ((RfField)candidate).getFieldModifier() == FieldModifier.COVERGROUP_PORT) {
                    return !ports.contains(candidate.getName());
                }
                return false;
            }

            public boolean allowEnumElement() {
                return false;
            }

            public int resultMaxSize() {
                return 50;
            }
        };
        scope.getElementsWithPrefix(candidates, this.fDeterminant, prefix, this.fMatchType, 1, true, IRfNamedElement.AccessModifier.SHOW_PUBLIC, elementFilter);
        IRfNamedElement[] sortedCandidates = candidates.toArray(new IRfNamedElement[candidates.size()]);
        int i = 0;
        while (i < candidates.size()) {
            IRfNamedElement candidate = (IRfNamedElement)candidates.get(i);
            sortedCandidates[i] = new R2LCoverpointArg((RfField)candidate);
            ++i;
        }
        this.fRfProject.getMixedLangProjectParent().getSortCandidatesForContentAssist((IRfSingleLangProject)this.fRfProject, sortedCandidates, prefix);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
        return sortedCandidates;
    }

    @Override
    public IRfNamedElement[] getOptionCandidates(R2LScopeContainer scopeContainer, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        List<RfField> candidates = RfCovergroup.getOptionsWithPrefix(this.fRfProject, prefix, this.fMatchType);
        IRfNamedElement[] sortedCandidates = candidates.toArray(new IRfNamedElement[candidates.size()]);
        int i = 0;
        while (i < candidates.size()) {
            IRfNamedElement candidate = candidates.get(i);
            sortedCandidates[i] = new R2LCoverpointArg((RfField)candidate);
            ++i;
        }
        this.fRfProject.getMixedLangProjectParent().getSortCandidatesForContentAssist((IRfSingleLangProject)this.fRfProject, sortedCandidates, prefix);
        Arrays.sort(sortedCandidates, R2LUtils.getContextSorter(prefix));
        return sortedCandidates;
    }

    @Override
    public IRfNamedElement[] getMatchBlockEnumCandidates(R2LScopeContainer scopeContainer, String prefix) {
        if (scopeContainer == null || scopeContainer.scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        IRfScopeElement scopeElement = scopeContainer.scope;
        if (!(scopeElement instanceof IRfScope)) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement scope = ((IRfScope)scopeElement).getNamedElement();
        if (scope == null) {
            return new RfNamedElement[]{new R2LNoProposalElement()};
        }
        RfNamedElement enumType = null;
        if (scope instanceof RfBlock) {
            enumType = ((RfBlock)scope).getMatchScope();
        }
        if (enumType == null) {
            return this.getExprCandidates(scopeContainer, null, prefix);
        }
        scopeContainer.scope = enumType;
        return this.getEnumCandidates(scopeContainer, prefix);
    }
}

