/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.statistics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.statistics.FileInfo;
import ro.amiq.dvt.statistics.Info;
import ro.amiq.dvt.statistics.Metric;
import ro.amiq.dvt.statistics.RelevantInfo;
import ro.amiq.dvt.statistics.StatisticsUtilProviderBase;
import ro.amiq.msdldt.model.reflection.RfDefElement;
import ro.amiq.msdldt.model.reflection.RfFileDef;
import ro.amiq.msdldt.model.reflection.RfManager;
import ro.amiq.msdldt.model.reflection.RfNamedElement;
import ro.amiq.msdldt.model.reflection.RfProject;

public class StatisticsUtilProvider
extends StatisticsUtilProviderBase {
    private MSDLInfo architecturesInfo;
    private MSDLInfo entitiesInfo;
    private MSDLInfo configurationsInfo;
    private MSDLInfo componentsInfo;
    private MSDLInfo functionsInfo;
    private MSDLInfo proceduresInfo;
    private MSDLInfo packagesInfo;

    public void clean() {
        super.clean();
        this.architecturesInfo = null;
        this.entitiesInfo = null;
        this.configurationsInfo = null;
        this.componentsInfo = null;
        this.functionsInfo = null;
        this.proceduresInfo = null;
        this.packagesInfo = null;
    }

    public void init() {
        super.init();
        this.architecturesInfo = new MSDLArchitectureInfo();
        this.entitiesInfo = new MSDLEntityInfo();
        this.configurationsInfo = new MSDLConfigurationInfo();
        this.componentsInfo = new MSDLComponentInfo();
        this.functionsInfo = new MSDLFunctionInfo();
        this.proceduresInfo = new MSDLProcedureInfo();
        this.packagesInfo = new MSDLPackageInfo();
    }

    protected void collectSpecificStatistics(IProject project, IProgressMonitor progressMonitor) {
        super.collectSpecificStatistics(project, progressMonitor);
        if (!this.setCurrentTask("Collecting type statistics ...", true)) {
            return;
        }
        this.addSeparator();
        this.createAndAddMetric("Nof Architectures", this.architecturesInfo.counter);
        this.createAndAddMetric("Nof Entities", this.entitiesInfo.counter);
        this.createAndAddMetric("Nof Configurations", this.configurationsInfo.counter);
        this.createAndAddMetric("Nof Components", this.componentsInfo.counter);
        this.createAndAddMetric("Nof Functions", this.functionsInfo.counter);
        this.createAndAddMetric("Nof Procedures", this.proceduresInfo.counter);
        this.createAndAddMetric("Nof Packages", this.packagesInfo.counter);
        if (this.architecturesInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.architecturesInfo);
        }
        if (this.entitiesInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.entitiesInfo);
        }
        if (this.configurationsInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.configurationsInfo);
        }
        if (this.componentsInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.componentsInfo);
        }
        if (this.functionsInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.functionsInfo);
        }
        if (this.proceduresInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.proceduresInfo);
        }
        if (this.packagesInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.packagesInfo);
        }
        this.fProgressMonitor = null;
    }

    protected boolean isFiltered(Object o) {
        if (!(o instanceof RfNamedElement) && o instanceof String) {
            return this.fSpm.isFiltered((String)o);
        }
        return false;
    }

    protected FileInfo computeFileInfo(String fileName) {
        FileInfo result;
        block18: {
            result = new FileInfo(fileName);
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(fileName));
                    String line = null;
                    boolean inComment = false;
                    while ((line = in.readLine()) != null) {
                        ++result.totalNofLines;
                        if ((line = line.trim()).startsWith("/*")) {
                            inComment = true;
                        }
                        if (line.contains("*/")) {
                            inComment = false;
                        }
                        if (line.startsWith("--")) {
                            ++result.commentNofLines;
                            continue;
                        }
                        if (line.length() == 0) {
                            ++result.emptyNofLines;
                            continue;
                        }
                        if (inComment) {
                            ++result.commentNofLines;
                            continue;
                        }
                        ++result.codeNofLines;
                        result.codeNofChars += line.length();
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (in == null) break block18;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private MSDLInfo computeElementInfo(RfNamedElement rfNamedElement) {
        MSDLInfo result = new MSDLInfo(rfNamedElement.getName());
        RfDefElement declaration = rfNamedElement.getDeclaration();
        if (declaration != null) {
            result.nofDefinitionLines.counter = declaration.getEndLine() - declaration.getStartLine() + 1;
        }
        return result;
    }

    public String getNature() {
        return "ro.amiq.msdldt.msdlnature";
    }

    protected String heading() {
        return "M-SDL statistics";
    }

    protected IRfSingleLangProject getRfProject(IProject project) {
        return RfManager.getInstance().getRfProject(project);
    }

    protected List<ParserPath> getCompiledParserPaths(IRfSingleLangProject rfProject) {
        RfProject msdlRfProject = (RfProject)rfProject;
        Collection<RfFileDef> allFiles = msdlRfProject.getFiles();
        return allFiles.stream().map(x -> x.getParserPath()).distinct().collect(Collectors.toList());
    }

    private static class MSDLArchitectureInfo
    extends MSDLInfo {
        public MSDLArchitectureInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Architectures Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class MSDLComponentInfo
    extends MSDLInfo {
        public MSDLComponentInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Components Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class MSDLConfigurationInfo
    extends MSDLInfo {
        public MSDLConfigurationInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Configuration Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class MSDLEntityInfo
    extends MSDLInfo {
        public MSDLEntityInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Entities Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class MSDLFunctionInfo
    extends MSDLInfo {
        public MSDLFunctionInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Functions Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class MSDLInfo
    extends Info {
        public RelevantInfo nofDefinitionLines;

        protected MSDLInfo(String elementName) {
            this.nofDefinitionLines = new RelevantInfo(elementName);
        }

        public void update(MSDLInfo info) {
            ++this.counter;
            this.nofDefinitionLines.update(info.nofDefinitionLines);
        }
    }

    private static class MSDLPackageInfo
    extends MSDLInfo {
        public MSDLPackageInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Packages Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    private static class MSDLProcedureInfo
    extends MSDLInfo {
        public MSDLProcedureInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Procedures Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }
}

