/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.test;

import antlr.Token;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IOutlineTreeViewProvider;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.model.MSDLModelManager;
import ro.amiq.msdldt.model.reflection.views.CompileOrderViewLabelProvider;
import ro.amiq.msdldt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.msdldt.ui.editor.MSDLEditor;
import ro.amiq.msdldt.ui.editor.MSDLEditorMessages;
import ro.amiq.msdldt.ui.editor.MSDLSourceViewerConfiguration;
import ro.amiq.msdldt.ui.editor.actions.MSDLRenameRefactorAction;

@ForTestingOrDebuggingOnly
public class TestHelper
extends ro.amiq.dvt.test.TestHelper {
    private static final TestHelper INSTANCE = new TestHelper();
    public static IOutlineTreeViewProvider wrp;
    public static TypesViewLabelProvider wrp2;
    public static CompileOrderViewLabelProvider wrp6;
    private static List<Identifier> fIdentifiers;

    private TestHelper() {
        this.fPreferenceStore = MSDLPlugin.getDefault().getPreferenceStore();
    }

    @ProductSafe
    public static TestHelper getInstance() {
        return INSTANCE;
    }

    public static int getOutlineItemsNumber() {
        Object[] roots = TestHelper.getOutlineData();
        if (roots != null && roots.length > 0) {
            return TestHelper.getOutlineItemsNumber(roots);
        }
        return 0;
    }

    private static int getOutlineItemsNumber(Object[] roots) {
        int count = roots.length;
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object root = objectArray[n2];
            Object[] children = TestHelper.getChildren(root);
            if (children != null && children.length > 0) {
                count += TestHelper.getOutlineItemsNumber(children);
            }
            ++n2;
        }
        return count;
    }

    static IOutlineTreeViewProvider getUIRfOutlineTreeViewProvider() {
        DVTLazyOutlinePage pssOutlinePage;
        ILabelProvider tmp;
        if (wrp == null && (tmp = (pssOutlinePage = (DVTLazyOutlinePage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getAdapter(IContentOutlinePage.class)).getLabelProvider()) instanceof IOutlineTreeViewProvider) {
            wrp = (IOutlineTreeViewProvider)tmp;
        }
        return wrp;
    }

    public String getText(Object wrapper) {
        return TestHelper.getUIRfOutlineTreeViewProvider().getText(wrapper);
    }

    public Image getImage(Object wrapper) {
        return TestHelper.getUIRfOutlineTreeViewProvider().getImage(wrapper);
    }

    public static Object[] getChildren(Object wrapper) {
        return TestHelper.getUIRfOutlineTreeViewProvider().getChildren(wrapper);
    }

    static TypesViewLabelProvider getUIRfTypesTreeViewProvider() {
        if (wrp2 == null) {
            wrp2 = new TypesViewLabelProvider();
        }
        return wrp2;
    }

    public String getTypesText(Object wrapper) {
        return TestHelper.getUIRfTypesTreeViewProvider().getText(wrapper);
    }

    public Image getTypesImage(Object wrapper) {
        return TestHelper.getUIRfTypesTreeViewProvider().getImage(wrapper);
    }

    public static Object[] getTypesChildren(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        IDVTElementWrapper wrapper2 = (IDVTElementWrapper)wrapper;
        if (wrapper2.hasChildren()) {
            return wrapper2.getChildren().toArray();
        }
        return null;
    }

    public static Object[] getDesignHierarchyChildren(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        IDVTElementWrapper wrapper2 = (IDVTElementWrapper)wrapper;
        if (wrapper2.hasChildren()) {
            return wrapper2.getChildren().toArray();
        }
        return null;
    }

    public static Image getImageByFieldName(String fieldName, Object with) {
        if (with instanceof IDVTElementWrapper) {
            Object element = ((IDVTElementWrapper)with).getRfElement();
            if (element instanceof IRfNamedElement) {
                return ((IRfNamedElement)element).testGetImage(fieldName);
            }
            if (element instanceof IRfDefElement) {
                return ((IRfDefElement)element).getNamedElement().testGetImage(fieldName);
            }
        }
        return null;
    }

    protected List<String> getFieldNameByDescriptor(Field[] fields, ImageDescriptor descriptor) {
        ArrayList<String> matches = new ArrayList<String>();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field != null && (field.getModifiers() & 1) != 0 && field.getType() == ImageDescriptor.class && field.get(null) == descriptor) {
                    matches.add(field.getName());
                }
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        return matches;
    }

    public List<String> getImageDescriptors(Image image) {
        ArrayList<String> results = new ArrayList<String>();
        List descriptors = DVTImages.imageCache.getImageDescriptors(image);
        for (ImageDescriptor descriptor : descriptors) {
            results.addAll(this.getFieldNameByDescriptor(DVTImages.class.getDeclaredFields(), descriptor));
        }
        if (results.isEmpty()) {
            results.add("IMAGE_WAS_NOT_LOADED");
        }
        return results;
    }

    public static String getFieldNameByImage(Image image, String targetDescriptorName) {
        List<String> descriptorNames = TestHelper.getInstance().getImageDescriptors(image);
        String result = null;
        if (targetDescriptorName.equals("") && !descriptorNames.isEmpty()) {
            return descriptorNames.get(0);
        }
        for (String descriptorName : descriptorNames) {
            if (!targetDescriptorName.equals(descriptorName)) continue;
            result = descriptorName;
        }
        if (result == null) {
            result = "IMAGE_WAS_NOT_LOADED";
        }
        return result;
    }

    public static void addNameConvention(String kind, String name, String description, String match, String pattern, boolean enabled, IProject project) throws IOException, CoreException {
        TestHelper.addNameConvention((String)"M-SDL", (String)kind, (String)name, (String)description, (String)match, (String)pattern, (boolean)enabled, (IProject)project);
    }

    static CompileOrderViewLabelProvider getLoadOrderViewProvider() {
        if (wrp6 == null) {
            wrp6 = new CompileOrderViewLabelProvider();
        }
        return wrp6;
    }

    public static String getLoadOrderName(Object wrapper) {
        return TestHelper.getLoadOrderViewProvider().getText(wrapper);
    }

    public static Object[] getCompileOrderChildren(Object wrapper) {
        if (wrapper == null) {
            return null;
        }
        if (wrapper instanceof IDVTElementWrapper && ((IDVTElementWrapper)wrapper).getChildren() != null) {
            return ((IDVTElementWrapper)wrapper).getChildren().toArray();
        }
        return null;
    }

    public static IDVTProject getMSDLProject(IProject iProject) {
        return MSDLModelManager.getInstance().getMSDLModel().getMSDLProject(iProject);
    }

    @ProductSafe
    public static void collectToken(Token token) {
        if (fIdentifiers == null) {
            return;
        }
        fIdentifiers.add(new Identifier(token));
    }

    public static void clearIdentifiers() {
        fIdentifiers.clear();
    }

    public static void initIdentifiers() {
        fIdentifiers = new ArrayList<Identifier>();
    }

    public static List<Identifier> getIdentifiers() {
        return fIdentifiers;
    }

    public static String doubleClick(int dbClickLineNo, int dbClickOffset, int refStartLineNo, int refStartOffset, int refEndLineNo, int refEndOffset) {
        int actualEndOffset;
        int actualEndLineNo;
        int actualStartOffset;
        int actualStartLineNo;
        block3: {
            try {
                MSDLEditor editor = (MSDLEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                int dbCLickOffset = TestHelper.getInstance().computeOffset(editor, dbClickLineNo - 1, dbClickOffset - 1);
                MSDLSourceViewerConfiguration sourceViewerConfiguration = editor.testGetSourceViewerConfiguration();
                ISourceViewer sourceViewer = editor.testGetSourceViewer();
                ITextDoubleClickStrategy doubleClickStrategy = sourceViewerConfiguration.getDoubleClickStrategy(sourceViewer, "__dftl_partition_content_type");
                editor.selectAndReveal(dbCLickOffset, 1);
                doubleClickStrategy.doubleClicked((ITextViewer)sourceViewer);
                Point selectedRange = sourceViewer.getSelectedRange();
                actualStartLineNo = document.getLineOfOffset(selectedRange.x) + 1;
                actualStartOffset = selectedRange.x - document.getLineOffset(actualStartLineNo - 1);
                actualEndLineNo = document.getLineOfOffset(selectedRange.x + selectedRange.y) + 1;
                actualEndOffset = selectedRange.x + selectedRange.y - document.getLineOffset(actualEndLineNo - 1);
                int refStartOffsetInDoc = TestHelper.getInstance().computeOffset(editor, refStartLineNo - 1, refStartOffset - 1);
                int refLength = TestHelper.getInstance().computeLengthInDocument(editor, refStartLineNo - 1, refStartOffset - 1, refEndLineNo - 1, refEndOffset - 1);
                if (selectedRange.x != refStartOffsetInDoc || selectedRange.y != refLength) break block3;
                return "";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return "Mismatch for double click at  [" + dbClickLineNo + ", " + dbClickOffset + "] :\n" + "Selection reference was : start [" + refStartLineNo + ", " + refStartOffset + "], end [" + refEndLineNo + ", " + refEndOffset + "]\n" + "Actual  selection was    : start [" + actualStartLineNo + ", " + actualStartOffset + "], end [" + actualEndLineNo + ", " + actualEndOffset + "]\n";
    }

    public static int selectText(int startLineNo, int startLineCol, int endLineNo, int endLineCol) {
        int selectedTextLength = 0;
        MSDLEditor editor = (MSDLEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        int startSelOffset = TestHelper.getInstance().computeOffset(editor, startLineNo - 1, startLineCol - 1);
        int endSelOffset = TestHelper.getInstance().computeOffset(editor, endLineNo - 1, endLineCol - 1);
        selectedTextLength = endSelOffset - startSelOffset;
        editor.selectAndReveal(startSelOffset, selectedTextLength);
        return selectedTextLength;
    }

    public static IProgressMonitor getMonitor() {
        IProgressMonitor monitor = new IProgressMonitor(){

            public void worked(int work) {
            }

            public void subTask(String name) {
            }

            public void setTaskName(String name) {
            }

            public void setCanceled(boolean value) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void internalWorked(double work) {
            }

            public void done() {
            }

            public void beginTask(String name, int totalWork) {
            }
        };
        return monitor;
    }

    public static IPreferenceStore getPreferenceStore() {
        return TestHelper.getInstance().fPreferenceStore;
    }

    public static void executeRefactoringRename(DVTEditor editor) {
        MSDLRenameRefactorAction rra = new MSDLRenameRefactorAction(MSDLEditorMessages.getResourceBundle(), "RefactorRename.", editor);
        rra.run();
    }

    public static class Identifier {
        private String text;
        private String filename;
        private int line;
        private int column;

        public Identifier(Token token) {
            this.text = token.getText();
            this.line = token.getLine();
            this.column = token.getColumn();
            this.filename = token.getFilename();
        }

        public String getFilename() {
            return this.filename;
        }

        public String getText() {
            return this.text;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

