/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.preferences.OverlayPreferenceStore;
import ro.amiq.dvt.ui.preferences.theme.IThemePreviewContributor;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.msdldt.core.MSDLPlugin;
import ro.amiq.msdldt.ui.editor.MSDLDocumentSetupParticipant;
import ro.amiq.msdldt.ui.editor.MSDLSourceViewerConfiguration;
import ro.amiq.msdldt.ui.editor.MSDLStyle;
import ro.amiq.msdldt.ui.preferences.MSDLSourcePreviewerUpdater;

public class MSDLThemePreviewContributor
implements IThemePreviewContributor {
    private DVTPreviewSourceViewer fPreviewViewer;
    private IPreferenceStore fPluginStore = MSDLPlugin.getDefault().getPreferenceStore();
    private OverlayPreferenceStore fOverlayStore = new OverlayPreferenceStore(MSDLPlugin.getDefault().getCombinedPreferenceStore(), this.createOverlayStoreKeys());
    private Control previewControl;

    public MSDLThemePreviewContributor() {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
    }

    public Control createLanguagePreviewer(Composite parent) {
        MSDLSourceViewerConfiguration configuration = new MSDLSourceViewerConfiguration(null);
        this.fPreviewViewer = new DVTPreviewSourceViewer(parent, 2560);
        this.fPreviewViewer.setPreferenceStore(MSDLPlugin.getDefault().getCombinedPreferenceStore());
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingsPreviewCode.sdl");
        Document document = new Document(content);
        MSDLDocumentSetupParticipant docSetup = new MSDLDocumentSetupParticipant();
        docSetup.setup((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        MSDLSourcePreviewerUpdater.registerPreviewer((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)this.fOverlayStore);
        this.addAllSemanticPositions((IDocument)document);
        this.previewControl = this.fPreviewViewer.getControl();
        return this.previewControl;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.x_template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.default.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_hyperlink.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_pragma.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_task.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.javadoc_tags.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyphrase.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyphrase.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyphrase.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyword.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.number.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_actor.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_actor.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_actor.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_enum_item.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_enum_item.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_enum_item.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_field.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_label.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_label.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_label.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_method.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_method.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_method.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_modifier.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_modifier.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_modifier.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_scenario.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_scenario.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_scenario.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.string.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.template_id.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.types.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.types.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.types.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.units.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.units.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.units.italic"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuilder buffer;
        block15: {
            buffer = new StringBuilder(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append("\n");
                    }
                }
                catch (IOException io) {
                    DVTLogger.INSTANCE.logError((Throwable)io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private void addAllSemanticPositions(IDocument document) {
        try {
            if (!document.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            } else {
                document.removePositionCategory("SEMANTIC_HIGHLIGHT");
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            }
            HashMap positions = new HashMap();
            DVTHlUtils.addPosition((IDocument)document, (int)31, (HighlightKind)HighlightKind.MSDL_ACTOR, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)35, (HighlightKind)HighlightKind.MSDL_SCENARIO_DECL, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)50, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)56, (HighlightKind)HighlightKind.MSDL_ACTOR, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)79, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)85, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)120, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)126, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)135, (HighlightKind)HighlightKind.MSDL_MODIFIER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)158, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)216, (HighlightKind)HighlightKind.LABEL, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)236, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)288, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)292, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)296, (HighlightKind)HighlightKind.MSDL_SCENARIO, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)302, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)326, (HighlightKind)HighlightKind.MSDL_MODIFIER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)354, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)359, (HighlightKind)HighlightKind.MSDL_SCENARIO, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)365, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)371, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)403, (HighlightKind)HighlightKind.MSDL_MODIFIER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)412, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)448, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)456, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)460, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)465, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)469, (HighlightKind)HighlightKind.MSDL_ENUM_ITEM, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)488, (HighlightKind)HighlightKind.MSDL_MODIFIER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)497, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)532, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)542, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)546, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)551, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)555, (HighlightKind)HighlightKind.MSDL_ENUM_ITEM, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)566, (HighlightKind)HighlightKind.LABEL, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)588, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)642, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)646, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)650, (HighlightKind)HighlightKind.MSDL_SCENARIO, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)656, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)671, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)676, (HighlightKind)HighlightKind.MSDL_SCENARIO, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)682, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)706, (HighlightKind)HighlightKind.MSDL_MODIFIER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)711, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)720, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)724, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)729, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)735, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)741, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)745, (HighlightKind)HighlightKind.MSDL_ENUM_ITEM, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)764, (HighlightKind)HighlightKind.MSDL_MODIFIER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)769, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)778, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)782, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)787, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)791, (HighlightKind)HighlightKind.MSDL_ENUM_ITEM, positions);
            DVTHlUtils.addPositionsToDocument((IDocument)document, positions.values());
            DVTHlUtils.notifyListeners((IDocument)document, null);
            this.fPreviewViewer.invalidateTextPresentation();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getLanguage() {
        return "M-SDL";
    }

    public OverlayPreferenceStore getOverlayPreferenceStore() {
        return this.fOverlayStore;
    }

    public IPreferenceStore getPluginPreferenceStore() {
        return this.fPluginStore;
    }

    public String getPluginId() {
        return "ro.amiq.msdldt";
    }

    public void cancelPreview() {
        MSDLStyle.getInstance().updateTokens();
    }

    public Integer getPreviewOrderId() {
        return 5;
    }

    public void updateBackground(Color color) {
        if (this.fPreviewViewer == null) {
            return;
        }
        if (this.fPreviewViewer.getTextWidget() == null) {
            return;
        }
        DVTColorUtil.INSTANCE.setBackground((Control)this.fPreviewViewer.getTextWidget(), color, true);
    }

    public Control getPreviewControl() {
        return this.previewControl;
    }
}

