/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.msdldt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import ro.amiq.dvt.ui.editor.DVTPositionUpdater;
import ro.amiq.dvt.ui.editor.IDVTDocumentSetupParticipant;
import ro.amiq.msdldt.ui.editor.MSDLPartitionScanner;

public abstract class MSDLDocumentSetupParticipantCommon
implements IDVTDocumentSetupParticipant {
    protected FastPartitioner partitioner;

    public void setup(IDocument document) {
        if (document == null) {
            return;
        }
        this.addPositionCategories(document);
    }

    public void addPositionCategories(IDocument document) {
        DVTPositionUpdater semanticUpdater = new DVTPositionUpdater("SEMANTIC_HIGHLIGHT");
        DVTPositionUpdater reflectionUpdater = new DVTPositionUpdater("REFLECTION");
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            this.partitioner = new FastPartitioner((IPartitionTokenScanner)new MSDLPartitionScanner(), new String[]{"__msdl_sl_comment", "__msdl_ml_comment", "__msdl_literal", "__msdl_literal_interpol", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__msdl_partitioning", (IDocumentPartitioner)this.partitioner);
            this.partitioner.connect(document);
        }
        document.addPositionCategory("SEMANTIC_HIGHLIGHT");
        document.addPositionUpdater((IPositionUpdater)semanticUpdater);
        document.addPositionCategory("REFLECTION");
        document.addPositionUpdater((IPositionUpdater)reflectionUpdater);
    }

    public void disconnect() {
        if (this.partitioner != null) {
            this.partitioner.disconnect();
        }
        this.partitioner = null;
    }
}

